/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramsCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.processor.Constants;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractVajramCodegenProcessor
extends AbstractProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractVajramCodegenProcessor.class);
    private final CodegenPhase codegenPhase;

    public AbstractVajramCodegenProcessor(CodegenPhase codegenPhase) {
        this.codegenPhase = codegenPhase;
        log.info("Initializing {} with codegen phase {}", (Object)this.getClass().getSimpleName(), (Object)codegenPhase);
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CodeGenUtility util = new CodeGenUtility(this.processingEnv, this.getClass());
        String phaseString = this.processingEnv.getOptions().get("krystal.vajram.codegen.phase");
        try {
            if (phaseString == null || !this.codegenPhase.equals((Object)CodegenPhase.valueOf((String)phaseString))) {
                util.note((CharSequence)"Skipping %s since codegen phase is '%s'. This class only supports '%s'".formatted(this.getClass().getSimpleName(), String.valueOf(phaseString), this.codegenPhase));
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            util.error("%s could not parse phase string '%s'. Exactly one of %s must be passed as value to the java compiler via the annotation processor argument '-A%s='".formatted(this.getClass().getSimpleName(), String.valueOf(phaseString), Arrays.toString(CodegenPhase.values()), "krystal.vajram.codegen.phase"), new Element[0]);
            return false;
        }
        List vajramDefinitions = util.getDefinitionClasses(roundEnv);
        util.note((CharSequence)"Vajrams and Traits received by %s: %s".formatted(this.getClass().getSimpleName(), vajramDefinitions.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]"))));
        Iterable vajramCodeGeneratorProviders = Iterables.concat(List.of(Constants.DEFAULT_VAJRAM_CODEGEN_PROVIDER), ServiceLoader.load(VajramCodeGeneratorProvider.class, this.getClass().getClassLoader()));
        record Failure(TypeElement element, Throwable throwable) {
        }
        ArrayList<Failure> failures = new ArrayList<Failure>();
        ArrayList<VajramInfo> vajramInfos = new ArrayList<VajramInfo>();
        for (TypeElement vajramDefinition : vajramDefinitions) {
            try {
                VajramInfo vajramInfo = util.computeVajramInfo(vajramDefinition);
                vajramInfos.add(vajramInfo);
                VajramCodeGenContext creationContext = new VajramCodeGenContext(vajramInfo, util, this.codegenPhase);
                for (VajramCodeGeneratorProvider customCodeGeneratorProvider : vajramCodeGeneratorProviders) {
                    try {
                        customCodeGeneratorProvider.create(creationContext).generate();
                    }
                    catch (Exception e) {
                        failures.add(new Failure(vajramDefinition, e));
                    }
                }
            }
            catch (Exception e) {
                failures.add(new Failure(vajramDefinition, e));
            }
        }
        ServiceLoader<AllVajramsCodeGeneratorProvider> allVajramCodeGeneratorProviders = ServiceLoader.load(AllVajramsCodeGeneratorProvider.class, this.getClass().getClassLoader());
        for (AllVajramsCodeGeneratorProvider allVajramCodeGen : allVajramCodeGeneratorProviders) {
            allVajramCodeGen.create(new AllVajramCodeGenContext(vajramInfos, util, this.codegenPhase)).generate();
        }
        for (Failure failure : failures) {
            util.note((CharSequence)("[Vajram Codegen Exception] " + String.valueOf(failure.element().getQualifiedName()) + "\n" + Throwables.getStackTraceAsString((Throwable)failure.throwable())));
        }
        return false;
    }
}

