/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.plugin;

import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.UnknownVal;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;

public class VajramPlugin
implements Plugin<Project> {
    static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String EMPTY_DIR = "tmp/empty";
    static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String SRC_GEN_DIR = "/generated/sources/annotationProcessor/java";
    static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String VAJRAM_MODELS_GEN_DIR = "/generated/sources/vajramModels/java";
    static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String MAIN_SRC_DIR = "src/main/java";
    static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String TEST_SRC_DIR = "src/test/java";

    public void apply(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Project project) {
        File mainModelsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/vajramModels/java/main");
        File mainImplsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/annotationProcessor/java/main");
        File testModelsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/vajramModels/java/test");
        File testImplsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/annotationProcessor/java/test");
        VajramPlugin.addSourceSets(project, mainModelsGenDir, mainImplsGenDir, testModelsGenDir, testImplsGenDir);
        VajramPlugin.registerCodeGenVajramModels(project, mainModelsGenDir);
        VajramPlugin.configureCompileJava(project);
        VajramPlugin.registerTestCodeGenVajramModels(project, testModelsGenDir);
        project.getTasks().named("jar").configure(task -> task.dependsOn(new Object[]{"compileJava"}));
    }

    private static void addSourceSets(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Project project, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent File mainModelsGenDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent File mainImplsGenDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent File testModelsGenDir, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent File testImplsGenDir) {
        SourceSetContainer sourceSets = ((JavaPluginExtension)Preconditions.checkNotNull((Object)((JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class)))).getSourceSets();
        ((SourceSet)sourceSets.getByName("main")).getJava().srcDir((Object)mainModelsGenDir).srcDir((Object)mainImplsGenDir);
        ((SourceSet)sourceSets.getByName("test")).getJava().srcDir((Object)testModelsGenDir).srcDir((Object)testImplsGenDir);
    }

    private static void registerCodeGenVajramModels(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Project project, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent File mainModelsGenDir) {
        project.getTasks().register("codeGenVajramModels", JavaCompile.class, task -> {
            task.setGroup("krystal");
            task.source(new Object[]{MAIN_SRC_DIR});
            task.setClasspath((FileCollection)project.getConfigurations().getByName("compileClasspath"));
            task.getDestinationDirectory().set((Provider)project.getObjects().directoryProperty().fileValue(VajramPlugin.getBuildDir(project).toPath().resolve(EMPTY_DIR).toFile()));
            task.getOptions().setAnnotationProcessorPath(((JavaCompile)project.getTasks().named("compileJava", JavaCompile.class).get()).getOptions().getAnnotationProcessorPath());
            task.getOptions().getGeneratedSourceOutputDirectory().fileValue(project.file((Object)mainModelsGenDir));
            task.getOptions().getCompilerArgs().addAll(List.of("-proc:only", "-Akrystal.vajram.codegen.phase=" + CodegenPhase.MODELS));
        });
    }

    private static void configureCompileJava(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Project project) {
        project.getTasks().named("compileJava", JavaCompile.class).configure(task -> {
            task.dependsOn(new Object[]{"codeGenVajramModels"});
            task.getOptions().getCompilerArgs().addAll(List.of("-Akrystal.vajram.codegen.phase=" + CodegenPhase.FINAL, "-parameters"));
        });
    }

    private static void registerTestCodeGenVajramModels(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Project project, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent File testModelsGenDir) {
        project.getTasks().register("testCodeGenVajramModels", JavaCompile.class, task -> {
            task.setGroup("krystal");
            task.mustRunAfter(new Object[]{task.getProject().getTasks().getByName("compileJava")});
            task.source(new Object[]{MAIN_SRC_DIR, TEST_SRC_DIR});
            task.setClasspath(project.getConfigurations().getByName("compileClasspath").plus((FileCollection)project.getConfigurations().getByName("testCompileClasspath")));
            task.getDestinationDirectory().set((Provider)project.getObjects().directoryProperty().fileValue(VajramPlugin.getBuildDir(project).toPath().resolve(EMPTY_DIR).toFile()));
            task.getOptions().setAnnotationProcessorPath(((JavaCompile)project.getTasks().named("compileTestJava", JavaCompile.class).get()).getOptions().getAnnotationProcessorPath());
            task.getOptions().getGeneratedSourceOutputDirectory().fileValue(project.file((Object)testModelsGenDir));
            task.getOptions().getCompilerArgs().addAll(List.of("-proc:only", "-Akrystal.vajram.codegen.phase=" + CodegenPhase.MODELS));
        });
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent File getBuildDir(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Project project) {
        return (File)project.getLayout().getBuildDirectory().getAsFile().get();
    }
}

