/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.Utils;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramsCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.processor.Constants;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractVajramCodegenProcessor
extends AbstractProcessor {
    private final CodegenPhase codegenPhase;

    public AbstractVajramCodegenProcessor(CodegenPhase codegenPhase) {
        this.codegenPhase = codegenPhase;
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Utils util = new Utils(this.processingEnv, this.getClass());
        String phaseString = this.processingEnv.getOptions().get("krystal.vajram.codegen.phase");
        try {
            if (phaseString == null || !this.codegenPhase.equals((Object)CodegenPhase.valueOf((String)phaseString))) {
                util.note((CharSequence)"Skipping %s since codegen phase is '%s'. This class only supports '%s'".formatted(this.getClass().getSimpleName(), String.valueOf(phaseString), this.codegenPhase));
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            util.error("%s could not parse phase string '%s'. Exactly one of %s must be passed as value to the java compiler via the annotation processor argument '-A%s='".formatted(this.getClass().getSimpleName(), String.valueOf(phaseString), Arrays.toString(CodegenPhase.values()), "krystal.vajram.codegen.phase"), null);
            return false;
        }
        List vajramDefinitions = util.getDefinitionClasses(roundEnv);
        util.note((CharSequence)"Vajrams and Traits received by %s: %s".formatted(this.getClass().getSimpleName(), vajramDefinitions.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]"))));
        Iterable vajramCodeGeneratorProviders = Iterables.concat(List.of(Constants.DEFAULT_VAJRAM_CODEGEN_PROVIDER), ServiceLoader.load(VajramCodeGeneratorProvider.class, this.getClass().getClassLoader()));
        List<VajramInfo> vajramInfos = vajramDefinitions.stream().map(arg_0 -> ((Utils)util).computeVajramInfo(arg_0)).toList();
        for (VajramInfo vajramInfo : vajramInfos) {
            VajramCodeGenContext creationContext = new VajramCodeGenContext(vajramInfo, util, this.codegenPhase);
            for (VajramCodeGeneratorProvider customCodeGeneratorProvider : vajramCodeGeneratorProviders) {
                try {
                    customCodeGeneratorProvider.create(creationContext).generate();
                }
                catch (VajramValidationException e) {}
            }
        }
        ServiceLoader<AllVajramsCodeGeneratorProvider> allVajramCodeGeneratorProviders = ServiceLoader.load(AllVajramsCodeGeneratorProvider.class, this.getClass().getClassLoader());
        for (AllVajramsCodeGeneratorProvider allVajramCodeGen : allVajramCodeGeneratorProviders) {
            allVajramCodeGen.create(new AllVajramCodeGenContext(vajramInfos, util, this.codegenPhase)).generate();
        }
        return false;
    }
}

