/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.annos.HasCreator;
import com.flipkart.krystal.annos.TraitDependency;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.FacetValuesContainer;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.facets.resolution.ResolutionTarget;
import com.flipkart.krystal.facets.resolution.ResolverCommand;
import com.flipkart.krystal.tags.ElementTags;
import com.flipkart.krystal.vajram.IOVajramDef;
import com.flipkart.krystal.vajram.TraitRequestRoot;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.VajramRequestRoot;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchEnabledImmutableFacetValues;
import com.flipkart.krystal.vajram.batching.Batched;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.BatchesGroupedBy;
import com.flipkart.krystal.vajram.codegen.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.Constants;
import com.flipkart.krystal.vajram.codegen.DependencyModel;
import com.flipkart.krystal.vajram.codegen.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.FacetJavaType;
import com.flipkart.krystal.vajram.codegen.GivenFacetModel;
import com.flipkart.krystal.vajram.codegen.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.TypeAndName;
import com.flipkart.krystal.vajram.codegen.Utils;
import com.flipkart.krystal.vajram.codegen.VajramInfo;
import com.flipkart.krystal.vajram.codegen.VajramInfoLite;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.FacetIdNameMapping;
import com.flipkart.krystal.vajram.facets.FacetValidation;
import com.flipkart.krystal.vajram.facets.FanoutCommand;
import com.flipkart.krystal.vajram.facets.One2OneCommand;
import com.flipkart.krystal.vajram.facets.Using;
import com.flipkart.krystal.vajram.facets.resolution.AbstractFanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.AbstractOne2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.FanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.InputResolver;
import com.flipkart.krystal.vajram.facets.resolution.One2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.Resolve;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryFacetDefaultSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryFanoutDepSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryOne2OneDepSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalFacetDefaultSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalFanoutDepSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalOne2OneDepSpec;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Documented;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import lombok.EqualsAndHashCode;
import lombok.Generated;
import lombok.ToString;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenerator {
    @Generated
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(VajramCodeGenerator.class);
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo currentVajramInfo;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> facetModels;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> facetModelsByName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean needsBatching;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Boolean> depFanoutMap;
    private @MonotonicNonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ParsedVajramData parsedVajramData;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util;

    public VajramCodeGenerator(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util) {
        this.currentVajramInfo = vajramInfo;
        this.packageName = vajramInfo.lite().packageName();
        this.util = util;
        this.facetModels = vajramInfo.facetStream().collect(Collectors.toMap(FacetGenModel::id, Function.identity(), (o1, o2) -> o1, () -> new LinkedHashMap()));
        this.facetModelsByName = vajramInfo.facetStream().collect(Collectors.toMap(FacetGenModel::name, Function.identity(), (o1, o2) -> o1, () -> new LinkedHashMap()));
        this.needsBatching = vajramInfo.givenFacets().stream().anyMatch(FacetGenModel::isBatched);
        this.depFanoutMap = vajramInfo.dependencies().stream().collect(Collectors.toMap(DependencyModel::id, DependencyModel::canFanout));
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int inferFacetId(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement parameter) {
        Using using = parameter.getAnnotation(Using.class);
        if (using != null) {
            return using.value();
        }
        String paramName = parameter.getSimpleName().toString();
        FacetGenModel facetGenModel = this.facetModelsByName.get(paramName);
        if (facetGenModel == null) {
            String message = "Unknown facet with name %s".formatted(paramName);
            this.util.error(message, parameter);
            throw new VajramValidationException(message);
        }
        return facetGenModel.id();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String codeGenVajramWrapper() {
        this.initParsedVajramData();
        TypeSpec.Builder vajramWrprClass = this.util.classBuilder(Utils.getVajramImplClassName(this.vajramName())).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Facet.class}).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)"facetDefinitions", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        vajramWrprClass.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(ClassName.get((TypeElement)this.currentVajramInfo.vajramClass()).box()).build();
        ClassName requestInterfaceType = this.getRequestInterfaceType();
        ClassName immutRequestType = ClassName.get((String)this.packageName, (String)Utils.getImmutRequestPojoName(this.vajramName()), (String[])new String[0]);
        ClassName immutFacetsType = ClassName.get((String)this.packageName, (String)Utils.getImmutFacetsClassname(this.vajramName()), (String[])new String[0]);
        if (this.currentVajramInfo.lite().isVajram()) {
            HashMap<String, List> resolverMap = new HashMap<String, List>();
            for (ExecutableElement resolver : this.getParsedVajramData().resolvers()) {
                String dependency = this.util.extractFacetName(this.vajramName(), ((Resolve)Preconditions.checkNotNull((Object)resolver.getAnnotation(Resolve.class))).dep(), resolver);
                resolverMap.computeIfAbsent(dependency, _k -> new ArrayList()).add(resolver);
            }
            ClassName batchFacetsClassName = this.getBatchFacetsClassName();
            ClassName commonFacetsClassName = this.getCommonFacetsClassName();
            TypeName vajramResponseType = this.util.toTypeName(this.getParsedVajramData().vajramInfo().lite().responseType());
            methodSpecs.add(this.createInputResolvers());
            if (this.util.isRawAssignable(this.getParsedVajramData().vajramInfo().vajramClass().asType(), IOVajramDef.class)) {
                methodSpecs.add(this.ioVajramExecuteMethod(batchFacetsClassName, commonFacetsClassName, vajramResponseType.box().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})));
            } else {
                methodSpecs.add(this.computeVajramExecuteMethod(vajramResponseType));
            }
            vajramWrprClass.addMethod(MethodSpec.methodBuilder((String)"facetsFromRequest").returns((TypeName)immutFacetsType.nestedClass("Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Request.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), "request", new Modifier[0]).addStatement("return new $T(($T)$L)", new Object[]{immutFacetsType.nestedClass("Builder"), this.currentVajramInfo.lite().conformsToTraitOrSelf().requestInterfaceType(), "request"}).build());
        }
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)vajramWrprClass.addMethods(methodSpecs).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(VajramDefRoot.class, "newRequestBuilder", 0)).returns((TypeName)immutRequestType.nestedClass("Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $T._builder()", new Object[]{immutRequestType}).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(VajramDefRoot.class, "requestRoot", 0)).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{requestInterfaceType})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $T.class", new Object[]{requestInterfaceType}).build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec createInputResolvers() {
        MethodSpec.Builder getInputResolversMethod = MethodSpec.methodBuilder((String)"getInputResolvers").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(ImmutableCollection.class, (Type[])new Type[]{InputResolver.class})).addAnnotation(Override.class);
        CodeBlock.Builder resolveMethodToObjConvCode = CodeBlock.builder();
        getInputResolversMethod.addCode("return $T.<$T>builder().addAll($L())", new Object[]{ImmutableList.class, InputResolver.class, "getSimpleInputResolvers"});
        HashMap<String, List> resolverMap = new HashMap<String, List>();
        for (ExecutableElement resolver : this.getParsedVajramData().resolvers()) {
            resolverMap.computeIfAbsent(this.util.extractFacetName(this.vajramName(), Objects.requireNonNull(resolver.getAnnotation(Resolve.class)).dep(), resolver), _k -> new ArrayList()).add(resolver);
        }
        resolverMap.forEach((depName, resolverMethods) -> {
            DependencyModel dep = this.currentVajramInfo.dependencies().stream().filter(d -> d.name().equals(depName)).findAny().orElseThrow();
            for (ExecutableElement resolverMethod : resolverMethods) {
                Resolve resolve = resolverMethod.getAnnotation(Resolve.class);
                if (resolve == null) {
                    throw new AssertionError((Object)"Cannot happen");
                }
                boolean fanoutResolver = this.util.isRawAssignable(resolverMethod.getReturnType(), FanoutCommand.class);
                List<String> resolvedInputNames = Arrays.stream(resolve.depInputs()).map(di -> this.util.extractFacetName(dep.depVajramInfo().vajramId().vajramId(), (String)di, resolverMethod)).toList();
                Class inputResolverInterfaceClass = fanoutResolver ? FanoutInputResolver.class : One2OneInputResolver.class;
                MethodSpec.Builder resolveMethod = MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(inputResolverInterfaceClass, "resolve", 2), (DeclaredType)((DeclaredType)((TypeElement)Preconditions.checkNotNull((Object)this.util.processingEnv().getElementUtils().getTypeElement((CharSequence)Preconditions.checkNotNull((Object)inputResolverInterfaceClass.getCanonicalName())))).asType()), (Types)this.util.processingEnv().getTypeUtils()).addCode(this.buildInputResolver(resolverMethod, fanoutResolver).build());
                List<FacetGenModel> usedFacets = resolverMethod.getParameters().stream().map(this::inferFacetId).map(key -> (FacetGenModel)Preconditions.checkNotNull((Object)this.facetModels.get(key))).toList();
                resolveMethodToObjConvCode.add(".add($L)", new Object[]{TypeSpec.anonymousClassBuilder((String)"$T.of($L), new $T($T.$L, $T.of($L))", (Object[])new Object[]{ImmutableSet.class, CodeBlock.of((String)usedFacets.stream().map(_f -> "$T.$L").collect(Collectors.joining(",")), (Object[])usedFacets.stream().flatMap(facet -> Stream.of(this.getFacetsInterfaceType(), facet.name() + "_s")).toArray()), ResolutionTarget.class, this.getFacetsInterfaceType(), dep.name() + "_s", ImmutableSet.class, CodeBlock.of((String)resolvedInputNames.stream().map(_f -> "$T.$L").collect(Collectors.joining(",")), (Object[])resolvedInputNames.stream().flatMap(inputName -> Stream.of(ClassName.get((String)dep.depReqPackageName(), (String)Utils.getRequestInterfaceName(dep.depVajramInfo().vajramId().vajramId()), (String[])new String[0]), inputName + "_s")).toArray())}).addSuperinterface(fanoutResolver ? AbstractFanoutInputResolver.class : AbstractOne2OneInputResolver.class).addMethod(resolveMethod.build()).build()});
            }
        });
        resolveMethodToObjConvCode.add(".build()", new Object[0]);
        return getInputResolversMethod.addStatement(resolveMethodToObjConvCode.build()).build();
    }

    private @NonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ParsedVajramData initParsedVajramData() {
        if (this.parsedVajramData == null) {
            this.parsedVajramData = ParsedVajramData.fromVajramInfo(this.currentVajramInfo, this.util).orElseThrow(() -> new VajramValidationException("Could not load Vajram class for vajramDef %s.\nParsedVajram Data should never be accessed in model generation phase.".formatted(this.currentVajramInfo.lite().vajramId())));
        }
        return this.parsedVajramData;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ParsedVajramData getParsedVajramData() {
        return this.parsedVajramData != null ? this.parsedVajramData : this.initParsedVajramData();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec computeVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName vajramResponseType) {
        MethodSpec.Builder executeBuilder = MethodSpec.methodBuilder((String)"executeCompute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{FacetValues.class}), "_facetValuesList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(FacetValues.class), ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{vajramResponseType.box()})})).addAnnotation(Override.class);
        if (this.needsBatching) {
            String message = "Batching is not supported in ComputeVajrams";
            this.util.error(message, this.getParsedVajramData().vajramInfo().givenFacets().stream().filter(FacetGenModel::isBatched).findAny().map(GivenFacetModel::facetField).orElse(this.getParsedVajramData().vajramInfo().vajramClass()));
            throw new VajramValidationException(message);
        }
        this.nonBatchedExecuteMethodBuilder(executeBuilder, false);
        return executeBuilder.build();
    }

    private void nonBatchedExecuteMethodBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec.Builder executeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isIOVajram) {
        String methodCallSuffix;
        CodeBlock.Builder returnBuilder = CodeBlock.builder().add("return _facetValuesList.stream().collect(\n     $T.toImmutableMap($T.identity(),\n     $L -> {\n        $T $L = ($T)$L;\n", new Object[]{ImmutableMap.class, Function.class, "_incomingFacets", this.getFacetsInterfaceType(), "_facetValues", this.getFacetsInterfaceType(), "_incomingFacets"});
        ExecutableElement outputLogic = Objects.requireNonNull(this.getParsedVajramData().outputLogic(), "Cannot generate execute method if output logic is missing");
        outputLogic.getParameters().forEach(parameter -> this.generateFacetLocalVariable(outputLogic, (VariableElement)parameter, returnBuilder, "_facetValues"));
        if (isIOVajram) {
            TypeMirror returnType = outputLogic.getReturnType();
            if (!this.util.isRawAssignable(returnType, CompletableFuture.class)) {
                String errorMessage = "The OutputLogic of non-batched IO vajramDef %s must return a CompletableFuture".formatted(this.vajramName());
                this.util.error(errorMessage, outputLogic);
                throw new VajramValidationException(errorMessage);
            }
            returnBuilder.add("\nreturn $L(\n", new Object[]{outputLogic.getSimpleName()});
            methodCallSuffix = ");\n";
        } else {
            returnBuilder.add("\nreturn $T.errableFrom(() -> $L(\n", new Object[]{Errable.class, outputLogic.getSimpleName()});
            methodCallSuffix = "));\n";
        }
        ArrayList<String> outputLogicParamsCode = new ArrayList<String>();
        ArrayList<Object> outputLogicParamsCodeArgs = new ArrayList<Object>();
        for (VariableElement variableElement : outputLogic.getParameters()) {
            this.generateLogicParams(variableElement, outputLogicParamsCode, outputLogicParamsCodeArgs);
        }
        returnBuilder.add(outputLogicParamsCode.stream().collect(Collectors.joining(", ")), outputLogicParamsCodeArgs.toArray());
        returnBuilder.add(methodCallSuffix, new Object[0]);
        returnBuilder.add("}));\n", new Object[0]);
        executeBuilder.addCode(returnBuilder.build());
    }

    private void generateLogicParams(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement param, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> outputLogicParamsCode, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> outputLogicParamsCodeArgs) {
        int facetId = this.inferFacetId(param);
        FacetGenModel facetGenModel = this.facetModels.get(facetId);
        if (facetGenModel == null) {
            throw new AssertionError((Object)"Cannot happen");
        }
        if (facetGenModel.isBatched()) {
            String message = "Cannot use batch facet '%s' as direct input param for output logic".formatted(facetId);
            this.util.error(message, param);
            throw new VajramValidationException(message);
        }
        outputLogicParamsCode.add("$L");
        outputLogicParamsCodeArgs.add(facetGenModel.name());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec ioVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName commonFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName vajramResponseType) {
        MethodSpec.Builder executeMethodBuilder = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{FacetValues.class}), "_facetValuesList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(FacetValues.class), ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        if (this.needsBatching) {
            this.batchedExecuteMethodBuilder(batchableInputs, commonFacets, vajramResponseType, codeBuilder, executeMethodBuilder);
        } else {
            this.nonBatchedExecuteMethodBuilder(executeMethodBuilder, true);
        }
        return executeMethodBuilder.build();
    }

    private void batchedExecuteMethodBuilder(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName commonFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName vajramResponseType, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder codeBuilder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec.Builder executeMethodBuilder) {
        ExecutableElement outputLogic = Objects.requireNonNull(this.getParsedVajramData().outputLogic(), "Execute method cannot be generated without output logic");
        ImmutableMap facets = (ImmutableMap)this.currentVajramInfo.facetStream().collect(ImmutableMap.toImmutableMap(FacetGenModel::name, Function.identity()));
        TypeMirror returnType = outputLogic.getReturnType();
        Preconditions.checkState((boolean)this.util.isRawAssignable(this.util.processingEnv().getTypeUtils().erasure(returnType), Map.class), (String)"A vajramDef supporting input batching must return map. Vajram: %s", (Object)this.vajramName());
        TypeMirror mapValue = Utils.getTypeParameters(returnType).get(1);
        if (!this.util.isRawAssignable(mapValue, CompletableFuture.class)) {
            String message = "Batched IO Vajram should return a map whose value type must be `CompletableFuture`.\nViolating vajramDef: %s".formatted(this.vajramName());
            this.util.error(message, outputLogic);
            throw new VajramValidationException(message);
        }
        String batchingExecutePrepareParams = "    if($facetValuesList:L.isEmpty()) {\n      return $imMap:T.of();\n    }\n    $map:T<$inputBatching:T, $facetValues:T> _batchItems = new $hashMap:T<>();\n    $commonInput:T _common = (($unmodInput:T)$facetValuesList:L.get(0))._common();\n    for ($facetValues:T $facetsVar:L : $facetValuesList:L) {\n      $unmodInput:T _castFacets = ($unmodInput:T) $facetsVar:L;\n      $inputBatching:T _batch = _castFacets._batchItem();\n      _batchItems.put(_batch, $facetsVar:L);\n    }\n";
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("facetValues", ClassName.get(FacetValues.class));
        valueMap.put("facetValuesList", "_facetValuesList");
        valueMap.put("facetsVar", "_facetValues");
        valueMap.put("unmodInput", ClassName.get((String)this.packageName, (String)Utils.getFacetsInterfaceName(this.vajramName()), (String[])new String[0]));
        valueMap.put("inputBatching", batchableInputs);
        valueMap.put("commonInput", commonFacets);
        valueMap.put("facetJavaType", vajramResponseType);
        valueMap.put("outputLogicMethod", outputLogic.getSimpleName());
        valueMap.put("modInput", ClassName.get(BatchedFacets.class));
        valueMap.put("imMap", ClassName.get(ImmutableMap.class));
        valueMap.put("imList", ClassName.get(ImmutableList.class));
        valueMap.put("hashMap", ClassName.get(HashMap.class));
        valueMap.put("arrayList", ClassName.get(ArrayList.class));
        valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
        valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
        valueMap.put("map", ClassName.get(Map.class));
        valueMap.put("list", ClassName.get(List.class));
        valueMap.put("valErr", Errable.class);
        valueMap.put("function", ClassName.get(Function.class));
        valueMap.put("optional", ClassName.get(Optional.class));
        codeBuilder.addNamed(batchingExecutePrepareParams, valueMap);
        for (VariableElement variableElement : outputLogic.getParameters()) {
            if (variableElement.getSimpleName().contentEquals("_batchItems")) {
                TypeMirror paramType = variableElement.asType();
                List<? extends TypeMirror> list = Utils.getTypeParameters(paramType);
                TypeMirror expected = ((TypeElement)Preconditions.checkNotNull((Object)this.util.processingEnv().getElementUtils().getTypeElement(this.getBatchFacetsClassName().canonicalName()))).asType();
                if (this.util.processingEnv().getTypeUtils().isSameType(Objects.requireNonNull(this.util.processingEnv().getTypeUtils().asElement(paramType)).asType(), Objects.requireNonNull(this.util.processingEnv().getElementUtils().getTypeElement(Objects.requireNonNull(ImmutableCollection.class.getCanonicalName()))).asType()) && list.size() == 1 && this.util.processingEnv().getTypeUtils().isSameType(expected, list.get(0))) continue;
                throw this.util.errorAndThrow("Batch of facetValues param must be of ImmutableCollection<" + expected + "> . Found: " + paramType, variableElement);
            }
            FacetGenModel facet = (FacetGenModel)facets.get((Object)variableElement.getSimpleName().toString());
            if (facet == null) {
                throw this.util.errorAndThrow("No facet with the name " + variableElement.getSimpleName() + " exists in the vajramDef " + this.currentVajramInfo.lite().vajramId(), variableElement);
            }
            if (!facet.isUsedToGroupBatches()) {
                throw this.util.errorAndThrow("Facet '" + facet.name() + "' can be accessed individually in the output logic only if it has been annotated as @" + BatchesGroupedBy.class.getSimpleName(), variableElement);
            }
            this.generateFacetLocalVariable(outputLogic, variableElement, codeBuilder, "_common");
        }
        codeBuilder.add("var _output = $L(", new Object[]{outputLogic.getSimpleName()});
        ArrayList<String> outputLogicParamsCode = new ArrayList<String>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (VariableElement variableElement : outputLogic.getParameters()) {
            if (variableElement.getSimpleName().contentEquals("_batchItems")) {
                outputLogicParamsCode.add("$T.copyOf($L.keySet())");
                arrayList.add(ImmutableList.class);
                arrayList.add("_batchItems");
                continue;
            }
            this.generateLogicParams(variableElement, outputLogicParamsCode, arrayList);
        }
        codeBuilder.add(outputLogicParamsCode.stream().collect(Collectors.joining(", ")), arrayList.toArray());
        codeBuilder.add(");", new Object[0]);
        codeBuilder.addNamed("    $map:T<$facetValues:T, $comFuture:T<$facetJavaType:T>> _returnValue = new $linkHashMap:T<>();\n\n    _output.forEach((_batch, _result) -> _returnValue.put(\n          $optional:T.ofNullable(_batchItems.get(_batch)).orElseThrow(),\n          _result.<$facetJavaType:T>thenApply($function:T.identity())));\n    return $imMap:T.copyOf(_returnValue);\n", valueMap);
        executeMethodBuilder.addCode(codeBuilder.build());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder buildInputResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean fanoutResolver) {
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method must have 'Resolve' annotation");
        String depName = this.util.extractFacetName(this.vajramName(), resolve.dep(), method);
        FacetGenModel facetGenModel = (FacetGenModel)Preconditions.checkNotNull((Object)this.facetModelsByName.get(depName));
        if (!(facetGenModel instanceof DependencyModel)) {
            String message = "No facet definition found for " + facetGenModel.name();
            this.util.error(message, method);
            throw new VajramValidationException(message);
        }
        DependencyModel dependencyModel = (DependencyModel)facetGenModel;
        VajramID depVajramName = dependencyModel.depVajramInfo().vajramId();
        String depRequestPackage = dependencyModel.depReqPackageName();
        ClassName requestBuilderType = ClassName.get((String)depRequestPackage, (String)Utils.getImmutRequestInterfaceName(depVajramName.vajramId()), (String[])new String[0]).nestedClass("Builder");
        CodeBlock.Builder codeBuilder = fanoutResolver ? CodeBlock.builder().addStatement("var $2L = (($1T)arg0)", new Object[]{requestBuilderType, "_resolverRequest"}) : CodeBlock.builder().addStatement("var $2L = (($1T)arg0)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableList.class), (TypeName[])new TypeName[]{requestBuilderType}), "_resolverRequests"});
        codeBuilder.addStatement("var $L = (($T)arg1)", new Object[]{"_facetValues", this.getFacetsInterfaceType()});
        method.getParameters().forEach(parameter -> this.generateFacetLocalVariable(method, (VariableElement)parameter, codeBuilder, "_facetValues"));
        this.buildResolverInvocation(codeBuilder, method, dependencyModel, Arrays.stream(resolve.depInputs()).map(di -> this.util.extractFacetName(dependencyModel.depVajramInfo().vajramId().vajramId(), (String)di, method)).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll), fanoutResolver, requestBuilderType);
        return codeBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateFacetLocalVariable(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement parameter, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder codeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String facetsVar) {
        int usingFacetId = this.inferFacetId(parameter);
        FacetGenModel usingFacetModel = (FacetGenModel)Preconditions.checkNotNull((Object)this.facetModels.get(usingFacetId));
        if (usingFacetModel instanceof DependencyModel) {
            this.generateDependencyResolutions(method, usingFacetId, codeBuilder, parameter);
            return;
        }
        if (!(usingFacetModel instanceof GivenFacetModel)) {
            String message = "No facetDef resolver found for " + usingFacetModel.name();
            this.util.error(message, parameter);
            throw new VajramValidationException(message);
        }
        GivenFacetModel givenFacetModel = (GivenFacetModel)usingFacetModel;
        TypeMirror facetType = this.util.toTypeMirror(givenFacetModel.dataType());
        String variable = usingFacetModel.name();
        TypeMirror parameterTypeMirror = parameter.asType();
        TypeName parameterType = TypeName.get((TypeMirror)parameterTypeMirror);
        if (givenFacetModel.isMandatory()) {
            if (!this.util.processingEnv().getTypeUtils().isAssignable(facetType, parameterTypeMirror)) {
                String message = String.format("Incorrect facet type being consumed. Expected '%s', found '%s'".formatted(facetType, parameterType), usingFacetModel.name());
                this.util.error(message, parameter);
                throw new VajramValidationException(message);
            }
            codeBuilder.add(CodeBlock.builder().addStatement("var $L = $T.validateMandatoryFacet($L.$L(), $S, $S)", new Object[]{variable, FacetValidation.class, facetsVar, usingFacetModel.name(), this.currentVajramInfo.lite().vajramId().vajramId(), usingFacetModel.name()}).build());
            return;
        }
        if (this.util.isRawAssignable(parameterTypeMirror, Optional.class)) {
            codeBuilder.add(CodeBlock.builder().addStatement("var $L = $T.ofNullable($L.$L())", new Object[]{variable, Optional.class, facetsVar, usingFacetModel.name()}).build());
            return;
        }
        String message = String.format("Optional dependency %s must have type as Optional", usingFacetModel.name());
        this.util.error(message, parameter);
        throw new VajramValidationException(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateDependencyResolutions(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int usingFacetId, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement parameter) {
        FacetGenModel usingFacetDef = (FacetGenModel)Preconditions.checkNotNull((Object)this.facetModels.get(usingFacetId));
        TypeMirror parameterType = parameter.asType();
        String usingFacetName = usingFacetDef.name();
        if (!(usingFacetDef instanceof DependencyModel)) return;
        DependencyModel dependencyModel = (DependencyModel)usingFacetDef;
        String variableName = usingFacetName;
        VajramInfoLite depVajramInfoLite = dependencyModel.depVajramInfo();
        String requestClass = dependencyModel.depReqClassQualifiedName();
        TypeName boxedDepType = this.util.toTypeName(depVajramInfoLite.responseType()).box();
        TypeName unboxedDepType = boxedDepType.isBoxedPrimitive() ? boxedDepType.unbox() : boxedDepType;
        String logicName = method.getSimpleName().toString();
        if (this.depFanoutMap.getOrDefault(usingFacetId, false).booleanValue()) {
            boolean typeMismatch = false;
            if (!this.util.isRawAssignable(parameterType, FanoutDepResponses.class)) {
                typeMismatch = true;
            } else if (Utils.getTypeParameters(parameterType).size() != 2) {
                typeMismatch = true;
            }
            if (typeMismatch) {
                String message = "The fanout dependency ('%s') can be consumed only via the FanoutDepResponses<ReqType,RespType> class. Found '%s' instead".formatted(dependencyModel.name(), parameterType);
                this.util.error(message, parameter);
                throw new VajramValidationException(message);
            }
            String depValueAccessorCode = "$T $L = $L.$L()";
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(FanoutDepResponses.class), (TypeName[])new TypeName[]{Utils.toClassName(requestClass), boxedDepType}), variableName, "_facetValues", usingFacetName});
            return;
        }
        String depValueAccessorCode = "$1T $2L =\n  $3L.$4L()";
        if (usingFacetDef.isMandatory()) {
            if (unboxedDepType.equals((Object)TypeName.get((TypeMirror)parameterType))) {
                ifBlockBuilder.addStatement(depValueAccessorCode + ".response().valueOrThrow()", new Object[]{unboxedDepType, variableName, "_facetValues", usingFacetName});
                return;
            }
            String message = "A resolver must consume a mandatory dependency directly using its type (%s). Found '%s' instead".formatted(unboxedDepType, parameterType);
            this.util.error(message, parameter);
            throw new VajramValidationException(message);
        }
        if (this.util.isRawAssignable(parameterType, Errable.class)) {
            ifBlockBuilder.addStatement(depValueAccessorCode + ".response()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, "_facetValues", usingFacetName});
            return;
        }
        if (this.util.isRawAssignable(parameterType, Optional.class)) {
            String code = depValueAccessorCode + ".response().valueOpt()";
            ifBlockBuilder.addStatement(code, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, "_facetValues", usingFacetName});
            return;
        }
        if (this.util.isRawAssignable(parameterType, One2OneDepResponse.class)) {
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, "_facetValues", usingFacetName});
            return;
        }
        String message = "A resolver ('%s') must not access an optional dependency ('%s') directly.Use Optional<>, Errable<>, or DependencyResponse<> instead".formatted(logicName, usingFacetName);
        this.util.error(message, parameter);
        throw new VajramValidationException(message);
    }

    private void buildResolverInvocation(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeBlock.Builder methodCodeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement resolverMethod, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyModel dependencyModel, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> depInputNames, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean fanoutResolver, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName requestBuilderType) {
        String resolverResultVar = fanoutResolver ? "_resolverResults" : "_resolverResult";
        methodCodeBuilder.add("var $L = $L(", new Object[]{resolverResultVar, resolverMethod.getSimpleName()});
        ImmutableList resolverSources = this.getResolverSources(resolverMethod).asList();
        for (int i = 0; i < resolverSources.size(); ++i) {
            int facetId = (Integer)resolverSources.get(i);
            String facetName = ((FacetGenModel)Preconditions.checkNotNull((Object)this.facetModels.get(facetId))).name();
            methodCodeBuilder.add("$L", new Object[]{facetName});
            if (i == resolverMethod.getParameters().size() - 1) continue;
            methodCodeBuilder.add(", ", new Object[0]);
        }
        methodCodeBuilder.add(");\n", new Object[0]);
        TypeMirror returnType = this.util.box(resolverMethod.getReturnType());
        boolean resovlerReturnedDepCommand = false;
        if (this.util.isRawAssignable(returnType, DependencyCommand.class)) {
            resovlerReturnedDepCommand = true;
            methodCodeBuilder.beginControlFlow("if($L.shouldSkip())", new Object[]{resolverResultVar});
            methodCodeBuilder.addStatement("\t return $T.skip($L.doc(), $L.skipCause())", new Object[]{ResolverCommand.class, resolverResultVar, resolverResultVar});
            methodCodeBuilder.add("} else {\n\t", new Object[0]);
            TypeMirror actualReturnType = Utils.getTypeParameters(returnType).get(0);
            if (this.util.isRawAssignable(returnType, One2OneCommand.class)) {
                methodCodeBuilder.beginControlFlow("for($T $L: $L)", new Object[]{requestBuilderType, "_resolverRequest", "_resolverRequests"});
                if (this.util.isRawAssignable(actualReturnType, Request.class)) {
                    for (String depInputName : depInputNames) {
                        methodCodeBuilder.addStatement("$L.ifPresent(_r -> $L.$L(_r.$L()))", new Object[]{"_resolverResult", "_resolverRequest", depInputName, depInputName});
                    }
                } else {
                    if (depInputNames.size() != 1) {
                        throw this.util.errorAndThrow("Resolver method which resolves multiple dependency inputs must return a Request Builder object", resolverMethod);
                    }
                    String depFacetName = depInputNames.iterator().next();
                    methodCodeBuilder.addStatement("$L.ifPresent($L::$L)", new Object[]{"_resolverResult", "_resolverRequest", depFacetName});
                }
                methodCodeBuilder.endControlFlow();
            } else if (this.util.isRawAssignable(returnType, FanoutCommand.class)) {
                if (!dependencyModel.canFanout()) {
                    String message = "Dependency '%s' is not a fanout dependency, yet the resolver method returns a MultiExecute command. This is not allowed. Return a SingleExecute command, a single value, or mark the dependency as `canFanout = true`.".formatted(dependencyModel.name());
                    this.util.error(message, resolverMethod);
                    throw new VajramValidationException(message);
                }
                methodCodeBuilder.addStatement("var $L = new $T()", new Object[]{"_resolverRequests", ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{requestBuilderType})});
                if (this.util.isRawAssignable(actualReturnType, ImmutableRequest.Builder.class) && depInputNames.size() <= 1) {
                    throw this.util.errorAndThrow("Resolver method that returns a request builder object must resolve multiple dependency inputs. Otherwise this can lead to unnecessary creation of request builder objects.", resolverMethod);
                }
                methodCodeBuilder.beginControlFlow("for($T $L: $L.inputs())", new Object[]{actualReturnType, "_resolverResult", "_resolverResults"});
                if (this.util.isRawAssignable(actualReturnType, ImmutableRequest.Builder.class)) {
                    methodCodeBuilder.add("$L.add($L._newCopy()", new Object[]{"_resolverRequests", "_resolverRequest"});
                    for (String depFacetName : depInputNames) {
                        methodCodeBuilder.add(".$L($L.$L())", new Object[]{depFacetName, "_resolverResult", depFacetName});
                    }
                    methodCodeBuilder.add(");", new Object[0]);
                } else {
                    if (depInputNames.size() > 1) {
                        throw this.util.errorAndThrow("Resolver method which resolves multiple dependency inputs must return a %s object".formatted(ImmutableRequest.Builder.class), resolverMethod);
                    }
                    String depFacetName = depInputNames.iterator().next();
                    methodCodeBuilder.addStatement("$L.add($L._newCopy().$L($L))", new Object[]{"_resolverRequests", "_resolverRequest", depFacetName, "_resolverResult"});
                }
                methodCodeBuilder.endControlFlow();
            }
        } else if (this.util.isRawAssignable(returnType, Request.class)) {
            methodCodeBuilder.beginControlFlow("for($T $L: $L)", new Object[]{requestBuilderType, "_resolverRequest", "_resolverRequests"});
            for (String depFacetName : depInputNames) {
                methodCodeBuilder.addStatement("$L.$L($L.$L())", new Object[]{"_resolverRequest", depFacetName, "_resolverResult", depFacetName});
            }
            methodCodeBuilder.endControlFlow();
        } else {
            methodCodeBuilder.beginControlFlow("for($T $L: $L)", new Object[]{requestBuilderType, "_resolverRequest", "_resolverRequests"});
            if (depInputNames.size() != 1) {
                throw this.util.errorAndThrow("Resolver method which resolves multiple dependency inputs must return a Request object", resolverMethod);
            }
            String depFacetName = depInputNames.iterator().next();
            methodCodeBuilder.addStatement("$L.$L($L)\n", new Object[]{"_resolverRequest", depFacetName, "_resolverResult"});
            methodCodeBuilder.endControlFlow();
        }
        if (fanoutResolver) {
            methodCodeBuilder.addStatement("return $T.executeWithRequests($T.copyOf($L))", new Object[]{ResolverCommand.class, ImmutableList.class, "_resolverRequests"});
        } else {
            methodCodeBuilder.addStatement("return $T.executeWithRequests($L)", new Object[]{ResolverCommand.class, "_resolverRequests"});
        }
        if (resovlerReturnedDepCommand) {
            methodCodeBuilder.endControlFlow();
        }
    }

    public void vajramRequest() {
        ClassName requestInterfaceType = this.currentVajramInfo.lite().requestInterfaceType();
        ClassName immutReqInterfaceType = this.currentVajramInfo.lite().immutReqInterfaceType();
        List<GivenFacetModel> inputs = this.currentVajramInfo.givenFacets().stream().filter(facetDef -> facetDef.facetTypes().contains((Object)FacetType.INPUT)).toList();
        TypeSpec.Builder requestInterface = this.util.interfaceBuilder(requestInterfaceType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.currentVajramInfo.lite().isTrait() ? TraitRequestRoot.class : VajramRequestRoot.class).addSuperinterfaces(this.currentVajramInfo.lite().requestInterfaceSuperTypes());
        this.facetConstants(requestInterface, inputs, CodeGenParams.builder().isRequest(true).build());
        this.facetsClassMembers(requestInterface, requestInterfaceType, this.currentVajramInfo.facetStream().filter(facet -> facet.facetTypes().contains((Object)FacetType.INPUT)).toList(), CodeGenParams.builder().isRequest(true).build());
        TypeSpec.Builder immutReqInterface = this.util.interfaceBuilder(immutReqInterfaceType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterfaces(this.currentVajramInfo.lite().immutReqInterfaceSuperTypes());
        TypeSpec.Builder builderInterface = this.util.interfaceBuilder("Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterfaces(this.currentVajramInfo.lite().reqBuilderInterfaceSuperTypes());
        this.facetsClassMembers(builderInterface, immutReqInterfaceType, this.currentVajramInfo.facetStream().filter(facet -> facet.facetTypes().contains((Object)FacetType.INPUT)).toList(), CodeGenParams.builder().isRequest(true).isBuilder(true).build());
        ClassName immutRequestPojoType = ClassName.get((String)this.packageName, (String)Utils.getImmutRequestPojoName(this.vajramName()), (String[])new String[0]);
        ClassName pojoRequestBuilderType = immutRequestPojoType.nestedClass("Builder");
        TypeSpec.Builder immutRequestPojo = this.util.classBuilder(immutRequestPojoType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)immutReqInterfaceType);
        this.facetsClassMembers(immutRequestPojo, immutRequestPojoType, this.currentVajramInfo.facetStream().filter(facet -> facet.facetTypes().contains((Object)FacetType.INPUT)).toList(), CodeGenParams.builder().isRequest(true).withImpl(true).build());
        TypeSpec.Builder builderClass = this.util.classBuilder("Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addSuperinterface(this.currentVajramInfo.lite().builderInterfaceType());
        this.facetsClassMembers(builderClass, immutRequestPojoType, this.currentVajramInfo.facetStream().filter(facet -> facet.facetTypes().contains((Object)FacetType.INPUT)).toList(), CodeGenParams.builder().isRequest(true).isBuilder(true).withImpl(true).build());
        this.util.generateSourceFile(requestInterfaceType.canonicalName(), JavaFile.builder((String)this.packageName, (TypeSpec)requestInterface.addMethods(this.facetContainerMethods(inputs, requestInterfaceType, immutReqInterfaceType, CodeGenParams.builder().isRequest(true).build())).build()).build().toString(), this.currentVajramInfo.vajramClass());
        this.util.generateSourceFile(immutReqInterfaceType.canonicalName(), JavaFile.builder((String)this.packageName, (TypeSpec)immutReqInterface.addMethods(this.facetContainerMethods(inputs, immutReqInterfaceType, immutReqInterfaceType, CodeGenParams.builder().isRequest(true).build())).addType(builderInterface.addMethods(this.facetContainerMethods(inputs, immutReqInterfaceType, immutReqInterfaceType, CodeGenParams.builder().isRequest(true).isBuilder(true).build())).build()).build()).build().toString(), this.currentVajramInfo.vajramClass());
        this.util.generateSourceFile(immutRequestPojoType.canonicalName(), JavaFile.builder((String)this.packageName, (TypeSpec)immutRequestPojo.addMethods(this.facetContainerMethods(inputs, immutRequestPojoType, immutRequestPojoType, CodeGenParams.builder().isRequest(true).withImpl(true).build())).addMethod(MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)pojoRequestBuilderType).addStatement("return new $T()", new Object[]{pojoRequestBuilderType}).build()).addType(builderClass.addMethods(this.facetContainerMethods(inputs, immutRequestPojoType, immutRequestPojoType, CodeGenParams.builder().isRequest(true).isBuilder(true).withImpl(true).build())).build()).build()).build().toString(), this.currentVajramInfo.vajramClass());
    }

    private void facetsClassMembers(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder classSpec, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName enclosingClassType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> eligibleFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        if (codeGenParams.wrapsRequest() && codeGenParams.isRequest()) {
            throw new IllegalArgumentException("A request cannot wrap another request - this is a bug");
        }
        MethodSpec.Builder fullConstructor = MethodSpec.constructorBuilder();
        ClassName immutRequestType = this.currentVajramInfo.lite().conformsToTraitOrSelf().immutReqInterfaceType();
        if (codeGenParams.withImpl()) {
            classSpec.addAnnotations(codeGenParams.isBuilder() ? List.of(AnnotationSpec.builder(ToString.class).addMember("doNotUseGetters", "true", new Object[0]).build()) : Utils.recordAnnotations());
            if (codeGenParams.wrapsRequest()) {
                ClassName requestOrBuilderType = codeGenParams.isBuilder() ? immutRequestType.nestedClass("Builder") : immutRequestType;
                fullConstructor.addParameter(ParameterSpec.builder((TypeName)requestOrBuilderType, (String)"_request", (Modifier[])new Modifier[0]).build());
                fullConstructor.addStatement("this._request = _request", new Object[0]);
                FieldSpec.Builder builder = FieldSpec.builder((TypeName)requestOrBuilderType, (String)"_request", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                if (!codeGenParams.isBuilder()) {
                    builder.addModifiers(new Modifier[]{Modifier.FINAL});
                }
                classSpec.addField(builder.build());
            }
            if (codeGenParams.isFacetsSubset() && codeGenParams.isBuilder()) {
                MethodSpec.Builder requestConstructor = MethodSpec.constructorBuilder();
                requestConstructor.addParameter(ParameterSpec.builder((TypeName)this.currentVajramInfo.lite().conformsToTraitOrSelf().requestInterfaceType(), (String)"_request", (Modifier[])new Modifier[0]).addAnnotation(NonNull.class).build());
                for (FacetGenModel facetGenModel : eligibleFacets) {
                    if (!facetGenModel.facetTypes().contains((Object)FacetType.INPUT)) continue;
                    requestConstructor.addStatement("this.$L = $T.$L.getFromRequest(_request)", new Object[]{facetGenModel.name(), this.getRequestInterfaceType(), facetGenModel.name() + "_s"});
                }
                classSpec.addMethod(requestConstructor.build());
            }
        }
        for (FacetGenModel facetGenModel : eligibleFacets) {
            FacetJavaType facetJavaType = this.util.getFacetFieldType(facetGenModel);
            ParameterSpec facetParam = ParameterSpec.builder((TypeName)facetJavaType.javaTypeName(facetGenModel).annotated(Utils.annotations(facetJavaType.typeAnnotations(facetGenModel, codeGenParams))), (String)facetGenModel.name(), (Modifier[])new Modifier[0]).build();
            boolean isInput = facetGenModel.facetTypes().contains((Object)FacetType.INPUT);
            if (!(!codeGenParams.withImpl() || isInput && codeGenParams.wrapsRequest())) {
                FieldSpec.Builder facetField = FieldSpec.builder((TypeName)facetJavaType.javaTypeName(facetGenModel).annotated(Utils.annotations(facetJavaType.typeAnnotations(facetGenModel, codeGenParams))), (String)facetGenModel.name(), (Modifier[])new Modifier[]{Modifier.PRIVATE});
                if (codeGenParams.isBuilder()) {
                    facetField.initializer(facetJavaType.fieldInitializer(facetGenModel));
                } else {
                    facetField.addModifiers(new Modifier[]{Modifier.FINAL});
                }
                classSpec.addField(facetField.build());
                fullConstructor.addParameter(facetParam);
                fullConstructor.addStatement("this.$L = $L", new Object[]{facetGenModel.name(), facetGenModel.name()});
            }
            this.createFacetGetter(classSpec, facetGenModel, codeGenParams);
            if (!codeGenParams.isBuilder()) continue;
            MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)facetGenModel.name()).returns((TypeName)enclosingClassType.nestedClass("Builder")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(facetParam);
            if (codeGenParams.withImpl()) {
                setterBuilder.addStatement(isInput && codeGenParams.wrapsRequest() ? CodeBlock.of((String)"this._request.$L($L)", (Object[])new Object[]{facetGenModel.name(), facetGenModel.name()}) : CodeBlock.of((String)"this.$L = $L", (Object[])new Object[]{facetGenModel.name(), facetGenModel.name()})).addStatement("return this", new Object[]{facetGenModel.name()});
            } else {
                setterBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            }
            classSpec.addMethod(setterBuilder.build());
        }
        if (codeGenParams.withImpl()) {
            classSpec.addMethod(fullConstructor.build());
        }
        if (codeGenParams.isBuilder() && codeGenParams.withImpl() && !fullConstructor.parameters.isEmpty()) {
            classSpec.addMethod(MethodSpec.constructorBuilder().addCode(codeGenParams.wrapsRequest() ? CodeBlock.builder().addStatement("this._request = $T._builder()", new Object[]{this.currentVajramInfo.lite().immutReqPojoType()}).build() : CodeBlock.builder().build()).build());
        }
        if (codeGenParams.isBuilder() && codeGenParams.withImpl() && !codeGenParams.isRequest() && !codeGenParams.isFacetsSubset()) {
            classSpec.addMethod(MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)this.currentVajramInfo.lite().conformsToTraitOrSelf().requestInterfaceType(), (String)"_request", (Modifier[])new Modifier[0]).build()).addStatement("this._request = _request._asBuilder()", new Object[0]).build());
        }
    }

    private void createFacetGetter(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder clazz, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel facet, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        TypeName typeName;
        FacetJavaType fieldType = this.util.getFacetFieldType(facet);
        FacetJavaType returnType = this.util.getReturnType(facet, codeGenParams);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)facet.name()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            typeName = this.util.wrapWithFacetValueClass(dep);
        } else {
            typeName = returnType.javaTypeName(facet).annotated(Utils.annotations(returnType.typeAnnotations(facet, codeGenParams)));
        }
        MethodSpec.Builder method = builder.returns(typeName);
        if (codeGenParams.withImpl()) {
            method.addStatement(fieldType.fieldGetterCode(facet, codeGenParams));
        } else {
            method.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        clazz.addMethod(method.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec> facetContainerMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> eligibleFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName enclosingClassName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName immutableClassName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        ArrayList<MethodSpec.Builder> methodBuilders = new ArrayList<MethodSpec.Builder>();
        String constructorParamString = (codeGenParams.isRequest() ? eligibleFacets.stream().map(FacetGenModel::name) : (codeGenParams.wrapsRequest() ? Stream.concat(Stream.of("%s"), eligibleFacets.stream().filter(f -> !f.facetTypes().contains((Object)FacetType.INPUT)).map(FacetGenModel::name)) : eligibleFacets.stream().map(FacetGenModel::name))).collect(Collectors.joining(", "));
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"_build").returns((TypeName)immutableClassName);
        if (codeGenParams.withImpl()) {
            methodBuilder.addStatement(codeGenParams.isBuilder() ? "return new %s(%s)".formatted(immutableClassName.simpleName(), constructorParamString.formatted(codeGenParams.wrapsRequest() ? "_request._build()" : "_batchable._build(), _common._build()")) : "return this", new Object[0]);
        } else {
            methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        methodBuilders.add(methodBuilder);
        methodBuilder = MethodSpec.methodBuilder((String)"_asBuilder").returns((TypeName)immutableClassName.nestedClass("Builder"));
        if (codeGenParams.withImpl()) {
            methodBuilder.addStatement(codeGenParams.isBuilder() ? "return this" : "return new Builder(%s)".formatted(constructorParamString.formatted(codeGenParams.wrapsRequest() ? "_request._asBuilder()" : "_batchable._asBuilder(), _common._asBuilder()")), new Object[0]);
        } else {
            methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        methodBuilders.add(methodBuilder);
        methodBuilder = MethodSpec.methodBuilder((String)"_newCopy").returns((TypeName)(codeGenParams.isBuilder() ? enclosingClassName.nestedClass("Builder") : enclosingClassName));
        if (codeGenParams.withImpl()) {
            methodBuilder.addStatement(codeGenParams.isBuilder() ? "return new Builder(%s)".formatted(constructorParamString.formatted(codeGenParams.wrapsRequest() ? "_request._newCopy()" : "_batchable._newCopy(), _common._newCopy()")) : "return this", new Object[0]);
        } else {
            methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        methodBuilders.add(methodBuilder);
        ImmutableList.Builder list = ImmutableList.builder();
        for (MethodSpec.Builder b : methodBuilders) {
            if (b == null) continue;
            MethodSpec build = b.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).build();
            list.add((Object)build);
        }
        return list.build();
    }

    public void vajramFacets() {
        this.basicFacetsClasses();
        boolean doInputsNeedBatching = this.currentVajramInfo.facetStream().anyMatch(FacetGenModel::isBatched);
        if (doInputsNeedBatching) {
            this.batchFacetsClasses();
        }
    }

    private void basicFacetsClasses() {
        StringWriter writer;
        boolean doInputsNeedBatching = this.currentVajramInfo.facetStream().anyMatch(FacetGenModel::isBatched);
        List<FacetGenModel> allFacets = this.currentVajramInfo.facetStream().toList();
        ClassName facetsType = this.getFacetsInterfaceType();
        ClassName immutableFacetsType = ClassName.get((String)this.packageName, (String)Utils.getImmutFacetsClassname(this.vajramName()), (String[])new String[0]);
        TypeSpec.Builder facetsInterface = this.util.interfaceBuilder(Utils.getFacetsInterfaceName(this.vajramName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(doInputsNeedBatching ? BatchEnabledFacetValues.class : FacetValues.class);
        this.facetConstants(facetsInterface, this.currentVajramInfo.facetStream().toList(), CodeGenParams.builder().build());
        allFacets.forEach(facet -> this.createFacetGetter(facetsInterface, (FacetGenModel)facet, CodeGenParams.builder().wrapsRequest(true).build()));
        TypeSpec.Builder immutFacetsClass = this.util.classBuilder(Utils.getImmutFacetsClassname(this.vajramName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)facetsType).addSuperinterface(doInputsNeedBatching ? BatchEnabledImmutableFacetValues.class : ImmutableFacetValues.class);
        this.facetsClassMembers(immutFacetsClass, immutableFacetsType, allFacets, CodeGenParams.builder().wrapsRequest(true).withImpl(true).build());
        TypeSpec.Builder facetsBuilderClass = this.util.classBuilder("Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)facetsType).addSuperinterface(doInputsNeedBatching ? BatchEnabledImmutableFacetValues.Builder.class : FacetValuesBuilder.class);
        this.facetsClassMembers(facetsBuilderClass, immutableFacetsType, allFacets, CodeGenParams.builder().wrapsRequest(true).isBuilder(true).withImpl(true).build());
        if (doInputsNeedBatching) {
            ClassName batchImmutFacetsType = this.getBatchFacetsClassName();
            ClassName commonImmutFacetsType = this.getCommonFacetsClassName();
            this.codegenBatchableFacets(facetsInterface, batchImmutFacetsType, commonImmutFacetsType, CodeGenParams.builder().build());
            this.codegenBatchableFacets(immutFacetsClass, batchImmutFacetsType, commonImmutFacetsType, CodeGenParams.builder().withImpl(true).build());
            this.codegenBatchableFacets(facetsBuilderClass, batchImmutFacetsType, commonImmutFacetsType, CodeGenParams.builder().withImpl(true).build());
        }
        try {
            writer = new StringWriter();
            JavaFile.builder((String)this.packageName, (TypeSpec)facetsInterface.addMethod(MethodSpec.methodBuilder((String)"_build").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)immutableFacetsType).addAnnotation(Override.class).build()).addMethod(MethodSpec.methodBuilder((String)"_asBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)immutableFacetsType.nestedClass("Builder")).addAnnotation(Override.class).build()).build()).build().writeTo((Appendable)writer);
            this.util.generateSourceFile(this.packageName() + "." + Utils.getFacetsInterfaceName(this.vajramName()), writer.toString(), this.currentVajramInfo.vajramClass());
        }
        catch (IOException e) {
            this.util.error(String.valueOf(e.getMessage()), this.currentVajramInfo.vajramClass());
        }
        try {
            writer = new StringWriter();
            JavaFile.builder((String)this.packageName, (TypeSpec)immutFacetsClass.addMethods(this.facetContainerMethods(allFacets, immutableFacetsType, immutableFacetsType, CodeGenParams.builder().wrapsRequest(true).withImpl(true).build())).addMethod(MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)immutableFacetsType.nestedClass("Builder")).addStatement("return new $T()", new Object[]{immutableFacetsType.nestedClass("Builder")}).build()).addType(facetsBuilderClass.addMethods(this.facetContainerMethods(allFacets, immutableFacetsType, immutableFacetsType, CodeGenParams.builder().wrapsRequest(true).isBuilder(true).withImpl(true).build())).build()).build()).build().writeTo((Appendable)writer);
            this.util.generateSourceFile(this.packageName() + "." + Utils.getImmutFacetsClassname(this.vajramName()), writer.toString(), this.currentVajramInfo.vajramClass());
        }
        catch (IOException e) {
            this.util.error(String.valueOf(e.getMessage()), this.currentVajramInfo.vajramClass());
        }
    }

    private void batchFacetsClasses() {
        ClassName allFacetsType = this.getFacetsInterfaceType();
        ClassName allImmutFacetsType = ClassName.get((String)this.packageName, (String)Utils.getImmutFacetsClassname(this.vajramName()), (String[])new String[0]);
        ClassName batchImmutFacetsType = this.getBatchFacetsClassName();
        ClassName commonImmutFacetsType = this.getCommonFacetsClassName();
        List<FacetGenModel> batchedFacets = this.currentVajramInfo.facetStream().filter(FacetGenModel::isBatched).toList();
        List<FacetGenModel> commonFacets = this.currentVajramInfo.facetStream().filter(FacetGenModel::isUsedToGroupBatches).toList();
        TypeSpec.Builder batchImmutFacetsClass = this.util.classBuilder(batchImmutFacetsType.simpleName()).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface(ImmutableFacetValuesContainer.class).addField((TypeName)allImmutFacetsType, "_facetValues", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)allFacetsType, "_facetValues", new Modifier[0]).addStatement("this.$L = $L._build()", new Object[]{"_facetValues", "_facetValues"}).build()).addAnnotation(AnnotationSpec.builder(EqualsAndHashCode.class).addMember("onlyExplicitlyIncluded", "true", new Object[0]).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_facets", 0)).addStatement("return $T._facets.stream()\n  .filter($T::isBatched)\n  .collect($T.toImmutableSet())\n", new Object[]{this.getFacetsInterfaceType(), FacetSpec.class, ImmutableSet.class}).build());
        for (FacetGenModel facet : batchedFacets) {
            CodeGenParams codeGenParams = CodeGenParams.builder().isSubsetBatch(true).withImpl(true).build();
            FacetJavaType returnType = this.util.getReturnType(facet, codeGenParams);
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)facet.name()).returns(returnType.javaTypeName(facet).annotated(Utils.annotations(returnType.typeAnnotations(facet, codeGenParams)))).addStatement(returnType.fieldGetterCode(facet, codeGenParams));
            if (facet.isGiven()) {
                getter.addAnnotation(EqualsAndHashCode.Include.class);
            }
            batchImmutFacetsClass.addMethod(getter.build());
        }
        TypeSpec.Builder commonImmutFacetsClass = this.util.classBuilder(commonImmutFacetsType.simpleName()).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface(ImmutableFacetValuesContainer.class).addField((TypeName)allFacetsType, "_facetValues", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)allFacetsType, "_facetValues", new Modifier[0]).addStatement("this.$L = $L._build()", new Object[]{"_facetValues", "_facetValues"}).build()).addAnnotation(AnnotationSpec.builder(EqualsAndHashCode.class).addMember("onlyExplicitlyIncluded", "true", new Object[0]).build()).addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_facets", 0)).addStatement("return $T._facets.stream()\n  .filter(spec -> !spec.isBatched())\n  .collect($T.toImmutableSet())\n", new Object[]{this.getFacetsInterfaceType(), ImmutableSet.class}).build());
        for (FacetGenModel facet : commonFacets) {
            CodeGenParams codeGenParams = CodeGenParams.builder().isSubsetCommon(true).withImpl(true).build();
            FacetJavaType returnType = this.util.getReturnType(facet, codeGenParams);
            MethodSpec.Builder getter = MethodSpec.methodBuilder((String)facet.name()).returns(returnType.javaTypeName(facet).annotated(Utils.annotations(returnType.typeAnnotations(facet, codeGenParams)))).addStatement(returnType.fieldGetterCode(facet, codeGenParams));
            if (facet.isGiven()) {
                getter.addAnnotation(EqualsAndHashCode.Include.class);
            }
            commonImmutFacetsClass.addMethod(getter.build());
        }
        this.util.generateSourceFile(batchImmutFacetsType.canonicalName(), JavaFile.builder((String)this.packageName(), (TypeSpec)batchImmutFacetsClass.build()).build().toString(), this.currentVajramInfo.vajramClass());
        this.util.generateSourceFile(commonImmutFacetsType.canonicalName(), JavaFile.builder((String)this.packageName(), (TypeSpec)commonImmutFacetsClass.build()).build().toString(), this.currentVajramInfo.vajramClass());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getFacetsInterfaceType() {
        return ClassName.get((String)this.packageName(), (String)Utils.getFacetsInterfaceName(this.vajramName()), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getRequestInterfaceType() {
        return ClassName.get((String)this.packageName(), (String)Utils.getRequestInterfaceName(this.vajramName()), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getBatchFacetsClassName() {
        return ClassName.get((String)this.packageName(), (String)(this.vajramName() + "_BatchItem"), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getCommonFacetsClassName() {
        return ClassName.get((String)this.packageName(), (String)(this.vajramName() + "_CommonFac"), (String[])new String[0]);
    }

    private void codegenBatchableFacets(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder allFacetsType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName batchFacetsType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName commonFacetsType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        MethodSpec.Builder batchElementMethod = MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(BatchEnabledFacetValues.class, "_batchItem", 0)).returns((TypeName)batchFacetsType);
        MethodSpec.Builder commonMethod = MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(BatchEnabledFacetValues.class, "_common", 0)).returns((TypeName)commonFacetsType);
        if (codeGenParams.withImpl()) {
            batchElementMethod.addStatement("return new $T(this)", new Object[]{batchFacetsType});
            commonMethod.addStatement("return new $T(this)", new Object[]{commonFacetsType});
        } else {
            batchElementMethod.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            commonMethod.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        allFacetsType.addMethod(batchElementMethod.build()).addMethod(commonMethod.build());
    }

    private void facetConstants(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec.Builder classBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel> facetValues, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        ArrayList<FieldSpec> specFields = new ArrayList<FieldSpec>(facetValues.size());
        ArrayList<FieldSpec> idFields = new ArrayList<FieldSpec>();
        int facetCount = 0;
        for (FacetGenModel facetGenModel : facetValues) {
            ParameterizedTypeName parameterizedTypeName;
            String docComment;
            DependencyModel vajramDepDef;
            ++facetCount;
            String facetDoc = facetGenModel.documentation();
            FieldSpec facetIdField = FieldSpec.builder(String.class, (String)(facetGenModel.name() + "_n"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.vajramName() + ":" + facetGenModel.name()}).addJavadoc(facetDoc != null ? CodeBlock.of((String)facetDoc, (Object[])new Object[0]) : Constants.EMPTY_CODE_BLOCK).build();
            idFields.add(facetIdField);
            TypeAndName facetType = this.util.getTypeName(this.util.getDataType(facetGenModel));
            TypeAndName boxedFacetType = this.util.box(facetType, new AnnotationSpec[0]);
            ClassName vajramReqClass = this.getRequestInterfaceType();
            ClassName specType = ClassName.get(codeGenParams.isRequest() ? InputMirrorSpec.class : (facetGenModel instanceof DependencyModel ? ((vajramDepDef = (DependencyModel)facetGenModel).canFanout() ? (vajramDepDef.isMandatory() ? MandatoryFanoutDepSpec.class : OptionalFanoutDepSpec.class) : (vajramDepDef.isMandatory() ? MandatoryOne2OneDepSpec.class : OptionalOne2OneDepSpec.class)) : (facetGenModel.isMandatory() ? MandatoryFacetDefaultSpec.class : OptionalFacetDefaultSpec.class)));
            ArrayList<TypeName> collectClassNames = new ArrayList<TypeName>();
            CodeBlock.Builder initializerCodeBlock = CodeBlock.builder();
            initializerCodeBlock.add("new $T<>(\n  $L,\n  $S,\n  $T.vajramID($S),\n", new Object[]{specType, facetGenModel.id(), facetGenModel.name(), VajramID.class, this.vajramName()}).add(this.util.getJavaTypeCreationCode((JavaType)facetGenModel.dataType(), collectClassNames, facetGenModel.facetField()) + ",", collectClassNames.toArray());
            if (facetGenModel instanceof GivenFacetModel && !codeGenParams.isRequest()) {
                initializerCodeBlock.add("$T.of(", new Object[]{ImmutableSet.class});
                ArrayList<String> params = new ArrayList<String>();
                ArrayList<String> args = new ArrayList<String>();
                if (facetGenModel.facetTypes().contains((Object)FacetType.INPUT)) {
                    params.add("$T.$L");
                    args.addAll(List.of(FacetType.class, "INPUT"));
                }
                if (facetGenModel.facetTypes().contains((Object)FacetType.INJECTION)) {
                    params.add("$T.$L");
                    args.addAll(List.of(FacetType.class, "INJECTION"));
                }
                initializerCodeBlock.add(params.stream().collect(Collectors.joining(",")) + "),", args.toArray());
            }
            initializerCodeBlock.add("  $T.class,\n", new Object[]{vajramReqClass});
            if (facetGenModel instanceof DependencyModel) {
                DependencyModel vajramDepDef2 = (DependencyModel)facetGenModel;
                ClassName depReqClass = ClassName.bestGuess((String)vajramDepDef2.depReqClassQualifiedName());
                initializerCodeBlock.add("  $T.class,\n  $T.$L($S),\n", new Object[]{depReqClass, VajramID.class, "vajramID", vajramDepDef2.depVajramInfo().vajramId().vajramId()});
            }
            if ((docComment = this.util.processingEnv().getElementUtils().getDocComment(facetGenModel.facetField())) == null) {
                docComment = "";
            }
            initializerCodeBlock.add("$S,", new Object[]{docComment});
            if (codeGenParams.isRequest()) {
                VajramInfoLite conformsToTraitInfoOrSelf = this.currentVajramInfo.lite().conformsToTraitOrSelf();
                initializerCodeBlock.add("  $T.of($L),\n  _request -> (($T)_request).$L(),\n  (_request, _value) -> {\n    if(_value != null) {\n      (($T) _request).$L(_value);\n    }\n  }\n)\n", new Object[]{ElementTags.class, facetGenModel.facetField().getAnnotationMirrors().stream().filter(annotationMirror -> annotationMirror.getAnnotationType().asElement().getAnnotation(Documented.class) != null).filter(annotationMirror -> annotationMirror.getAnnotationType().asElement().getAnnotation(HasCreator.class) != null).map(annotationMirror -> CodeBlock.of((String)"$T.Creator.create($L)", (Object[])new Object[]{annotationMirror.getAnnotationType(), annotationMirror.getElementValues().values().stream().map(annotationValue -> CodeBlock.of((String)"$L", (Object[])new Object[]{annotationValue.getValue()})).collect(CodeBlock.joining((String)","))})).collect(CodeBlock.joining((String)",")), conformsToTraitInfoOrSelf.requestInterfaceType(), facetGenModel.name(), conformsToTraitInfoOrSelf.immutReqInterfaceType().nestedClass("Builder"), facetGenModel.name()});
            } else {
                DependencyModel dep;
                initializerCodeBlock.add("    $L,\n    $T.parseFacetTags(() -> $T.$L.class.getDeclaredField($S)).mergeAnnotations($L),\n    _facetValues -> (($T)_facetValues).$L(),\n    (_facetValues, _value) -> {\n      if(_value != null) {\n        (($T) _facetValues).$L(_value);\n      }\n    }\n  )\n", new Object[]{facetGenModel.facetField().getAnnotation(Batched.class) != null, FacetSpec.class, this.currentVajramInfo.vajramClass(), "_Facets", facetGenModel.name(), CodeBlock.builder().add(facetGenModel instanceof DependencyModel && (dep = (DependencyModel)facetGenModel).depVajramInfo().isTrait() ? CodeBlock.of((String)"$T.Creator.create()", (Object[])new Object[]{TraitDependency.class}) : Constants.EMPTY_CODE_BLOCK).build(), ClassName.get((String)this.packageName(), (String)Utils.getFacetsInterfaceName(this.vajramName()), (String[])new String[0]), facetGenModel.name(), ClassName.get((String)this.packageName(), (String)Utils.getImmutFacetsClassname(this.vajramName()), (String[])new String[]{"Builder"}), facetGenModel.name()});
            }
            if (facetGenModel instanceof DependencyModel) {
                DependencyModel vajramDepDef3 = (DependencyModel)facetGenModel;
                parameterizedTypeName = ParameterizedTypeName.get((ClassName)specType, (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramReqClass, ClassName.bestGuess((String)vajramDepDef3.depReqClassQualifiedName())});
            } else {
                parameterizedTypeName = ParameterizedTypeName.get((ClassName)specType, (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramReqClass});
            }
            specFields.add(FieldSpec.builder((TypeName)parameterizedTypeName, (String)(facetGenModel.name() + "_s"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(FacetIdNameMapping.class).addMember("id", "$L", new Object[]{facetGenModel.id()}).addMember("name", "$S", new Object[]{facetGenModel.name()}).build()).initializer(initializerCodeBlock.build()).build());
        }
        for (int i = 0; i < facetCount; ++i) {
            classBuilder.addField((FieldSpec)idFields.get(i)).addField((FieldSpec)specFields.get(i));
        }
        ParameterizedTypeName facetsFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableSet.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)(codeGenParams.isRequest() ? ClassName.get(InputMirrorSpec.class) : ClassName.get(FacetSpec.class)), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf((TypeName)this.getRequestInterfaceType())}))});
        FieldSpec fieldSpec = FieldSpec.builder((TypeName)facetsFieldType, (String)"_facets", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(specFields.stream().map(specField -> "$N").collect(Collectors.joining(", ", "$T.of(", ")")), Stream.concat(Stream.of(ImmutableSet.class), specFields.stream()).toArray()).build();
        classBuilder.addField(fieldSpec);
        classBuilder.addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethodToOverride(FacetValuesContainer.class, "_facets", 0)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)facetsFieldType).addStatement("return $N", new Object[]{fieldSpec}).build());
    }

    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableSet<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer> getResolverSources(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement resolve) {
        return (ImmutableSet)resolve.getParameters().stream().map(v -> this.inferFacetId((VariableElement)v)).collect(ImmutableSet.toImmutableSet());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramName() {
        return this.currentVajramInfo.lite().vajramId().vajramId();
    }

    @Generated
    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName() {
        return this.packageName;
    }
}

