/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.models;

import com.flipkart.krystal.vajram.codegen.Utils;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.facets.Output;
import com.flipkart.krystal.vajram.facets.resolution.sdk.Resolve;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ParsedVajramData(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement> resolvers, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement outputLogic, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo) {
    @Generated
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(ParsedVajramData.class);

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ParsedVajramData> fromVajram(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util) {
        String packageName = vajramInfo.packageName();
        for (ExecutableElement method : ParsedVajramData.getAllMethods(vajramInfo.vajramClass())) {
            String errorMessage = "Vajram class %s has non-static method %s".formatted(vajramInfo.vajramId(), method.getSimpleName());
            if (!ParsedVajramData.isOutputLogic(method) && !ParsedVajramData.isResolver(method) || ParsedVajramData.isStatic(method)) continue;
            util.error(errorMessage, method);
            throw new VajramValidationException(errorMessage);
        }
        ArrayList<ExecutableElement> resolverMethods = new ArrayList<ExecutableElement>();
        ExecutableElement outputLogic = ParsedVajramData.getOutputLogicAndResolverMethods(vajramInfo, resolverMethods, util);
        return Optional.of(new ParsedVajramData(resolverMethods, outputLogic, packageName, vajramInfo));
    }

    public static void validateNoDuplicateResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement> methods, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util) {
        HashMap<Integer, Map> lookUpMap = new HashMap<Integer, Map>();
        for (ExecutableElement method : methods) {
            int[] depInputs;
            int depId = Optional.ofNullable(method.getAnnotation(Resolve.class)).orElseThrow().dep();
            for (int depinput : depInputs = method.getAnnotation(Resolve.class).depInputs()) {
                if (lookUpMap.getOrDefault(depId, Map.of()).getOrDefault(depinput, false).booleanValue()) {
                    String errorMessage = "Two Resolver resolving same input (%s) for dependency name (%s)".formatted(depinput, depId);
                    util.error(errorMessage, method);
                    throw new VajramValidationException(errorMessage);
                }
                lookUpMap.computeIfAbsent(depId, k -> new HashMap()).put(depinput, true);
            }
        }
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement getOutputLogicAndResolverMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement> resolveMethods, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util) {
        ExecutableElement outputLogic = null;
        TypeElement vajramClass = vajramInfo.vajramClass();
        List<ExecutableElement> methods = ParsedVajramData.getStaticMethods(vajramClass);
        for (ExecutableElement method : methods) {
            if (ParsedVajramData.isResolver(method)) {
                resolveMethods.add(method);
                continue;
            }
            if (!ParsedVajramData.isOutputLogic(method)) continue;
            if (outputLogic == null) {
                outputLogic = method;
                continue;
            }
            String errorMessage = "Multiple @Output annotated methods (%s, %s) found in %s".formatted(outputLogic.getSimpleName(), method.getSimpleName(), vajramClass.getSimpleName());
            util.error(errorMessage, outputLogic);
            util.error(errorMessage, method);
            throw new VajramValidationException(errorMessage);
        }
        ParsedVajramData.validateNoDuplicateResolvers(resolveMethods, vajramInfo, util);
        if (outputLogic == null) {
            String errorMessage = "Missing output logic method";
            util.error(errorMessage, vajramClass);
            throw new VajramValidationException(errorMessage);
        }
        return outputLogic;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method) {
        return ((Resolve[])method.getAnnotationsByType(Resolve.class)).length == 1;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isOutputLogic(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method) {
        return ((Output[])method.getAnnotationsByType(Output.class)).length == 1;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement> getStaticMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramClass) {
        return ParsedVajramData.getAllMethods(vajramClass).stream().filter(element -> element.getModifiers().contains((Object)Modifier.STATIC)).toList();
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement> getAllMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramCalss) {
        return (ImmutableList)vajramCalss.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).map(element -> (ExecutableElement)element).collect(ImmutableList.toImmutableList());
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isStatic(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }
}

