/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.utils.SkippedExecutionException;
import com.flipkart.krystal.vajram.DependencyResponse;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.Vajrams;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.FacetsConverter;
import com.flipkart.krystal.vajram.batching.UnBatchedFacets;
import com.flipkart.krystal.vajram.codegen.Utils;
import com.flipkart.krystal.vajram.codegen.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.models.InputModel;
import com.flipkart.krystal.vajram.codegen.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.models.VajramInfoLite;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.DependencyDef;
import com.flipkart.krystal.vajram.facets.FacetValuesAdaptor;
import com.flipkart.krystal.vajram.facets.InputDef;
import com.flipkart.krystal.vajram.facets.InputSource;
import com.flipkart.krystal.vajram.facets.MultiExecute;
import com.flipkart.krystal.vajram.facets.SingleExecute;
import com.flipkart.krystal.vajram.facets.VajramDepFanoutTypeSpec;
import com.flipkart.krystal.vajram.facets.VajramDepSingleTypeSpec;
import com.flipkart.krystal.vajram.facets.VajramFacetDefinition;
import com.flipkart.krystal.vajram.facets.VajramFacetSpec;
import com.flipkart.krystal.vajram.facets.resolution.sdk.Resolve;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenerator {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramCodeGenerator.class);
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String packageName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String requestClassName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo vajramInfo;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramID, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfoLite> vajramDefs;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FacetGenModel> facetModels;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean needsBatching;
    private @MonotonicNonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized ParsedVajramData parsedVajramData;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Utils util;

    public VajramCodeGenerator(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo vajramInfo, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramID, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfoLite> vajramDefs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Utils util) {
        this.vajramInfo = vajramInfo;
        this.vajramName = vajramInfo.vajramId().vajramId();
        this.packageName = vajramInfo.packageName();
        this.processingEnv = processingEnv;
        this.util = util;
        this.requestClassName = Utils.getRequestClassName(this.vajramName);
        this.vajramDefs = Collections.unmodifiableMap(vajramDefs);
        this.facetModels = vajramInfo.facetStream().collect(Collectors.toMap(FacetGenModel::name, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
        this.needsBatching = vajramInfo.inputs().stream().anyMatch(InputModel::isBatched);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramName() {
        return this.vajramName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenVajramImpl() {
        this.initParsedVajramData();
        TypeSpec.Builder vajramImplClass = this.util.classBuilder(Utils.getVajramImplClassName(this.vajramName)).addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramFacetDefinition.class}).annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)"facetDefinitions", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        vajramImplClass.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(ClassName.get((TypeElement)this.vajramInfo.vajramClass()).box()).build();
        HashMap<String, List> resolverMap = new HashMap<String, List>();
        for (ExecutableElement resolver : this.getParsedVajramData().resolvers()) {
            String key = ((Resolve)Preconditions.checkNotNull((Object)resolver.getAnnotation(Resolve.class))).depName();
            resolverMap.computeIfAbsent(key, _k -> new ArrayList()).add(resolver);
        }
        Map<String, Boolean> depFanoutMap = this.vajramInfo.dependencies().stream().collect(Collectors.toMap(DependencyModel::name, DependencyModel::canFanout));
        ClassName inputBatch = ClassName.get((String)this.getParsedVajramData().packageName(), (String)Utils.getFacetUtilClassName(this.getParsedVajramData().vajramName()), (String[])new String[]{Utils.getBatchedInputsClassname(this.vajramName)});
        ClassName commonInputs = ClassName.get((String)this.getParsedVajramData().packageName(), (String)Utils.getFacetUtilClassName(this.getParsedVajramData().vajramName()), (String[])new String[]{Utils.getCommonFacetsClassname(this.vajramName)});
        TypeName vajramResponseType = this.util.toTypeName(this.getParsedVajramData().responseType());
        MethodSpec facetDefinitionsMethod = this.createFacetDefinitions();
        methodSpecs.add(facetDefinitionsMethod);
        Optional<MethodSpec> inputResolverMethod = this.createResolvers(resolverMap, depFanoutMap);
        inputResolverMethod.ifPresent(methodSpecs::add);
        if (this.util.isRawAssignable(this.getParsedVajramData().vajramClass().asType(), IOVajram.class)) {
            methodSpecs.add(this.createIOVajramExecuteMethod(inputBatch, commonInputs, vajramResponseType.box().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})));
        } else {
            methodSpecs.add(this.createComputeVajramExecuteMethod(vajramResponseType, inputBatch, commonInputs));
        }
        if (this.needsBatching) {
            methodSpecs.add(this.createInputConvertersMethod(inputBatch, commonInputs));
        }
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)vajramImplClass.addMethods(methodSpecs).build()).indent("  ").build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private @NonNull @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized ParsedVajramData initParsedVajramData() {
        if (this.parsedVajramData == null) {
            this.parsedVajramData = ParsedVajramData.fromVajram(this.vajramInfo, this.util).orElseThrow(() -> new VajramValidationException("Could not load Vajram class for vajram %s.\nParsedVajram Data should never be accessed in model generation phase.".formatted(this.vajramInfo.vajramId())));
        }
        return this.parsedVajramData;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ParsedVajramData getParsedVajramData() {
        return Optional.ofNullable(this.parsedVajramData).orElseGet(this::initParsedVajramData);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String> getResolverSources(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement resolve) {
        return (ImmutableSet)resolve.getParameters().stream().map(this.util::inferFacetName).collect(ImmutableSet.toImmutableSet());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createComputeVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName vajramResponseType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonInputs) {
        MethodSpec.Builder executeBuilder = MethodSpec.methodBuilder((String)"executeCompute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Facets.class}), "facetsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Facets.class), ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{vajramResponseType.box()})})).addAnnotation(Override.class);
        if (this.needsBatching) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("facets", ClassName.get(Facets.class));
            valueMap.put("unmodInput", ClassName.get(UnBatchedFacets.class));
            valueMap.put("inputBatching", batchableInputs);
            valueMap.put("commonInput", commonInputs);
            valueMap.put("returnType", vajramResponseType.box());
            valueMap.put("outputLogicMethod", this.getParsedVajramData().outputLogic().getSimpleName());
            valueMap.put("modInput", ClassName.get(BatchedFacets.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", Errable.class);
            valueMap.put("function", ClassName.get(Function.class));
            valueMap.put("optional", ClassName.get(Optional.class));
            TypeMirror returnType = this.getParsedVajramData().outputLogic().getReturnType();
            Preconditions.checkState((boolean)this.util.isRawAssignable(returnType, Map.class), (String)"Any vajram supporting inputDef batching must return map. Vajram: %s", (Object)this.vajramName);
            TypeMirror mapValue = Utils.getTypeParameters(returnType).get(1);
            if (this.util.isRawAssignable(mapValue, CompletableFuture.class)) {
                codeBuilder.addNamed("    $map:T<$inputBatching:T, $facets:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonFacets = null;\n    for ($facets:T facets : facetsList) {\n      $unmodInput:T<$inputBatching:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(facets);\n      commonFacets = allInputs.commonFacets();\n      $inputBatching:T im = allInputs.batchedInputs();\n      mapping.put(im, facets);\n    }\n    $map:T<$facets:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonFacets != null) {\n      var results = $outputLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonFacets));\n      results.forEach((im, future) -> returnValue.put(\n            $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n            future.<$returnType:T>thenApply($function:T.identity())));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            } else {
                codeBuilder.addNamed("    $map:T<$inputBatching:T, $facets:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonFacets = null;\n    for ($facets:T facets : facetsList) {\n      $unmodInput:T<$inputBatching:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(facets);\n      commonFacets = allInputs.commonFacets();\n      $inputBatching:T im = allInputs.batchedInputs();\n      mapping.put(im, facets);\n    }\n    $map:T<$facets:T, $valErr:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonFacets != null) {\n      var results = $outputLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonFacets));\n      results.forEach((im, value) -> returnValue.put(\n           $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n           $valErr:T.withValue(value)));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            }
            executeBuilder.addCode(codeBuilder.build());
        } else {
            this.nonBatchedComputeMethodBuilder(executeBuilder, false);
        }
        return executeBuilder.build();
    }

    private void nonBatchedComputeMethodBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec.Builder executeBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isIOVajram) {
        CodeBlock.Builder returnBuilder = CodeBlock.builder().add("return facetsList.stream().collect(\n     $T.toImmutableMap($T.identity(),\n     element -> {\n", new Object[]{ImmutableMap.class, Function.class});
        ArrayList inputCodeBlocks = new ArrayList();
        this.facetModels.values().forEach(inputDef -> {
            if (inputDef instanceof DependencyModel) {
                DependencyModel dependencyModel = (DependencyModel)inputDef;
                VajramID depVajramId = dependencyModel.depVajramId();
                String depRequestClass = dependencyModel.depReqClassQualifiedName();
                VajramInfoLite depVajramInfo = (VajramInfoLite)Preconditions.checkNotNull((Object)this.vajramDefs.get(depVajramId), (String)"Could not find ParsedVajramData for %s", (Object)depVajramId);
                TypeName boxedResponseType = this.util.toTypeName(depVajramInfo.responseType()).box();
                String variableName = VajramCodeGenerator.toJavaName(inputDef.name());
                String depVariableName = variableName + "Responses";
                if (dependencyModel.canFanout()) {
                    CodeBlock.Builder codeBlock = CodeBlock.builder();
                    codeBlock.addNamed("$depResp:T<$request:T, $response:T> $depResponse:L =\n     new $depResp:T<>(\n         element.<$response:T>getDepValue($variable:S).values().entrySet().stream()\n             .filter(\n                 e ->\n                     e.getValue()\n                         .error()\n                         .filter(t -> t instanceof $skippedException:T)\n                         .isEmpty())\n             .collect(\n                 $imMap:T.toImmutableMap(\n                     e -> $request:T.from(e.getKey()), java.util.Map.Entry::getValue)));\n", (Map)ImmutableMap.of((Object)"depResp", DependencyResponse.class, (Object)"request", (Object)VajramCodeGenerator.toClassName(depRequestClass), (Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name(), (Object)"depResponse", (Object)depVariableName, (Object)"imMap", ImmutableMap.class, (Object)"skippedException", SkippedExecutionException.class));
                    inputCodeBlocks.add(CodeBlock.builder().add(depVariableName, new Object[0]).build());
                    returnBuilder.add(codeBlock.build());
                } else if (dependencyModel.isMandatory()) {
                    inputCodeBlocks.add(CodeBlock.builder().addNamed("element.<$response:T>getDepValue($variable:S)\n    .values()\n    .entrySet()\n    .iterator()\n    .next()\n    .getValue()\n    .getValueOrThrow()\n    .orElseThrow(() -> new $stacktracelessArgument:T(\"Missing mandatory dependency '$variable:L' in vajram '$vajram:L'\"))", (Map)ImmutableMap.of((Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name(), (Object)"stacktracelessArgument", StackTracelessException.class, (Object)"vajram", (Object)this.vajramName)).build());
                } else {
                    inputCodeBlocks.add(CodeBlock.builder().addNamed("element.<$response:T>getDepValue($variable:S)\n    .values()\n    .entrySet()\n    .iterator()\n    .next()\n    .getValue()", (Map)ImmutableMap.of((Object)"response", (Object)boxedResponseType, (Object)"variable", (Object)inputDef.name())).build());
                }
            } else if (inputDef.isMandatory()) {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrThrow($S)", new Object[]{inputDef.name()}).build());
            } else {
                inputCodeBlocks.add(CodeBlock.builder().add("element.getInputValueOrDefault($S, null)", new Object[]{inputDef.name()}).build());
            }
        });
        if (isIOVajram) {
            TypeMirror returnType = this.getParsedVajramData().outputLogic().getReturnType();
            if (!this.util.isRawAssignable(returnType, CompletableFuture.class)) {
                String errorMessage = "The OutputLogic of non-batched IO vajram %s must return a CompletableFuture".formatted(this.vajramName);
                this.util.error(errorMessage, this.getParsedVajramData().outputLogic());
                throw new VajramValidationException(errorMessage);
            }
            returnBuilder.add("\nreturn ($L(new $T(\n", new Object[]{this.getParsedVajramData().outputLogic().getSimpleName(), ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{Utils.getAllFacetsClassname(this.vajramName)})});
        } else {
            returnBuilder.add("\nreturn $T.errableFrom(() -> $L(new $T(\n", new Object[]{Errable.class, this.getParsedVajramData().outputLogic().getSimpleName(), ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{Utils.getAllFacetsClassname(this.vajramName)})});
        }
        for (int i = 0; i < inputCodeBlocks.size(); ++i) {
            returnBuilder.add("\t\t", new Object[0]);
            returnBuilder.add((CodeBlock)inputCodeBlocks.get(i));
            if (i == inputCodeBlocks.size() - 1) continue;
            returnBuilder.add(",\n", new Object[0]);
        }
        returnBuilder.add(")));\n", new Object[0]);
        returnBuilder.add("}));\n", new Object[0]);
        executeBuilder.addCode(returnBuilder.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createInputConvertersMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonInputs) {
        MethodSpec.Builder inputConvertersBuilder = MethodSpec.methodBuilder((String)"getInputsConvertor").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(FacetsConverter.class), (TypeName[])new TypeName[]{batchableInputs, commonInputs})).addAnnotation(Override.class);
        inputConvertersBuilder.addCode(CodeBlock.builder().addStatement("return $T.CONVERTER", new Object[]{ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[0])}).build());
        return inputConvertersBuilder.build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createIOVajramExecuteMethod(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName batchableInputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName commonFacets, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName vajramResponseType) {
        MethodSpec.Builder executeMethodBuilder = MethodSpec.methodBuilder((String)"execute").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{Facets.class}), "facetsList", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableMap.class), (TypeName[])new TypeName[]{ClassName.get(Facets.class), ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{vajramResponseType})})).addAnnotation(Override.class);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        if (this.needsBatching) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("facets", ClassName.get(Facets.class));
            valueMap.put("unmodInput", ClassName.get(UnBatchedFacets.class));
            valueMap.put("inputBatching", batchableInputs);
            valueMap.put("commonInput", commonFacets);
            valueMap.put("returnType", vajramResponseType);
            valueMap.put("outputLogicMethod", this.getParsedVajramData().outputLogic().getSimpleName());
            valueMap.put("modInput", ClassName.get(BatchedFacets.class));
            valueMap.put("imMap", ClassName.get(ImmutableMap.class));
            valueMap.put("imList", ClassName.get(ImmutableList.class));
            valueMap.put("hashMap", ClassName.get(HashMap.class));
            valueMap.put("arrayList", ClassName.get(ArrayList.class));
            valueMap.put("comFuture", ClassName.get(CompletableFuture.class));
            valueMap.put("linkHashMap", ClassName.get(LinkedHashMap.class));
            valueMap.put("map", ClassName.get(Map.class));
            valueMap.put("list", ClassName.get(List.class));
            valueMap.put("valErr", Errable.class);
            valueMap.put("function", ClassName.get(Function.class));
            valueMap.put("optional", ClassName.get(Optional.class));
            TypeMirror returnType = this.getParsedVajramData().outputLogic().getReturnType();
            Preconditions.checkState((boolean)this.util.isRawAssignable(this.processingEnv.getTypeUtils().erasure(returnType), Map.class), (String)"Any vajram supporting inputDef batching must return map. Vajram: %s", (Object)this.vajramName);
            TypeMirror mapValue = Utils.getTypeParameters(returnType).get(1);
            if (this.util.isRawAssignable(mapValue, CompletableFuture.class)) {
                codeBuilder.addNamed("    $map:T<$inputBatching:T, $facets:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonFacets = null;\n    for ($facets:T facets : facetsList) {\n      $unmodInput:T<$inputBatching:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(facets);\n      commonFacets = allInputs.commonFacets();\n      $inputBatching:T im = allInputs.batchedInputs();\n      mapping.put(im, facets);\n    }\n    $map:T<$facets:T, $comFuture:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonFacets != null) {\n      var results = $outputLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonFacets));\n      results.forEach((im, future) -> returnValue.put(\n            $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n            future.<$returnType:T>thenApply($function:T.identity())));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            } else {
                codeBuilder.addNamed("    $map:T<$inputBatching:T, $facets:T> mapping = new $hashMap:T<>();\n    $commonInput:T commonFacets = null;\n    for ($facets:T facets : facetsList) {\n      $unmodInput:T<$inputBatching:T, $commonInput:T> allInputs =\n          getInputsConvertor().apply(facets);\n      commonFacets = allInputs.commonFacets();\n      $inputBatching:T im = allInputs.batchedInputs();\n      mapping.put(im, facets);\n    }\n    $map:T<$facets:T, $valErr:T<$returnType:T>> returnValue = new $linkHashMap:T<>();\n\n    if (commonFacets != null) {\n      var results = $outputLogicMethod:L(new $modInput:T<>($imList:T.copyOf(mapping.keySet()), commonFacets));\n      results.forEach((im, value) -> returnValue.put(\n           $optional:T.ofNullable(mapping.get(im)).orElseThrow(),\n           $valErr:T.withValue(value)));\n    }\n    return $imMap:T.copyOf(returnValue);\n", valueMap);
            }
            executeMethodBuilder.addCode(codeBuilder.build());
        } else {
            this.nonBatchedComputeMethodBuilder(executeMethodBuilder, true);
        }
        return executeMethodBuilder.build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec> createResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement>> resolverMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap) {
        String dependencyDef = "dependencyDef";
        MethodSpec.Builder resolveInputsBuilder = MethodSpec.methodBuilder((String)"resolveInputOfDependency").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, dependencyDef, new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(ImmutableSet.class, (Type[])new Type[]{String.class}), "resolvableInputs", new Modifier[0]).addParameter(Facets.class, "facets", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyCommand.class), (TypeName[])new TypeName[]{ClassName.get(Facets.class)}));
        if (Objects.nonNull(this.getParsedVajramData())) {
            resolveInputsBuilder.beginControlFlow("switch ($L) ", new Object[]{dependencyDef});
            if (this.getParsedVajramData().resolvers().isEmpty()) {
                return Optional.empty();
            }
            Set<String> resolvedVariables = resolverMap.keySet();
            resolverMap.forEach((variable, methods) -> {
                CodeBlock.Builder caseBuilder = CodeBlock.builder().beginControlFlow("case $S -> ", new Object[]{variable});
                methods.forEach(method -> {
                    AtomicBoolean fanout = new AtomicBoolean(false);
                    method.getParameters().forEach(parameter -> {
                        String bindParamName = this.util.inferFacetName((VariableElement)parameter);
                        if (!fanout.get() && depFanoutMap.containsKey(bindParamName)) {
                            fanout.set((Boolean)depFanoutMap.get(bindParamName));
                        }
                        if (!this.facetModels.containsKey(bindParamName) && !resolvedVariables.contains(bindParamName)) {
                            String message = "Parameter binding incorrect for inputDef - " + bindParamName;
                            this.util.error(message, (Element)parameter);
                            throw new VajramValidationException(message);
                        }
                    });
                    CodeBlock.Builder ifBlockBuilder = this.buildInputResolver((ExecutableElement)method, depFanoutMap, fanout.get());
                    caseBuilder.add(ifBlockBuilder.build());
                });
                caseBuilder.endControlFlow();
                resolveInputsBuilder.addCode(caseBuilder.build());
            });
            resolveInputsBuilder.endControlFlow();
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependencyDef"});
        } else {
            resolveInputsBuilder.addStatement("throw new $T($S)", new Object[]{ClassName.get(VajramValidationException.class), "Unresolvable dependencyDef"});
        }
        return Optional.of(resolveInputsBuilder.build());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder buildInputResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isParamFanoutDependency) {
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method must have 'Resolve' annotation");
        CharSequence[] facets = resolve.depInputs();
        String depName = resolve.depName();
        CodeBlock.Builder ifBlockBuilder = CodeBlock.builder();
        ifBlockBuilder.beginControlFlow("if ($T.of($S).equals(resolvableInputs))", new Object[]{Set.class, String.join((CharSequence)",", facets)});
        method.getParameters().forEach(parameter -> {
            String usingInputName = this.util.inferFacetName((VariableElement)parameter);
            FacetGenModel facetGenModel = this.facetModels.get(usingInputName);
            if (facetGenModel instanceof DependencyModel) {
                this.generateDependencyResolutions(method, usingInputName, ifBlockBuilder, depFanoutMap, (VariableElement)parameter);
                return;
            }
            if (!(facetGenModel instanceof InputModel)) {
                String message = "No inputDef resolver found for " + usingInputName;
                this.util.error(message, (Element)parameter);
                throw new VajramValidationException(message);
            }
            InputModel inputModel = (InputModel)facetGenModel;
            TypeMirror facetType = this.util.toTypeMirror(inputModel.type());
            String variable = VajramCodeGenerator.toJavaName(usingInputName);
            TypeMirror parameterTypeMirror = parameter.asType();
            TypeName parameterType = TypeName.get((TypeMirror)parameterTypeMirror);
            if (inputModel.isMandatory()) {
                if (!this.util.getProcessingEnv().getTypeUtils().isAssignable(facetType, parameterTypeMirror)) {
                    String message = String.format("Incorrect facet type being consumed. Expected '%s', found '%s'".formatted(facetType, parameterType), usingInputName);
                    this.util.error(message, (Element)parameter);
                    throw new VajramValidationException(message);
                }
                ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOrThrow($S)", new Object[]{parameterType, variable, "facets", usingInputName}).build());
                return;
            }
            if (this.util.isRawAssignable(parameterTypeMirror, Optional.class)) {
                ifBlockBuilder.add(CodeBlock.builder().addStatement("$T $L = $L.getInputValueOpt($S)", new Object[]{parameterType, variable, "facets", usingInputName}).build());
                return;
            }
            String message = String.format("Optional inputDef dependencyDef %s must have type as Optional", usingInputName);
            this.util.error(message, (Element)parameter);
            throw new VajramValidationException(message);
        });
        boolean isFanOut = depFanoutMap.getOrDefault(depName, false);
        this.buildFinalResolvers(method, (String[])facets, ifBlockBuilder, depName, isFanOut);
        ifBlockBuilder.endControlFlow();
        return ifBlockBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateDependencyResolutions(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String usingInputName, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Boolean> depFanoutMap, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        FacetGenModel facetDef = this.facetModels.get(usingInputName);
        Resolve resolve = (Resolve)Preconditions.checkNotNull((Object)method.getAnnotation(Resolve.class), (Object)"Resolver method cannot be null");
        String resolvedDep = resolve.depName();
        TypeMirror parameterType = parameter.asType();
        if (!(facetDef instanceof DependencyModel)) return;
        DependencyModel dependencyModel = (DependencyModel)facetDef;
        String variableName = VajramCodeGenerator.toJavaName(usingInputName);
        VajramInfoLite vajramInfoLite = (VajramInfoLite)Preconditions.checkNotNull((Object)this.vajramDefs.get(dependencyModel.depVajramId()), (String)"Could not find parsed vajram data for class %s", (Object)dependencyModel.depVajramId());
        String requestClass = dependencyModel.depReqClassQualifiedName();
        TypeName boxedDepType = this.util.toTypeName(vajramInfoLite.responseType()).box();
        TypeName unboxedDepType = boxedDepType.isBoxedPrimitive() ? boxedDepType.unbox() : boxedDepType;
        String resolverName = method.getSimpleName().toString();
        if (depFanoutMap.getOrDefault(usingInputName, false).booleanValue()) {
            boolean typeMismatch = false;
            if (!this.util.isRawAssignable(parameterType, DependencyResponse.class)) {
                typeMismatch = true;
            } else if (Utils.getTypeParameters(parameterType).size() != 2) {
                typeMismatch = true;
            }
            if (typeMismatch) {
                String message = "A fanout dependency ('%s') can be consumed only via the DependencyResponse<ReqType,RespType> class. Found '%s' instead".formatted(resolvedDep, parameterType);
                this.util.error(message, parameter);
                throw new VajramValidationException(message);
            }
            String depValueAccessorCode = "$1T $2L =\n new $3T<>(facets.<$4T>getDepValue($5S)\n      .values().entrySet().stream()\n      .collect($6T.toImmutableMap(e -> $7T.from(e.getKey()),\n      $8T::getValue)))";
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{VajramCodeGenerator.toClassName(requestClass), boxedDepType}), variableName, DependencyResponse.class, boxedDepType, usingInputName, ImmutableMap.class, VajramCodeGenerator.toClassName(requestClass), ClassName.get(Map.Entry.class)});
            return;
        }
        String depValueAccessorCode = "$1T $2L =\n  facets.<$3T>getDepValue($4S)\n     .values()\n     .entrySet()\n     .iterator()\n     .next()\n     .getValue()";
        if (facetDef.isMandatory()) {
            if (unboxedDepType.equals((Object)TypeName.get((TypeMirror)parameterType))) {
                String code = depValueAccessorCode + ".getValueOrThrow().orElseThrow(() ->\n    new $5T(\"Received null value for mandatory dependencyDef '$6L' of vajram '$7L'\"))";
                ifBlockBuilder.addStatement(code, new Object[]{unboxedDepType, variableName, boxedDepType, usingInputName, IllegalArgumentException.class, usingInputName, this.vajramName});
                return;
            }
            String message = "A resolver must consume a mandatory dependency directly using its type (%s). Found '%s' instead".formatted(unboxedDepType, parameterType);
            this.util.error(message, parameter);
            throw new VajramValidationException(message);
        }
        if (this.util.isRawAssignable(parameterType, Errable.class)) {
            ifBlockBuilder.addStatement(depValueAccessorCode, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, boxedDepType, usingInputName});
            return;
        }
        if (this.util.isRawAssignable(parameterType, Optional.class)) {
            String code = depValueAccessorCode + ".value()";
            ifBlockBuilder.addStatement(code, new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{boxedDepType}), variableName, boxedDepType, usingInputName});
            return;
        }
        String message = "A resolver ('%s') must not access an optional dependencyDef ('%s') directly.Use Optional<>, Errable<>, or DependencyResponse<> instead".formatted(resolverName, usingInputName);
        this.util.error(message, parameter);
        throw new VajramValidationException(message);
    }

    private void buildFinalResolvers(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement resolverMethod, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized [] facets, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder ifBlockBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String depName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isFanOut) {
        String variableName = "resolverResult";
        boolean controlFLowStarted = false;
        TypeName methodReturnType = TypeName.get((TypeMirror)resolverMethod.getReturnType());
        ifBlockBuilder.add("$T $L = $L(", new Object[]{methodReturnType, variableName, resolverMethod.getSimpleName()});
        ImmutableList resolverSources = this.getResolverSources(resolverMethod).asList();
        for (int i = 0; i < resolverSources.size(); ++i) {
            String bindName = (String)resolverSources.get(i);
            ifBlockBuilder.add("$L", new Object[]{VajramCodeGenerator.toJavaName(bindName)});
            if (i == resolverMethod.getParameters().size() - 1) continue;
            ifBlockBuilder.add(", ", new Object[0]);
        }
        ifBlockBuilder.add(");\n", new Object[0]);
        TypeMirror returnType = this.util.box(resolverMethod.getReturnType());
        if (this.util.isRawAssignable(returnType, DependencyCommand.class)) {
            ifBlockBuilder.beginControlFlow("if($L.shouldSkip())", new Object[]{variableName});
            ifBlockBuilder.addStatement("\t return $T.skipExecution($L.doc())", new Object[]{SingleExecute.class, variableName});
            ifBlockBuilder.add("} else {\n\t", new Object[0]);
            controlFLowStarted = true;
            if (this.util.isRawAssignable(returnType, SingleExecute.class)) {
                ifBlockBuilder.addStatement("  return $T.executeWith(new $T(\n   $T.of($S, $T.withValue(\n      $L.inputs().iterator().next().orElse(null)))))\n", new Object[]{SingleExecute.class, Facets.class, ImmutableMap.class, facets[0], Errable.class, variableName});
            } else if (this.util.isRawAssignable(returnType, MultiExecute.class)) {
                if (!isFanOut) {
                    String message = "Dependency '%s' is not a fanout dependency, yet the resolver method returns a MultiExecute command. This is not allowed. Return a SingleExecute command, a single value, or mark the dependency as `canFanout = true`.".formatted(depName);
                    this.util.error(message, resolverMethod);
                    throw new VajramValidationException(message);
                }
                if (this.util.isRawAssignable(Utils.getTypeParameters(returnType).get(0), VajramRequest.class)) {
                    code = "return $T.executeFanoutWith(\n    $L.inputs()\n        .stream()\n        .map(\n            element ->\n              element\n                .filter(Optional::isPresent)\n                .map(VajramRequest::toFacetValues())\n                .orElse(Facets.empty()))))\n    .toList())";
                    ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName});
                } else {
                    code = "return $T.executeFanoutWith(\n    $L.inputs().stream()\n        .map(\n            element ->\n                new $T(\n                    $T.of($S, $T.withValue(element))))\n    .toList())";
                    ifBlockBuilder.addStatement(code, new Object[]{MultiExecute.class, variableName, Facets.class, ImmutableMap.class, facets[0], Errable.class});
                }
            }
        } else if (this.util.isRawAssignable(returnType, VajramRequest.class)) {
            ifBlockBuilder.addStatement("return $T.executeWith($L.toFacetValues())", new Object[]{SingleExecute.class, variableName});
        } else {
            ifBlockBuilder.addStatement("return $T.executeWith(new $T(\n $T.of($S, $T.withValue($L))))", new Object[]{SingleExecute.class, Facets.class, ImmutableMap.class, facets[0], Errable.class, variableName});
        }
        if (controlFLowStarted) {
            ifBlockBuilder.endControlFlow();
        }
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec createFacetDefinitions() {
        MethodSpec.Builder facetDefinitionsBuilder = MethodSpec.methodBuilder((String)"getFacetDefinitions").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(ImmutableList.class, (Type[])new Type[]{VajramFacetDefinition.class})).addAnnotation(Override.class);
        facetDefinitionsBuilder.beginControlFlow("if(this.$L == null)", new Object[]{"facetDefinitions"});
        facetDefinitionsBuilder.addStatement("var $L =\n        $T.stream($L.$L.class.getDeclaredFields())\n            .collect($T.toMap($T::getName, $T.identity()));", new Object[]{"facetsFields", Arrays.class, this.getVajramName(), "_Facets", Collectors.class, Field.class, Function.class});
        List<FacetGenModel> facetGenModels = this.vajramInfo.facetStream().toList();
        ArrayList codeBlocks = new ArrayList(facetGenModels.size());
        facetGenModels.forEach(facetGenModel -> {
            CodeBlock.Builder inputDefBuilder = CodeBlock.builder();
            if (facetGenModel instanceof InputModel) {
                InputModel inputDef = (InputModel)facetGenModel;
                this.buildVajramInput(inputDefBuilder, inputDef);
            } else if (facetGenModel instanceof DependencyModel) {
                DependencyModel dependencyDef = (DependencyModel)facetGenModel;
                VajramCodeGenerator.buildVajramDependency(inputDefBuilder, dependencyDef);
            }
            inputDefBuilder.add(".tags($T.parseFacetTags($L.get($S)))", new Object[]{Vajrams.class, "facetsFields", facetGenModel.name()});
            inputDefBuilder.add(".build()", new Object[0]);
            codeBlocks.add(inputDefBuilder.build());
        });
        facetDefinitionsBuilder.addCode(CodeBlock.builder().add("this.$L = $T.of(\n", new Object[]{"facetDefinitions", ImmutableList.class}).add(CodeBlock.join(codeBlocks, (String)",\n\t")).add("\n);\n", new Object[0]).build());
        facetDefinitionsBuilder.endControlFlow();
        facetDefinitionsBuilder.addStatement("return $L", new Object[]{"facetDefinitions"});
        return facetDefinitionsBuilder.build();
    }

    private static void buildVajramDependency(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder inputDefBuilder, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DependencyModel dependencyDef) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(DependencyDef.class)}).add(".name($S)", new Object[]{dependencyDef.name()});
        String code = ".dataAccessSpec($1T.vajramID($2S))";
        inputDefBuilder.add(code, new Object[]{ClassName.get(VajramID.class), dependencyDef.depVajramId().vajramId()});
        inputDefBuilder.add(".isMandatory($L)", new Object[]{dependencyDef.isMandatory()});
    }

    private void buildVajramInput(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CodeBlock.Builder inputDefBuilder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized InputModel<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputDef) {
        inputDefBuilder.add("$T.builder()", new Object[]{ClassName.get(InputDef.class)}).add(".name($S)", new Object[]{inputDef.name()});
        ImmutableSet<InputSource> inputSources = inputDef.sources();
        if (!inputSources.isEmpty()) {
            inputDefBuilder.add(".sources(", new Object[0]);
            String sources = inputSources.stream().map(inputSource -> {
                if (inputSource == InputSource.CLIENT) {
                    return "$inputSrc:T.CLIENT";
                }
                if (inputSource == InputSource.SESSION) {
                    return "$inputSrc:T.SESSION";
                }
                throw new IllegalArgumentException("Incorrect source defined in vajram config");
            }).collect(Collectors.joining(","));
            inputDefBuilder.addNamed(sources, (Map)ImmutableMap.of((Object)"inputSrc", InputSource.class)).add(")", new Object[0]);
        }
        DataType<?> inputType = inputDef.type();
        inputDefBuilder.add(".type(", new Object[0]);
        if (inputType instanceof JavaType) {
            JavaType javaType = (JavaType)inputType;
            ArrayList<TypeName> collectClassNames = new ArrayList<TypeName>();
            inputDefBuilder.add(this.getJavaTypeCreationCode(javaType, collectClassNames, inputDef.facetField()), (Object[])collectClassNames.toArray(TypeName[]::new));
        } else {
            this.util.error("Unrecognised data type %s".formatted(inputType), inputDef.facetField());
        }
        inputDefBuilder.add(")", new Object[0]);
        inputDefBuilder.add(".isMandatory($L)", new Object[]{inputDef.isMandatory()});
        inputDefBuilder.add(".isBatched($L)", new Object[]{inputDef.isBatched()});
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getJavaTypeCreationCode(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized JavaType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> javaType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName> collectClassNames, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VariableElement facetField) {
        TypeMirror typeMirror = javaType.javaModelType(this.processingEnv);
        collectClassNames.add((TypeName)ClassName.get(JavaType.class));
        if (javaType.typeParameters().isEmpty()) {
            collectClassNames.add(TypeName.get((TypeMirror)typeMirror));
            return "$T.create($T.class)";
        }
        collectClassNames.add(TypeName.get((TypeMirror)this.processingEnv.getTypeUtils().erasure(typeMirror)));
        collectClassNames.add((TypeName)ClassName.get(List.class));
        return "$T.create($T.class, $T.of(" + javaType.typeParameters().stream().map(dataType -> {
            if (!(dataType instanceof JavaType)) {
                this.util.error("Unrecognised data type %s".formatted(dataType), facetField);
                return "";
            }
            JavaType typeParamType = (JavaType)dataType;
            return this.getJavaTypeCreationCode(typeParamType, collectClassNames, facetField);
        }).collect(Collectors.joining(",")) + "))";
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenVajramRequest() {
        ImmutableList<InputModel<?>> inputDefs = this.vajramInfo.inputs();
        MethodSpec.Builder requestConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        ClassName builderClassType = ClassName.get((String)(this.packageName + "." + this.requestClassName), (String)"Builder", (String[])new String[0]);
        TypeSpec.Builder requestClass = this.util.classBuilder(this.requestClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramRequest.class), (TypeName[])new TypeName[]{this.util.toTypeName(this.vajramInfo.responseType()).box()})).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)builderClassType).addStatement("return new Builder()", new Object[0]).build());
        TypeSpec.Builder builderClass = this.util.classBuilder("Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        LinkedHashSet<String> inputNames = new LinkedHashSet<String>();
        List<FacetGenModel> facets = this.vajramInfo.facetStream().toList();
        ArrayList<FieldSpec.Builder> inputNameFields = new ArrayList<FieldSpec.Builder>(facets.size());
        ArrayList<FieldSpec.Builder> inputSpecFields = new ArrayList<FieldSpec.Builder>(facets.size());
        for (FacetGenModel facet : facets) {
            InputModel inputDef2;
            String facetJavaName = VajramCodeGenerator.toJavaName(facet.name());
            TypeAndName facetType = this.getTypeName(this.getDataType(facet));
            TypeAndName boxedFacetType = this.boxPrimitive(facetType);
            ClassName vajramReqClass = ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]);
            String inputNameFieldName = facetJavaName + "_n";
            FieldSpec.Builder inputNameField = FieldSpec.builder(String.class, (String)inputNameFieldName, (Modifier[])new Modifier[0]).initializer("\"$L\"", new Object[]{facet.name()});
            FieldSpec.Builder inputSpecField = null;
            if (!(facet instanceof DependencyModel)) {
                inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(VajramFacetSpec.class), (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramReqClass}), (String)(facetJavaName + "_s"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}).initializer("new $T<>($L, $T.class)", new Object[]{VajramFacetSpec.class, inputNameFieldName, vajramReqClass});
                inputSpecFields.add(inputSpecField);
            }
            inputNameFields.add(inputNameField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
            if (!(facet instanceof InputModel) || !(inputDef2 = (InputModel)facet).sources().contains((Object)InputSource.CLIENT)) continue;
            if (inputSpecField != null) {
                inputSpecField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            inputNameField.addModifiers(new Modifier[]{Modifier.PUBLIC});
            inputNames.add(facetJavaName);
            requestClass.addField(FieldSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            builderClass.addField(FieldSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            requestConstructor.addParameter(ParameterSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[0]).build());
            requestConstructor.addStatement("this.$L = $L", new Object[]{facetJavaName, facetJavaName});
            requestClass.addMethod(this.getterCodeForInput(inputDef2, facetJavaName, facetType));
            builderClass.addMethod(MethodSpec.methodBuilder((String)facetJavaName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()})).addStatement("return this.$L", new Object[]{facetJavaName}).build());
            builderClass.addMethod(MethodSpec.methodBuilder((String)facetJavaName).returns((TypeName)builderClassType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)boxedFacetType.typeName().annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}), (String)facetJavaName, (Modifier[])new Modifier[0]).build()).addStatement("this.$L = $L", new Object[]{facetJavaName, facetJavaName}).addStatement("return this", new Object[]{facetJavaName}).build());
        }
        requestClass.addFields(inputNameFields.stream().map(FieldSpec.Builder::build)::iterator);
        requestClass.addFields(inputSpecFields.stream().map(FieldSpec.Builder::build)::iterator);
        builderClass.addMethod(MethodSpec.methodBuilder((String)"build").returns((TypeName)ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return new %s(%s)".formatted(this.requestClassName, String.join((CharSequence)", ", inputNames)), new Object[0]).build());
        StringWriter writer = new StringWriter();
        FromAndTo fromAndTo = this.fromAndToMethods(inputDefs.stream().filter(inputDef -> inputDef.sources().contains((Object)InputSource.CLIENT)).toList(), ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]));
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)requestClass.addMethod(requestConstructor.build()).addMethod(fromAndTo.from()).addMethod(fromAndTo.to()).addType(builderClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDataType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FacetGenModel abstractInput) {
        if (abstractInput instanceof InputModel) {
            InputModel inputDef = (InputModel)abstractInput;
            return inputDef.type();
        }
        if (abstractInput instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)abstractInput;
            return dep.responseType();
        }
        throw new UnsupportedOperationException("Unable to extract datatype from facet : %s".formatted(abstractInput));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName boxPrimitive(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName javaType) {
        if (javaType.type().isPresent() && javaType.type().get().getKind().isPrimitive()) {
            TypeMirror boxed = this.processingEnv.getTypeUtils().boxedClass((PrimitiveType)javaType.type().get()).asType();
            return new TypeAndName(TypeName.get((TypeMirror)boxed).annotated(javaType.annotationSpecs()), Optional.of(boxed), javaType.annotationSpecs());
        }
        return javaType;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName unboxPrimitive(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName javaType) {
        if (javaType.type().isPresent()) {
            PrimitiveType primitiveType;
            try {
                primitiveType = this.processingEnv.getTypeUtils().unboxedType(javaType.type().get());
            }
            catch (IllegalArgumentException ignored) {
                return javaType;
            }
            return new TypeAndName(TypeName.get((TypeMirror)primitiveType), Optional.of(primitiveType), javaType.annotationSpecs());
        }
        return javaType;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FromAndTo fromAndToMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FacetGenModel> inputDefs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName enclosingClass) {
        MethodSpec.Builder toFacetValues = MethodSpec.methodBuilder((String)"toFacetValues").returns(Facets.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return new $T($T.of(%s))".formatted(inputDefs.stream().map(facetGenModel -> "$S, $T.withValue(this.$L)").collect(Collectors.joining(","))), Stream.of(Stream.of(Facets.class, ImmutableMap.class), inputDefs.stream().flatMap(facet -> Stream.of(facet.name(), Errable.class, VajramCodeGenerator.toJavaName(facet.name())))).flatMap(Function.identity()).toArray());
        MethodSpec.Builder fromFacetValues = MethodSpec.methodBuilder((String)"from").returns((TypeName)enclosingClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(Facets.class, "values", new Modifier[0]);
        List<String> inputNames = inputDefs.stream().map(FacetGenModel::name).toList();
        fromFacetValues.addStatement("return new $T(%s)".formatted(inputNames.stream().map(s -> "values.getInputValueOrDefault($S, null)").collect(Collectors.joining(", "))), Stream.concat(Stream.of(enclosingClass), inputNames.stream()).toArray());
        return new FromAndTo(fromFacetValues.build(), toFacetValues.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType) {
        return this.getTypeName(dataType, List.of());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> typeAnnotations) {
        TypeMirror javaModelType = dataType.javaModelType(this.processingEnv);
        return new TypeAndName(TypeName.get((TypeMirror)javaModelType).annotated(typeAnnotations), Optional.of(javaModelType), typeAnnotations);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec getterCodeForInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized InputModel<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> facet, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String name, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName typeAndName) {
        boolean wrapWithOptional = !facet.isMandatory();
        return MethodSpec.methodBuilder((String)name).returns(wrapWithOptional ? VajramCodeGenerator.optional(this.boxPrimitive(typeAndName).typeName().withoutAnnotations()) : this.unboxPrimitive(typeAndName).typeName().withoutAnnotations()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(!wrapWithOptional ? CodeBlock.of((String)"if($L == null) {\n  throw new IllegalStateException(\"The inputDef '$L' is not optional, but has null value. This should not happen\");\n}", (Object[])new Object[]{name, name}) : CodeBlock.builder().build()).addCode(wrapWithOptional ? CodeBlock.builder().addStatement("return $T.ofNullable(this.$L)", new Object[]{Optional.class, name}).build() : CodeBlock.builder().addStatement("return this.$L", new Object[]{name}).build()).build();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec getterCodeForDependency(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DependencyModel dependencyDef, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String name, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName typeAndName) {
        boolean wrapWithErrable = !dependencyDef.isMandatory() && !dependencyDef.canFanout();
        return MethodSpec.methodBuilder((String)name).returns(wrapWithErrable ? typeAndName.typeName() : this.unboxPrimitive(typeAndName).typeName().withoutAnnotations()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(!wrapWithErrable ? CodeBlock.of((String)"if($L == null) {\n  throw new IllegalStateException(\"The dependency '$L' is not optional, but has null value. This should not happen\");\n}", (Object[])new Object[]{name, name}) : CodeBlock.builder().build()).addCode(CodeBlock.builder().addStatement("return this.$L", new Object[]{name}).build()).build();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenInputUtil() {
        boolean doInputsNeedBatching = this.vajramInfo.facetStream().filter(d -> d instanceof InputModel).map(d -> (InputModel)d).anyMatch(InputModel::isBatched);
        if (doInputsNeedBatching) {
            return this.codeGenBatchedInputUtil();
        }
        return this.codeGenSimpleInputUtil();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenSimpleInputUtil() {
        TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
        String className = Utils.getAllFacetsClassname(this.vajramName);
        TypeSpec.Builder allInputsClass = this.util.classBuilder(className).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC}).addAnnotations(VajramCodeGenerator.recordAnnotations());
        ArrayList<FieldTypeName> fieldsList = new ArrayList<FieldTypeName>();
        this.vajramInfo.inputs().forEach(inputDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.name());
            TypeAndName inputType = this.getTypeName(inputDef.type(), List.of(AnnotationSpec.builder(Nullable.class).build()));
            TypeAndName boxedInputType = this.boxPrimitive(inputType);
            allInputsClass.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(this.getterCodeForInput((InputModel<?>)inputDef, inputJavaName, inputType));
            fieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
        });
        this.vajramInfo.dependencies().forEach(dependencyDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.name());
            TypeAndName depType = this.getDependencyOutputsType((DependencyModel)dependencyDef);
            allInputsClass.addField(this.boxPrimitive(depType).typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(this.getterCodeForDependency((DependencyModel)dependencyDef, inputJavaName, depType));
            fieldsList.add(new FieldTypeName(depType.typeName(), inputJavaName));
        });
        this.generateConstructor(fieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)allInputsClass).addMethod(arg_0));
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(allInputsClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec> generateConstructor(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized FieldTypeName> fieldsList) {
        if (fieldsList.isEmpty()) {
            return Optional.empty();
        }
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        fieldsList.forEach(fieldTypeName -> {
            constructor.addParameter(fieldTypeName.typeName(), fieldTypeName.name(), new Modifier[0]);
            constructor.addCode(CodeBlock.builder().addStatement("this.$L = $L", new Object[]{fieldTypeName.name(), fieldTypeName.name()}).build());
        });
        return Optional.of(constructor.build());
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeAndName getDependencyOutputsType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DependencyModel dependencyDef) {
        boolean wrapWithErrable = !dependencyDef.isMandatory() && !dependencyDef.canFanout();
        DataType<?> depResponseType = dependencyDef.responseType();
        if (dependencyDef.canFanout()) {
            return new TypeAndName((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{VajramCodeGenerator.toClassName(dependencyDef.depReqClassQualifiedName()), this.boxPrimitive(this.getTypeName(depResponseType)).typeName()}));
        }
        if (wrapWithErrable) {
            return new TypeAndName((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{this.boxPrimitive(this.getTypeName(depResponseType)).typeName()}));
        }
        return this.getTypeName(depResponseType);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ClassName toClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String depReqClassName) {
        int lastDotIndex = depReqClassName.lastIndexOf(".");
        return ClassName.get((String)depReqClassName.substring(0, lastDotIndex), (String)depReqClassName.substring(lastDotIndex + 1), (String[])new String[0]);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String codeGenBatchedInputUtil() {
        StringWriter writer = new StringWriter();
        try {
            TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
            VajramInfo vajramFacetsDef = this.vajramInfo;
            String imClassName = Utils.getBatchedInputsClassname(this.vajramName);
            String ciClassName = Utils.getCommonFacetsClassname(this.vajramName);
            FromAndTo imFromAndTo = this.fromAndToMethods(vajramFacetsDef.inputs().stream().filter(InputModel::isBatched).toList(), ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{imClassName}));
            TypeSpec.Builder inputsNeedingBatching = this.util.classBuilder(imClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(FacetValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(imFromAndTo.to()).addMethod(imFromAndTo.from());
            FromAndTo ciFromAndTo = this.fromAndToMethods(Stream.concat(vajramFacetsDef.inputs().stream().filter(inputDef -> !inputDef.isBatched()), vajramFacetsDef.dependencies().stream()).toList(), ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{ciClassName}));
            TypeSpec.Builder commonInputs = this.util.classBuilder(ciClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(FacetValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(ciFromAndTo.to()).addMethod(ciFromAndTo.from());
            ClassName imType = ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{imClassName});
            ClassName ciType = ClassName.get((String)this.packageName, (String)Utils.getFacetUtilClassName(this.vajramName), (String[])new String[]{ciClassName});
            ArrayList<FieldTypeName> ciFieldsList = new ArrayList<FieldTypeName>();
            ArrayList<FieldTypeName> imFieldsList = new ArrayList<FieldTypeName>();
            vajramFacetsDef.inputs().forEach(inputDef -> {
                String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.name());
                TypeAndName inputType = this.getTypeName(inputDef.type(), List.of(AnnotationSpec.builder(Nullable.class).build()));
                TypeAndName boxedInputType = this.boxPrimitive(inputType);
                if (inputDef.isBatched()) {
                    inputsNeedingBatching.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    inputsNeedingBatching.addMethod(this.getterCodeForInput((InputModel<?>)inputDef, inputJavaName, inputType));
                    imFieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
                } else {
                    commonInputs.addField(boxedInputType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    commonInputs.addMethod(this.getterCodeForInput((InputModel<?>)inputDef, inputJavaName, inputType));
                    ciFieldsList.add(new FieldTypeName(boxedInputType.typeName(), inputJavaName));
                }
            });
            vajramFacetsDef.dependencies().forEach(dependencyDef -> {
                TypeAndName depType = this.getDependencyOutputsType((DependencyModel)dependencyDef);
                String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.name());
                commonInputs.addField(this.boxPrimitive(depType).typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                commonInputs.addMethod(this.getterCodeForDependency((DependencyModel)dependencyDef, inputJavaName, depType));
                ciFieldsList.add(new FieldTypeName(depType.typeName(), inputJavaName));
            });
            this.generateConstructor(ciFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)commonInputs).addMethod(arg_0));
            this.generateConstructor(imFieldsList).ifPresent(arg_0 -> ((TypeSpec.Builder)inputsNeedingBatching).addMethod(arg_0));
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(FacetsConverter.class), (TypeName[])new TypeName[]{imType, ciType});
            CodeBlock.Builder initializer = CodeBlock.builder().add("$L", new Object[]{this.util.classBuilder("").addSuperinterface((TypeName)parameterizedTypeName).addMethod(MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(UnBatchedFacets.class), (TypeName[])new TypeName[]{imType, ciType})).addParameter(Facets.class, "inputValues", new Modifier[0]).addStatement("return new $T<>($T.from(inputValues),$T.from(inputValues))", new Object[]{UnBatchedFacets.class, imType, ciType}).build()).build()});
            FieldSpec.Builder converter = FieldSpec.builder((TypeName)parameterizedTypeName, (String)"CONVERTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer(initializer.build());
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(inputsNeedingBatching.build()).addType(commonInputs.build()).addField(converter.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> recordAnnotations() {
        return VajramCodeGenerator.annotations(EqualsAndHashCode.class, ToString.class);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeSpec.Builder createInputUtilClass() {
        TypeSpec.Builder classBuilder = this.util.classBuilder(Utils.getFacetUtilClassName(this.vajramName)).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        List<FacetGenModel> facets = this.vajramInfo.facetStream().toList();
        ArrayList<FieldSpec.Builder> depSpecFields = new ArrayList<FieldSpec.Builder>(facets.size());
        for (FacetGenModel facet : facets) {
            String facetJavaName = VajramCodeGenerator.toJavaName(facet.name());
            TypeAndName facetType = this.getTypeName(this.getDataType(facet));
            TypeAndName boxedFacetType = this.boxPrimitive(facetType);
            ClassName vajramReqClass = ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]);
            String inputNameFieldName = facetJavaName + "_n";
            if (!(facet instanceof DependencyModel)) continue;
            DependencyModel vajramDepDef = (DependencyModel)facet;
            ClassName depReqClass = ClassName.bestGuess((String)vajramDepDef.depReqClassQualifiedName());
            ClassName specType = ClassName.get(vajramDepDef.canFanout() ? VajramDepFanoutTypeSpec.class : VajramDepSingleTypeSpec.class);
            FieldSpec.Builder inputSpecField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)specType, (TypeName[])new TypeName[]{boxedFacetType.typeName(), vajramReqClass, depReqClass}), (String)(facetJavaName + "_s"), (Modifier[])new Modifier[0]).initializer("new $T<>($T.$L, $T.class, $T.class)", new Object[]{specType, vajramReqClass, inputNameFieldName, vajramReqClass, depReqClass});
            depSpecFields.add(inputSpecField.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL}));
        }
        return classBuilder.addFields(depSpecFields.stream().map(FieldSpec.Builder::build)::iterator);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getRequestClassName() {
        return this.requestClassName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getPackageName() {
        return this.packageName;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String toJavaName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String inputName) {
        return inputName;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName optional(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{javaType});
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName errable(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Errable.class), (TypeName[])new TypeName[]{javaType});
    }

    private record TypeAndName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror> type, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized AnnotationSpec> annotationSpecs) {
        private TypeAndName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName) {
            this(typeName, Optional.empty(), List.of());
        }
    }

    private record FromAndTo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec from, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized MethodSpec to) {
    }

    private record FieldTypeName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName typeName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String name) {
    }
}

