/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.vajram.Dependency;
import com.flipkart.krystal.vajram.Generated;
import com.flipkart.krystal.vajram.Input;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.batching.Batch;
import com.flipkart.krystal.vajram.codegen.DeclaredTypeVisitor;
import com.flipkart.krystal.vajram.codegen.VajramCodeGenerator;
import com.flipkart.krystal.vajram.codegen.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.models.InputModel;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.models.VajramInfoLite;
import com.flipkart.krystal.vajram.facets.InputSource;
import com.flipkart.krystal.vajram.facets.Using;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.inject.Inject;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Clock;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;

public class Utils {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean DEBUG = false;
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String DOT = ".";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String COMMA = ",";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String REQUEST_SUFFIX = "Request";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String IMPL = "Impl";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String FACET_UTIL = "FacetUtil";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String CONVERTER = "BATCH_CONVERTER";
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Types typeUtils;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Elements elementUtils;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> generator;

    public Utils(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> generator) {
        this.processingEnv = processingEnv;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.generator = generator;
    }

    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement> getVajramClasses(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized RoundEnvironment roundEnv) {
        return roundEnv.getElementsAnnotatedWith(VajramDef.class).stream().filter(element -> element.getKind() == ElementKind.CLASS).map(executableElement -> (TypeElement)executableElement).toList();
    }

    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramCodeGenerator createCodeGenerator(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo vajramInfo) {
        HashMap<VajramID, VajramInfoLite> vajramDefs = new HashMap<VajramID, VajramInfoLite>();
        for (DependencyModel depModel : vajramInfo.dependencies()) {
            vajramDefs.put(depModel.depVajramId(), new VajramInfoLite(depModel.depVajramId().vajramId(), depModel.responseType()));
        }
        return new VajramCodeGenerator(vajramInfo, vajramDefs, this.processingEnv, this);
    }

    void generateSourceFile(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String className, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String code, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramDefinition) {
        try {
            JavaFileObject requestFile = this.processingEnv.getFiler().createSourceFile(className, vajramDefinition);
            this.note("Successfully Create source file %s".formatted(className));
            try (PrintWriter out = new PrintWriter(requestFile.openWriter());){
                out.println(code);
            }
        }
        catch (Exception e) {
            this.error("Error creating java file for className: %s. Error: %s".formatted(className, e), vajramDefinition);
        }
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo computeVajramInfo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramClass) {
        VajramInfoLite vajramInfoLite = this.getVajramInfoLite(vajramClass);
        Optional<Element> facetsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_Facets")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        List<VariableElement> fields = ElementFilter.fieldsIn(facetsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> inputFields = fields.stream().filter(variableElement -> variableElement.getAnnotation(Input.class) != null || variableElement.getAnnotation(Inject.class) != null).toList();
        List<VariableElement> dependencyFields = fields.stream().filter(variableElement -> variableElement.getAnnotation(Dependency.class) != null).toList();
        PackageElement enclosingElement = (PackageElement)vajramClass.getEnclosingElement();
        String packageName = enclosingElement.getQualifiedName().toString();
        VajramInfo vajramInfo = new VajramInfo(VajramID.vajramID((String)vajramInfoLite.vajramId()), vajramInfoLite.responseType(), packageName, (ImmutableList)inputFields.stream().map(inputField -> {
            InputModel.InputModelBuilder inputBuilder = InputModel.builder().facetField((VariableElement)inputField);
            inputBuilder.name(inputField.getSimpleName().toString());
            inputBuilder.isMandatory(!DeclaredTypeVisitor.isOptional(inputField.asType(), this.processingEnv));
            DataType dataType = (DataType)inputField.asType().accept(new DeclaredTypeVisitor(this, true, (Element)inputField), null);
            inputBuilder.type(dataType);
            inputBuilder.isBatched(Optional.ofNullable(inputField.getAnnotation(Batch.class)).isPresent());
            Optional<Input> inputAnno = Optional.ofNullable(inputField.getAnnotation(Input.class));
            LinkedHashSet<InputSource> sources = new LinkedHashSet<InputSource>();
            if (inputAnno.isPresent()) {
                sources.add(InputSource.CLIENT);
            }
            if (inputField.getAnnotation(Inject.class) != null) {
                sources.add(InputSource.SESSION);
            }
            inputBuilder.sources(sources);
            return inputBuilder.build();
        }).collect(ImmutableList.toImmutableList()), (ImmutableList<DependencyModel>)((ImmutableList)dependencyFields.stream().map(depField -> this.toDependencyModel(vajramInfoLite.vajramId(), (VariableElement)depField)).collect(ImmutableList.toImmutableList())), vajramClass);
        this.note("VajramInfo: %s".formatted(vajramInfo));
        return vajramInfo;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DependencyModel toDependencyModel(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramId, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VariableElement depField) {
        Dependency dependency = depField.getAnnotation(Dependency.class);
        DependencyModel.DependencyModelBuilder depBuilder = DependencyModel.builder().facetField(depField);
        depBuilder.name(depField.getSimpleName().toString());
        depBuilder.isMandatory(!DeclaredTypeVisitor.isOptional(depField.asType(), this.processingEnv));
        Optional<TypeMirror> vajramReqType = this.getTypeFromAnnotationMember(() -> ((Dependency)dependency).withVajramReq()).filter(typeMirror -> !((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)).getQualifiedName().equals(this.getTypeElement(VajramRequest.class.getName()).getQualifiedName()));
        Optional<TypeMirror> vajramType = this.getTypeFromAnnotationMember(() -> ((Dependency)dependency).onVajram()).filter(typeMirror -> !((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)).getQualifiedName().equals(this.getTypeElement(Vajram.class.getName()).getQualifiedName()));
        TypeMirror vajramOrReqType = vajramReqType.or(() -> vajramType).orElseThrow(() -> {
            this.error("At least one of `onVajram` or `withVajramReq` is needed in dependency declaration '%s' of vajram '%s'".formatted(depField.getSimpleName(), vajramId), depField);
            return new RuntimeException("Invalid Dependency specification");
        });
        if (!vajramReqType.isPresent() || !vajramType.isPresent()) {
            DataType declaredDataType = (DataType)new DeclaredTypeVisitor(this, true, depField).visit(depField.asType());
            TypeElement vajramOrReqElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(vajramOrReqType);
            VajramInfoLite depVajramId = this.getVajramInfoLite(vajramOrReqElement);
            depBuilder.depVajramId(VajramID.vajramID((String)depVajramId.vajramId())).depReqClassQualifiedName(this.getVajramReqClassName(vajramOrReqElement)).canFanout(dependency.canFanout());
            if (!declaredDataType.equals(depVajramId.responseType())) {
                this.error("Declared dependency type %s does not match dependency vajram response type %s".formatted(declaredDataType, depVajramId.responseType()), depField);
            }
            depBuilder.responseType(declaredDataType);
            return depBuilder.build();
        }
        this.error("Both `withVajramReq` and `onVajram` cannot be set. Please set only one of them for dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get()), depField);
        this.error("Invalid dependency spec of dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get()), depField);
        throw new RuntimeException("Invalid Dependency specification");
    }

    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement getTypeElement(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String name) {
        return Optional.ofNullable(this.elementUtils.getTypeElement(name)).orElseThrow(() -> new IllegalStateException("Could not find type element with name %s".formatted(name)));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfoLite getVajramInfoLite(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramOrReqClass) {
        String vajramClassSimpleName = vajramOrReqClass.getSimpleName().toString();
        if (this.isRawAssignable(vajramOrReqClass.asType(), VajramRequest.class)) {
            TypeMirror responseType = this.getResponseType(vajramOrReqClass, VajramRequest.class);
            TypeElement responseTypeElement = (TypeElement)this.typeUtils.asElement(responseType);
            return new VajramInfoLite(vajramClassSimpleName.substring(0, vajramClassSimpleName.length() - REQUEST_SUFFIX.length()), (DataType)new DeclaredTypeVisitor(this, false, responseTypeElement).visit(responseType));
        }
        if (this.isRawAssignable(vajramOrReqClass.asType(), Vajram.class)) {
            TypeMirror responseType = this.getResponseType(vajramOrReqClass, Vajram.class);
            TypeElement responseTypeElement = (TypeElement)this.typeUtils.asElement(responseType);
            VajramDef vajramDef = vajramOrReqClass.getAnnotation(VajramDef.class);
            if (vajramDef == null) {
                throw new IllegalArgumentException("Vajram class %s does not have @VajramDef annotation. This should not happen".formatted(vajramOrReqClass));
            }
            return new VajramInfoLite(vajramClassSimpleName, (DataType)new DeclaredTypeVisitor(this, false, responseTypeElement).visit(responseType));
        }
        throw new IllegalArgumentException("Unknown class hierarchy of vajram class %s. Expected %s or %s".formatted(vajramOrReqClass, Vajram.class, VajramRequest.class));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramReqClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramClass) {
        if (this.isRawAssignable(vajramClass.asType(), Vajram.class)) {
            return vajramClass.getQualifiedName().toString() + REQUEST_SUFFIX;
        }
        if (this.isRawAssignable(vajramClass.asType(), VajramRequest.class)) {
            return vajramClass.getQualifiedName().toString();
        }
        throw new AssertionError((Object)"This should not happen!");
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror> getTypeFromAnnotationMember(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> runnable) {
        try {
            runnable.get();
            throw new AssertionError();
        }
        catch (MirroredTypeException mte) {
            return Optional.ofNullable(mte.getTypeMirror());
        }
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror getResponseType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramDef, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass) {
        int typeParamIndex = 0;
        List<TypeMirror> currentTypes = List.of(vajramDef.asType());
        this.note("VajramDef: %s".formatted(vajramDef));
        Types typeUtils = this.processingEnv.getTypeUtils();
        DeclaredType vajramInterface = null;
        do {
            ArrayList<TypeMirror> newSuperTypes = new ArrayList<TypeMirror>();
            for (TypeMirror currentType : currentTypes) {
                List<DeclaredType> superTypes = this.processingEnv.getTypeUtils().directSupertypes(currentType).stream().filter(t -> t instanceof DeclaredType).map(t -> (DeclaredType)t).toList();
                newSuperTypes.addAll(superTypes);
                for (DeclaredType superType : superTypes) {
                    this.note("SuperType: %s [%s]".formatted(superType, superType.getClass()));
                    Element element = typeUtils.asElement(superType);
                    if (!(element instanceof TypeElement)) continue;
                    TypeElement typeElement = (TypeElement)element;
                    this.note("Element qualified name: %s".formatted(typeElement.getQualifiedName()));
                    if (!typeElement.getQualifiedName().contentEquals(targetClass.getName())) continue;
                    vajramInterface = superType;
                    break;
                }
                this.note("CurrentElement: %s".formatted(currentType));
            }
            if (vajramInterface != null) continue;
            currentTypes = newSuperTypes;
        } while (!currentTypes.isEmpty() && vajramInterface == null);
        if (vajramInterface != null) {
            List<? extends TypeMirror> typeParameters = vajramInterface.getTypeArguments();
            if (typeParameters.size() > typeParamIndex) {
                return typeParameters.get(typeParamIndex);
            }
            this.error("Incorrect number of parameter types on Vajram interface. Expected 1, Found %s".formatted(typeParameters), vajramDef);
        }
        this.error("Unable to infer response type for Vajram %s".formatted(vajramDef.getQualifiedName()), vajramDef);
        throw new RuntimeException();
    }

    void note(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized CharSequence message) {
    }

    public void error(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String message, @javax.annotation.Nullable @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Nullable @Initialized Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getTimestamp() {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(Clock.systemDefaultZone().instant().atZone(ZoneId.systemDefault()));
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getFacetUtilClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + FACET_UTIL;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getRequestClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + REQUEST_SUFFIX;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramImplClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramId) {
        return vajramId + IMPL;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getAllFacetsClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + "Facets";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getCommonFacetsClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + "CommonFacets";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getBatchedFacetsClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + "BatchFacets";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName getMethodReturnType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method method) {
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            return Utils.toTypeName(method.getGenericReturnType());
        }
        return TypeName.get(method.getReturnType());
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName toTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType) {
        return TypeName.get((TypeMirror)this.toTypeMirror(dataType));
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror toTypeMirror(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType) {
        return dataType.javaModelType(this.processingEnv);
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName toTypeName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Type typeArg) {
        if (typeArg instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeArg;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            return ParameterizedTypeName.get((ClassName)((ClassName)Utils.toTypeName(rawType)), (TypeName[])((TypeName[])Arrays.stream(typeArgs).map(Utils::toTypeName).toArray(TypeName[]::new)));
        }
        if (typeArg instanceof Class) {
            return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
        }
        return ClassName.bestGuess((String)typeArg.getTypeName());
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror> getTypeParameters(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        return returnType.accept(new SimpleTypeVisitor14<List<? extends TypeMirror>, Void>(){

            @Override
            public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror> visitDeclared(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DeclaredType t, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Nullable @Initialized Void unused) {
                return t.getTypeArguments();
            }
        }, null);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isRawAssignable(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror from, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> to) {
        return this.typeUtils.isAssignable(this.typeUtils.erasure(from), this.typeUtils.erasure(this.getTypeElement(to.getName()).asType()));
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror box(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType p = (PrimitiveType)type;
            return this.typeUtils.boxedClass(p).asType();
        }
        return type;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeSpec.Builder classBuilder(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String className) {
        TypeSpec.Builder classBuilder = className.isBlank() ? TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]) : TypeSpec.classBuilder((String)className);
        return classBuilder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("by", "$S", new Object[]{this.generator.getName()}).build());
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String inferFacetName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VariableElement parameter) {
        String usingInputName = Objects.nonNull(parameter.getAnnotation(Using.class)) ? parameter.getAnnotation(Using.class).value() : parameter.getSimpleName().toString();
        return usingInputName;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment getProcessingEnv() {
        return this.processingEnv;
    }
}

