/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.models;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.vajram.VajramLogic;
import com.flipkart.krystal.vajram.codegen.models.VajramInfo;
import com.flipkart.krystal.vajram.exception.VajramValidationException;
import com.flipkart.krystal.vajram.inputs.resolution.Resolve;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ParsedVajramData(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement> resolvers, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement outputLogic, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramClass, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String packageName, /*
 * Issues handling annotations - annotations may be inaccurate
 */
@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> responseType) {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(ParsedVajramData.class);

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ParsedVajramData> fromVajram(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized VajramInfo vajramInfo) {
        TypeElement vajramClass = vajramInfo.vajramClass();
        String packageName = vajramInfo.packageName();
        for (ExecutableElement method : ParsedVajramData.iter(ParsedVajramData.getAllMethods(vajramClass))) {
            if (!ParsedVajramData.isOutputLogic(method) && !ParsedVajramData.isResolver(method) || ParsedVajramData.isStatic(method)) continue;
            throw new VajramValidationException("Vajram class %s has non-static method %s".formatted(vajramInfo.vajramId(), method.getSimpleName()));
        }
        ArrayList<ExecutableElement> resolveMethods = new ArrayList<ExecutableElement>();
        ExecutableElement vajramLogic = ParsedVajramData.getVajramLogicAndResolverMethods(vajramClass, resolveMethods);
        return Optional.of(new ParsedVajramData(vajramInfo.vajramId().vajramId(), resolveMethods, vajramLogic, vajramClass, packageName, vajramInfo.responseType()));
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement getVajramLogicAndResolverMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramCalss, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement> resolveMethods) {
        ExecutableElement vajramLogic = null;
        for (ExecutableElement method : ParsedVajramData.getStaticMethods(vajramCalss)) {
            if (ParsedVajramData.isResolver(method)) {
                resolveMethods.add(method);
                continue;
            }
            if (!ParsedVajramData.isOutputLogic(method)) continue;
            if (vajramLogic == null) {
                vajramLogic = method;
                continue;
            }
            throw new VajramValidationException("Multiple VajramLogic annotated methods found in " + vajramCalss.getSimpleName());
        }
        if (vajramLogic == null) {
            throw new VajramValidationException("Missing vajram logic method");
        }
        return vajramLogic;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isResolver(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return ((Resolve[])method.getAnnotationsByType(Resolve.class)).length == 1;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isOutputLogic(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement method) {
        return ((VajramLogic[])method.getAnnotationsByType(VajramLogic.class)).length == 1;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement> getStaticMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramClass) {
        return ParsedVajramData.getAllMethods(vajramClass).filter(element -> element.getModifiers().contains((Object)Modifier.STATIC)).toList();
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Stream<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ExecutableElement> getAllMethods(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeElement vajramCalss) {
        return vajramCalss.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).map(element -> (ExecutableElement)element);
    }

    private static <T> @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Iterable<T> iter(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Stream<T> elementStream) {
        return elementStream::iterator;
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isStatic(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }
}

