/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.datatypes.DataType;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.lang.model.util.Types;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodegenUtils {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(CodegenUtils.class);
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String DOT = ".";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String COMMA = ",";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String REQUEST_SUFFIX = "Request";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String IMPL = "Impl";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String INPUT_UTIL = "InputUtil";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String CONVERTER = "CONVERTER";
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Types typeUtils;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Elements elementUtils;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv;

    public CodegenUtils(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized ProcessingEnvironment processingEnv) {
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.processingEnv = processingEnv;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getPackageFromPath(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path filePath) {
        Path parentDir = (Path)Preconditions.checkNotNull((Object)filePath.getParent(), (String)"Cannot get package for a file %s as it does not have a parent directory", (Object)filePath);
        return IntStream.range(0, parentDir.getNameCount()).mapToObj(i -> parentDir.getName(i).toString()).collect(Collectors.joining(DOT));
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getInputUtilClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + INPUT_UTIL;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getRequestClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + REQUEST_SUFFIX;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramImplClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramId) {
        return vajramId + IMPL;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getAllInputsClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + "Inputs";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getCommonInputsClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + "CommonInputs";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getInputModulationClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + "ModInputs";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName getMethodReturnType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method method) {
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            return CodegenUtils.toTypeName(method.getGenericReturnType());
        }
        return TypeName.get(method.getReturnType());
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName toTypeName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType) {
        return TypeName.get((TypeMirror)this.toTypeMirror(dataType));
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror toTypeMirror(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DataType<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType) {
        return dataType.javaModelType(this.processingEnv);
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName toTypeName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Type typeArg) {
        if (typeArg instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeArg;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            return ParameterizedTypeName.get((ClassName)((ClassName)CodegenUtils.toTypeName(rawType)), (TypeName[])((TypeName[])Arrays.stream(typeArgs).map(CodegenUtils::toTypeName).toArray(TypeName[]::new)));
        }
        if (typeArg instanceof Class) {
            return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
        }
        return ClassName.bestGuess((String)typeArg.getTypeName());
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror> getTypeParameters(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror returnType) {
        return returnType.accept(new SimpleTypeVisitor14<List<? extends TypeMirror>, Void>(){

            @Override
            public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized List<@BottomVal @ClassValBottom @MethodValBottom @KeyForBottom @NonNull @Initialized ? extends @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror> visitDeclared(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized DeclaredType t, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Nullable @Initialized Void unused) {
                return t.getTypeArguments();
            }
        }, null);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isRawAssignable(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror from, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> to) {
        return this.typeUtils.isAssignable(this.typeUtils.erasure(from), this.typeUtils.erasure(this.elementUtils.getTypeElement(to.getName()).asType()));
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror box(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeMirror type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType p = (PrimitiveType)type;
            return this.typeUtils.boxedClass(p).asType();
        }
        return type;
    }
}

