/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.utils;

import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodegenUtils {
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(CodegenUtils.class);
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String DOT = ".";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String COMMA = ",";
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Pattern COMPILE = Pattern.compile(".");
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String REQUEST = "Request";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String IMPL = "Impl";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String INPUT_UTIL = "InputUtil";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String VAJRAM = "vajram";
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String CONVERTER = "CONVERTER";

    private CodegenUtils() {
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getPackageFromPath(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Path filePath) {
        Path parentDir = (Path)Preconditions.checkNotNull((Object)filePath.getParent(), (String)"Cannot get package for a file %s as it does not have a parent directory", (Object)filePath);
        return IntStream.range(0, parentDir.getNameCount()).mapToObj(i -> parentDir.getName(i).toString()).collect(Collectors.joining(DOT));
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getInputUtilClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return (vajramName.toLowerCase().endsWith(VAJRAM) ? vajramName.substring(0, vajramName.length() - 6) : vajramName) + INPUT_UTIL;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getRequestClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return CodegenUtils.getVajramBaseName(vajramName) + REQUEST;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramImplClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName + IMPL;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramBaseName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return vajramName.toLowerCase().endsWith(VAJRAM) ? vajramName.substring(0, vajramName.length() - 6) : vajramName;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getVajramNameFromClass(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramClassFullName) {
        String[] splits = COMPILE.split(vajramClassFullName);
        return splits[splits.length - 1];
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String toJavaName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String input) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input);
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getAllInputsClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return CodegenUtils.getVajramBaseName(vajramName) + "Inputs";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getCommonInputsClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return CodegenUtils.getVajramBaseName(vajramName) + "CommonInputs";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String getInputModulationClassname(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String vajramName) {
        return CodegenUtils.getVajramBaseName(vajramName) + "ModInputs";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName getMethodReturnType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method method) {
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            return CodegenUtils.getType(method.getGenericReturnType());
        }
        return TypeName.get(method.getReturnType());
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName getMethodGenericReturnType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType genericReturnType = (ParameterizedType)type;
            Type[] actualTypeArguments = genericReturnType.getActualTypeArguments();
            if (actualTypeArguments.length == 1) {
                if (actualTypeArguments[0] instanceof ParameterizedType) {
                    return ParameterizedTypeName.get((ClassName)((ClassName)CodegenUtils.getType(((ParameterizedType)actualTypeArguments[0]).getRawType())), (TypeName[])((TypeName[])Arrays.stream(((ParameterizedType)actualTypeArguments[0]).getActualTypeArguments()).map(CodegenUtils::getType).toArray(TypeName[]::new)));
                }
                return CodegenUtils.getType(actualTypeArguments[0]);
            }
            return ParameterizedTypeName.get((ClassName)((ClassName)CodegenUtils.getType(actualTypeArguments[0])), (TypeName[])((TypeName[])Arrays.stream(actualTypeArguments).skip(1L).map(CodegenUtils::getType).toArray(TypeName[]::new)));
        }
        return ClassName.get((Class)Primitives.wrap(method.getReturnType()));
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName getClassGenericArgumentsType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class klass) {
        Type type = klass.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType genericReturnType = (ParameterizedType)type;
            Type typeArg = genericReturnType.getActualTypeArguments()[0];
            if (typeArg instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)typeArg;
                return CodegenUtils.getType(typeArg);
            }
            if (typeArg instanceof Class) {
                return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
            }
            return ClassName.bestGuess((String)typeArg.getTypeName());
        }
        return TypeName.VOID;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized TypeName getType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Type typeArg) {
        if (typeArg instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeArg;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            return ParameterizedTypeName.get((ClassName)((ClassName)CodegenUtils.getType(rawType)), (TypeName[])((TypeName[])Arrays.stream(typeArgs).map(CodegenUtils::getType).toArray(TypeName[]::new)));
        }
        if (typeArg instanceof Class) {
            return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
        }
        return ClassName.bestGuess((String)typeArg.getTypeName());
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized boolean isDepResolverFanout(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Class dependencyVajram, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Method resolverMethod, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized [] inputs, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Map<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized Field> fields) {
        TypeName classGenericArgumentsType = CodegenUtils.getClassGenericArgumentsType(dependencyVajram);
        TypeName methodGenericReturnType = CodegenUtils.getMethodReturnType(resolverMethod);
        if (methodGenericReturnType.equals((Object)classGenericArgumentsType)) {
            return false;
        }
        if (methodGenericReturnType instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)methodGenericReturnType;
            try {
                Class<?> methodRawType = null;
                methodRawType = Objects.nonNull(parameterizedTypeName.rawType.enclosingClassName()) ? Class.forName(parameterizedTypeName.rawType.enclosingClassName() + "$" + parameterizedTypeName.rawType.simpleName()) : Class.forName(parameterizedTypeName.rawType.canonicalName());
                TypeName typeName = (TypeName)parameterizedTypeName.typeArguments.get(0);
                if (DependencyCommand.class.isAssignableFrom(methodRawType)) {
                    return false;
                }
                if (Iterable.class.isAssignableFrom(methodRawType)) {
                    if (typeName instanceof ParameterizedTypeName && typeName.equals((Object)classGenericArgumentsType)) {
                        return true;
                    }
                    if (ClassName.get(VajramRequest.class).equals((Object)typeName) && Iterable.class.isAssignableFrom(methodRawType)) {
                        return true;
                    }
                    AtomicBoolean fanout = new AtomicBoolean(false);
                    Stream.of(inputs).forEach(input -> {
                        String key = CodegenUtils.toJavaName(input);
                        if (fields.containsKey(key)) {
                            Field field = (Field)fields.get(key);
                            if (typeName.equals((Object)CodegenUtils.getType(field.getType())) && !fanout.get()) {
                                fanout.set(true);
                            }
                        } else {
                            log.error("Field {} not found in {}", (Object)key, (Object)dependencyVajram.getName());
                            throw new RuntimeException(String.format("field %s not found in %s vajram", key, dependencyVajram.getName()));
                        }
                    });
                    return fanout.get();
                }
                assert (typeName instanceof ClassName);
                Class<?> typeClass = Class.forName(((ClassName)typeName).canonicalName());
                if (typeName.equals((Object)classGenericArgumentsType) && Iterable.class.isAssignableFrom(methodRawType)) {
                    return true;
                }
                if (VajramRequest.class.isAssignableFrom(typeClass) && Iterable.class.isAssignableFrom(methodRawType)) {
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

