/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.codegen.common.models.AbstractKrystalAnnoProcessor;
import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.codegen.common.spi.ModelsCodeGeneratorProvider;
import com.flipkart.krystal.model.ModelProtocol;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.model.PlainJavaObject;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"com.flipkart.krystal.model.ModelRoot"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"krystal.codegen.phase", "krystal.codegen.moduleRootPath"})
@AutoService(value={Processor.class})
public final class ModelGenProcessor
extends AbstractKrystalAnnoProcessor {
    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CodeGenUtility util = this.codeGenUtil();
        List<TypeElement> modelRoots = roundEnv.getElementsAnnotatedWith(ModelRoot.class).stream().filter(element -> element.getKind() == ElementKind.INTERFACE).map(executableElement -> (TypeElement)executableElement).toList();
        util.note((CharSequence)"Model Roots received by %s: %s".formatted(((Object)((Object)this)).getClass().getSimpleName(), modelRoots.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]"))));
        ServiceLoader<ModelsCodeGeneratorProvider> codeGeneratorProviders = ServiceLoader.load(ModelsCodeGeneratorProvider.class, ((Object)((Object)this)).getClass().getClassLoader());
        for (TypeElement modelRoot : modelRoots) {
            Set<Class<? extends ModelProtocol>> supportedModelProtocols = this.getSupportedModelProtocols(modelRoot, util);
            ModelsCodeGenContext creationContext = new ModelsCodeGenContext(modelRoot, util, this.codegenPhase());
            for (Class<? extends ModelProtocol> modelProtocol : supportedModelProtocols) {
                if (!StreamSupport.stream(codeGeneratorProviders.spliterator(), false).noneMatch(customCodeGeneratorProvider -> customCodeGeneratorProvider.getSupportedModelProtocols().contains(modelProtocol))) continue;
                util.error("No model code generator found supporting model protocol %s for model root %s".formatted(modelProtocol, modelRoot), new Element[]{modelRoot});
            }
            for (ModelsCodeGeneratorProvider customCodeGeneratorProvider2 : codeGeneratorProviders) {
                try {
                    customCodeGeneratorProvider2.create(creationContext).generate();
                }
                catch (Exception e) {
                    util.error(Throwables.getStackTraceAsString((Throwable)e), new Element[]{creationContext.modelRootType()});
                }
            }
        }
        return false;
    }

    private Set<Class<? extends ModelProtocol>> getSupportedModelProtocols(TypeElement modelRootType, CodeGenUtility util) {
        SupportedModelProtocols supportedModelProtocols = modelRootType.getAnnotation(SupportedModelProtocols.class);
        if (supportedModelProtocols == null) {
            return Set.of(PlainJavaObject.class);
        }
        return util.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value()).stream().map(typeMirror -> util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror)).filter(elem -> elem instanceof QualifiedNameable).map(element -> Objects.requireNonNull((QualifiedNameable)element).getQualifiedName().toString()).map(s -> {
            try {
                return Class.forName(s, false, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                util.error(Throwables.getStackTraceAsString((Throwable)e), new Element[]{modelRootType});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

