/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.codegen.common.models.AbstractKrystalAnnoProcessor;
import com.flipkart.krystal.codegen.common.models.CodeGenShortCircuitException;
import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramsCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGeneratorProvider;
import com.flipkart.krystal.vajram.codegen.processor.Constants;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class AbstractVajramCodegenProcessor
extends AbstractKrystalAnnoProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractVajramCodegenProcessor.class);
    private final List<TypeElement> vajramDefinitions = new LinkedList<TypeElement>();

    public final boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        VajramCodeGenUtility util = new VajramCodeGenUtility(this.codeGenUtil());
        this.vajramDefinitions.addAll(util.getDefinitionClasses(roundEnv));
        String message = "Vajrams and Traits received by %s: %s".formatted(((Object)((Object)this)).getClass().getSimpleName(), this.vajramDefinitions.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]")));
        util.codegenUtil().note((CharSequence)message);
        Iterable vajramCodeGeneratorProviders = Iterables.concat(List.of(Constants.DEFAULT_VAJRAM_CODEGEN_PROVIDER), ServiceLoader.load(VajramCodeGeneratorProvider.class, ((Object)((Object)this)).getClass().getClassLoader()));
        ArrayList<Failure> failures = new ArrayList<Failure>();
        ArrayList<VajramInfo> vajramInfos = new ArrayList<VajramInfo>();
        Iterator<TypeElement> iterator = this.vajramDefinitions.iterator();
        while (iterator.hasNext()) {
            TypeElement vajramDefinition = iterator.next();
            try {
                VajramInfo vajramInfo = util.computeVajramInfo(vajramDefinition);
                vajramInfos.add(vajramInfo);
                VajramCodeGenContext creationContext = new VajramCodeGenContext(vajramInfo, util, this.codegenPhase());
                for (VajramCodeGeneratorProvider customCodeGeneratorProvider : vajramCodeGeneratorProviders) {
                    try {
                        customCodeGeneratorProvider.create(creationContext).generate();
                    }
                    catch (Exception e) {
                        failures.add(new Failure(vajramDefinition, e));
                    }
                }
                iterator.remove();
            }
            catch (Exception e) {
                failures.add(new Failure(vajramDefinition, e));
            }
        }
        ServiceLoader<AllVajramsCodeGeneratorProvider> allVajramCodeGeneratorProviders = ServiceLoader.load(AllVajramsCodeGeneratorProvider.class, ((Object)((Object)this)).getClass().getClassLoader());
        for (AllVajramsCodeGeneratorProvider allVajramCodeGen : allVajramCodeGeneratorProviders) {
            try {
                allVajramCodeGen.create(new AllVajramCodeGenContext(vajramInfos, util, this.codegenPhase())).generate();
            }
            catch (Exception e) {
                failures.add(new Failure(null, e));
            }
        }
        for (Failure failure : failures) {
            Throwable throwable = failure.throwable();
            if (throwable instanceof CodeGenShortCircuitException) {
                util.codegenUtil().note((CharSequence)("[Vajram Codegen Exception]" + throwable.getMessage()), failure.element());
                continue;
            }
            util.codegenUtil().error("[Vajram Codegen Exception] " + Throwables.getStackTraceAsString((Throwable)throwable), new Element[]{failure.element()});
        }
        return false;
    }

    private record Failure(@Nullable TypeElement element, Throwable throwable) {
    }
}

