package com.flipkart.krystal.vajram.codegen.processor;

import static com.flipkart.krystal.codegen.common.models.CodeGenUtility.addCommonObjectMethods;
import static com.flipkart.krystal.codegen.common.models.CodeGenUtility.annotations;
import static com.flipkart.krystal.codegen.common.models.CodeGenUtility.getTypeParameters;
import static com.flipkart.krystal.codegen.common.models.Constants.EMPTY_CODE_BLOCK;
import static com.flipkart.krystal.facets.FacetType.DEPENDENCY;
import static com.flipkart.krystal.facets.FacetType.INPUT;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.BATCHED_OUTPUT_VAR;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.BATCHES_VAR;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.BATCH_ITEM_FACETS_SUFFIX;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.BATCH_KEY_FACETS_SUFFIX;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.BATCH_KEY_NAME;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.FACETS_LIST;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.FACET_NAME_SUFFIX;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.FACET_SPEC_SUFFIX;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.FACET_VALUES_VAR;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.GET_INPUT_RESOLVERS;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.GET_SIMPLE_INPUT_RESOLVERS;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.OUTPUT_LOGIC_INPUT_VAR;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.QUALIFIED_FACET_SEPARATOR;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.RESOLVER_REQUEST;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.RESOLVER_REQUESTS;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.RESOLVER_RESULT;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.RESOLVER_RESULTS;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants.VAJRAM_ID_CONSTANT_NAME;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants._INPUTS_CLASS;
import static com.flipkart.krystal.vajram.codegen.common.models.Constants._INTERNAL_FACETS_CLASS;
import static com.flipkart.krystal.vajram.codegen.common.models.ParsedVajramData.fromVajramInfo;
import static com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility.getImmutFacetsClassName;
import static com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility.getImmutRequestInterfaceName;
import static com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility.getImmutRequestPojoName;
import static com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility.getRequestInterfaceName;
import static com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility.getVajramImplClassName;
import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.collect.ImmutableMap.toImmutableMap;
import static com.google.common.collect.ImmutableSet.toImmutableSet;
import static com.squareup.javapoet.MethodSpec.constructorBuilder;
import static com.squareup.javapoet.MethodSpec.methodBuilder;
import static com.squareup.javapoet.MethodSpec.overriding;
import static com.squareup.javapoet.TypeSpec.anonymousClassBuilder;
import static java.util.Arrays.stream;
import static java.util.Map.entry;
import static java.util.Objects.requireNonNull;
import static java.util.stream.Collectors.toMap;
import static java.util.stream.Collectors.toSet;
import static javax.lang.model.element.Modifier.ABSTRACT;
import static javax.lang.model.element.Modifier.DEFAULT;
import static javax.lang.model.element.Modifier.FINAL;
import static javax.lang.model.element.Modifier.PRIVATE;
import static javax.lang.model.element.Modifier.PUBLIC;
import static javax.lang.model.element.Modifier.STATIC;

import com.flipkart.krystal.annos.TraitDependency;
import com.flipkart.krystal.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.models.TypeAndName;
import com.flipkart.krystal.codegen.common.models.TypeNameVisitor;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.core.GraphExecutionData;
import com.flipkart.krystal.core.OutputLogicExecutionInput;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.FacetValuesContainer;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.data.ImmutableFacetValuesContainer;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponse;
import com.flipkart.krystal.data.RequestResponseFuture;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.facets.FacetUtils;
import com.flipkart.krystal.facets.resolution.ResolutionTarget;
import com.flipkart.krystal.facets.resolution.ResolverCommand;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.model.IfAbsent.IfAbsentThen;
import com.flipkart.krystal.model.Model;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.model.ModelRoot.ModelType;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.serial.ReservedSerialIds;
import com.flipkart.krystal.serial.SerialId;
import com.flipkart.krystal.vajram.IOVajramDef;
import com.flipkart.krystal.vajram.TraitRequestRoot;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.VajramInitData;
import com.flipkart.krystal.vajram.VajramRequestRoot;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchEnabledImmutableFacetValues;
import com.flipkart.krystal.vajram.batching.BatchItemExecutionItem;
import com.flipkart.krystal.vajram.batching.Batched;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.BatchesGroupedBy;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.common.models.DefaultFacetModel;
import com.flipkart.krystal.vajram.codegen.common.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetJavaType;
import com.flipkart.krystal.vajram.codegen.common.models.LogicMethods;
import com.flipkart.krystal.vajram.codegen.common.models.LogicMethods.OutputLogics;
import com.flipkart.krystal.vajram.codegen.common.models.LogicMethods.OutputLogics.NoBatching;
import com.flipkart.krystal.vajram.codegen.common.models.LogicMethods.OutputLogics.WithBatching;
import com.flipkart.krystal.vajram.codegen.common.models.ParsedVajramData;
import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGenContext;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.FacetIdNameMapping;
import com.flipkart.krystal.vajram.facets.FacetValidation;
import com.flipkart.krystal.vajram.facets.FanoutCommand;
import com.flipkart.krystal.vajram.facets.One2OneCommand;
import com.flipkart.krystal.vajram.facets.resolution.AbstractFanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.AbstractOne2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.FanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.InputResolver;
import com.flipkart.krystal.vajram.facets.resolution.One2OneInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.Resolve;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryFacetDefaultSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryFanoutDepSpec;
import com.flipkart.krystal.vajram.facets.specs.MandatoryOne2OneDepSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalFacetDefaultSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalFanoutDepSpec;
import com.flipkart.krystal.vajram.facets.specs.OptionalOne2OneDepSpec;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Documented;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import lombok.EqualsAndHashCode;
import lombok.EqualsAndHashCode.Include;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Slf4j
public class VajramCodeGenerator implements CodeGenerator {

  private static final ImmutableSet<String> MODEL_METHOD_ANNOTATIONS =
      ImmutableSet.<@NonNull String>copyOf(
          Stream.of(IfAbsent.class, SerialId.class)
              .<@NonNull String>map(aClass -> requireNonNull(aClass.getCanonicalName()))
              .toList());

  private static final ImmutableSet<String> MODEL_CLASS_ANNOTATIONS =
      ImmutableSet.<@NonNull String>copyOf(
          Stream.of(ReservedSerialIds.class, SupportedModelProtocols.class)
              .<@NonNull String>map(aClass -> requireNonNull(aClass.getCanonicalName()))
              .toList());

  private final String packageName;
  private final VajramInfo currentVajramInfo;

  private final Map<Integer, FacetGenModel> facetModels;
  private final Map<String, FacetGenModel> facetModelsByName;
  private final boolean needsBatching;
  private final Map<Integer, Boolean> depFanoutMap;
  private final CodegenPhase codegenPhase;
  private @MonotonicNonNull ParsedVajramData parsedVajramData;
  private final VajramCodeGenUtility util;
  private final String vajramName;
  private final Types typeUtils;
  private final Elements elementUtils;

  public VajramCodeGenerator(VajramCodeGenContext creationContext) {
    this.currentVajramInfo = creationContext.vajramInfo();
    this.packageName = creationContext.vajramInfo().lite().packageName();
    this.util = creationContext.util();
    this.typeUtils = util.processingEnv().getTypeUtils();
    this.elementUtils = util.processingEnv().getElementUtils();
    // noinspection Convert2MethodRef
    this.facetModels =
        creationContext
            .vajramInfo()
            .facetStream()
            .collect(
                toMap(
                    FacetGenModel::id,
                    Function.identity(),
                    (o1, o2) -> o1,
                    () -> new LinkedHashMap<>()));
    // noinspection Convert2MethodRef
    this.facetModelsByName =
        creationContext
            .vajramInfo()
            .facetStream()
            .collect(
                toMap(
                    FacetGenModel::name,
                    Function.identity(),
                    (o1, o2) -> o1,
                    () -> new LinkedHashMap<>()));
    this.needsBatching =
        creationContext.vajramInfo().givenFacets().stream().anyMatch(DefaultFacetModel::isBatched);
    this.depFanoutMap =
        creationContext.vajramInfo().dependencies().stream()
            .collect(toMap(DependencyModel::id, DependencyModel::canFanout));
    this.codegenPhase = creationContext.codegenPhase();
    this.vajramName = currentVajramInfo.vajramName();
  }

  @Override
  public void generate() {
    validate();
    if (CodegenPhase.MODELS.equals(codegenPhase)) {
      vajramRequest();
      // Generate facets classes only for Vajrams and not for Traits
      if (currentVajramInfo.vajramClassElem().getAnnotation(Vajram.class) != null) {
        vajramFacets();
      }
    } else if (CodegenPhase.FINAL.equals(codegenPhase)) {
      vajramWrapper();
    }
  }

  private void validate() {
    // Validate that IfAbsent.Strategy values are only applied to facets with
    // compatible data types
    validateIfAbsentStrategyApplicability();

    // Validate that none of the SerialId annotations on facets clash with the ReservedSerialIds
    // annotation on the Vajram
    validateSerialIdReservations();
  }

  private void vajramRequest() {
    ClassName requestInterfaceType = currentVajramInfo.lite().requestInterfaceClassName();
    ClassName immutReqInterfaceType = currentVajramInfo.lite().reqImmutInterfaceType();
    TypeMirror responseType =
        currentVajramInfo.lite().responseType().javaModelType(util.processingEnv());
    TypeName responseTypeName = new TypeNameVisitor(true).visit(responseType);
    List<TypeVariableName> typeVariableNames = new ArrayList<>();
    if (responseTypeName instanceof TypeVariableName typeVariableName) {
      typeVariableNames = List.of(typeVariableName);
    }
    List<DefaultFacetModel> inputs =
        currentVajramInfo.givenFacets().stream()
            .filter(facetDef -> facetDef.facetType().equals(INPUT))
            .toList();

    TypeSpec.Builder requestInterface =
        util.codegenUtil()
            .interfaceBuilder(
                requestInterfaceType.simpleName(),
                typeVariableNames,
                currentVajramInfo.vajramClassElem().getQualifiedName().toString())
            .addModifiers(PUBLIC)
            .addAnnotation(
                currentVajramInfo.lite().isTrait()
                    ? TraitRequestRoot.class
                    : VajramRequestRoot.class)
            .addAnnotation(
                AnnotationSpec.builder(ModelRoot.class)
                    .addMember(
                        "type", CodeBlock.of("$T.$L", ModelType.class, ModelType.REQUEST.name()))
                    .addMember("suffixSeparator", CodeBlock.of("$S", ""))
                    .addMember("builderExtendsModelRoot", "true")
                    .build())
            .addAnnotations(
                currentVajramInfo.vajramClassElem().getAnnotationMirrors().stream()
                    .filter(
                        annotationMirror ->
                            MODEL_CLASS_ANNOTATIONS.contains(
                                ((QualifiedNameable)
                                        annotationMirror.getAnnotationType().asElement())
                                    .getQualifiedName()
                                    .toString()))
                    .map(AnnotationSpec::get)
                    .toList())
            .addSuperinterfaces(currentVajramInfo.requestInterfaceSuperTypes());

    // Add VAJRAM_ID constant to the request interface
    FieldSpec vajramIdField =
        FieldSpec.builder(VajramID.class, VAJRAM_ID_CONSTANT_NAME)
            .addModifiers(PUBLIC, STATIC, FINAL)
            .initializer("$T.vajramID($S)", VajramID.class, vajramName)
            .addJavadoc("The VajramID for this Vajram")
            .build();
    requestInterface.addField(vajramIdField);

    // Add _vajramID() method to the request interface
    requestInterface.addMethod(
        overriding(util.codegenUtil().getMethod(FacetValuesContainer.class, "_vajramID", 0))
            .addModifiers(DEFAULT)
            .addStatement("return " + VAJRAM_ID_CONSTANT_NAME)
            .build());

    facetConstants(requestInterface, inputs, CodeGenParams.builder().isRequest(true).build());
    modelsClassMembers(
        requestInterface,
        requestInterfaceType,
        inputs,
        CodeGenParams.builder().isRequest(true).isModelRoot(true).build());

    util.codegenUtil()
        .generateSourceFile(
            requestInterfaceType.canonicalName(),
            JavaFile.builder(
                    packageName,
                    requestInterface
                        .addMethods(
                            facetContainerMethods(
                                inputs,
                                requestInterfaceType,
                                immutReqInterfaceType,
                                typeVariableNames,
                                CodeGenParams.builder().isRequest(true).build()))
                        .build())
                .build()
                .toString(),
            currentVajramInfo.vajramClassElem());
  }

  public void vajramFacets() {
    basicFacetsClasses();
    boolean doInputsNeedBatching =
        currentVajramInfo.facetStream().anyMatch(FacetGenModel::isBatched);
    if (doInputsNeedBatching) {
      batchFacetsClasses();
    }
  }

  /**
   * Method to generate VajramImpl class Input dependencyDef code gen Resolve method code gen Vajram
   * logic code gen Compute vajramDef execute IO vajramDef executeBlocking
   */
  public void vajramWrapper() {
    initParsedVajramData();
    final TypeSpec.Builder vajramWrapperClass =
        util.codegenUtil()
            .classBuilder(
                getVajramImplClassName(vajramName),
                currentVajramInfo.vajramClassElem().getQualifiedName().toString())
            .addModifiers(PUBLIC, FINAL);
    List<MethodSpec> methodSpecs = new ArrayList<>();
    // Add superType
    if (currentVajramInfo.lite().isTrait()) {
      vajramWrapperClass.addSuperinterface(ClassName.get(currentVajramInfo.vajramClassElem()));
    } else {
      vajramWrapperClass.superclass(ClassName.get(currentVajramInfo.vajramClassElem()));
    }
    wrapperConstructor(vajramWrapperClass);

    ClassName requestInterfaceType = getRequestInterfaceType();
    ClassName immutRequestType = ClassName.get(packageName, getImmutRequestPojoName(vajramName));
    ClassName immutFacetsType = ClassName.get(packageName, getImmutFacetsClassName(vajramName));

    if (currentVajramInfo.lite().isVajram()) {

      // Initialize few common attributes and data structures
      MethodSpec inputResolversMethod = createInputResolvers();
      if (inputResolversMethod != null) {
        methodSpecs.add(inputResolversMethod);
      }

      TypeMirror from = getParsedVajramData().vajramInfo().vajramClassElem().asType();
      if (util.codegenUtil().isRawAssignable(from, IOVajramDef.class)) {
        methodSpecs.add(ioVajramExecuteMethod());
      } else {
        methodSpecs.add(computeVajramExecuteMethod());
      }

      vajramWrapperClass.addMethod(
          methodBuilder("facetsFromRequest")
              .returns(immutFacetsType.nestedClass("Builder"))
              .addModifiers(PUBLIC)
              .addParameter(
                  ParameterizedTypeName.get(
                      ClassName.get(Request.class), WildcardTypeName.subtypeOf(Object.class)),
                  "request")
              .addStatement(
                  "return new $T(($T)$L)",
                  immutFacetsType.nestedClass("Builder"),
                  currentVajramInfo.conformsToTraitOrSelf().requestInterfaceClassName(),
                  "request")
              .build());
      vajramWrapperClass.addMethod(executeGraph());
    }

    StringWriter writer = new StringWriter();
    try {
      JavaFile.builder(
              packageName,
              vajramWrapperClass
                  .addMethods(methodSpecs)
                  .addMethod(
                      overriding(
                              util.codegenUtil()
                                  .getMethod(VajramDefRoot.class, "newRequestBuilder", 0))
                          .returns(immutRequestType.nestedClass("Builder"))
                          .addModifiers(PUBLIC)
                          .addStatement("return $T._builder()", immutRequestType)
                          .build())
                  .addMethod(
                      overriding(
                              util.codegenUtil()
                                  .getMethod(VajramDefRoot.class, "requestRootType", 0))
                          .returns(
                              ParameterizedTypeName.get(
                                  ClassName.get(Class.class), requestInterfaceType))
                          .addModifiers(PUBLIC)
                          .addStatement("return $T.class", requestInterfaceType)
                          .build())
                  .build())
          .build()
          .writeTo(writer);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
    String className =
        currentVajramInfo.lite().packageName()
            + '.'
            + getVajramImplClassName(currentVajramInfo.lite().vajramId().id());

    try {
      util.codegenUtil()
          .generateSourceFile(className, writer.toString(), currentVajramInfo.vajramClassElem());
    } catch (Exception e) {
      StringWriter exception = new StringWriter();
      e.printStackTrace(new PrintWriter(exception));
      util.codegenUtil()
          .error(
              "Error while generating file for class %s. Exception: %s"
                  .formatted(className, exception),
              currentVajramInfo.vajramClassElem());
    }
  }

  private void wrapperConstructor(TypeSpec.Builder wrapperClassBuilder) {
    CodeBlock.Builder constructorBody = CodeBlock.builder();
    if (currentVajramInfo.lite().isVajram()) {
      boolean simpleInputResolversMethodPresent =
          currentVajramInfo.vajramClassElem().getEnclosedElements().stream()
              .filter(e -> e instanceof ExecutableElement)
              .anyMatch(e -> e.getSimpleName().contentEquals(GET_SIMPLE_INPUT_RESOLVERS));

      wrapperClassBuilder.addField(
          ParameterizedTypeName.get(ImmutableCollection.class, InputResolver.class),
          "_inputResolvers",
          PRIVATE);

      for (DependencyModel dependency : currentVajramInfo.dependencies()) {
        String fieldName = prependUnderscore(dependency.name() + "_reqBuilderSupplier");
        ParameterizedTypeName fieldType =
            ParameterizedTypeName.get(
                ClassName.get(Supplier.class),
                dependency.depVajramInfo().reqImmutInterfaceType().nestedClass("Builder"));
        wrapperClassBuilder.addField(fieldType, fieldName, FINAL);
        constructorBody.addStatement(
            """
        this.$L = ($T)
           _vajramInitData
            .vajramRequestBuilderSuppliers()
            .getOrDefault($T.$L.onVajramID(), () -> $T._builder())
        """,
            fieldName,
            fieldType,
            currentVajramInfo.facetsInterfaceType(),
            dependency.name() + FACET_SPEC_SUFFIX,
            dependency.depVajramInfo().reqImmutPojoType());
      }
      List<CodeBlock> cases = new ArrayList<>();
      for (DependencyModel dependency : currentVajramInfo.dependencies()) {
        if (dependency.canFanout()) {
          wrapperClassBuilder.addField(
              FanoutInputResolver.class,
              prependUnderscore(dependency.name() + "_fanoutInputResolver"));
        }
        ParameterizedTypeName depFacetsType =
            ParameterizedTypeName.get(List.class, One2OneInputResolver.class);
        String fieldName = prependUnderscore(dependency.name() + "_one2oneInputResolvers");
        wrapperClassBuilder.addField(depFacetsType, fieldName, FINAL);
        constructorBody.addStatement("$T $L = new $T()", depFacetsType, fieldName, ArrayList.class);
      }
      if (simpleInputResolversMethodPresent) {
        for (DependencyModel dependency : currentVajramInfo.dependencies()) {
          ParameterizedTypeName depFacetsType = ParameterizedTypeName.get(Set.class, Facet.class);
          String depFacetsName = prependUnderscore(dependency.name() + "_depFacets");
          wrapperClassBuilder.addField(depFacetsType, depFacetsName, FINAL);
          constructorBody.addStatement("this.$L = new $T<>()", depFacetsName, HashSet.class);
        }
      }

      for (DependencyModel dependency : currentVajramInfo.dependencies()) {
        cases.add(
            CodeBlock.of(
"""
                case $S -> {
                  if (_resolver instanceof $T _fanoutResolver) {
$L
                  } else if (_resolver instanceof $T _oneToOneResolver) {
                    _$L_one2oneInputResolvers.add(_oneToOneResolver);
                  }
$L
                }
""",
                dependency.name(),
                FanoutInputResolver.class,
                dependency.canFanout()
                    ? CodeBlock.of("_$L_fanoutInputResolver = _fanoutResolver;", dependency.name())
                    : CodeBlock.of(
"""
                    throw new $T(
                        \"""
                        $S vajram's dependency '$L' is not marked as canFanout=true,
                        but still has a simple fanout resolver defined.
                        Either mark the @Dependency as canFanout = true or remove the fanout resolver.
                        \""");
""",
                        VajramDefinitionException.class,
                        currentVajramInfo.lite().vajramId().id(),
                        dependency.name()),
                One2OneInputResolver.class,
                dependency.name(),
                simpleInputResolversMethodPresent
                    ? CodeBlock.of(
"""
                  if(_resolver instanceof $T _simpleResolver){
                    _$L_depFacets.addAll(_simpleResolver.getResolverSpec().sources());
                  }
""",
                        SimpleInputResolver.class,
                        dependency.name())
                    : EMPTY_CODE_BLOCK));
      }
      constructorBody.add(
          """
            for(InputResolver _resolver : getInputResolvers()) {
              switch (_resolver.definition().target().dependency().name()) {
          $L
              }
            }
          """,
          cases.stream().collect(CodeBlock.joining("")));
    }

    for (DependencyModel dependency : currentVajramInfo.dependencies()) {
      String fieldName = prependUnderscore(dependency.name() + "_one2oneInputResolvers");
      constructorBody.addStatement("this.$L = $L", fieldName, fieldName);
    }

    wrapperClassBuilder.addMethod(
        constructorBuilder()
            .addModifiers(PUBLIC)
            .addParameter(VajramInitData.class, "_vajramInitData")
            .addCode(constructorBody.build())
            .build());
  }

  private String prependUnderscore(String string) {
    return "_" + string;
  }

  private MethodSpec executeGraph() {
    MethodSpec.Builder executeGraph =
        overriding(
            util.codegenUtil()
                .getMethod(
                    () -> VajramDef.class.getMethod("executeGraph", GraphExecutionData.class)));
    boolean simpleInputResolversMethodPresent =
        currentVajramInfo.vajramClassElem().getEnclosedElements().stream()
            .filter(e -> e instanceof ExecutableElement)
            .anyMatch(e -> e.getSimpleName().contentEquals(GET_SIMPLE_INPUT_RESOLVERS));

    CodeBlock.Builder executionCode = CodeBlock.builder();

    Map<String, List<ExecutableElement>> resolverMethodsByDependency =
        getResolverMethodsByDependency();

    for (DependencyModel dependency : currentVajramInfo.dependencies()) {
      Map<String, Object> commonNamesMap =
          Map.ofEntries(
              entry("list", List.class),
              entry("facetName", dependency.name()),
              entry("facetSpec", dependency.name() + FACET_SPEC_SUFFIX),
              entry("req", dependency.depVajramInfo().requestInterfaceClassName()),
              entry("depReqIface", dependency.depVajramInfo().requestInterfaceClassName()),
              entry("reqImmutType", dependency.depVajramInfo().reqImmutInterfaceType()),
              entry("facImmutPojo", currentVajramInfo.facetsImmutPojoType()),
              entry(
                  "depType",
                  util.codegenUtil()
                      .box(
                          dependency
                              .depVajramInfo()
                              .responseType()
                              .javaModelType(util.processingEnv()))),
              entry("fac", currentVajramInfo.facetsInterfaceType()),
              entry("one2OneInputResolver", One2OneInputResolver.class),
              entry(
                  "reqBuilder",
                  dependency.depVajramInfo().reqImmutInterfaceType().nestedClass("Builder")),
              entry(
                  "respType",
                  util.codegenUtil()
                      .box(
                          dependency
                              .depVajramInfo()
                              .responseType()
                              .javaModelType(util.processingEnv()))),
              entry("completableFuture", CompletableFuture.class),
              entry("arrayList", ArrayList.class),
              entry("fanoutDepResponses", FanoutDepResponses.class),
              entry("requestResponse", RequestResponse.class),
              entry("errable", Errable.class),
              entry("executionItem", ExecutionItem.class),
              entry("reqRespFuture", RequestResponseFuture.class));

      List<ExecutableElement> resolverMethods =
          resolverMethodsByDependency.getOrDefault(dependency.name(), List.of());

      Set<FacetGenModel> usedFacetsInResolverMethods =
          resolverMethods.stream()
              .flatMap(r -> r.getParameters().stream().map(this::inferFacet))
              .filter(f -> !f.isGiven())
              .collect(toSet());

      executionCode.addNamed(
          """
          {
            $completableFuture:T.allOf(
                    $allUsedFutures:L)
                .whenComplete(
                  (_unused, _throwable) -> {
                    $list:T<$reqRespFuture:T<$reqImmutType:T.Builder, $depType:T>> _$facetName:L_reqs = new $arrayList:T<>();
                    $list:T<$executionItem:T> _executionItems = _graphExecData.executionItems();
                    var _$facetName:L_futures = new $completableFuture:T[_executionItems.size()];
                    for (int i = 0; i < _executionItems.size(); i++) {
                      var _executionItem = _executionItems.get(i);
                      $facImmutPojo:T.Builder _facetValues =
                          ($facImmutPojo:T.Builder) _executionItem.facetValues()._asBuilder();
                      var _$facetName:L_requestBuilder = _$facetName:L_reqBuilderSupplier.get();
                      $list:T<$reqImmutType:T.Builder> _$facetName:L_reqBuilders = $list:T.of(_$facetName:L_requestBuilder);
  $executeFanoutResolver:L
                      for ($one2OneInputResolver:T _$facetName:L_inputResolver :
                          _$facetName:L_one2oneInputResolvers) {
                        _$facetName:L_reqBuilders =
                            ($list:T<$reqImmutType:T.Builder>)
                                _$facetName:L_inputResolver
                                    .resolve(_$facetName:L_reqBuilders, _facetValues)
                                    .getRequests();
                      }
                      $reassignReqBuilder:L
                      $setupFutures:L
                    }
                    $completableFuture:T.allOf(_$facetName:L_futures)
                        .whenComplete((_unused2, _throwable2) -> _$facetName:L_ready.complete(null));
                    _graphExecData
                        .communicationFacade()
                        .triggerDependency($fac:T.$facetSpec:L, _$facetName:L_reqs);
                  });
          }
  """,
          merge(
              commonNamesMap,
              Map.ofEntries(
                  entry(
                      "allUsedFutures",
                      stream(
                              new @NonNull CodeBlock[] {
                                usedFacetsInResolverMethods.stream()
                                    .map(f -> CodeBlock.of("_$L_ready", f.name()))
                                    .collect(CodeBlock.joining(", ")),
                                simpleInputResolversMethodPresent
                                    ? CodeBlock.of(
                                        """
                                $T.allOf(
                                    $T.filterKeys(_futuresByFacet, _$L_depFacets::contains)
                                      .values()
                                      .toArray($T[]::new)
                                )
                                """,
                                        CompletableFuture.class,
                                        Maps.class,
                                        dependency.name(),
                                        CompletableFuture.class)
                                    : EMPTY_CODE_BLOCK
                              })
                          .filter(Objects::nonNull)
                          .filter(c -> !c.isEmpty())
                          .collect(CodeBlock.joining(", "))),
                  entry(
                      "reassignReqBuilder",
                      dependency.canFanout()
                          ? CodeBlock.of(
                              "$T<$T> _$L_requestBuilders = _$L_reqBuilders;",
                              List.class,
                              dependency
                                  .depVajramInfo()
                                  .reqImmutInterfaceType()
                                  .nestedClass("Builder"),
                              dependency.name(),
                              dependency.name())
                          : EMPTY_CODE_BLOCK),
                  entry(
                      "executeFanoutResolver",
                      dependency.canFanout()
                          ? CodeBlock.builder()
                              .addNamed(
"""
                      if(_$facetName:L_fanoutInputResolver != null){
                          _$facetName:L_reqBuilders = ($list:T<$reqImmutType:T.Builder>) _$facetName:L_fanoutInputResolver
                              .resolve(_$facetName:L_reqBuilderSupplier.get(), _facetValues)
                              .getRequests();
                      }
""",
                                  Map.ofEntries(
                                      entry("facetName", dependency.name()),
                                      entry("list", List.class),
                                      entry(
                                          "reqImmutType",
                                          dependency.depVajramInfo().reqImmutInterfaceType())))
                              .build()
                          : EMPTY_CODE_BLOCK),
                  entry(
                      "setupFutures",
                      dependency.canFanout()
                          ? CodeBlock.builder()
                              .addNamed(
"""
$list:T<$reqRespFuture:T<$reqBuilder:T, $respType:T>> _$facetName:L_reqRespFutures =
    $reqRespFuture:T.forRequests(_$facetName:L_reqBuilders);
_$facetName:L_reqs.addAll(_$facetName:L_reqRespFutures);
_$facetName:L_futures[i] = $completableFuture:T.allOf($reqRespFuture:T.getFutures(_$facetName:L_reqRespFutures))
    .whenComplete(
        (_unused2, _throwable2) -> {
          $fanoutDepResponses:T<$req:T, $respType:T> _fanoutResponses;
          if (_throwable != null) {
            $list:T<$requestResponse:T<$depReqIface:T, $depType:T>> _erroredRequests = new $arrayList:T<>();
            for ($depReqIface:T _$facetName:L_request : _$facetName:L_requestBuilders) {
              _erroredRequests.add(
                  new $requestResponse:T<>(_$facetName:L_request, $errable:T.withError(_throwable)));
            }
            _fanoutResponses = new $fanoutDepResponses:T<>(_erroredRequests);
          } else {
            $list:T<$requestResponse:T<$req:T, $respType:T>>
                _requestResponsePairs =
                    new $arrayList:T<>(_$facetName:L_reqRespFutures.size());
            for ($reqRespFuture:T<$reqBuilder:T, $respType:T>
                _$facetName:L_reqRespFuture : _$facetName:L_reqRespFutures) {
              _requestResponsePairs.add(
                  new $requestResponse:T<>(
                      _$facetName:L_reqRespFuture.request(),
                      _$facetName:L_reqRespFuture
                          .response()
                          .handle($errable:T::errableFrom)
                          .getNow($errable:T.nil())));
            }
            _fanoutResponses = new $fanoutDepResponses:T<>(_requestResponsePairs);
          }
          _facetValues.$facetName:L(_fanoutResponses);
        });
""",
                                  commonNamesMap)
                              .build()
                          : CodeBlock.builder()
                              .addNamed(
"""

if (_$facetName:L_reqBuilders.isEmpty()) {
  _$facetName:L_futures[i] = $completableFuture:T.completedFuture(null);
} else {
  var _$facetName:L_future = new $completableFuture:T<$depType:T>();
  _$facetName:L_futures[i] =
      _$facetName:L_future.whenComplete(
          (_unused2, _throwable2) -> {
            var _errable = $errable:T.errableFrom(_unused2, _throwable2);
            _facetValues.$facetName:L(new $requestResponse:T<>(_$facetName:L_requestBuilder, _errable));
          });
  _$facetName:L_reqs.add(new $reqRespFuture:T<>(_$facetName:L_requestBuilder, _$facetName:L_future));
}
""",
                                  commonNamesMap)
                              .build()))));
    }
    OutputLogics outputLogics = requireNonNull(getParsedVajramData().logicMethods()).outputLogics();
    List<VariableElement> outputLogicParams = new ArrayList<>();
    if (outputLogics instanceof OutputLogics.WithBatching batchingOutputLogics) {
      outputLogicParams.addAll(batchingOutputLogics.batchedOutput().getParameters());
      outputLogicParams.addAll(batchingOutputLogics.unbatchOutput().getParameters());
    } else if (outputLogics instanceof OutputLogics.NoBatching noBatchingOutputLogics) {
      outputLogicParams.addAll(noBatchingOutputLogics.output().getParameters());
    }
    Set<FacetGenModel> computedOutputLogicSources =
        outputLogicParams.stream()
            .filter(p -> !p.getSimpleName().toString().startsWith("_"))
            .map(this::inferFacet)
            .filter(f -> !f.isGiven())
            .collect(toSet());

    CodeBlock executeOutputLogic =
        CodeBlock.of(
            """
            _graphExecData.communicationFacade().executeOutputLogic();
            """);
    if (computedOutputLogicSources.isEmpty()) {
      executionCode.add(executeOutputLogic);
    } else {
      executionCode.add(
"""
    $L
        .whenComplete(
            (_unused, _throwable) -> {
              $L
            });
""",
          switch (computedOutputLogicSources.size()) {
            case 1 ->
                CodeBlock.of("_$L_ready", computedOutputLogicSources.iterator().next().name());
            default ->
                CodeBlock.of(
                    "$T.allOf($L)",
                    CompletableFuture.class,
                    computedOutputLogicSources.stream()
                        .map(f -> CodeBlock.of("_$L_ready", f.name()))
                        .collect(CodeBlock.joining(", ")));
          },
          executeOutputLogic);
    }
    executeGraph.addCode(
        "$T<$T, $T<$T>> _futuresByFacet = new $T<>();",
        Map.class,
        Facet.class,
        CompletableFuture.class,
        Void.class,
        HashMap.class);
    for (DependencyModel dependency : currentVajramInfo.dependencies()) {
      executeGraph.addCode(
          "var _$L_ready = new $T<$T>();", dependency.name(), CompletableFuture.class, Void.class);
      executeGraph.addCode(
          "_futuresByFacet.put($T.$L_s, _$L_ready);",
          currentVajramInfo.facetsInterfaceType(),
          dependency.name(),
          dependency.name());
      executeGraph.addCode("\n");
    }
    executeGraph.addCode(executionCode.build());
    return executeGraph.build();
  }

  private static Map<String, Object> merge(
      Map<String, Object> commonNamesMap, Map<String, Object> customNamesMap) {
    Map<String, Object> map = new HashMap<>(commonNamesMap);
    map.putAll(customNamesMap);
    return map;
  }

  private FacetGenModel inferFacet(VariableElement parameter) {
    String facetName = parameter.getSimpleName().toString();
    FacetGenModel facetGenModel = facetModelsByName.get(facetName);
    if (facetGenModel == null) {
      throw util.codegenUtil()
          .errorAndThrow("Unknown facet with name %s".formatted(facetName), parameter);
    }
    return facetGenModel;
  }

  private @Nullable MethodSpec createInputResolvers() {
    Map<String, List<ExecutableElement>> resolverMap = getResolverMethodsByDependency();
    if (resolverMap.isEmpty()) {
      return null;
    }

    MethodSpec.Builder getInputResolversMethod =
        overriding(util.codegenUtil().getMethod(VajramDef.class, GET_INPUT_RESOLVERS, 0));

    CodeBlock.Builder resolveMethodToObjConvCode = CodeBlock.builder();
    getInputResolversMethod.addCode("if(_inputResolvers != null) { return _inputResolvers; }");
    getInputResolversMethod.addCode(
        "return _inputResolvers = $T.<$T>builder().addAll($L())",
        ImmutableList.class,
        InputResolver.class,
        GET_SIMPLE_INPUT_RESOLVERS);

    resolverMap.forEach(
        (depName, resolverMethods) -> {
          @SuppressWarnings("method.invocation")
          DependencyModel dep =
              currentVajramInfo.dependencies().stream()
                  .filter(d -> d.name().equals(depName))
                  .findAny()
                  .orElseThrow();

          for (ExecutableElement resolverMethod : resolverMethods) {
            Resolve resolve = resolverMethod.getAnnotation(Resolve.class);
            if (resolve == null) {
              throw new AssertionError("Cannot happen");
            }
            TypeMirror from = resolverMethod.getReturnType();
            boolean fanoutResolver = util.codegenUtil().isRawAssignable(from, FanoutCommand.class);

            List<String> resolvedInputNames =
                stream(resolve.depInputs())
                    .map(
                        di ->
                            util.extractFacetName(
                                dep.depVajramInfo().vajramId().id(), di, resolverMethod))
                    .toList();

            Class<?> inputResolverInterfaceClass;
            if (fanoutResolver) {
              inputResolverInterfaceClass = FanoutInputResolver.class;
            } else {
              inputResolverInterfaceClass = One2OneInputResolver.class;
            }
            MethodSpec.Builder resolveMethod =
                overriding(
                        util.codegenUtil().getMethod(inputResolverInterfaceClass, "resolve", 2),
                        (DeclaredType)
                            checkNotNull(
                                    elementUtils.getTypeElement(
                                        checkNotNull(
                                            inputResolverInterfaceClass.getCanonicalName())))
                                .asType(),
                        typeUtils)
                    .addCode(buildInputResolver(resolverMethod, fanoutResolver).build());
            List<FacetGenModel> usedFacets =
                resolverMethod.getParameters().stream().map(this::inferFacet).toList();
            resolveMethodToObjConvCode.add(
                ".add($L)",
                anonymousClassBuilder(
                        "$T.of($L), new $T($T.$L, $T.of($L))",
                        ImmutableSet.class,
                        CodeBlock.of(
                            usedFacets.stream().map(_f -> "$T.$L").collect(Collectors.joining(",")),
                            usedFacets.stream()
                                .flatMap(
                                    facet ->
                                        Stream.of(
                                            currentVajramInfo.facetsInterfaceType(),
                                            facet.name() + FACET_SPEC_SUFFIX))
                                .toArray()),
                        ResolutionTarget.class,
                        currentVajramInfo.facetsInterfaceType(),
                        dep.name() + FACET_SPEC_SUFFIX,
                        ImmutableSet.class,
                        CodeBlock.of(
                            resolvedInputNames.stream()
                                .map(_f -> "$T.$L")
                                .collect(Collectors.joining(",")),
                            resolvedInputNames.stream()
                                .flatMap(
                                    inputName ->
                                        Stream.of(
                                            ClassName.get(
                                                dep.depReqPackageName(),
                                                getRequestInterfaceName(
                                                    dep.depVajramInfo().vajramId().id())),
                                            inputName + FACET_SPEC_SUFFIX))
                                .toArray()))
                    .addSuperinterface(
                        fanoutResolver
                            ? AbstractFanoutInputResolver.class
                            : AbstractOne2OneInputResolver.class)
                    .addMethod(resolveMethod.build())
                    .build());
          }
        });
    resolveMethodToObjConvCode.add(".build()");

    return getInputResolversMethod.addStatement(resolveMethodToObjConvCode.build()).build();
  }

  private Map<String, List<ExecutableElement>> getResolverMethodsByDependency() {
    LogicMethods logicMethods = getParsedVajramData().logicMethods();
    List<ExecutableElement> resolvers = logicMethods != null ? logicMethods.resolvers() : List.of();

    Map<String, List<ExecutableElement>> resolverMap = new HashMap<>();

    for (ExecutableElement resolver : resolvers) {
      resolverMap
          .computeIfAbsent(
              util.extractFacetName(
                  vajramName,
                  requireNonNull(resolver.getAnnotation(Resolve.class)).dep(),
                  resolver),
              _k -> new ArrayList<>())
          .add(resolver);
    }
    return resolverMap;
  }

  private ParsedVajramData initParsedVajramData() {
    if (parsedVajramData == null) {
      this.parsedVajramData =
          fromVajramInfo(currentVajramInfo, util)
              .orElseThrow(
                  () ->
                      util.codegenUtil()
                          .errorAndThrow(
                              """
                                        Could not load Vajram class for vajramDef %s.
                                        ParsedVajram Data should never be accessed in model generation phase."""
                                  .formatted(currentVajramInfo.lite().vajramId()),
                              currentVajramInfo.vajramClassElem()));
    }
    return parsedVajramData;
  }

  private ParsedVajramData getParsedVajramData() {
    if (codegenPhase != CodegenPhase.FINAL) {
      throw new IllegalStateException(
          "getParsedVajramData can only be invoked in the FINAL phase. This is a bug in "
              + this.getClass());
    }
    // This should not happen since this method is only ever called after
    // initParsedVajramData is called. But we still implement the best effort
    // fallback
    return parsedVajramData != null ? parsedVajramData : initParsedVajramData();
  }

  /**
   * Method to generate "executeCompute" function code for ComputeVajrams Supported DataAccessSpec
   * => VajramID only.
   *
   * @return generated code for "execute" {@link MethodSpec}
   */
  private MethodSpec computeVajramExecuteMethod() {

    MethodSpec.Builder executeBuilder =
        overriding(
            util.codegenUtil()
                .getMethod(
                    () -> VajramDef.class.getMethod("execute", OutputLogicExecutionInput.class)));
    if (needsBatching) {
      util.codegenUtil()
          .error(
              "Batching is not supported in ComputeVajrams",
              getParsedVajramData().vajramInfo().givenFacets().stream()
                  .filter(DefaultFacetModel::isBatched)
                  .findAny()
                  .<Element>map(DefaultFacetModel::facetField)
                  .orElse(getParsedVajramData().vajramInfo().vajramClassElem()));
    } else { // TODO : Need non batched IO vajramDef to test this
      nonBatchedExecuteMethodBuilder(executeBuilder, false);
    }
    return executeBuilder.build();
  }

  private void nonBatchedExecuteMethodBuilder(
      MethodSpec.Builder executeBuilder, boolean isIOVajram) {
    if (!(requireNonNull(getParsedVajramData().logicMethods(), "Vajrams must have output logic.")
            .outputLogics()
        instanceof NoBatching noBatchingOutputLogic)) {
      util.codegenUtil()
          .error(
              "Cannot generate execute method if @Output logic is missing",
              getParsedVajramData().vajramInfo().vajramClassElem());
      return;
    }
    ExecutableElement outputLogic = noBatchingOutputLogic.output();
    CodeBlock outputLogicParams =
        outputLogic.getParameters().stream()
            .map(this::generateLogicParams)
            .collect(CodeBlock.joining(","));

    CodeBlock.Builder returnBuilder = CodeBlock.builder();

    TypeMirror returnType = outputLogic.getReturnType();
    if (isIOVajram) {
      if (!util.codegenUtil().isRawAssignable(returnType, CompletableFuture.class)) {
        // TODO: Validate IOVajram response type is CompletableFuture<Type>"
        util.codegenUtil()
            .error(
                "The OutputLogic of the non-batched IO vajram %s must return a CompletableFuture"
                    .formatted(vajramName),
                outputLogic);
      }
      returnBuilder.add(
          "\n$T.linkFutures($L($L), _executionItem.response(), _logicInput.graphExecutor());\n",
          Futures.class,
          outputLogic.getSimpleName(),
          outputLogicParams);
    } else {
      TypeMirror expectedReturnType =
          currentVajramInfo.lite().responseType().javaModelType(util.processingEnv());
      if (!util.processingEnv()
          .getTypeUtils()
          .isSameType(
              util.codegenUtil().box(returnType), util.codegenUtil().box(expectedReturnType))) {
        util.codegenUtil()
            .error(
                "The OutputLogic of the Compute vajram %s must return %s"
                    .formatted(vajramName, expectedReturnType),
                outputLogic);
      }
      returnBuilder.add(
          "\n$T.linkFutures($T.errableFrom(() -> $L($L)).toFuture(), _executionItem.response());\n",
          Futures.class,
          Errable.class,
          outputLogic.getSimpleName(),
          outputLogicParams);
    }
    CodeBlock facetLocalVars =
        outputLogic.getParameters().stream()
            .map(
                variableElement ->
                    facetLocalVariable(outputLogic, variableElement, FACET_VALUES_VAR))
            .collect(CodeBlock.joining("\n"));
    executeBuilder.addCode(
        """
        for ($T _executionItem : _logicInput.facetValueResponses()) {
          $T $L = ($T)_executionItem.facetValues();
          $L
          $L
        }
        """,
        ExecutionItem.class,
        currentVajramInfo.facetsInterfaceType(),
        FACET_VALUES_VAR,
        currentVajramInfo.facetsInterfaceType(),
        facetLocalVars,
        returnBuilder.build());
  }

  private CodeBlock generateLogicParams(VariableElement param) {
    FacetGenModel facetGenModel = inferFacet(param);
    if (facetGenModel.isBatched()) {
      util.codegenUtil()
          .error(
              "Cannot use batch facet '%s' as direct input param for output logic"
                  .formatted(facetGenModel.id()),
              param);
    }
    return CodeBlock.of("$L", facetGenModel.name());
  }

  /**
   * Method to generate "execute" function code for IOVajrams
   *
   * @return generated code for "execute" {@link MethodSpec}
   */
  private MethodSpec ioVajramExecuteMethod() {

    MethodSpec.Builder executeMethodBuilder =
        overriding(
            util.codegenUtil()
                .getMethod(
                    () -> VajramDef.class.getMethod("execute", OutputLogicExecutionInput.class)));

    if (needsBatching) {
      batchedExecuteMethodBuilder(executeMethodBuilder);
    } else {
      nonBatchedExecuteMethodBuilder(executeMethodBuilder, true);
    }
    return executeMethodBuilder.build();
  }

  private void batchedExecuteMethodBuilder(MethodSpec.Builder executeMethodBuilder) {
    if (!(requireNonNull(getParsedVajramData().logicMethods(), "Vajrams must have output logic.")
            .outputLogics()
        instanceof OutputLogics.WithBatching withBatchingOutputLogic)) {
      util.codegenUtil()
          .error(
              "Cannot generate execute method if either of @Output.Batched or @Output.Unbatch is missing",
              getParsedVajramData().vajramInfo().vajramClassElem());
      return;
    }
    CodeBlock.Builder codeBuilder = CodeBlock.builder();

    ImmutableMap<String, FacetGenModel> facets =
        currentVajramInfo
            .facetStream()
            .collect(toImmutableMap(FacetGenModel::name, Function.identity()));

    TypeMirror batchedOutputReturnType = withBatchingOutputLogic.batchedOutput().getReturnType();
    if (!util.codegenUtil().isRawAssignable(batchedOutputReturnType, CompletableFuture.class)) {
      throw util.codegenUtil()
          .errorAndThrow(
              "The OutputLogic of batched IO vajramDef %s must return a CompletableFuture"
                  .formatted(vajramName),
              withBatchingOutputLogic.batchedOutput());
    }
    TypeMirror batchedOutputActualType = getTypeParameters(batchedOutputReturnType).get(0);

    TypeMirror unbatchOutputReturnType = withBatchingOutputLogic.unbatchOutput().getReturnType();
    TypeMirror type =
        getParsedVajramData()
            .vajramInfo()
            .lite()
            .responseType()
            .javaModelType(util.processingEnv());
    TypeMirror vajramResponseType = util.codegenUtil().box(type);
    TypeName vajramResponseTypeName =
        TypeName.get(vajramResponseType).annotated(AnnotationSpec.builder(Nullable.class).build());

    TypeMirror unbatchOutputExpectedType =
        typeUtils.getDeclaredType(
            requireNonNull(
                elementUtils.getTypeElement(requireNonNull(Map.class.getCanonicalName()))),
            requireNonNull(elementUtils.getTypeElement(getBatchItemIfaceName().canonicalName()))
                .asType(),
            typeUtils.getDeclaredType(
                requireNonNull(
                    elementUtils.getTypeElement(requireNonNull(Errable.class.getCanonicalName()))),
                vajramResponseType));
    if (!typeUtils.isAssignable(unbatchOutputReturnType, unbatchOutputExpectedType)) {
      util.codegenUtil()
          .error(
              """
                @Output.Unbatch return type is not as expected. Expected:
                %s.
                Found:
                %s"""
                  .formatted(unbatchOutputExpectedType, unbatchOutputReturnType),
              withBatchingOutputLogic.unbatchOutput());
    }

    Map<String, Object> valueMap = new HashMap<>();
    valueMap.put("facetValues", FacetValues.class);
    valueMap.put("executionItem", ExecutionItem.class);
    valueMap.put("immutableFacetValues", ImmutableFacetValues.class);
    valueMap.put("stackTracelessException", StackTracelessException.class);
    valueMap.put("batchItemExecItem", BatchItemExecutionItem.class);

    valueMap.put("batchKeyName", BATCH_KEY_NAME);
    valueMap.put("facetValuesList", FACETS_LIST);
    valueMap.put("logicInput", OUTPUT_LOGIC_INPUT_VAR);
    valueMap.put("facetsVar", FACET_VALUES_VAR);
    valueMap.put("facetsInterface", currentVajramInfo.facetsInterfaceType());
    valueMap.put("inputBatching", getBatchItemIfaceName());
    valueMap.put("commonInput", getCommonFacetsClassName());
    valueMap.put("vajramResponseType", vajramResponseTypeName);
    valueMap.put("futuresUtil", Futures.class);
    valueMap.put("batchedOutputLogic", withBatchingOutputLogic.batchedOutput().getSimpleName());
    valueMap.put("unbatchOutputLogic", withBatchingOutputLogic.unbatchOutput().getSimpleName());
    valueMap.put("unbatchOutputExpectedType", unbatchOutputExpectedType);
    valueMap.put("modInput", BatchedFacets.class);
    valueMap.put("imMap", ImmutableMap.class);
    valueMap.put("imList", ImmutableList.class);
    valueMap.put("comFuture", CompletableFuture.class);
    valueMap.put("linkHashMap", LinkedHashMap.class);
    valueMap.put("map", Map.class);
    valueMap.put("list", List.class);
    valueMap.put("arrayList", ArrayList.class);
    valueMap.put("valErr", Errable.class);
    valueMap.put("optional", Optional.class);

    codeBuilder.addNamed(
        """
            var _executionItems = $logicInput:L.facetValueResponses();
            if(_executionItems.isEmpty()) {
              return;
            }
            $commonInput:T $batchKeyName:L = (($facetsInterface:T)_executionItems.get(0).facetValues())._batchKey();
            $list:T<$inputBatching:T> _batchItems = new $arrayList:T<>();
            $list:T<$batchItemExecItem:T> _batchItemExecItems = new $arrayList:T<>();
            for ($executionItem:T _executionItem : _executionItems) {
              $facetsInterface:T _castFacets = ($facetsInterface:T) _executionItem.facetValues();
              $inputBatching:T _batchItem = _castFacets._batchItem();
              _batchItems.add(_batchItem);
              _batchItemExecItems.add(new $batchItemExecItem:T(_batchItem, _executionItem));
            }
        """,
        valueMap);
    Map<String, VariableElement> batchedOutputLogicParams =
        withBatchingOutputLogic.batchedOutput().getParameters().stream()
            .collect(toMap(v -> v.getSimpleName().toString(), v -> v));
    Map<String, VariableElement> unbatchOutputLogicParams =
        withBatchingOutputLogic.unbatchOutput().getParameters().stream()
            .collect(toMap(v -> v.getSimpleName().toString(), v -> v));
    for (String paramName :
        Sets.union(batchedOutputLogicParams.keySet(), unbatchOutputLogicParams.keySet())) {
      VariableElement p1 = batchedOutputLogicParams.get(paramName);
      VariableElement p2 = unbatchOutputLogicParams.get(paramName);
      List<VariableElement> list = new ArrayList<>();
      if (p1 != null && p2 != null && !typeUtils.isSameType(p1.asType(), p2.asType())) {
        util.codegenUtil()
            .error(
                "The same parameter cannot be accessed via different types in @Output.Batched and @Output.Unbatch methods.",
                p1,
                p2);
      }

      if (p1 != null) {
        list.add(p1);
      }
      if (p2 != null) {
        list.add(p2);
      }
      LogicParam logicParam = new LogicParam(list);
      validateParamsAndCreateParamCode(
          codeBuilder, withBatchingOutputLogic, logicParam, batchedOutputActualType, facets);
    }

    {
      List<CodeBlock> batchedOutputParamCodes = new ArrayList<>();
      for (VariableElement param : withBatchingOutputLogic.batchedOutput().getParameters()) {
        if (param.getSimpleName().contentEquals(BATCHES_VAR)) {
          batchedOutputParamCodes.add(
              CodeBlock.of("$T.unmodifiableCollection(_batchItems)", Collections.class));
        } else {
          batchedOutputParamCodes.add(generateLogicParams(param));
        }
      }
      valueMap.put(
          "batchedOutputParams", batchedOutputParamCodes.stream().collect(CodeBlock.joining(",")));
    }

    {
      List<CodeBlock> unbatchOutputParamsCode = new ArrayList<>();
      for (VariableElement param : withBatchingOutputLogic.unbatchOutput().getParameters()) {
        if (param.getSimpleName().contentEquals(BATCHES_VAR)) {
          unbatchOutputParamsCode.add(
              CodeBlock.of("$T.unmodifiableCollection($L)", Collections.class, BATCHES_VAR));
        } else if (param.getSimpleName().contentEquals(BATCHED_OUTPUT_VAR)) {
          if (typeUtils.isSameType(
              typeUtils.erasure(param.asType()),
              typeUtils.erasure(
                  requireNonNull(
                          elementUtils.getTypeElement(
                              requireNonNull(Errable.class.getCanonicalName())))
                      .asType()))) {
            unbatchOutputParamsCode.add(
                CodeBlock.of(
                    "$T.errableFrom($L, $L)", Errable.class, BATCHED_OUTPUT_VAR, "_throwable"));
            valueMap.put("nullCheckCode", "");
          } else {
            valueMap.put("nullCheckCode", "if(_batchedOutput != null) ");
            unbatchOutputParamsCode.add(CodeBlock.of("$L", BATCHED_OUTPUT_VAR));
          }
        } else {
          unbatchOutputParamsCode.add(generateLogicParams(param));
        }
      }
      valueMap.put(
          "unbatchOutputParams", unbatchOutputParamsCode.stream().collect(CodeBlock.joining(",")));
    }

    codeBuilder.addNamed(
        """
                var _batchedOutputFuture = $batchedOutputLogic:L($batchedOutputParams:L);

                _batchedOutputFuture.whenCompleteAsync(
                    (_batchedOutput, _throwable) -> {
                      $unbatchOutputExpectedType:T _unbatchedOutput = $imMap:T.of();
                      $nullCheckCode:L{
                        try {
                          _unbatchedOutput = $unbatchOutputLogic:L($unbatchOutputParams:L);
                        } catch (Throwable _e) {
                          _throwable = _e;
                        }
                      }
                      for(var _entry : _batchItemExecItems) {
                        var _batchItem = _entry.batchItem();
                        var _result = _unbatchedOutput.get(_batchItem);

                        if (_result != null) {
                          $futuresUtil:T.linkFutures(_result.toFuture(), _entry.executionItem().response());
                        } else if (_throwable == null) {
                            _entry.executionItem().response().complete(null);
                        } else {
                          _entry.executionItem().response().completeExceptionally(
                            $stackTracelessException:T.stackTracelessWrap(_throwable));
                        }
                      }
                    }, $logicInput:L.graphExecutor());
            """,
        valueMap);
    executeMethodBuilder.addCode(codeBuilder.build());
  }

  private record LogicParam(ImmutableList<VariableElement> elements) {

    LogicParam(List<VariableElement> elements) {
      this(ImmutableList.copyOf(elements));
    }

    LogicParam {
      if (elements.isEmpty()) {
        throw new IllegalArgumentException("elements cannot be empty");
      }
    }

    String getSimpleName() {
      return element().getSimpleName().toString();
    }

    TypeMirror asType() {
      return element().asType();
    }

    private VariableElement element() {
      return elements.get(0);
    }

    public Element[] elementArray() {
      return elements.toArray(Element[]::new);
    }
  }

  private void validateParamsAndCreateParamCode(
      CodeBlock.Builder codeBuilder,
      WithBatching withBatchingOutputLogic,
      LogicParam param,
      TypeMirror batchedOutputActualType,
      ImmutableMap<String, FacetGenModel> facets) {
    if (param.getSimpleName().contentEquals(BATCHES_VAR)) {
      TypeMirror paramType = param.asType();
      List<? extends TypeMirror> batchTypeParams = getTypeParameters(paramType);
      TypeMirror expected =
          checkNotNull(
                  util.processingEnv()
                      .getElementUtils()
                      .getTypeElement(getBatchItemIfaceName().canonicalName()))
              .asType();
      if (!util.processingEnv()
              .getTypeUtils()
              .isSameType(
                  requireNonNull(typeUtils.asElement(paramType)).asType(),
                  requireNonNull(
                          util.processingEnv()
                              .getElementUtils()
                              .getTypeElement(requireNonNull(Collection.class.getCanonicalName())))
                      .asType())
          || batchTypeParams.size() != 1
          || !typeUtils.isSameType(expected, batchTypeParams.get(0))) {
        @Nullable Element[] elements = param.elementArray();
        util.codegenUtil()
            .error(
                "'_batchItems' param must be of type Collection<"
                    + expected
                    + "> . Found: "
                    + paramType,
                elements);
      }
    } else if (param.getSimpleName().contentEquals(BATCHED_OUTPUT_VAR)) {
      DeclaredType errableOfBatcheOutputType =
          util.processingEnv()
              .getTypeUtils()
              .getDeclaredType(
                  requireNonNull(
                      util.processingEnv()
                          .getElementUtils()
                          .getTypeElement(requireNonNull(Errable.class.getCanonicalName()))),
                  batchedOutputActualType);
      if (!typeUtils.isAssignable(batchedOutputActualType, param.asType())
          && !util.processingEnv()
              .getTypeUtils()
              .isAssignable(errableOfBatcheOutputType, param.asType())) {
        String message =
            "'_batchedOutput' param must be compatible with type parameter of the "
                + "Future returned by the @Output.Batched method: Expected \n'"
                + batchedOutputActualType
                + "'\n or \n'"
                + errableOfBatcheOutputType
                + "'\n Found: \n"
                + param.asType();
        @Nullable Element[] elements = param.elementArray();
        util.codegenUtil().error(message, elements);
      }
    } else {
      FacetGenModel facet = facets.get(param.getSimpleName());
      if (facet == null) {
        String message =
            "No facet with the name "
                + param.getSimpleName()
                + " exists in the vajramDef "
                + currentVajramInfo.lite().vajramId();
        @Nullable Element[] elements = param.elementArray();
        util.codegenUtil().error(message, elements);
      } else if (!facet.isUsedToGroupBatches()) {
        String message =
            "Facet '"
                + facet.name()
                + "' can be accessed individually in the output logic only if it has been annotated as @"
                + BatchesGroupedBy.class.getSimpleName();
        @Nullable Element[] elements = param.elementArray();
        util.codegenUtil().error(message, elements);
      }
      codeBuilder.add(
          facetLocalVariable(
              withBatchingOutputLogic.batchedOutput(), param.element(), BATCH_KEY_NAME));
    }
  }

  /**
   * Method to generate resolver code for facetDef binding
   *
   * @return {@link CodeBlock.Builder} with resolver code
   */
  private CodeBlock.Builder buildInputResolver(ExecutableElement method, boolean fanoutResolver) {
    Resolve resolve =
        checkNotNull(
            method.getAnnotation(Resolve.class), "Resolver method must have 'Resolve' annotation");
    String depName = util.extractFacetName(vajramName, resolve.dep(), method);
    FacetGenModel facetGenModel = checkNotNull(facetModelsByName.get(depName));

    if (!(facetGenModel instanceof DependencyModel dependencyModel)) {
      String message = "No facet definition found for " + facetGenModel.name();
      util.codegenUtil().error(message, method);
      return CodeBlock.builder();
    }
    VajramID depVajramName = dependencyModel.depVajramInfo().vajramId();
    String depRequestPackage = dependencyModel.depReqPackageName();

    // check if the facetDef is satisfied by facetDef or other resolved variables
    ClassName requestBuilderType =
        ClassName.get(depRequestPackage, getImmutRequestInterfaceName(depVajramName.id()))
            .nestedClass("Builder");
    CodeBlock.Builder codeBuilder =
        CodeBlock.builder()
            .add(
"""
  try {
""");
    if (fanoutResolver) {
      codeBuilder.addStatement(
          "var $2L = (($1T)_depRequest)", requestBuilderType, RESOLVER_REQUEST);
    } else {
      codeBuilder.addStatement(
          "var $2L = (($1T)_depRequests)",
          ParameterizedTypeName.get(ClassName.get(List.class), requestBuilderType),
          RESOLVER_REQUESTS);
    }
    codeBuilder.addStatement(
        "var $L = (($T)_rawFacetValues)",
        FACET_VALUES_VAR,
        currentVajramInfo.facetsInterfaceType());
    // TODO : add validation if fanout, then method should accept dependencyDef
    // response for the
    // bind type parameter else error
    // Iterate over the method params and call respective binding methods

    codeBuilder.add(
        method.getParameters().stream()
            .map(parameter -> facetLocalVariable(method, parameter, FACET_VALUES_VAR))
            .collect(CodeBlock.joining("\n")));

    buildResolverInvocation(
        codeBuilder,
        method,
        dependencyModel,
        stream(resolve.depInputs())
            .map(
                di ->
                    util.extractFacetName(
                        dependencyModel.depVajramInfo().vajramId().id(), di, method))
            .collect(LinkedHashSet<String>::new, LinkedHashSet::add, LinkedHashSet::addAll),
        fanoutResolver,
        requestBuilderType);
    return codeBuilder.add(
        """
        } catch (Exception e) {
          return $T.skip(
              "Got exception while executing the resolver of the dependency '$L'", e);
        }
        """,
        ResolverCommand.class,
        dependencyModel.name());
  }

  private CodeBlock facetLocalVariable(
      ExecutableElement method, VariableElement parameter, String facetsVar) {
    // check if the bind param has multiple resolvers
    FacetGenModel usingFacetModel = inferFacet(parameter);
    CodeBlock facetLocalVarCode = EMPTY_CODE_BLOCK;
    if (usingFacetModel instanceof DependencyModel) {
      facetLocalVarCode = depFacetLocalVariable(method, usingFacetModel.id(), parameter);
    } else if (usingFacetModel instanceof DefaultFacetModel defaultFacetModel) {
      TypeMirror facetType = defaultFacetModel.dataType().javaModelType(util.processingEnv());
      TypeMirror parameterTypeMirror = parameter.asType();
      final TypeName parameterType = TypeName.get(parameterTypeMirror);
      if (defaultFacetModel.isMandatoryOnServer()) {
        if (!typeUtils.isAssignable(facetType, parameterTypeMirror)) {
          util.codegenUtil()
              .error(
                  "Incorrect facet type being consumed. Expected '%s', found '%s'"
                      .formatted(facetType, parameterType),
                  parameter);
        }
        facetLocalVarCode =
            CodeBlock.builder()
                .addStatement(
                    "var $L = $T.validateMandatoryFacet($L.$L(), $S, $S)",
                    usingFacetModel.name(),
                    FacetValidation.class,
                    facetsVar,
                    usingFacetModel.name(),
                    currentVajramInfo.lite().vajramId().id(),
                    usingFacetModel.name())
                .build();
      } else if (util.codegenUtil().isOptional(parameterTypeMirror)) {
        facetLocalVarCode =
            CodeBlock.builder()
                .addStatement(
                    "var $L = $T.ofNullable($L.$L())",
                    usingFacetModel.name(),
                    Optional.class,
                    facetsVar,
                    usingFacetModel.name())
                .build();
      } else if (util.codegenUtil().isAnyNullable(parameterTypeMirror, parameter)) {
        facetLocalVarCode =
            CodeBlock.builder()
                .addStatement(
                    "var $L = $L.$L()", usingFacetModel.name(), facetsVar, usingFacetModel.name())
                .build();
      } else {
        String message =
            String.format(
                "Optional facet '%s' must be accessed via a @Nullable param or an Optional<> param",
                usingFacetModel.name());
        util.codegenUtil().error(message, parameter);
      }
    } else {
      String message = "No facetDef resolver found for " + usingFacetModel.name();
      util.codegenUtil().error(message, parameter);
    }
    return facetLocalVarCode;
  }

  /**
   * Method to generate resolver code for dependencyDef bindings
   *
   * @param method Dependency resolver method
   * @param usingFacetId The bind param name in the resolver method
   * @param parameter the bind parameter in the resolver method
   */
  private CodeBlock depFacetLocalVariable(
      ExecutableElement method, final int usingFacetId, VariableElement parameter) {
    CodeBlock returnValue = EMPTY_CODE_BLOCK;
    FacetGenModel usingFacetDef = checkNotNull(facetModels.get(usingFacetId));

    TypeMirror parameterType = parameter.asType();
    String usingFacetName = usingFacetDef.name();
    // ReturnType returnType
    if (usingFacetDef instanceof DependencyModel dependencyModel) {
      String variableName = usingFacetName;
      final VajramInfoLite depVajramInfoLite = dependencyModel.depVajramInfo();
      TypeName boxedDepType = util.codegenUtil().toTypeName(depVajramInfoLite.responseType()).box();
      TypeName unboxedDepType =
          boxedDepType.isBoxedPrimitive() ? boxedDepType.unbox() : boxedDepType;
      String logicName = method.getSimpleName().toString();
      if (depFanoutMap.getOrDefault(usingFacetId, false)) {
        // fanout case
        boolean typeMismatch = false;
        if (!util.codegenUtil().isRawAssignable(parameterType, FanoutDepResponses.class)) {
          typeMismatch = true;
        } else if (getTypeParameters(parameterType).size() != 2) {
          typeMismatch = true;
        }
        if (typeMismatch) {
          // the parameter data type must be RequestResponse<Req, Resp>
          util.codegenUtil()
              .error(
                  """
                        The fanout dependency ('%s') can be consumed only via the FanoutDepResponses<ReqType,RespType> class. \
                        Found '%s' instead"""
                      .formatted(dependencyModel.name(), parameterType),
                  parameter);
        }
        returnValue =
            CodeBlock.of(
                "$T $L = $L.$L();",
                util.responsesType(dependencyModel),
                variableName,
                FACET_VALUES_VAR,
                usingFacetName);
      } else {
        // This means the dependency being consumed used is not a fanout dependency
        String depAccessLhs = "var $1L";
        String depAccessRhs = "$2L.$3L()";
        String depValueAccessorCode = depAccessLhs + " = " + depAccessRhs;
        if (usingFacetDef.isMandatoryOnServer()) {
          if (unboxedDepType.equals(TypeName.get(parameterType))) {
            // This means this dependencyDef being consumed is a non fanout mandatory
            // dependency and
            // the dev has requested the value directly. So we extract the only value from
            // dependencyDef response and provide it.
            returnValue =
                CodeBlock.of(
                    depAccessLhs
                        + "= $4T.validateMandatoryFacet("
                        + depAccessRhs
                        + ".response().value(), $5S, $6S);",
                    variableName,
                    FACET_VALUES_VAR,
                    usingFacetName,
                    FacetValidation.class,
                    currentVajramInfo.lite().vajramId().id(),
                    usingFacetName);
          } else {
            // This means the dependency being consumed is mandatory, but the type of the
            // parameter
            // is not matching the type of the facet
            util.codegenUtil()
                .error(
                    """
                        A resolver must consume a mandatory dependency directly using its type.
                        Expected: %s
                        Found: %s"""
                        .formatted(unboxedDepType, parameterType),
                    parameter);
          }
        } else {
          // dependency is optional then accept only errable and optional in resolver
          if (util.codegenUtil().isRawAssignable(parameterType, Errable.class)) {
            // This means this dependencyDef in "Using" annotation is not a fanout and the
            // dev has
            // requested the 'Errable'. So we extract the only Errable from dependencyDef
            // response and provide it.
            returnValue =
                CodeBlock.of(
                    depValueAccessorCode + ".response();",
                    variableName,
                    FACET_VALUES_VAR,
                    usingFacetName);
          } else if (util.codegenUtil().isRawAssignable(parameterType, Optional.class)) {
            // This means this dependencyDef being consumed is not a fanout and the
            // dev has  requested an 'Optional'. So we retrieve the Errable from the
            // response, extract the optional and provide it.
            returnValue =
                CodeBlock.of(
                    depValueAccessorCode + ".response().valueOpt();",
                    variableName,
                    FACET_VALUES_VAR,
                    usingFacetName);
          } else if (util.codegenUtil().isAnyNullable(parameterType, parameter)) {
            // This means this dependencyDef being consumed is not a fanout and the
            // dev has  requested a @Nullable value. So we retrieve the Errable from the
            // response, extract the nullable and provide it.
            returnValue =
                CodeBlock.of(
                    depValueAccessorCode + ".response().value();",
                    variableName,
                    FACET_VALUES_VAR,
                    usingFacetName);
          } else if (util.codegenUtil().isRawAssignable(parameterType, One2OneDepResponse.class)) {
            // This means this dependencyDef being consumed is not a fanout and the  dev has
            // requested a 'One2OneDepResponse'.
            returnValue =
                CodeBlock.of(depValueAccessorCode, variableName, FACET_VALUES_VAR, usingFacetName);
          } else {
            util.codegenUtil()
                .error(
                    ("A resolver ('%s') must not access an optional dependency ('%s') directly."
                            + "Use @Nullable, Optional<>, Errable<>, One2OneDepResponse<> or FanoutDepResponses<> instead")
                        .formatted(logicName, usingFacetName),
                    parameter);
          }
        }
      }
    }
    return returnValue;
  }

  /**
   * Method to generate resolver code for variables having single resolver.
   *
   * <p>Fanout case
   *
   * <p>- MultiRequest of normal type => fanout loop and create facetValues
   *
   * <p>- MultiRequest of Vajram Request - DependencyCommand.MultiExecute<NormalType>
   *
   * <p>Non - fanout
   *
   * <p>- Normal datatype - Vajram Request => toInputValues() - DependencyCommand.executeWith
   *
   * @param methodCodeBuilder {@link CodeBlock.Builder}
   * @param resolverMethod Resolve method
   * @param depInputNames Resolve facetValues
   */
  private void buildResolverInvocation(
      CodeBlock.Builder methodCodeBuilder,
      ExecutableElement resolverMethod,
      DependencyModel dependencyModel,
      Set<String> depInputNames,
      boolean fanoutResolver,
      ClassName requestBuilderType) {

    /*
     * TODO In the following code, we are assuming that if the
     * resolver method is returning SingleExecute<T>, MultiExecute<T>, or just T,
     * the T is exactly matching the resolved inputs data type. If the developer
     * makes an error,
     * then the generated code will fail at runtime with ClassCastException. We need
     * to add a validation
     * here which proactively fails if the data type mismatches.
     */
    String resolverResultVar = fanoutResolver ? RESOLVER_RESULTS : RESOLVER_RESULT;
    methodCodeBuilder.add(
        """
  var $L = $L(""",
        resolverResultVar,
        resolverMethod.getSimpleName());
    ImmutableList<FacetGenModel> resolverSources = getResolverSources(resolverMethod).asList();
    for (int i = 0; i < resolverSources.size(); i++) {
      methodCodeBuilder.add("$L", resolverSources.get(i).name());
      if (i != resolverMethod.getParameters().size() - 1) {
        methodCodeBuilder.add(", ");
      }
    }
    methodCodeBuilder.add(");\n");

    TypeMirror type = resolverMethod.getReturnType();
    TypeMirror returnType = util.codegenUtil().box(type);
    boolean resolverReturnedDepCommand = false;
    if (util.codegenUtil().isRawAssignable(returnType, DependencyCommand.class)) {
      resolverReturnedDepCommand = true;
      methodCodeBuilder.beginControlFlow("if($L.shouldSkip())", resolverResultVar);
      methodCodeBuilder.addStatement(
          "\t return $T.skip($L.doc(), $L.skipCause())",
          ResolverCommand.class,
          resolverResultVar,
          resolverResultVar);
      methodCodeBuilder.add("} else {\n\t");

      TypeMirror actualReturnType = getTypeParameters(returnType).get(0);
      if (util.codegenUtil().isRawAssignable(returnType, One2OneCommand.class)) {
        methodCodeBuilder.beginControlFlow(
            "for($T $L: $L)", requestBuilderType, RESOLVER_REQUEST, RESOLVER_REQUESTS);
        if (util.codegenUtil().isRawAssignable(actualReturnType, Request.class)) {
          for (String depInputName : depInputNames) {
            methodCodeBuilder.addStatement(
                "$L.ifPresent(_r -> $L.$L(_r.$L()))",
                RESOLVER_RESULT,
                RESOLVER_REQUEST,
                depInputName,
                depInputName);
          }
        } else {
          if (depInputNames.size() != 1) {
            util.codegenUtil()
                .error(
                    "Resolver method which resolves multiple dependency inputs must return a Request Builder object",
                    resolverMethod);
          }
          String depFacetName = depInputNames.iterator().next();

          methodCodeBuilder.addStatement(
              "$L.ifPresent($L::$L)", RESOLVER_RESULT, RESOLVER_REQUEST, depFacetName);
        }
        methodCodeBuilder.endControlFlow();
      } else if (util.codegenUtil().isRawAssignable(returnType, FanoutCommand.class)) {
        // TODO : add missing validations if any (??)
        if (!dependencyModel.canFanout()) {

          util.codegenUtil()
              .error(
                  """
                        Dependency '%s' is not a fanout dependency, yet the resolver method returns a MultiExecute command.\
                        This is not allowed. Return a SingleExecute command, a single value, or mark the dependency as `canFanout = true`."""
                      .formatted(dependencyModel.name()),
                  resolverMethod);
        }
        methodCodeBuilder.addStatement(
            "var $L = new $T()",
            RESOLVER_REQUESTS,
            ParameterizedTypeName.get(ClassName.get(ArrayList.class), requestBuilderType));
        if (util.codegenUtil().isRawAssignable(actualReturnType, ImmutableRequest.Builder.class)) {
          if (depInputNames.size() <= 1) {
            util.codegenUtil()
                .error(
                    "Resolver method that returns a request builder object must resolve multiple dependency inputs. Otherwise this can lead to unnecessary creation of request builder objects.",
                    resolverMethod);
          }
        }
        methodCodeBuilder.beginControlFlow(
            "for($T $L: $L.values())", actualReturnType, RESOLVER_RESULT, RESOLVER_RESULTS);
        if (util.codegenUtil().isRawAssignable(actualReturnType, ImmutableRequest.Builder.class)) {
          /*
           * TODO: Add validation that this vajramDef request is of the same type as the
           * request of the dependency Vajram
           */
          methodCodeBuilder.add("$L.add($L._newCopy()", RESOLVER_REQUESTS, RESOLVER_REQUEST);
          for (String depFacetName : depInputNames) {
            methodCodeBuilder.add(".$L($L.$L())", depFacetName, RESOLVER_RESULT, depFacetName);
          }
          methodCodeBuilder.add(");");
        } else {
          // TODO : Add validation for the type parameter of the MultiExecute to match the
          // type of
          // the input being resolved
          if (depInputNames.size() > 1) {
            util.codegenUtil()
                .error(
                    "Resolver method which resolves multiple dependency inputs must return a %s object"
                        .formatted(ImmutableRequest.Builder.class),
                    resolverMethod);
          }
          // Here we are assuming that the method is returning an MultiExecute of the type
          // of the
          // input being resolved. If this assumption is incorrect, the generated wrapper
          // class will
          // fail compilation.
          String depFacetName = depInputNames.iterator().next();
          methodCodeBuilder.addStatement(
              "$L.add($L._newCopy().$L($L))",
              RESOLVER_REQUESTS,
              RESOLVER_REQUEST,
              depFacetName,
              RESOLVER_RESULT);
        }
        methodCodeBuilder.endControlFlow();
      }
    } else if (util.codegenUtil().isRawAssignable(returnType, Request.class)) {
      methodCodeBuilder.beginControlFlow(
          "for($T $L: $L)", requestBuilderType, RESOLVER_REQUEST, RESOLVER_REQUESTS);
      for (String depFacetName : depInputNames) {
        methodCodeBuilder.addStatement(
            "$L.$L($L.$L())", RESOLVER_REQUEST, depFacetName, RESOLVER_RESULT, depFacetName);
      }
      methodCodeBuilder.endControlFlow();
    } else {
      methodCodeBuilder.beginControlFlow(
          "for($T $L: $L)", requestBuilderType, RESOLVER_REQUEST, RESOLVER_REQUESTS);
      if (depInputNames.size() != 1) {
        util.codegenUtil()
            .error(
                "Resolver method which resolves multiple dependency inputs must return a Request object",
                resolverMethod);
      }
      String depFacetName = depInputNames.iterator().next();
      methodCodeBuilder.addStatement(
          """
              $L.$L($L)
              """,
          RESOLVER_REQUEST,
          depFacetName,
          RESOLVER_RESULT);
      methodCodeBuilder.endControlFlow();
    }

    if (fanoutResolver) {
      methodCodeBuilder.addStatement(
          "return $T.executeWithRequests($T.copyOf($L))",
          ResolverCommand.class,
          ImmutableList.class,
          RESOLVER_REQUESTS);
    } else {
      methodCodeBuilder.addStatement(
          "return $T.executeWithRequests($L)", ResolverCommand.class, RESOLVER_REQUESTS);
    }
    if (resolverReturnedDepCommand) {
      // close the else block of "if($L.shouldSkip())"
      methodCodeBuilder.endControlFlow();
    }
  }

  private void modelsClassMembers(
      TypeSpec.Builder classSpec,
      ClassName enclosingClassType,
      List<? extends FacetGenModel> eligibleFacets,
      CodeGenParams codeGenParams) {
    if (codeGenParams.wrapsRequest() && codeGenParams.isRequest()) {
      throw new IllegalArgumentException("A request cannot wrap another request - this is a bug");
    }
    ClassName immutFacetsType = ClassName.get(packageName, getImmutFacetsClassName(vajramName));
    // TODO : Add checks for subsetRequest
    MethodSpec.Builder fullConstructor = constructorBuilder();
    ClassName immutRequestType = currentVajramInfo.conformsToTraitOrSelf().reqImmutInterfaceType();
    if (codeGenParams.withImpl()) {
      if (codeGenParams.isBuilder()) {
        addCommonObjectMethods(classSpec);
      } else {
        util.codegenUtil()
            .addImmutableModelObjectMethods(
                immutFacetsType,
                Sets.union(
                    eligibleFacets.stream()
                        .filter(f -> !INPUT.equals(f.facetType()))
                        .map(FacetGenModel::name)
                        .collect(toSet()),
                    Set.of("_request")),
                classSpec);
      }
      if (codeGenParams.wrapsRequest()) {
        ClassName requestOrBuilderType =
            codeGenParams.isBuilder() ? immutRequestType.nestedClass("Builder") : immutRequestType;
        fullConstructor.addParameter(
            ParameterSpec.builder(requestOrBuilderType, "_request").build());
        fullConstructor.addStatement("this._request = _request");
        FieldSpec.Builder field =
            FieldSpec.builder(requestOrBuilderType, "_request", PRIVATE, FINAL)
                .addAnnotation(Getter.class);
        if (!codeGenParams.isBuilder()) {
          field.addModifiers(FINAL);
        }
        classSpec.addField(field.build());
      }
      if (codeGenParams.isFacetsSubset() && codeGenParams.isBuilder()) {
        MethodSpec.Builder requestConstructor = constructorBuilder();
        requestConstructor.addParameter(
            ParameterSpec.builder(
                    currentVajramInfo.conformsToTraitOrSelf().requestInterfaceClassName(),
                    "_request")
                .addAnnotation(NonNull.class)
                .build());
        for (FacetGenModel facet : eligibleFacets) {
          if (facet.facetType().equals(INPUT)) {
            requestConstructor.addStatement(
                "this.$L = $T.$L.getFromRequest(_request)",
                facet.name(),
                getRequestInterfaceType(),
                facet.name() + FACET_SPEC_SUFFIX);
          }
        }
        classSpec.addMethod(requestConstructor.build());
      }
    }

    for (FacetGenModel facet : eligibleFacets) {
      FacetJavaType facetFieldType = util.getFacetFieldType(facet);
      ParameterSpec facetParam =
          ParameterSpec.builder(
                  facetFieldType
                      .javaTypeName(facet)
                      .annotated(annotations(facetFieldType.typeAnnotations(facet, codeGenParams))),
                  facet.name())
              .build();
      boolean isInput = facet.facetType().equals(INPUT);
      if (codeGenParams.withImpl()) {
        if (!isInput || !codeGenParams.wrapsRequest()) {
          FieldSpec.Builder facetField =
              FieldSpec.builder(
                  facetFieldType
                      .javaTypeName(facet)
                      .annotated(annotations(facetFieldType.typeAnnotations(facet, codeGenParams))),
                  facet.name(),
                  PRIVATE);
          if (codeGenParams.isBuilder()) {
            facetField.initializer(facetFieldType.fieldInitializer(facet));
          } else {
            facetField.addModifiers(FINAL);
          }
          classSpec.addField(facetField.build());
          fullConstructor.addParameter(facetParam);

          fullConstructor.addStatement("this.$L = $L", facet.name(), facet.name());
        }
      }
      // Getter
      createFacetGetter(classSpec, facet, codeGenParams);
      if (codeGenParams.isBuilder()) {
        MethodSpec.Builder setterBuilder =
            methodBuilder(facet.name())
                .returns(enclosingClassType.nestedClass("Builder"))
                .addModifiers(PUBLIC)
                .addParameter(facetParam);

        boolean usePlatformDefault = util.usePlatformDefault(facet);

        if (codeGenParams.isBuilderRoot()) {
          String documentation = facet.documentation();
          setterBuilder.addJavadoc(
              "Sets the facet '$L'$L\n@param $L the value to set\n@return this builder for method chaining",
              facet.name(),
              documentation == null ? "\n" : ":\n<p>" + documentation,
              facet.name());
        }

        if (codeGenParams.withImpl()) {
          if (isInput && codeGenParams.wrapsRequest()) {
            // For facets that are wrapped in a request
            setterBuilder.addStatement("this._request.$L($L)", facet.name(), facet.name());
          } else {
            // For facets that are not wrapped in a request
            if (usePlatformDefault) {
              setterBuilder.addStatement(
                  "this.$L = $L != null ? $L : $T.$L.getPlatformDefaultValue()",
                  facet.name(),
                  facet.name(),
                  facet.name(),
                  getRequestInterfaceType(),
                  facet.name() + FACET_SPEC_SUFFIX);
            } else {
              setterBuilder.addStatement("this.$L = $L", facet.name(), facet.name());
            }
          }
          setterBuilder.addStatement("return this");
        } else {
          setterBuilder.addModifiers(ABSTRACT);
        }
        classSpec.addMethod(
            // Setter
            // public Builder inputName(Type inputName){this.inputName = inputName; return
            // this;}
            setterBuilder.build());
      }
    }
    if (codeGenParams.withImpl()) {
      classSpec.addMethod(fullConstructor.build());
    }

    if (codeGenParams.isBuilder()
        && codeGenParams.withImpl()
        && !fullConstructor.parameters.isEmpty()) {
      // Make sure there is always a no-arg constructor for the builder
      classSpec.addMethod(
          constructorBuilder()
              .addCode(
                  codeGenParams.wrapsRequest()
                      ? CodeBlock.builder()
                          .addStatement(
                              "this._request = $T._builder()",
                              currentVajramInfo.lite().reqImmutPojoType())
                          .build()
                      : CodeBlock.builder().build())
              .build());
    }
    if (codeGenParams.isBuilder()
        && codeGenParams.withImpl()
        && !(codeGenParams.isRequest() || codeGenParams.isFacetsSubset())) {
      // Make sure Builder always has a constructor which accepts only the request
      // irrespective of
      // type of Facet class
      // See Vajram#facetsFromRequest
      classSpec.addMethod(
          constructorBuilder()
              .addParameter(
                  ParameterSpec.builder(
                          currentVajramInfo.conformsToTraitOrSelf().requestInterfaceClassName(),
                          "_request")
                      .build())
              .addStatement("this._request = _request._asBuilder()")
              .build());
    }
  }

  private void createFacetGetter(
      TypeSpec.Builder clazz, FacetGenModel facet, CodeGenParams codeGenParams) {
    MethodSpec.Builder method;
    FacetJavaType fieldType = util.getFacetFieldType(facet);
    FacetJavaType returnType = util.getFacetReturnType(facet, codeGenParams);
    // Non-dependency facet (Example: GivenFacet)
    method =
        methodBuilder(facet.name())
            .addModifiers(PUBLIC)
            .returns(
                returnType
                    .javaTypeName(facet)
                    .annotated(annotations(returnType.typeAnnotations(facet, codeGenParams))));

    if (codeGenParams.isModelRoot()) {
      String documentation = facet.documentation();
      if (documentation != null && !documentation.trim().isEmpty()) {
        method.addJavadoc("$L", documentation);
      }
      method.addAnnotations(
          facet.facetField().getAnnotationMirrors().stream()
              .filter(
                  annotationMirror ->
                      MODEL_METHOD_ANNOTATIONS.contains(
                          ((QualifiedNameable) annotationMirror.getAnnotationType().asElement())
                              .getQualifiedName()
                              .toString()))
              .map(AnnotationSpec::get)
              .toList());
    }

    if (codeGenParams.withImpl()) {
      method.addStatement(fieldType.fieldGetterCode(facet, codeGenParams));
    } else {
      method.addModifiers(ABSTRACT);
    }
    clazz.addMethod(method.build());
  }

  /**
   * Validates that none of the SerialId annotations on facets clash with the ReservedSerialIds
   * annotation on the Vajram.
   *
   * <p>This ensures that facets don't use serial IDs that are explicitly reserved for backward
   * compatibility reasons.
   */
  private void validateSerialIdReservations() {
    ReservedSerialIds reservedSerialIds =
        currentVajramInfo.vajramClassElem().getAnnotation(ReservedSerialIds.class);

    // If there's no ReservedSerialIds annotation, there's nothing to validate
    if (reservedSerialIds == null) {
      return;
    }

    // Get the set of reserved serial IDs
    Set<Integer> reservedIdSet =
        stream(reservedSerialIds.value()).boxed().collect(toImmutableSet());

    // Check each facet's SerialId annotation
    for (FacetGenModel facet : facetModelsByName.values()) {
      SerialId facetSerialId = facet.facetField().getAnnotation(SerialId.class);
      if (facetSerialId != null && reservedIdSet.contains(facetSerialId.value())) {
        String message =
            String.format(
                "SerialId %d on facet '%s' in Vajram '%s' conflicts with a reserved ID. "
                    + "This ID is reserved via the @ReservedSerialIds annotation on the Vajram class.",
                facetSerialId.value(),
                facet.name(),
                currentVajramInfo.vajramClassElem().getSimpleName());
        @Nullable Element[] elements = new Element[] {facet.facetField()};
        util.codegenUtil().error(message, elements);
      }
    }
  }

  /**
   * Validates that the Strategy values in the IfAbsent annotation are only applied to facets with
   * data types that match the whitelisted types specified in the ApplicableToTypes annotation on
   * each enum value.
   */
  private void validateIfAbsentStrategyApplicability() {

    for (FacetGenModel facet : facetModelsByName.values()) {
      Element facetField = facet.facetField();
      IfAbsent ifAbsent = facetField.getAnnotation(IfAbsent.class);
      if (ifAbsent != null) {
        IfAbsentThen ifAbsentThen = ifAbsent.value();
        if (ifAbsentThen.usePlatformDefault()) {
          if (facet.facetType().equals(DEPENDENCY)) {
            util.codegenUtil()
                .error(
                    "Defaulting to a platform default value is not supported for dependency facets.",
                    facetField);
          }
        }
      }
    }
  }

  private ImmutableList<MethodSpec> facetContainerMethods(
      List<? extends FacetGenModel> eligibleFacets,
      ClassName enclosingClassName,
      ClassName immutableClassRawName,
      List<TypeVariableName> typeVariableNames,
      CodeGenParams codeGenParams) {

    // TODO : add validations for subsetRequest

    List<MethodSpec.Builder> methodBuilders = new ArrayList<>();

    String constructorParamString =
        (codeGenParams.isRequest()
                ? eligibleFacets.stream().map(FacetGenModel::name)
                : codeGenParams.wrapsRequest()
                    ? Stream.concat(
                        Stream.of("%s"),
                        eligibleFacets.stream()
                            .filter(f -> !f.facetType().equals(INPUT))
                            .map(FacetGenModel::name))
                    : eligibleFacets.stream().map(FacetGenModel::name))
            .collect(Collectors.joining(", "));
    {
      TypeName immutableClassName =
          typeVariableNames.isEmpty()
              ? immutableClassRawName
              : ParameterizedTypeName.get(
                  immutableClassRawName, typeVariableNames.toArray(TypeName[]::new));
      MethodSpec.Builder methodBuilder = methodBuilder("_build").returns(immutableClassName);
      if (codeGenParams.withImpl()) {
        methodBuilder.addStatement(
            codeGenParams.isBuilder()
                ? "return new %s(%s)"
                    .formatted(
                        immutableClassRawName.simpleName(),
                        constructorParamString.formatted(
                            codeGenParams.wrapsRequest()
                                ? "_request._build()"
                                : "_batchable._build(), _batchKey._build()"))
                : "return this");
      } else {
        methodBuilder.addModifiers(ABSTRACT);
      }
      methodBuilders.add(methodBuilder);
    }

    {
      ClassName asBuilderRawType = immutableClassRawName.nestedClass("Builder");
      TypeName asBuilderType;
      if (typeVariableNames.isEmpty()) {
        asBuilderType = asBuilderRawType;
      } else {
        asBuilderType =
            ParameterizedTypeName.get(asBuilderRawType, typeVariableNames.toArray(TypeName[]::new));
      }
      MethodSpec.Builder methodBuilder = methodBuilder("_asBuilder").returns(asBuilderType);
      if (codeGenParams.withImpl()) {
        methodBuilder.addStatement(
            codeGenParams.isBuilder()
                ? "return this"
                : "return new Builder(%s)"
                    .formatted(
                        constructorParamString.formatted(
                            codeGenParams.wrapsRequest()
                                ? "_request._asBuilder()"
                                : "_batchable._asBuilder(), _batchKey._asBuilder()")));
      } else {
        methodBuilder.addModifiers(ABSTRACT);
      }
      methodBuilders.add(methodBuilder);
    }

    {
      ClassName copyRawType =
          codeGenParams.isBuilder()
              ? enclosingClassName.nestedClass("Builder")
              : enclosingClassName;
      TypeName copyType;
      if (typeVariableNames.isEmpty()) {
        copyType = copyRawType;
      } else {
        copyType =
            ParameterizedTypeName.get(copyRawType, typeVariableNames.toArray(TypeName[]::new));
      }

      MethodSpec.Builder methodBuilder = methodBuilder("_newCopy").returns(copyType);
      if (codeGenParams.withImpl()) {
        methodBuilder.addStatement(
            codeGenParams.isBuilder()
                ? "return new Builder(%s)"
                    .formatted(
                        constructorParamString.formatted(
                            codeGenParams.wrapsRequest()
                                ? "_request._newCopy()"
                                : "_batchable._newCopy(), _batchKey._newCopy()"))
                : "return this");
      } else {
        methodBuilder.addModifiers(ABSTRACT);
      }
      methodBuilders.add(methodBuilder);
    }

    ImmutableList.Builder<MethodSpec> list = ImmutableList.builder();
    for (MethodSpec.Builder b : methodBuilders) {
      if (b != null) {
        MethodSpec build = b.addModifiers(PUBLIC).addAnnotation(Override.class).build();
        list.add(build);
      }
    }
    return list.build();
  }

  private void basicFacetsClasses() {
    boolean doInputsNeedBatching =
        currentVajramInfo.facetStream().anyMatch(FacetGenModel::isBatched);

    List<FacetGenModel> allFacets = currentVajramInfo.facetStream().toList();

    ClassName facetsType = currentVajramInfo.facetsInterfaceType();
    ClassName immutableFacetsType = ClassName.get(packageName, getImmutFacetsClassName(vajramName));

    TypeSpec.Builder facetsInterface =
        util.codegenUtil()
            .interfaceBuilder(
                currentVajramInfo.facetsInterfaceType().simpleName(),
                currentVajramInfo.vajramClassElem().getQualifiedName().toString())
            .addModifiers(PUBLIC)
            .addSuperinterface(
                doInputsNeedBatching ? BatchEnabledFacetValues.class : FacetValues.class);

    // Add _vajramID() method to the facets interface
    facetsInterface.addMethod(
        overriding(util.codegenUtil().getMethod(FacetValuesContainer.class, "_vajramID", 0))
            .addModifiers(DEFAULT)
            .addStatement("return $T." + VAJRAM_ID_CONSTANT_NAME, getRequestInterfaceType())
            .build());
    facetConstants(
        facetsInterface, currentVajramInfo.facetStream().toList(), CodeGenParams.builder().build());
    allFacets.forEach(
        facet ->
            createFacetGetter(
                facetsInterface, facet, CodeGenParams.builder().wrapsRequest(true).build()));

    TypeSpec.Builder immutFacetsClass =
        util.codegenUtil()
            .classBuilder(
                getImmutFacetsClassName(vajramName),
                currentVajramInfo.vajramClassElem().getQualifiedName().toString())
            .addModifiers(PUBLIC, FINAL)
            .addSuperinterface(facetsType)
            .addSuperinterface(
                doInputsNeedBatching
                    ? BatchEnabledImmutableFacetValues.class
                    : ImmutableFacetValues.class);
    modelsClassMembers(
        immutFacetsClass,
        immutableFacetsType,
        allFacets,
        CodeGenParams.builder().wrapsRequest(true).withImpl(true).build());

    TypeSpec.Builder facetsBuilderClass =
        util.codegenUtil()
            .classBuilder(
                "Builder", currentVajramInfo.vajramClassElem().getQualifiedName().toString())
            .addModifiers(PUBLIC, STATIC, FINAL)
            .addSuperinterface(facetsType)
            .addSuperinterface(
                doInputsNeedBatching
                    ? BatchEnabledImmutableFacetValues.Builder.class
                    : FacetValuesBuilder.class);
    modelsClassMembers(
        facetsBuilderClass,
        immutableFacetsType,
        allFacets,
        CodeGenParams.builder().wrapsRequest(true).isBuilder(true).withImpl(true).build());
    if (doInputsNeedBatching) {
      codegenBatchableFacets(facetsInterface, CodeGenParams.builder().build());
      codegenBatchableFacets(immutFacetsClass, CodeGenParams.builder().withImpl(true).build());
      codegenBatchableFacets(facetsBuilderClass, CodeGenParams.builder().withImpl(true).build());
    }

    try {
      StringWriter writer = new StringWriter();
      JavaFile.builder(
              packageName,
              facetsInterface
                  .addMethod(
                      methodBuilder("_build")
                          .addModifiers(PUBLIC, ABSTRACT)
                          .returns(immutableFacetsType)
                          .addAnnotation(Override.class)
                          .build())
                  .addMethod(
                      methodBuilder("_asBuilder")
                          .addModifiers(PUBLIC, ABSTRACT)
                          .returns(immutableFacetsType.nestedClass("Builder"))
                          .addAnnotation(Override.class)
                          .build())
                  .build())
          .build()
          .writeTo(writer);
      util.codegenUtil()
          .generateSourceFile(
              currentVajramInfo.facetsInterfaceType().canonicalName(),
              writer.toString(),
              currentVajramInfo.vajramClassElem());
    } catch (IOException e) {
      String message = String.valueOf(e.getMessage());
      util.codegenUtil().error(message, currentVajramInfo.vajramClassElem());
    }
    try {
      StringWriter writer = new StringWriter();
      JavaFile.builder(
              packageName,
              immutFacetsClass
                  .addMethods(
                      facetContainerMethods(
                          allFacets,
                          immutableFacetsType,
                          immutableFacetsType,
                          List.of(),
                          CodeGenParams.builder().wrapsRequest(true).withImpl(true).build()))
                  .addMethod(
                      methodBuilder("_builder")
                          .addModifiers(PUBLIC, STATIC)
                          .returns(immutableFacetsType.nestedClass("Builder"))
                          .addStatement(
                              "return new $T()", immutableFacetsType.nestedClass("Builder"))
                          .build())
                  .addType(
                      facetsBuilderClass
                          .addMethods(
                              facetContainerMethods(
                                  allFacets,
                                  immutableFacetsType,
                                  immutableFacetsType,
                                  List.of(),
                                  CodeGenParams.builder()
                                      .wrapsRequest(true)
                                      .isBuilder(true)
                                      .withImpl(true)
                                      .build()))
                          .build())
                  .build())
          .build()
          .writeTo(writer);
      util.codegenUtil()
          .generateSourceFile(
              packageName + '.' + getImmutFacetsClassName(vajramName),
              writer.toString(),
              currentVajramInfo.vajramClassElem());
    } catch (IOException e) {
      String message = String.valueOf(e.getMessage());
      util.codegenUtil().error(message, currentVajramInfo.vajramClassElem());
    }
  }

  private void batchFacetsClasses() {
    ClassName allFacetsType = currentVajramInfo.facetsInterfaceType();
    ClassName batchItemsIfaceType = getBatchItemIfaceName();

    ClassName commonImmutFacetsType = getCommonFacetsClassName();

    List<FacetGenModel> batchedFacets =
        currentVajramInfo.facetStream().filter(FacetGenModel::isBatched).toList();
    List<FacetGenModel> commonFacets =
        currentVajramInfo.facetStream().filter(FacetGenModel::isUsedToGroupBatches).toList();

    TypeSpec.Builder batchItemsIface =
        util.codegenUtil()
            .interfaceBuilder(
                batchItemsIfaceType.simpleName(),
                currentVajramInfo.vajramClassElem().getQualifiedName().toString())
            .addSuperinterface(ImmutableFacetValuesContainer.class)
            .addSuperinterface(Model.class)
            .addAnnotation(
                AnnotationSpec.builder(ModelRoot.class)
                    .addMember("type", "$T.$L", ModelType.class, DEFAULT.name())
                    .addMember("suffixSeparator", "$S", "")
                    .build());

    for (FacetGenModel facet : batchedFacets) {
      CodeGenParams codeGenParams =
          CodeGenParams.builder().isSubsetBatch(true).wrapsFacets(true).build();
      FacetJavaType returnType = util.getFacetReturnType(facet, codeGenParams);
      batchItemsIface.addMethod(
          methodBuilder(facet.name())
              .addModifiers(PUBLIC, ABSTRACT)
              .addAnnotations(
                  facet.facetField().getAnnotationMirrors().stream()
                      .filter(
                          annotationMirror ->
                              IfAbsent.class
                                  .getCanonicalName()
                                  .equals(
                                      ((QualifiedNameable)
                                              annotationMirror.getAnnotationType().asElement())
                                          .getQualifiedName()
                                          .toString()))
                      .map(AnnotationSpec::get)
                      .toList())
              .returns(
                  returnType
                      .javaTypeName(facet)
                      .annotated(annotations(returnType.typeAnnotations(facet, codeGenParams))))
              .build());
    }
    batchItemsIface
        .addMethod(
            overriding(util.codegenUtil().getMethod(FacetValuesContainer.class, "_facets", 0))
                .addModifiers(DEFAULT)
                .addStatement(
                    """
                        return $T._facets.stream()
                          .filter($T::isBatched)
                          .collect($T.toImmutableSet())
                        """,
                    currentVajramInfo.facetsInterfaceType(),
                    FacetSpec.class,
                    ImmutableSet.class)
                .build())
        .addMethod(
            overriding(util.codegenUtil().getMethod(FacetValuesContainer.class, "_vajramID", 0))
                .addModifiers(DEFAULT)
                .addStatement("return $T." + VAJRAM_ID_CONSTANT_NAME, getRequestInterfaceType())
                .build())
        .addMethod(
            methodBuilder("_pojoBuilder")
                .addModifiers(PUBLIC, STATIC)
                .returns(
                    ClassName.get(
                        packageName, getBatchItemIfaceName().simpleName() + "ImmutPojo", "Builder"))
                .addStatement(
                    "return $T._builder()",
                    ClassName.get(packageName, getBatchItemIfaceName().simpleName() + "ImmutPojo"))
                .build())
        .addMethod(
            methodBuilder("_fromFacets")
                .addModifiers(PUBLIC, STATIC)
                .returns(batchItemsIfaceType)
                .addParameter(allFacetsType, FACET_VALUES_VAR)
                .addCode("return _pojoBuilder()")
                .addCode(
                    "$L",
                    batchedFacets.stream()
                        .map(
                            f -> CodeBlock.of(".$L($L.$L())", f.name(), FACET_VALUES_VAR, f.name()))
                        .collect(CodeBlock.joining("")))
                .addCode("._build();")
                .build());

    TypeSpec.Builder commonImmutFacetsClass =
        util.codegenUtil()
            .classBuilder(
                commonImmutFacetsType.simpleName(),
                currentVajramInfo.vajramClassElem().getQualifiedName().toString())
            .addModifiers(FINAL)
            .addSuperinterface(ImmutableFacetValuesContainer.class)
            .addField(allFacetsType, FACET_VALUES_VAR, PRIVATE, FINAL)
            .addMethod(
                constructorBuilder()
                    .addParameter(allFacetsType, FACET_VALUES_VAR)
                    .addStatement("this.$L = $L._build()", FACET_VALUES_VAR, FACET_VALUES_VAR)
                    .build())
            .addAnnotation(
                AnnotationSpec.builder(EqualsAndHashCode.class)
                    .addMember("onlyExplicitlyIncluded", "true")
                    .build())
            .addMethod(
                overriding(util.codegenUtil().getMethod(FacetValuesContainer.class, "_facets", 0))
                    .addStatement(
                        """
                        return $T._facets.stream()
                          .filter(spec -> !spec.isBatched())
                          .collect($T.toImmutableSet())
                        """,
                        currentVajramInfo.facetsInterfaceType(),
                        ImmutableSet.class)
                    .build())
            .addMethod(
                overriding(util.codegenUtil().getMethod(FacetValuesContainer.class, "_vajramID", 0))
                    .addStatement("return $T." + VAJRAM_ID_CONSTANT_NAME, getRequestInterfaceType())
                    .build());

    for (FacetGenModel facet : commonFacets) {
      CodeGenParams codeGenParams =
          CodeGenParams.builder().isSubsetCommon(true).withImpl(true).build();
      FacetJavaType returnType = util.getFacetReturnType(facet, codeGenParams);
      MethodSpec.Builder getter =
          methodBuilder(facet.name())
              .returns(
                  returnType
                      .javaTypeName(facet)
                      .annotated(annotations(returnType.typeAnnotations(facet, codeGenParams))))
              .addStatement(returnType.fieldGetterCode(facet, codeGenParams));
      if (facet.isGiven()) {
        getter.addAnnotation(Include.class);
      }
      commonImmutFacetsClass.addMethod(getter.build());
    }

    util.codegenUtil()
        .generateSourceFile(
            batchItemsIfaceType.canonicalName(),
            JavaFile.builder(packageName, batchItemsIface.build()).build().toString(),
            currentVajramInfo.vajramClassElem());
    util.codegenUtil()
        .generateSourceFile(
            commonImmutFacetsType.canonicalName(),
            JavaFile.builder(packageName, commonImmutFacetsClass.build()).build().toString(),
            currentVajramInfo.vajramClassElem());
  }

  private ClassName getRequestInterfaceType() {
    return ClassName.get(packageName, getRequestInterfaceName(vajramName));
  }

  private ClassName getBatchItemIfaceName() {
    return ClassName.get(packageName, vajramName + BATCH_ITEM_FACETS_SUFFIX);
  }

  private ClassName getCommonFacetsClassName() {
    return ClassName.get(packageName, vajramName + BATCH_KEY_FACETS_SUFFIX);
  }

  private void codegenBatchableFacets(TypeSpec.Builder allFacetsType, CodeGenParams codeGenParams) {
    MethodSpec.Builder batchElementMethod =
        overriding(util.codegenUtil().getMethod(BatchEnabledFacetValues.class, "_batchItem", 0))
            .returns(getBatchItemIfaceName());
    MethodSpec.Builder commonMethod =
        overriding(util.codegenUtil().getMethod(BatchEnabledFacetValues.class, BATCH_KEY_NAME, 0))
            .returns(getCommonFacetsClassName());
    if (codeGenParams.withImpl()) {
      batchElementMethod.addStatement("return $T._fromFacets(this)", getBatchItemIfaceName());
      commonMethod.addStatement("return new $T(this)", getCommonFacetsClassName());
    } else {
      batchElementMethod.addModifiers(ABSTRACT);
      commonMethod.addModifiers(ABSTRACT);
    }
    allFacetsType.addMethod(batchElementMethod.build()).addMethod(commonMethod.build());
  }

  private void facetConstants(
      TypeSpec.Builder classBuilder,
      List<? extends FacetGenModel> facetValues,
      CodeGenParams codeGenParams) {
    List<FieldSpec> specFields = new ArrayList<>(facetValues.size());
    List<FieldSpec> idFields = new ArrayList<>();
    int facetCount = 0;
    for (FacetGenModel facet : facetValues) {
      facetCount++;
      String facetDoc = facet.documentation();
      FieldSpec facetIdField =
          FieldSpec.builder(String.class, facet.name() + FACET_NAME_SUFFIX)
              .addModifiers(PUBLIC, STATIC, FINAL)
              .initializer("$S", vajramName + QUALIFIED_FACET_SEPARATOR + facet.name())
              .addJavadoc(facetDoc != null ? CodeBlock.of(facetDoc) : EMPTY_CODE_BLOCK)
              .build();

      idFields.add(facetIdField);

      CodeGenType dataType = util.getDataType(facet);
      TypeAndName facetType = util.codegenUtil().getTypeName(dataType);
      TypeAndName boxedFacetType = util.codegenUtil().box(facetType);
      ClassName vajramReqClass = getRequestInterfaceType();
      ClassName specType =
          ClassName.get(
              codeGenParams.isRequest()
                  ? InputMirrorSpec.class
                  : facet instanceof DependencyModel vajramDepDef
                      ? vajramDepDef.canFanout()
                          ? vajramDepDef.isMandatoryOnServer()
                              ? MandatoryFanoutDepSpec.class
                              : OptionalFanoutDepSpec.class
                          : vajramDepDef.isMandatoryOnServer()
                              ? MandatoryOne2OneDepSpec.class
                              : OptionalOne2OneDepSpec.class
                      : facet.isMandatoryOnServer()
                          ? MandatoryFacetDefaultSpec.class
                          : OptionalFacetDefaultSpec.class);
      List<TypeName> collectClassNames = new ArrayList<>();
      FieldSpec.Builder fieldSpec =
          FieldSpec.builder(
                  facet instanceof DependencyModel vajramDepDef
                      ? ParameterizedTypeName.get(
                          specType,
                          boxedFacetType.typeName(),
                          vajramReqClass,
                          vajramDepDef.depReqClassName())
                      : ParameterizedTypeName.get(
                          specType, boxedFacetType.typeName(), vajramReqClass),
                  facet.name() + FACET_SPEC_SUFFIX)
              .addModifiers(PUBLIC, STATIC, FINAL)
              .addAnnotation(
                  AnnotationSpec.builder(FacetIdNameMapping.class)
                      .addMember("id", "$L", facet.id())
                      .addMember("name", "$S", facet.name())
                      .build());

      CodeBlock.Builder initializerCodeBlock = CodeBlock.builder();
      CodeGenType javaType = facet.dataType();
      initializerCodeBlock
          .add(
              """
                  new $T<>(
                    $L,
                    $S,
                    $T.$L,
                  """,
              specType,
              facet.id(),
              facet.name(),
              getRequestInterfaceType(),
              VAJRAM_ID_CONSTANT_NAME)
          .add(
              util.codegenUtil().getJavaTypeCreationCode(javaType, collectClassNames) + ",",
              collectClassNames.toArray());
      if (facet instanceof DefaultFacetModel && !codeGenParams.isRequest()) {
        if (!DEPENDENCY.equals(facet.facetType())) {
          initializerCodeBlock.add("$T.$L,", FacetType.class, facet.facetType().name());
        }
      }
      initializerCodeBlock.add(
          """
                $T.class,
              """,
          vajramReqClass);
      if (facet instanceof DependencyModel vajramDepDef) {
        ClassName depReqInterfaceClass =
            ClassName.get(
                vajramDepDef.depReqPackageName(),
                getRequestInterfaceName(vajramDepDef.depVajramInfo().vajramId().id()));
        initializerCodeBlock.add(
            """
                  $T.class,
                  $T.$L,
                """,
            vajramDepDef.depReqClassName(),
            depReqInterfaceClass,
            VAJRAM_ID_CONSTANT_NAME);
      }
      String docComment = util.processingEnv().getElementUtils().getDocComment(facet.facetField());
      if (docComment == null) {
        docComment = "";
      }
      initializerCodeBlock.add("$S,", docComment);
      if (codeGenParams.isRequest()) {
        VajramInfoLite conformsToTraitInfoOrSelf = currentVajramInfo.conformsToTraitOrSelf();
        initializerCodeBlock.add(
            """
                  $T.fieldTagsParser(() -> $T.class.getDeclaredField($S)),
                  _request -> (($T)_request).$L(),
                  (_request, _value) -> {
                    if(_value != null) {
                      (($T) _request).$L(_value);
                    }
                  }
                )
                """,
            FacetUtils.class,
            getRequestInterfaceType(),
            facet.name() + FACET_SPEC_SUFFIX,
            conformsToTraitInfoOrSelf.requestInterfaceClassName(),
            facet.name(),
            conformsToTraitInfoOrSelf.reqImmutInterfaceType().nestedClass("Builder"),
            facet.name());
        fieldSpec.addAnnotations(
            facet.facetField().getAnnotationMirrors().stream()
                .filter(
                    annotationMirror ->
                        annotationMirror
                                .getAnnotationType()
                                .asElement()
                                .getAnnotation(Documented.class)
                            != null)
                .map(AnnotationSpec::get)
                .toList());
      } else {
        initializerCodeBlock.add(
            """
                    $L,
                    $T.fieldTagsParser(
                      () -> $T.$L.class.getDeclaredField($S),
                      () -> $T.class.getDeclaredField($S)),
                    _facetValues -> (($T)_facetValues).$L(),
                    (_facetValues, _value) -> {
                      if(_value != null) {
                        (($T) _facetValues).$L(_value);
                      }
                    }
                  )
                """,
            facet.facetField().getAnnotation(Batched.class) != null,
            FacetUtils.class,
            currentVajramInfo.vajramClassElem(),
            facet.facetType().equals(INPUT) ? _INPUTS_CLASS : _INTERNAL_FACETS_CLASS,
            facet.name(),
            currentVajramInfo.facetsInterfaceType(),
            facet.name() + FACET_SPEC_SUFFIX,
            currentVajramInfo.facetsInterfaceType(),
            facet.name(),
            ClassName.get(packageName, getImmutFacetsClassName(vajramName), "Builder"),
            facet.name());
        if (facet instanceof DependencyModel dep && dep.depVajramInfo().isTrait()) {
          fieldSpec.addAnnotation(TraitDependency.class);
        }
      }
      specFields.add(fieldSpec.initializer(initializerCodeBlock.build()).build());
    }
    for (int i = 0; i < facetCount; i++) {
      classBuilder.addField(idFields.get(i)).addField(specFields.get(i));
    }

    ParameterizedTypeName facetsFieldType =
        ParameterizedTypeName.get(
            ClassName.get(ImmutableSet.class),
            WildcardTypeName.subtypeOf(
                ParameterizedTypeName.get(
                    codeGenParams.isRequest()
                        ? ClassName.get(InputMirrorSpec.class)
                        : ClassName.get(FacetSpec.class),
                    WildcardTypeName.subtypeOf(Object.class),
                    WildcardTypeName.subtypeOf(getRequestInterfaceType()))));
    FieldSpec facetsField =
        FieldSpec.builder(facetsFieldType, "_facets", PUBLIC, STATIC, FINAL)
            .initializer(
                specFields.stream()
                    .map(specField -> "$N")
                    .collect(Collectors.joining(", ", "$T.of(", ")")),
                Stream.concat(Stream.of(ImmutableSet.class), specFields.stream()).toArray())
            .build();
    classBuilder.addField(facetsField);

    classBuilder.addMethod(
        overriding(util.codegenUtil().getMethod(FacetValuesContainer.class, "_facets", 0))
            .addModifiers(PUBLIC, DEFAULT)
            .returns(facetsFieldType)
            .addStatement("return $N", facetsField)
            .build());
  }

  ImmutableSet<FacetGenModel> getResolverSources(ExecutableElement resolve) {
    return resolve.getParameters().stream().map(this::inferFacet).collect(toImmutableSet());
  }
}
