/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.processor;

import com.flipkart.krystal.codegen.common.models.AbstractKrystalAnnoProcessor;
import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.codegen.common.spi.ModelsCodeGeneratorProvider;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.vajram.codegen.processor.Constants;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"com.flipkart.krystal.model.ModelRoot"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@SupportedOptions(value={"krystal.codegen.phase"})
@AutoService(value={Processor.class})
public final class ModelGenProcessor
extends AbstractKrystalAnnoProcessor {
    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        CodeGenUtility util = this.codeGenUtil();
        List<TypeElement> modelRoots = roundEnv.getElementsAnnotatedWith(ModelRoot.class).stream().filter(element -> element.getKind() == ElementKind.INTERFACE).map(executableElement -> (TypeElement)executableElement).toList();
        util.note((CharSequence)"Model Roots received by %s: %s".formatted(((Object)((Object)this)).getClass().getSimpleName(), modelRoots.stream().map(Objects::toString).collect(Collectors.joining(System.lineSeparator(), "[" + System.lineSeparator(), System.lineSeparator() + "]"))));
        Iterable codeGeneratorProviders = Iterables.concat(List.of(Constants.DEFAULT_MODELS_CODEGEN_PROVIDER), ServiceLoader.load(ModelsCodeGeneratorProvider.class, ((Object)((Object)this)).getClass().getClassLoader()));
        for (TypeElement modelRoot : modelRoots) {
            ModelsCodeGenContext creationContext = new ModelsCodeGenContext(modelRoot, util, this.codegenPhase());
            for (ModelsCodeGeneratorProvider customCodeGeneratorProvider : codeGeneratorProviders) {
                try {
                    customCodeGeneratorProvider.create(creationContext).generate();
                }
                catch (Exception e) {
                    util.error(Throwables.getStackTraceAsString((Throwable)e), new Element[]{creationContext.modelRootType()});
                }
            }
        }
        return false;
    }
}

