/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.plugin;

import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import java.io.File;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.artifacts.ResolvableConfiguration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;

public class VajramPlugin
implements Plugin<Project> {
    static final String EMPTY_DIR = "tmp/empty";
    static final String SRC_GEN_DIR = "/generated/sources/annotationProcessor/java";
    static final String VAJRAM_MODELS_GEN_DIR = "/generated/sources/vajramModels/java";
    static final String MAIN_SRC_DIR = "src/main/java";
    static final String TEST_SRC_DIR = "src/test/java";
    public static final String KRYSTAL_MODELS_GEN = "krystalModelsGen";
    public static final String KRYSTAL_MODELS_GEN_PROC = "krystalModelsGenProcessor";
    public static final String KRYSTAL_MODELS_GEN_PROC_PATH = "krystalModelsGenProcessorPath";

    public void apply(Project project) {
        File mainModelsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/vajramModels/java/main");
        File mainImplsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/annotationProcessor/java/main");
        File testModelsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/vajramModels/java/test");
        File testImplsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/annotationProcessor/java/test");
        VajramPlugin.addSourceSets(project, mainModelsGenDir, mainImplsGenDir, testModelsGenDir, testImplsGenDir);
        VajramPlugin.registerKrystalModelsGen(project, mainModelsGenDir);
        VajramPlugin.configureCompileJava(project);
        VajramPlugin.registerTestKrystalModelsGen(project, testModelsGenDir);
        project.getTasks().named("jar").configure(task -> task.dependsOn(new Object[]{"compileJava"}));
        project.getTasks().withType(Test.class).named("test").configure(task -> task.systemProperty("krystal.krystex.risky.openAllVajramsToExternalInvocation", (Object)true));
    }

    private static void addSourceSets(Project project, File mainModelsGenDir, File mainImplsGenDir, File testModelsGenDir, File testImplsGenDir) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        if (javaPluginExtension == null) {
            return;
        }
        SourceSetContainer sourceSets = javaPluginExtension.getSourceSets();
        ((SourceSet)sourceSets.getByName("main")).getJava().srcDir((Object)mainModelsGenDir).srcDir((Object)mainImplsGenDir);
        ((SourceSet)sourceSets.getByName("test")).getJava().srcDir((Object)testModelsGenDir).srcDir((Object)testImplsGenDir);
    }

    private static void registerKrystalModelsGen(Project project, File mainModelsGenDir) {
        DependencyScopeConfiguration krystalModelsGenProcessor = (DependencyScopeConfiguration)project.getConfigurations().dependencyScope(KRYSTAL_MODELS_GEN_PROC).get();
        ResolvableConfiguration krystalModelsGenProcessorPath = (ResolvableConfiguration)project.getConfigurations().resolvable(KRYSTAL_MODELS_GEN_PROC_PATH, f -> f.extendsFrom(new Configuration[]{krystalModelsGenProcessor})).get();
        project.getConfigurations().getByName("annotationProcessor", annotationProcessor -> annotationProcessor.extendsFrom(new Configuration[]{krystalModelsGenProcessorPath}));
        project.getTasks().register(KRYSTAL_MODELS_GEN, JavaCompile.class, task -> {
            task.setGroup("krystal");
            task.source(new Object[]{MAIN_SRC_DIR});
            task.setClasspath((FileCollection)project.getConfigurations().getByName("compileClasspath"));
            task.getDestinationDirectory().set((Provider)project.getObjects().directoryProperty().fileValue(VajramPlugin.getBuildDir(project).toPath().resolve(EMPTY_DIR).toFile()));
            task.getOptions().getGeneratedSourceOutputDirectory().fileValue(project.file((Object)mainModelsGenDir));
            task.getOptions().getCompilerArgs().addAll(List.of("-proc:only", "-Akrystal.codegen.phase=" + String.valueOf(CodegenPhase.MODELS)));
        }).configure(krystalModelsGen -> krystalModelsGen.doFirst(_t -> krystalModelsGen.getOptions().setAnnotationProcessorPath((FileCollection)project.getConfigurations().named(KRYSTAL_MODELS_GEN_PROC_PATH).get())));
    }

    private static void configureCompileJava(Project project) {
        project.getTasks().named("compileJava", JavaCompile.class).configure(task -> {
            task.dependsOn(new Object[]{KRYSTAL_MODELS_GEN});
            task.getOptions().getCompilerArgs().addAll(List.of("-Akrystal.codegen.phase=" + String.valueOf(CodegenPhase.FINAL), "-parameters"));
        });
    }

    private static void registerTestKrystalModelsGen(Project project, File testModelsGenDir) {
        DependencyScopeConfiguration testKrystalModelsGenProcessor = (DependencyScopeConfiguration)project.getConfigurations().dependencyScope("test" + VajramPlugin.capitalizeFirstChar(KRYSTAL_MODELS_GEN_PROC)).get();
        String testModelGenProcessorPath = "test" + VajramPlugin.capitalizeFirstChar(KRYSTAL_MODELS_GEN_PROC_PATH);
        ResolvableConfiguration testKrystalModelsGenProcessorPath = (ResolvableConfiguration)project.getConfigurations().resolvable(testModelGenProcessorPath, f -> f.extendsFrom(new Configuration[]{testKrystalModelsGenProcessor})).get();
        project.getConfigurations().getByName("testAnnotationProcessor", annotationProcessor -> annotationProcessor.extendsFrom(new Configuration[]{testKrystalModelsGenProcessorPath}));
        project.getTasks().register("test" + VajramPlugin.capitalizeFirstChar(KRYSTAL_MODELS_GEN), JavaCompile.class, task -> {
            task.setGroup("krystal");
            task.mustRunAfter(new Object[]{task.getProject().getTasks().getByName("compileJava")});
            task.source(new Object[]{MAIN_SRC_DIR, TEST_SRC_DIR});
            task.setClasspath(project.getConfigurations().getByName("compileClasspath").plus((FileCollection)project.getConfigurations().getByName("testCompileClasspath")));
            task.getDestinationDirectory().set((Provider)project.getObjects().directoryProperty().fileValue(VajramPlugin.getBuildDir(project).toPath().resolve(EMPTY_DIR).toFile()));
            task.getOptions().getGeneratedSourceOutputDirectory().fileValue(project.file((Object)testModelsGenDir));
            task.getOptions().getCompilerArgs().addAll(List.of("-proc:only", "-Akrystal.codegen.phase=" + String.valueOf(CodegenPhase.MODELS)));
        }).configure(testKrystalModelsGen -> testKrystalModelsGen.doFirst(_t -> testKrystalModelsGen.getOptions().setAnnotationProcessorPath((FileCollection)project.getConfigurations().named(testModelGenProcessorPath).get())));
    }

    private static @NonNull String capitalizeFirstChar(String krystalModelsGen) {
        return krystalModelsGen.substring(0, 1).toUpperCase() + krystalModelsGen.substring(1);
    }

    private static File getBuildDir(Project project) {
        return (File)project.getLayout().getBuildDirectory().getAsFile().get();
    }
}

