/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.plugin;

import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;

public class VajramPlugin
implements Plugin<Project> {
    static final String EMPTY_DIR = "tmp/empty";
    static final String SRC_GEN_DIR = "/generated/sources/annotationProcessor/java";
    static final String VAJRAM_MODELS_GEN_DIR = "/generated/sources/vajramModels/java";
    static final String MAIN_SRC_DIR = "src/main/java";
    static final String TEST_SRC_DIR = "src/test/java";

    public void apply(Project project) {
        File mainModelsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/vajramModels/java/main");
        File mainImplsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/annotationProcessor/java/main");
        File testModelsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/vajramModels/java/test");
        File testImplsGenDir = new File(VajramPlugin.getBuildDir(project).getPath() + "/generated/sources/annotationProcessor/java/test");
        VajramPlugin.addSourceSets(project, mainModelsGenDir, mainImplsGenDir, testModelsGenDir, testImplsGenDir);
        VajramPlugin.registerCodeGenVajramModels(project, mainModelsGenDir);
        VajramPlugin.configureCompileJava(project);
        VajramPlugin.registerTestCodeGenVajramModels(project, testModelsGenDir);
        project.getTasks().named("jar").configure(task -> task.dependsOn(new Object[]{"compileJava"}));
        project.getTasks().withType(Test.class).named("test").configure(task -> task.systemProperty("krystal.krystex.risky.openAllVajramsToExternalInvocation", (Object)true));
    }

    private static void addSourceSets(Project project, File mainModelsGenDir, File mainImplsGenDir, File testModelsGenDir, File testImplsGenDir) {
        SourceSetContainer sourceSets = ((JavaPluginExtension)Preconditions.checkNotNull((Object)((JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class)))).getSourceSets();
        ((SourceSet)sourceSets.getByName("main")).getJava().srcDir((Object)mainModelsGenDir).srcDir((Object)mainImplsGenDir);
        ((SourceSet)sourceSets.getByName("test")).getJava().srcDir((Object)testModelsGenDir).srcDir((Object)testImplsGenDir);
    }

    private static void registerCodeGenVajramModels(Project project, File mainModelsGenDir) {
        project.getTasks().register("codeGenVajramModels", JavaCompile.class, task -> {
            task.setGroup("krystal");
            task.source(new Object[]{MAIN_SRC_DIR});
            task.setClasspath((FileCollection)project.getConfigurations().getByName("compileClasspath"));
            task.getDestinationDirectory().set((Provider)project.getObjects().directoryProperty().fileValue(VajramPlugin.getBuildDir(project).toPath().resolve(EMPTY_DIR).toFile()));
            task.getOptions().setAnnotationProcessorPath(((JavaCompile)project.getTasks().named("compileJava", JavaCompile.class).get()).getOptions().getAnnotationProcessorPath());
            task.getOptions().getGeneratedSourceOutputDirectory().fileValue(project.file((Object)mainModelsGenDir));
            task.getOptions().getCompilerArgs().addAll(List.of("-proc:only", "-Akrystal.codegen.phase=" + CodegenPhase.MODELS));
        });
    }

    private static void configureCompileJava(Project project) {
        project.getTasks().named("compileJava", JavaCompile.class).configure(task -> {
            task.dependsOn(new Object[]{"codeGenVajramModels"});
            task.getOptions().getCompilerArgs().addAll(List.of("-Akrystal.codegen.phase=" + CodegenPhase.FINAL, "-parameters"));
        });
    }

    private static void registerTestCodeGenVajramModels(Project project, File testModelsGenDir) {
        project.getTasks().register("testCodeGenVajramModels", JavaCompile.class, task -> {
            task.setGroup("krystal");
            task.mustRunAfter(new Object[]{task.getProject().getTasks().getByName("compileJava")});
            task.source(new Object[]{MAIN_SRC_DIR, TEST_SRC_DIR});
            task.setClasspath(project.getConfigurations().getByName("compileClasspath").plus((FileCollection)project.getConfigurations().getByName("testCompileClasspath")));
            task.getDestinationDirectory().set((Provider)project.getObjects().directoryProperty().fileValue(VajramPlugin.getBuildDir(project).toPath().resolve(EMPTY_DIR).toFile()));
            task.getOptions().setAnnotationProcessorPath(((JavaCompile)project.getTasks().named("compileTestJava", JavaCompile.class).get()).getOptions().getAnnotationProcessorPath());
            task.getOptions().getGeneratedSourceOutputDirectory().fileValue(project.file((Object)testModelsGenDir));
            task.getOptions().getCompilerArgs().addAll(List.of("-proc:only", "-Akrystal.codegen.phase=" + CodegenPhase.MODELS));
        });
    }

    private static File getBuildDir(Project project) {
        return (File)project.getLayout().getBuildDirectory().getAsFile().get();
    }
}

