/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.flipkart.krystal.vajram.DependencyResponse;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.codegen.models.AbstractInput;
import com.flipkart.krystal.vajram.codegen.models.DependencyDef;
import com.flipkart.krystal.vajram.codegen.models.InputDef;
import com.flipkart.krystal.vajram.codegen.models.VajramDependencyDef;
import com.flipkart.krystal.vajram.codegen.models.VajramInputFile;
import com.flipkart.krystal.vajram.codegen.models.VajramInputsDef;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajram.modulation.UnmodulatedInput;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.ToString;

public class VajramCodeGenerator {
    private final String packageName;
    private final String requestClassName;
    private final VajramInputFile vajramInputFile;
    private final String allInputsClassName;
    private final String vajramName;

    public VajramCodeGenerator(VajramInputFile vajramInputFile) {
        this.vajramInputFile = vajramInputFile;
        Path filePath = vajramInputFile.srcRelativeFilePath();
        Path parentDir = filePath.getParent();
        this.vajramName = vajramInputFile.vajramName();
        this.packageName = IntStream.range(0, parentDir.getNameCount()).mapToObj(i -> parentDir.getName(i).toString()).collect(Collectors.joining("."));
        this.requestClassName = VajramCodeGenerator.getRequestClassName(this.vajramName);
        this.allInputsClassName = "AllInputs";
    }

    private static String getRequestClassName(String vajramName) {
        return (vajramName.toLowerCase().endsWith("vajram") ? vajramName.substring(0, vajramName.length() - 6) : vajramName) + "Request";
    }

    public String codeGenVajramRequest() {
        VajramInputsDef vajramInputsDef = this.vajramInputFile.vajramInputsDef();
        ImmutableList<InputDef> inputDefs = vajramInputsDef.inputs();
        MethodSpec.Builder requestConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        ClassName builderClassType = ClassName.get((String)(this.packageName + "." + this.requestClassName), (String)"Builder", (String[])new String[0]);
        TypeSpec.Builder requestClass = TypeSpec.classBuilder((String)this.requestClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(VajramRequest.class).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)builderClassType).addStatement("return new Builder()", new Object[0]).build());
        TypeSpec.Builder builderClass = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(EqualsAndHashCode.class).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        LinkedHashSet<String> inputNames = new LinkedHashSet<String>();
        for (InputDef input : inputDefs) {
            Input<?> inputDefinition = input.toInputDefinition();
            if (!inputDefinition.sources().contains(InputSource.CLIENT)) continue;
            String inputJavaName = VajramCodeGenerator.toJavaName(input.getName());
            inputNames.add(inputJavaName);
            TypeAndName javaType = VajramCodeGenerator.getTypeName(inputDefinition.type());
            requestClass.addField(FieldSpec.builder((TypeName)VajramCodeGenerator.wrapPrimitive(javaType).typeName(), (String)inputJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            builderClass.addField(FieldSpec.builder((TypeName)javaType.typeName(), (String)inputJavaName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            requestConstructor.addParameter(ParameterSpec.builder((TypeName)javaType.typeName(), (String)inputJavaName, (Modifier[])new Modifier[0]).build());
            requestConstructor.addStatement("this.$L = $L", new Object[]{inputJavaName, inputJavaName});
            requestClass.addMethod(VajramCodeGenerator.getterCodeForInput(input, inputJavaName, javaType));
            builderClass.addMethod(MethodSpec.methodBuilder((String)inputJavaName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(javaType.typeName()).addStatement("return this.$L", new Object[]{inputJavaName}).build());
            builderClass.addMethod(MethodSpec.methodBuilder((String)inputJavaName).returns((TypeName)builderClassType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)javaType.typeName(), (String)inputJavaName, (Modifier[])new Modifier[0]).build()).addStatement("this.$L = $L", new Object[]{inputJavaName, inputJavaName}).addStatement("return this", new Object[]{inputJavaName}).build());
        }
        builderClass.addMethod(MethodSpec.methodBuilder((String)"build").returns((TypeName)ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return new %s(%s)".formatted(this.requestClassName, String.join((CharSequence)", ", inputNames)), new Object[0]).build());
        StringWriter writer = new StringWriter();
        FromAndTo fromAndTo = this.fromAndToMethods(inputDefs.stream().filter(inputDef -> inputDef.toInputDefinition().sources().contains(InputSource.CLIENT)).toList(), ClassName.get((String)this.packageName, (String)this.requestClassName, (String[])new String[0]));
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)requestClass.addMethod(requestConstructor.build()).addMethod(fromAndTo.from()).addMethod(fromAndTo.to()).addType(builderClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static TypeAndName wrapPrimitive(TypeAndName javaType) {
        Type type;
        if (javaType.type().isPresent() && (type = javaType.type().get()) instanceof Class) {
            Class clazz = (Class)type;
            Class wrapped = Primitives.wrap((Class)clazz);
            return new TypeAndName((TypeName)ClassName.get((Class)wrapped), Optional.of(wrapped));
        }
        return javaType;
    }

    private static TypeAndName unwrapPrimitive(TypeAndName javaType) {
        Type type;
        if (javaType.type().isPresent() && (type = javaType.type().get()) instanceof Class) {
            Class clazz = (Class)type;
            Class unwrapped = Primitives.unwrap((Class)clazz);
            return new TypeAndName(TypeName.get((Type)unwrapped), Optional.of(unwrapped));
        }
        return javaType;
    }

    private FromAndTo fromAndToMethods(List<? extends AbstractInput> inputDefs, ClassName enclosingClass) {
        MethodSpec.Builder toInputValues = MethodSpec.methodBuilder((String)"toInputValues").returns(Inputs.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("$T builder = new $T<>()", new Object[]{new TypeToken<Map<String, InputValue<Object>>>(){}.getType(), new TypeToken<HashMap>(){}.getType()});
        MethodSpec.Builder fromInputValues = MethodSpec.methodBuilder((String)"from").returns((TypeName)enclosingClass).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(Inputs.class, "values", new Modifier[0]);
        for (AbstractInput abstractInput : inputDefs) {
            String inputJavaName = VajramCodeGenerator.toJavaName(abstractInput.getName());
            toInputValues.addStatement("builder.put($S, $T.withValue($L()))", new Object[]{abstractInput.getName(), ValueOrError.class, inputJavaName});
        }
        toInputValues.addStatement("return new $T(builder)", new Object[]{Inputs.class});
        List<String> inputNames = inputDefs.stream().map(AbstractInput::getName).toList();
        fromInputValues.addStatement("return new $T(%s)".formatted(inputNames.stream().map(s -> "values.getInputValueOrDefault($S, null)").collect(Collectors.joining(", "))), Stream.concat(Stream.of(enclosingClass), inputNames.stream()).toArray());
        return new FromAndTo(fromInputValues.build(), toInputValues.build());
    }

    private static TypeAndName getTypeName(DataType dataType) {
        if (dataType instanceof JavaType) {
            ClassName className;
            JavaType javaType = (JavaType)dataType;
            Optional simpleName = javaType.simpleName();
            if (simpleName.isPresent()) {
                List<String> classNames = Stream.concat(javaType.enclosingClasses().stream(), Stream.of((String)simpleName.get())).toList();
                className = ClassName.get((String)javaType.packageName().orElse(""), (String)classNames.get(0), (String[])((String[])classNames.subList(1, classNames.size()).toArray(String[]::new)));
            } else {
                className = ClassName.bestGuess((String)javaType.className());
            }
            if (javaType.typeParameters().size() > 0) {
                return new TypeAndName((TypeName)ParameterizedTypeName.get((ClassName)className, (TypeName[])((TypeName[])javaType.typeParameters().stream().map(VajramCodeGenerator::getTypeName).map(TypeAndName::typeName).toArray(TypeName[]::new))));
            }
            return new TypeAndName((TypeName)className);
        }
        Optional javaType = TypeUtils.getJavaType((DataType)dataType);
        return new TypeAndName(javaType.map(type -> {
            Type type2;
            if (type instanceof Class) {
                Class clazz = (Class)type;
                type2 = Primitives.wrap((Class)clazz);
            } else {
                type2 = type;
            }
            return type2;
        }).map(TypeName::get).orElseThrow(() -> {
            throw new IllegalArgumentException("Could not determine java Type of %s".formatted(dataType));
        }), javaType);
    }

    private static MethodSpec getterCodeForInput(AbstractInput input, String name, TypeAndName typeAndName) {
        boolean wrapWithOptional = input instanceof InputDef && !input.isMandatory();
        return MethodSpec.methodBuilder((String)name).returns(wrapWithOptional ? VajramCodeGenerator.optional(VajramCodeGenerator.wrapPrimitive(typeAndName).typeName()) : VajramCodeGenerator.unwrapPrimitive(typeAndName).typeName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(wrapWithOptional ? CodeBlock.builder().addStatement("return $T.ofNullable(this.$L)", new Object[]{Optional.class, name}).build() : CodeBlock.builder().addStatement("return this.$L", new Object[]{name}).build()).build();
    }

    public String codeGenInputUtil() {
        boolean doInputsNeedModulation = this.vajramInputFile.vajramInputsDef().allInputsDefinitions().stream().anyMatch(VajramInputDefinition::needsModulation);
        if (doInputsNeedModulation) {
            return this.codeGenModulatedInputUtil();
        }
        return this.codeGenSimpleInputUtil();
    }

    private String codeGenSimpleInputUtil() {
        TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
        TypeSpec.Builder allInputsClass = TypeSpec.classBuilder((String)this.allInputsClassName).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC}).addAnnotations(VajramCodeGenerator.recordAnnotations());
        VajramInputsDef vajramInputsDef = this.vajramInputFile.vajramInputsDef();
        vajramInputsDef.inputs().forEach(inputDef -> {
            String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.getName());
            TypeAndName javaType = VajramCodeGenerator.getTypeName(inputDef.toInputDefinition().type());
            allInputsClass.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            allInputsClass.addMethod(VajramCodeGenerator.getterCodeForInput(inputDef, inputJavaName, javaType));
        });
        vajramInputsDef.dependencies().forEach(dependencyDef -> VajramCodeGenerator.addDependencyOutputs(allInputsClass, dependencyDef));
        StringWriter writer = new StringWriter();
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(allInputsClass.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static void addDependencyOutputs(TypeSpec.Builder enclosingClass, DependencyDef dependencyDef) {
        String inputJavaName = VajramCodeGenerator.toJavaName(dependencyDef.getName());
        if (dependencyDef instanceof VajramDependencyDef) {
            VajramDependencyDef vajramDepSpec = (VajramDependencyDef)dependencyDef;
            String depVajramClass = vajramDepSpec.getVajramClass();
            int lastDotIndex = depVajramClass.lastIndexOf(46);
            String depRequestClass = VajramCodeGenerator.getRequestClassName(depVajramClass.substring(lastDotIndex + 1));
            String depPackageName = depVajramClass.substring(0, lastDotIndex);
            ParameterizedTypeName javaType = ParameterizedTypeName.get((ClassName)ClassName.get(DependencyResponse.class), (TypeName[])new TypeName[]{ClassName.get((String)depPackageName, (String)depRequestClass, (String[])new String[0]), VajramCodeGenerator.getTypeName(vajramDepSpec.toDataType()).typeName()});
            enclosingClass.addField((TypeName)javaType, inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            enclosingClass.addMethod(VajramCodeGenerator.getterCodeForInput(dependencyDef, inputJavaName, new TypeAndName((TypeName)javaType)));
        }
    }

    private String codeGenModulatedInputUtil() {
        StringWriter writer = new StringWriter();
        try {
            TypeSpec.Builder inputUtilClass = this.createInputUtilClass();
            VajramInputsDef vajramInputsDef = this.vajramInputFile.vajramInputsDef();
            String imClassName = "InputsNeedingModulation";
            String ciClassName = "CommonInputs";
            FromAndTo imFromAndTo = this.fromAndToMethods(vajramInputsDef.inputs().stream().filter(InputDef::isNeedsModulation).toList(), ClassName.get((String)this.packageName, (String)this.getInputUtilClassName(), (String[])new String[]{imClassName}));
            TypeSpec.Builder inputsNeedingModulation = TypeSpec.classBuilder((String)imClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(InputValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(imFromAndTo.to()).addMethod(imFromAndTo.from());
            FromAndTo ciFromAndTo = this.fromAndToMethods(Stream.concat(vajramInputsDef.inputs().stream().filter(i -> !i.isNeedsModulation()), vajramInputsDef.dependencies().stream()).toList(), ClassName.get((String)this.packageName, (String)this.getInputUtilClassName(), (String[])new String[]{ciClassName}));
            TypeSpec.Builder commonInputs = TypeSpec.classBuilder((String)ciClassName).addModifiers(new Modifier[]{Modifier.STATIC}).addSuperinterface(InputValuesAdaptor.class).addAnnotations(VajramCodeGenerator.recordAnnotations()).addMethod(ciFromAndTo.to()).addMethod(ciFromAndTo.from());
            ClassName imType = ClassName.get((String)this.packageName, (String)this.getInputUtilClassName(), (String[])new String[]{imClassName});
            ClassName ciType = ClassName.get((String)this.packageName, (String)this.getInputUtilClassName(), (String[])new String[]{ciClassName});
            vajramInputsDef.inputs().forEach(inputDef -> {
                String inputJavaName = VajramCodeGenerator.toJavaName(inputDef.getName());
                TypeAndName javaType = VajramCodeGenerator.getTypeName(inputDef.toInputDefinition().type());
                if (inputDef.isNeedsModulation()) {
                    inputsNeedingModulation.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    inputsNeedingModulation.addMethod(VajramCodeGenerator.getterCodeForInput(inputDef, inputJavaName, javaType));
                } else {
                    commonInputs.addField(javaType.typeName(), inputJavaName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
                    commonInputs.addMethod(VajramCodeGenerator.getterCodeForInput(inputDef, inputJavaName, javaType));
                }
            });
            vajramInputsDef.dependencies().forEach(dependencyDef -> VajramCodeGenerator.addDependencyOutputs(commonInputs, dependencyDef));
            ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(InputsConverter.class), (TypeName[])new TypeName[]{imType, ciType});
            CodeBlock.Builder initializer = CodeBlock.builder().add("$L", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)parameterizedTypeName).addMethod(MethodSpec.methodBuilder((String)"apply").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(UnmodulatedInput.class), (TypeName[])new TypeName[]{imType, ciType})).addParameter(Inputs.class, "inputValues", new Modifier[0]).addStatement("return new $T<>($T.from(inputValues),$T.from(inputValues))", new Object[]{UnmodulatedInput.class, imType, ciType}).build()).build()});
            FieldSpec.Builder converter = FieldSpec.builder((TypeName)parameterizedTypeName, (String)"CONVERTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer(initializer.build());
            JavaFile.builder((String)this.packageName, (TypeSpec)inputUtilClass.addType(inputsNeedingModulation.build()).addType(commonInputs.build()).addField(converter.build()).build()).build().writeTo((Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static List<AnnotationSpec> recordAnnotations() {
        return VajramCodeGenerator.annotations(EqualsAndHashCode.class, AllArgsConstructor.class, ToString.class);
    }

    private static List<AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    private TypeSpec.Builder createInputUtilClass() {
        return TypeSpec.classBuilder((String)this.getInputUtilClassName()).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
    }

    public String getRequestClassName() {
        return this.requestClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getInputUtilClassName() {
        return (this.vajramName.toLowerCase().endsWith("vajram") ? this.vajramName.substring(0, this.vajramName.length() - 6) : this.vajramName) + "InputUtil";
    }

    private static String toJavaName(String inputName) {
        if (!inputName.contains("_")) {
            return inputName;
        }
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, inputName);
    }

    private static TypeName optional(TypeName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{javaType});
    }

    private MethodSpec resolveInputOfDependency(Vajram<?> vajram) {
        return null;
    }

    private MethodSpec vajramLogic(Vajram<?> vajram) {
        String packageName = vajram.getClass().getPackageName();
        String vajramName = vajram.getClass().getSimpleName();
        JavaFile.builder((String)packageName, (TypeSpec)TypeSpec.classBuilder((String)vajramName).addMethod(this.resolveInputOfDependency(vajram)).addMethod(this.vajramLogic(vajram)).build());
        return null;
    }

    private void codeGenVajramImpl() {
        ImmutableList<VajramInputDefinition> inputDefinitions = this.vajramInputFile.vajramInputsDef().allInputsDefinitions();
    }

    private record TypeAndName(TypeName typeName, Optional<Type> type) {
        public TypeAndName(TypeName typeName) {
            this(typeName, Optional.empty());
        }
    }

    private record FromAndTo(MethodSpec from, MethodSpec to) {
    }
}

