/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen;

import com.flipkart.krystal.vajram.codegen.InputFilePath;
import com.flipkart.krystal.vajram.codegen.VajramCodeGenerator;
import com.flipkart.krystal.vajram.codegen.models.VajramInputFile;
import com.flipkart.krystal.vajram.codegen.models.VajramInputsDef;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramModelsCodeGen {
    private static final Logger log = LoggerFactory.getLogger(VajramModelsCodeGen.class);
    public static final String INPUTS_FILE_EXTENSION = ".vajram.yaml";
    private final List<Path> srcDirs;
    private final Path javaDir;

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        Option classesDirOpt = new Option("c", "classesDir", true, "Root Directory for all .class files");
        classesDirOpt.setRequired(true);
        options.addOption(classesDirOpt);
        Option javaSrcDir = new Option("j", "javaDir", true, "Root Directory for all .java files");
        javaSrcDir.setRequired(true);
        options.addOption(javaSrcDir);
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            log.error("Command line options could not be parsed", (Throwable)e);
            formatter.printHelp("Vajram Code Generator", options);
            System.exit(1);
        }
    }

    public static void codeGenModels(Set<File> srcDirs, String destinationDir) throws Exception {
        new VajramModelsCodeGen(srcDirs.stream().map(File::toPath).toList(), Path.of(destinationDir, new String[0])).codeGenModels();
    }

    public VajramModelsCodeGen(List<Path> srcDirs, Path javaDir) {
        this.srcDirs = srcDirs;
        this.javaDir = javaDir;
    }

    private void codeGenModels() throws Exception {
        ImmutableList<VajramInputFile> inputFiles = this.getInputDefinitions();
        for (VajramInputFile inputFile : inputFiles) {
            try {
                this.codeGenRequest(inputFile);
                this.codeGenUtil(inputFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate code for file %s".formatted(inputFile.srcRelativeFilePath()), e);
            }
        }
    }

    private void codeGenRequest(VajramInputFile vajramInputFile) throws IOException {
        VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator(vajramInputFile);
        File vajramJavaDir = Paths.get(this.javaDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramRequestJavaCode = vajramCodeGenerator.codeGenVajramRequest();
            File vajramImplSourceFile = new File(vajramJavaDir, vajramCodeGenerator.getRequestClassName() + ".java");
            Files.writeString(vajramImplSourceFile.toPath(), (CharSequence)vajramRequestJavaCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    private void codeGenUtil(VajramInputFile vajramInputFile) throws IOException {
        VajramCodeGenerator vajramCodeGenerator = new VajramCodeGenerator(vajramInputFile);
        File vajramJavaDir = Paths.get(this.javaDir.toString(), vajramCodeGenerator.getPackageName().split("\\.")).toFile();
        if (vajramJavaDir.isDirectory() || vajramJavaDir.mkdirs()) {
            String vajramRequestJavaCode = vajramCodeGenerator.codeGenInputUtil();
            File vajramImplSourceFile = new File(vajramJavaDir, vajramCodeGenerator.getInputUtilClassName() + ".java");
            Files.writeString(vajramImplSourceFile.toPath(), (CharSequence)vajramRequestJavaCode, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
    }

    ImmutableList<VajramInputFile> getInputDefinitions() throws Exception {
        ArrayList<VajramInputFile> vajramInputFiles = new ArrayList<VajramInputFile>();
        Set<InputFilePath> inputFiles = this.getInputsYamlFiles();
        for (InputFilePath inputFile : inputFiles) {
            String fileName = inputFile.relativeFilePath().getFileName().toString();
            String vajramName = fileName.substring(0, fileName.length() - INPUTS_FILE_EXTENSION.length());
            vajramInputFiles.add(new VajramInputFile(vajramName, inputFile.relativeFilePath(), VajramInputsDef.from(inputFile.absolutePath().toFile())));
        }
        return ImmutableList.copyOf(vajramInputFiles);
    }

    private Set<InputFilePath> getInputsYamlFiles() throws IOException {
        LinkedHashSet<InputFilePath> inputFilePaths = new LinkedHashSet<InputFilePath>();
        for (Path srcDir : this.srcDirs) {
            if (!srcDir.toFile().isDirectory()) continue;
            Stream<Path> vajramInputPathStream = Files.find(srcDir, 100, (path, fileAttributes) -> {
                if (!fileAttributes.isRegularFile()) {
                    return false;
                }
                return path.getFileName().toString().endsWith(INPUTS_FILE_EXTENSION);
            }, new FileVisitOption[0]);
            try {
                vajramInputPathStream.forEach(p -> inputFilePaths.add(new InputFilePath(srcDir, srcDir.relativize((Path)p))));
            }
            finally {
                if (vajramInputPathStream == null) continue;
                vajramInputPathStream.close();
            }
        }
        return inputFilePaths;
    }
}

