/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.vajram.annos.CallGraphDelegationMode;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.LogicMethods;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.facets.Output;
import com.flipkart.krystal.vajram.facets.resolution.Resolve;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ParsedVajramData(@Nullable LogicMethods logicMethods, String packageName, VajramInfo vajramInfo) {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParsedVajramData.class);

    public static Optional<ParsedVajramData> fromVajramInfo(VajramInfo vajramInfo, CodeGenUtility util) {
        ParsedVajramData.validate(vajramInfo, util);
        String packageName = vajramInfo.lite().packageName();
        ImmutableList<ExecutableElement> allMethods = ParsedVajramData.getAllMethods(vajramInfo.vajramClass());
        if (vajramInfo.lite().isTrait() && !allMethods.isEmpty()) {
            util.error("A trait definition must not have any methods.", vajramInfo.vajramClass());
        }
        for (ExecutableElement method : allMethods) {
            if (!ParsedVajramData.isNonBatchedOutputLogic(method) && !ParsedVajramData.isResolver(method) && !ParsedVajramData.hasAnnotation(method, Output.Batched.class) && !ParsedVajramData.hasAnnotation(method, Output.Unbatch.class) || ParsedVajramData.isStatic(method)) continue;
            util.error("@Resolve methods and @Output methods must be static", method);
        }
        LogicMethods logicMethods = null;
        if (vajramInfo.lite().isVajram()) {
            logicMethods = ParsedVajramData.getOutputLogicAndResolverMethods(vajramInfo, util);
        }
        return Optional.of(new ParsedVajramData(logicMethods, packageName, vajramInfo));
    }

    private static void validate(VajramInfo vajramInfo, CodeGenUtility util) {
        TypeElement typeElement;
        CallGraphDelegationMode callGraphDelegationMode;
        if (vajramInfo.lite().isTrait() && (callGraphDelegationMode = (typeElement = vajramInfo.lite().vajramOrReqClass()).getAnnotation(CallGraphDelegationMode.class)) == null) {
            util.error("A trait must specify a @CallGraphDelegationMode.", typeElement);
        }
    }

    public static void validateNoDuplicateResolvers(List<ExecutableElement> methods, VajramInfo vajramInfo, CodeGenUtility util) {
        HashMap<String, Map> lookUpMap = new HashMap<String, Map>();
        for (ExecutableElement method : methods) {
            Resolve resolve = method.getAnnotation(Resolve.class);
            String dep = util.extractFacetName(vajramInfo.lite().vajramId().id(), ((Resolve)Preconditions.checkNotNull((Object)resolve)).dep(), method);
            String depVajramId = vajramInfo.dependencies().stream().filter(d -> d.name().equals(dep)).findFirst().orElseThrow().depVajramInfo().vajramId().id();
            List<String> depInputNames = Arrays.stream(resolve.depInputs()).map(di -> util.extractFacetName(depVajramId, (String)di, method)).toList();
            for (String depInputName : depInputNames) {
                if (!Boolean.TRUE.equals(lookUpMap.computeIfAbsent(dep, k -> new LinkedHashMap()).put(depInputName, true))) continue;
                String errorMessage = "Two Resolver resolving same input (%s) for dependency name (%s)".formatted(depInputName, dep);
                util.error(errorMessage, method);
                throw new VajramValidationException(errorMessage);
            }
        }
    }

    private static LogicMethods getOutputLogicAndResolverMethods(VajramInfo vajramInfo, CodeGenUtility util) {
        Record outputLogics;
        ArrayList<ExecutableElement> resolverMethods = new ArrayList<ExecutableElement>();
        boolean vajramSupportsBatching = vajramInfo.facetStream().anyMatch(FacetGenModel::isBatched);
        ExecutableElement nonBatchedOutputLogic = null;
        ExecutableElement batchedOutputLogic = null;
        ExecutableElement unbatchOutputLogic = null;
        TypeElement vajramClass = vajramInfo.vajramClass();
        List<ExecutableElement> methods = ParsedVajramData.getStaticMethods(vajramClass);
        for (ExecutableElement method : methods) {
            if (ParsedVajramData.isResolver(method)) {
                resolverMethods.add(method);
                continue;
            }
            if (ParsedVajramData.isNonBatchedOutputLogic(method)) {
                if (nonBatchedOutputLogic != null) {
                    util.error("Duplicate @Output annotated method %s".formatted(method.getSimpleName()), method);
                    continue;
                }
                if (vajramSupportsBatching) {
                    util.error("Vajram which support batching must use @Output.Batched and @Output.Unbatch instead of @Output", method);
                    continue;
                }
                nonBatchedOutputLogic = method;
                continue;
            }
            if (ParsedVajramData.hasAnnotation(method, Output.Batched.class)) {
                if (batchedOutputLogic != null) {
                    util.error("Duplicate @Output.Batched annotated method %s".formatted(method.getSimpleName()), method);
                    continue;
                }
                if (!vajramSupportsBatching) {
                    util.error("Vajram which does not support batching must use @Output instead of @Output.Batched", method);
                    continue;
                }
                batchedOutputLogic = method;
                continue;
            }
            if (!ParsedVajramData.hasAnnotation(method, Output.Unbatch.class)) continue;
            if (unbatchOutputLogic != null) {
                util.error("Duplicate @Output.Unbatch annotated method", method);
                continue;
            }
            if (!vajramSupportsBatching) {
                util.error("Vajram which does not support batching must use @Output instead of @Output.Unbatch", method);
                continue;
            }
            unbatchOutputLogic = method;
        }
        if (!vajramSupportsBatching) {
            if (nonBatchedOutputLogic == null) {
                throw util.errorAndThrow("Vajram which does not support batching must have @Output annotated method", vajramClass);
            }
            outputLogics = new LogicMethods.OutputLogics.NoBatching(nonBatchedOutputLogic);
        } else {
            if (batchedOutputLogic == null || unbatchOutputLogic == null) {
                throw util.errorAndThrow("Vajram which supports batching must have @Output.Unbatch annotated method", vajramClass);
            }
            outputLogics = new LogicMethods.OutputLogics.WithBatching(batchedOutputLogic, unbatchOutputLogic);
        }
        ParsedVajramData.validateNoDuplicateResolvers(resolverMethods, vajramInfo, util);
        return new LogicMethods((LogicMethods.OutputLogics)((Object)outputLogics), (List<ExecutableElement>)resolverMethods);
    }

    private static boolean isResolver(ExecutableElement method) {
        return ParsedVajramData.hasAnnotation(method, Resolve.class);
    }

    private static boolean isNonBatchedOutputLogic(ExecutableElement method) {
        return ParsedVajramData.hasAnnotation(method, Output.class);
    }

    private static boolean hasAnnotation(ExecutableElement method, Class<? extends Annotation> annotationType) {
        return method.getAnnotationsByType(annotationType).length == 1;
    }

    private static List<ExecutableElement> getStaticMethods(TypeElement vajramClass) {
        return ParsedVajramData.getAllMethods(vajramClass).stream().filter(element -> element.getModifiers().contains((Object)Modifier.STATIC)).toList();
    }

    private static ImmutableList<ExecutableElement> getAllMethods(TypeElement vajramCalss) {
        return (ImmutableList)vajramCalss.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).map(element -> (ExecutableElement)element).collect(ImmutableList.toImmutableList());
    }

    private static boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }
}

