/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.vajram.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.vajram.codegen.common.datatypes.DataTypeRegistry;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.CodeValidationException;
import com.google.common.collect.ImmutableMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor14;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DeclaredTypeVisitor
extends AbstractTypeVisitor14<CodeGenType, Void> {
    private final CodeGenUtility util;
    private final @Nullable Element element;
    private final ImmutableMap<Class<?>, String> disallowedTypes;
    private final DataTypeRegistry dataTypeRegistry;

    public DeclaredTypeVisitor(CodeGenUtility util, @Nullable Element element) {
        this(util, element, ImmutableMap.of());
    }

    public DeclaredTypeVisitor(CodeGenUtility util, @Nullable Element element, ImmutableMap<Class<?>, String> disallowedTypes) {
        this.util = util;
        this.element = element;
        this.disallowedTypes = disallowedTypes;
        this.dataTypeRegistry = util.dataTypeRegistry();
    }

    @Override
    public CodeGenType visitDeclared(DeclaredType t, Void inputDef) {
        Element elementOfType;
        String disallowedMessage = this.util.getDisallowedMessage(t, this.disallowedTypes);
        if (disallowedMessage != null) {
            this.util.error(disallowedMessage, this.element);
        }
        if ((elementOfType = t.asElement()) instanceof QualifiedNameable) {
            QualifiedNameable qualifiedNameable = (QualifiedNameable)elementOfType;
            return this.dataTypeRegistry.create(this.util.processingEnv(), qualifiedNameable.getQualifiedName().toString(), (CodeGenType[])t.getTypeArguments().stream().map(this::visit).toArray(CodeGenType[]::new));
        }
        throw this.util.errorAndThrow("Could not infer data type for type " + elementOfType, this.element);
    }

    @Override
    public CodeGenType visitPrimitive(PrimitiveType t, Void unused) {
        PrimitiveType withoutAnnotations = this.util.processingEnv().getTypeUtils().getPrimitiveType(t.getKind());
        return this.dataTypeRegistry.create(this.util.processingEnv(), withoutAnnotations.toString(), new CodeGenType[0]);
    }

    @Override
    public CodeGenType visitArray(ArrayType t, Void unused) {
        throw this.uoe("Array types are not supported by Krystal. Use collections instead.");
    }

    @Override
    public CodeGenType visitTypeVariable(TypeVariable t, Void unused) {
        throw this.uoe();
    }

    @Override
    public CodeGenType visitNull(NullType t, Void unused) {
        throw this.uoe();
    }

    @Override
    public CodeGenType visitIntersection(IntersectionType t, Void unused) {
        throw this.uoe();
    }

    @Override
    public CodeGenType visitError(ErrorType t, Void unused) {
        throw this.uoe();
    }

    @Override
    public CodeGenType visitWildcard(WildcardType t, Void unused) {
        throw this.uoe();
    }

    @Override
    public CodeGenType visitExecutable(ExecutableType t, Void unused) {
        throw this.uoe();
    }

    @Override
    public CodeGenType visitNoType(NoType t, Void unused) {
        throw this.uoe();
    }

    @Override
    public CodeGenType visitUnion(UnionType t, Void unused) {
        throw this.uoe();
    }

    private CodeValidationException uoe(String message) {
        return this.util.errorAndThrow(message, this.element);
    }

    private CodeValidationException uoe() {
        return this.util.errorAndThrow("Unsupported operation", this.element);
    }
}

