/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.vajram.Trait;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.vajram.codegen.common.datatypes.DataTypeRegistry;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.common.models.CodeValidationException;
import com.flipkart.krystal.vajram.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.vajram.codegen.common.models.DefaultFacetModel;
import com.flipkart.krystal.vajram.codegen.common.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetJavaType;
import com.flipkart.krystal.vajram.codegen.common.models.TypeAndName;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.facets.Dependency;
import com.flipkart.krystal.vajram.facets.FacetIdNameMapping;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.inject.Inject;
import java.io.PrintWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenUtility {
    @lombok.Generated
    private static final Logger log = LoggerFactory.getLogger(CodeGenUtility.class);
    private static final boolean NOTE_LEVEL = System.getProperty("krystal.codegen.logLevel", "error").equalsIgnoreCase("note");
    private static final ImmutableMap<Class<?>, String> DISALLOWED_FACET_TYPES = ImmutableMap.builder().put(Optional.class, (Object)(Optional.class + " is not an allowed facet type. All facets are optional by default. So this should not be needed.")).put(Request.class, (Object)(Request.class + " is not an allowed facet type as this can cause undesired behaviour.")).put(FacetValues.class, (Object)(FacetValues.class + " is not an allowed facet type as this can cause undesired behaviour.")).build();
    public static final Splitter QUALIFIED_FACET_SPLITTER = Splitter.onPattern((String)":");
    private final ProcessingEnvironment processingEnv;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final Class<?> generator;
    private final DataTypeRegistry dataTypeRegistry;

    public CodeGenUtility(ProcessingEnvironment processingEnv, Class<?> generator) {
        this.processingEnv = processingEnv;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.generator = generator;
        this.dataTypeRegistry = new DataTypeRegistry();
    }

    public static ClassName toClassName(String depReqClassName) {
        int lastDotIndex = depReqClassName.lastIndexOf(46);
        return ClassName.get((String)depReqClassName.substring(0, lastDotIndex), (String)depReqClassName.substring(lastDotIndex + 1), (String[])new String[0]);
    }

    public static List<AnnotationSpec> recordAnnotations() {
        return List.of(AnnotationSpec.builder(EqualsAndHashCode.class).build(), AnnotationSpec.builder(ToString.class).addMember("doNotUseGetters", "true", new Object[0]).build());
    }

    public static List<AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    public IfAbsent getIfAbsent(Element element) {
        IfAbsent ifAbsent = element.getAnnotation(IfAbsent.class);
        if (ifAbsent == null) {
            ifAbsent = IfAbsent.Creator.create((IfAbsent.IfAbsentThen)IfAbsent.IfAbsentThen.WILL_NEVER_FAIL, (String)"");
        }
        return ifAbsent;
    }

    public List<ExecutableElement> extractAndValidateModelMethods(TypeElement modelRootType) {
        ArrayList<ExecutableElement> modelMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement executableElem : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers(modelRootType))) {
            if (!ElementKind.METHOD.equals((Object)executableElem.getKind()) || !executableElem.getModifiers().contains((Object)Modifier.ABSTRACT) || executableElem.getSimpleName().toString().startsWith("_")) continue;
            this.validateGetterMethod(executableElem);
            modelMethods.add(executableElem);
        }
        return modelMethods;
    }

    private void validateGetterMethod(ExecutableElement method) {
        TypeMirror returnType;
        if (!method.getParameters().isEmpty()) {
            this.error("Model root methods must have zero parameters: " + method.getSimpleName(), method);
        }
        if ((returnType = method.getReturnType()).getKind() == TypeKind.VOID) {
            this.error("Model root methods must have a return type (not void): " + method.getSimpleName(), method);
        }
        if (returnType.getKind() == TypeKind.ARRAY) {
            this.error("Model root methods must not return arrays. Use List instead.", method);
        }
    }

    public boolean isNullable(TypeMirror typeMirror) {
        return typeMirror.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map(DeclaredType::asElement).filter(type -> type instanceof QualifiedNameable).map(type -> (QualifiedNameable)type).anyMatch(element -> element.getQualifiedName().contentEquals(Nullable.class.getCanonicalName()));
    }

    public boolean isOptional(TypeMirror returnType) {
        return this.isRawAssignable(returnType, Optional.class);
    }

    public TypeMirror getOptionalInnerType(TypeMirror optionalType) {
        DeclaredType declaredType;
        if (!this.isOptional(optionalType)) {
            return optionalType;
        }
        if (optionalType instanceof DeclaredType && !(declaredType = (DeclaredType)optionalType).getTypeArguments().isEmpty()) {
            return declaredType.getTypeArguments().get(0);
        }
        return Objects.requireNonNull(this.processingEnv().getElementUtils().getTypeElement(Optional.class.getCanonicalName())).asType();
    }

    @Nullable String getDisallowedMessage(TypeMirror type, ImmutableMap<Class<?>, String> disallowedTypes) {
        return disallowedTypes.entrySet().stream().map(e -> {
            if (CodeGenUtility.isRawAssignable(type, (Class)e.getKey(), this.processingEnv())) {
                return (String)e.getValue();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean isRawAssignable(TypeMirror from, Class<?> to, ProcessingEnvironment processingEnv) {
        Types typeUtils = processingEnv.getTypeUtils();
        return typeUtils.isAssignable(typeUtils.erasure(from), typeUtils.erasure(CodeGenUtility.getTypeElement((String)Preconditions.checkNotNull((Object)to.getCanonicalName()), processingEnv).asType()));
    }

    public static TypeElement getTypeElement(String name, ProcessingEnvironment processingEnv) {
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(name);
        if (typeElement == null) {
            throw new IllegalStateException("Could not find type element with name %s".formatted(name));
        }
        return typeElement;
    }

    public FacetJavaType getFacetReturnType(FacetGenModel facet, CodeGenParams codeGenParams) {
        boolean localDevAccessible;
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            if (dep.canFanout()) {
                return new FacetJavaType.FanoutResponses(this);
            }
            return new FacetJavaType.One2OneResponse(this);
        }
        boolean bl = localDevAccessible = codeGenParams.isDevAccessible() && codeGenParams.isLocal();
        if (localDevAccessible) {
            IfAbsent ifAbsent = this.getIfAbsent(facet.facetField());
            if (ifAbsent.value().isMandatoryOnServer()) {
                return new FacetJavaType.Actual(this);
            }
            return new FacetJavaType.OptionalType(this);
        }
        return new FacetJavaType.Boxed(this);
    }

    public String extractFacetName(String vajramId, String qualifiedFacet, ExecutableElement resolverMethod) {
        List parts = QUALIFIED_FACET_SPLITTER.splitToList((CharSequence)qualifiedFacet);
        if (parts.size() != 2) {
            throw this.errorAndThrow("Qualified Facet is not of the form <vajramId>:<facetName> : " + qualifiedFacet, resolverMethod);
        }
        if (!vajramId.equals(parts.get(0))) {
            this.error("Expected vajram id '" + vajramId + "' does not match with the given qualified facet: " + qualifiedFacet, resolverMethod);
        }
        return (String)parts.get(1);
    }

    public List<TypeElement> getDefinitionClasses(RoundEnvironment roundEnv) {
        return Stream.concat(roundEnv.getElementsAnnotatedWith(Vajram.class).stream().filter(element -> element.getKind() == ElementKind.CLASS).map(executableElement -> (TypeElement)executableElement).filter(typeElement -> typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)), roundEnv.getElementsAnnotatedWith(Trait.class).stream().filter(element -> element.getKind() == ElementKind.INTERFACE).map(executableElement -> (TypeElement)executableElement)).toList();
    }

    public void generateSourceFile(String className, String code, TypeElement vajramDefinition) {
        try {
            JavaFileObject requestFile = this.processingEnv.getFiler().createSourceFile(className, vajramDefinition);
            this.note("Successfully Create source file %s".formatted(className));
            try (PrintWriter out = new PrintWriter(requestFile.openWriter());){
                out.println(code);
            }
        }
        catch (Exception e) {
            this.error("Error creating java file for className: %s. Error: %s".formatted(className, e), vajramDefinition);
        }
    }

    public VajramInfo computeVajramInfo(TypeElement vajramClass) {
        VajramInfoLite vajramInfoLite = this.computeVajramInfoLite(vajramClass);
        VajramInfoLite conformsToTraitInfo = this.getConformToTraitInfoFromVajram(vajramClass);
        Optional<Element> inputsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_Inputs")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        Optional<Element> internalFacetsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_InternalFacets")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        HashBiMap givenIdsByName = HashBiMap.create();
        Set takenFacetIds = givenIdsByName.values();
        List<VariableElement> inputFields = ElementFilter.fieldsIn(inputsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> internalFacetFields = ElementFilter.fieldsIn(internalFacetsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> dependencyFields = internalFacetFields.stream().filter(variableElement -> variableElement.getAnnotation(Dependency.class) != null).toList();
        List<VariableElement> injectionFields = internalFacetFields.stream().filter(variableElement -> variableElement.getAnnotation(Inject.class) != null).toList();
        AtomicInteger nextFacetId = new AtomicInteger(1);
        VajramInfo vajramInfo = new VajramInfo(vajramInfoLite, (ImmutableList<DefaultFacetModel>)((ImmutableList)Streams.concat((Stream[])new Stream[]{inputFields.stream().map(arg_0 -> this.lambda$computeVajramInfo$18((BiMap)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite, arg_0)), injectionFields.stream().map(arg_0 -> this.lambda$computeVajramInfo$19((BiMap)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite, arg_0)).filter(facet -> facet.facetType().equals((Object)FacetType.INJECTION))}).collect(ImmutableList.toImmutableList())), (ImmutableList<DependencyModel>)((ImmutableList)dependencyFields.stream().map(arg_0 -> this.lambda$computeVajramInfo$21(vajramInfoLite, (BiMap)givenIdsByName, takenFacetIds, nextFacetId, arg_0)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())), conformsToTraitInfo);
        this.note("VajramInfo: %s".formatted(vajramInfo));
        this.validateVajramInfo(vajramInfo);
        return vajramInfo;
    }

    private void validateVajramInfo(VajramInfo vajramInfo) {
        vajramInfo.facetStream().forEach(facetGenModel -> {
            if (facetGenModel.name().startsWith("_")) {
                this.error("Facet names cannot start with an underscore (_). These are reserved for platform specific identifiers", facetGenModel.facetField());
            }
        });
    }

    private DefaultFacetModel toGivenFacetModel(VariableElement facetField, boolean isInput, BiMap<String, Integer> givenIdsByName, Set<Integer> takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite) {
        DefaultFacetModel.DefaultFacetModelBuilder facetBuilder = DefaultFacetModel.builder().facetField(facetField);
        String facetName = facetField.getSimpleName().toString();
        facetBuilder.id(Objects.requireNonNullElseGet((Integer)givenIdsByName.get((Object)facetName), () -> CodeGenUtility.getNextAvailableFacetId(takenFacetIds, nextFacetId)));
        facetBuilder.name(facetName);
        facetBuilder.documentation(this.elementUtils.getDocComment(facetField));
        CodeGenType dataType = facetField.asType().accept(new DeclaredTypeVisitor(this, facetField, DISALLOWED_FACET_TYPES), null);
        facetBuilder.dataType(dataType);
        FacetType facetType = null;
        if (isInput) {
            facetType = FacetType.INPUT;
        }
        if (facetField.getAnnotation(Inject.class) != null) {
            if (isInput) {
                this.error("Inject facet '%s' cannot be an input facet".formatted(facetName), facetField);
            }
            facetType = FacetType.INJECTION;
        }
        if (facetType == null) {
            throw this.errorAndThrow("Facet '%s' is not an input facet or an injection facet".formatted(facetName), facetField);
        }
        DefaultFacetModel facetModel = facetBuilder.facetType(Objects.requireNonNull(facetType)).vajramInfo(vajramInfoLite).build();
        givenIdsByName.putIfAbsent((Object)facetName, (Object)facetModel.id());
        return facetModel;
    }

    private static int getNextAvailableFacetId(Set<Integer> takenFacetIds, AtomicInteger nextFacetId) {
        while (takenFacetIds.contains(nextFacetId.get())) {
            nextFacetId.getAndIncrement();
        }
        return nextFacetId.getAndIncrement();
    }

    private @Nullable DependencyModel toDependencyModel(VajramID vajramId, VariableElement depField, BiMap<String, Integer> givenIdsByName, Set<Integer> takenFacetIds, AtomicInteger nextFacetId) {
        String facetName = depField.getSimpleName().toString();
        Dependency dependency = depField.getAnnotation(Dependency.class);
        DependencyModel.DependencyModelBuilder depBuilder = DependencyModel.builder().facetField(depField);
        depBuilder.id(Objects.requireNonNullElseGet((Integer)givenIdsByName.get((Object)facetName), () -> CodeGenUtility.getNextAvailableFacetId(takenFacetIds, nextFacetId)));
        depBuilder.name(facetName);
        Optional<TypeMirror> vajramReqType = this.getTypeFromAnnotationMember(() -> ((Dependency)dependency).withVajramReq()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(CodeGenUtility.getTypeElement(Request.class.getName(), this.processingEnv).getQualifiedName()));
        Optional<TypeMirror> vajramType = this.getTypeFromAnnotationMember(() -> ((Dependency)dependency).onVajram()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(CodeGenUtility.getTypeElement(VajramDef.class.getName(), this.processingEnv).getQualifiedName()));
        TypeMirror vajramOrReqType = vajramReqType.or(() -> vajramType).orElseThrow(() -> {
            this.error("At least one of `onVajram` or `withVajramReq` is needed in dependency declaration '%s' of vajram '%s'".formatted(depField.getSimpleName(), vajramId), depField);
            return new VajramDefinitionException("Invalid Dependency specification");
        });
        depBuilder.documentation(this.elementUtils.getDocComment(depField));
        if (!vajramReqType.isPresent() || !vajramType.isPresent()) {
            CodeGenType declaredDataType = (CodeGenType)new DeclaredTypeVisitor(this, depField, DISALLOWED_FACET_TYPES).visit(depField.asType());
            TypeElement vajramOrReqElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.processingEnv.getTypeUtils().asElement(vajramOrReqType)));
            VajramInfoLite depVajramInfoLite = this.computeVajramInfoLite(vajramOrReqElement);
            depBuilder.depVajramInfo(depVajramInfoLite).depReqClassQualifiedName(this.getVajramReqClassName(vajramOrReqElement)).canFanout(dependency.canFanout());
            if (!declaredDataType.equals(depVajramInfoLite.responseType())) {
                this.error("Declared dependency type %s does not match dependency vajram response type %s".formatted(declaredDataType, depVajramInfoLite.responseType()), depField);
            }
            DependencyModel depModel = depBuilder.dataType(declaredDataType).vajramInfo(depVajramInfoLite).build();
            givenIdsByName.putIfAbsent((Object)facetName, (Object)depModel.id());
            return depModel;
        }
        this.error("Both `withVajramReq` and `onVajram` cannot be set. Please set only one of them for dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get()), depField);
        this.error("Invalid dependency spec of dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get()), depField);
        return null;
    }

    private VajramInfoLite computeVajramInfoLite(TypeElement vajramOrReqClass) {
        CodeGenType responseType;
        VajramID vajramId;
        String vajramClassSimpleName = vajramOrReqClass.getSimpleName().toString();
        ImmutableBiMap facetIdNameMappings = ImmutableBiMap.of();
        String packageName = this.elementUtils.getPackageOf(vajramOrReqClass).getQualifiedName().toString();
        if (this.isRawAssignable(vajramOrReqClass.asType(), Request.class)) {
            facetIdNameMappings = (ImmutableBiMap)ElementFilter.fieldsIn(vajramOrReqClass.getEnclosedElements()).stream().filter(element -> {
                TypeElement t;
                DeclaredType d;
                Element patt25073$temp;
                TypeMirror patt25004$temp = element.asType();
                return patt25004$temp instanceof DeclaredType && (patt25073$temp = (d = (DeclaredType)patt25004$temp).asElement()) instanceof TypeElement && (t = (TypeElement)patt25073$temp).getQualifiedName().contentEquals(InputMirrorSpec.class.getCanonicalName());
            }).map(element -> element.getAnnotation(FacetIdNameMapping.class)).filter(Objects::nonNull).collect(ImmutableBiMap.toImmutableBiMap(FacetIdNameMapping::id, FacetIdNameMapping::name));
            TypeMirror responseTypeMirror = this.getVajramResponseType(vajramOrReqClass, Request.class);
            TypeElement responseTypeElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.typeUtils.asElement(responseTypeMirror)));
            vajramId = VajramID.vajramID((String)vajramClassSimpleName.substring(0, vajramClassSimpleName.length() - "_Req".length()));
            responseType = (CodeGenType)new DeclaredTypeVisitor(this, responseTypeElement, DISALLOWED_FACET_TYPES).visit(responseTypeMirror);
        } else if (this.isRawAssignable(vajramOrReqClass.asType(), VajramDefRoot.class)) {
            Vajram vajram = vajramOrReqClass.getAnnotation(Vajram.class);
            Trait trait = vajramOrReqClass.getAnnotation(Trait.class);
            if (vajram == null && trait == null) {
                throw new VajramValidationException("Vajram class %s does not have either @VajramDef or @VajramTrait annotation. This should not happen".formatted(vajramOrReqClass));
            }
            TypeMirror responseTypeMirror = this.getVajramResponseType(vajramOrReqClass, VajramDefRoot.class);
            TypeElement responseTypeElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.typeUtils.asElement(responseTypeMirror)));
            TypeElement requestType = this.elementUtils.getTypeElement(packageName + "." + CodeGenUtility.getRequestInterfaceName(vajramClassSimpleName));
            if (requestType != null) {
                facetIdNameMappings = (ImmutableBiMap)ElementFilter.fieldsIn(requestType.getEnclosedElements()).stream().filter(element -> {
                    TypeElement t;
                    DeclaredType d;
                    Element patt27139$temp;
                    TypeMirror patt27068$temp = element.asType();
                    return patt27068$temp instanceof DeclaredType && (patt27139$temp = (d = (DeclaredType)patt27068$temp).asElement()) instanceof TypeElement && (t = (TypeElement)patt27139$temp).getQualifiedName().contentEquals(InputMirrorSpec.class.getCanonicalName());
                }).map(element -> element.getAnnotation(FacetIdNameMapping.class)).filter(Objects::nonNull).collect(ImmutableBiMap.toImmutableBiMap(FacetIdNameMapping::id, FacetIdNameMapping::name));
            }
            vajramId = VajramID.vajramID((String)vajramClassSimpleName);
            responseType = (CodeGenType)new DeclaredTypeVisitor(this, responseTypeElement, DISALLOWED_FACET_TYPES).visit(responseTypeMirror);
        } else {
            throw new IllegalArgumentException("Unknown class hierarchy of vajram class %s. Expected %s or %s".formatted(vajramOrReqClass, VajramDef.class, ImmutableRequest.class));
        }
        return new VajramInfoLite(vajramId, responseType, packageName, (ImmutableBiMap<Integer, String>)facetIdNameMappings, vajramOrReqClass, this);
    }

    private @Nullable VajramInfoLite getConformToTraitInfoFromVajram(TypeElement vajramClass) {
        Optional<TypeElement> conformsToTrait = this.getConformsToTraitType(vajramClass);
        VajramInfoLite conformsToTraitInfo = null;
        if (conformsToTrait.isPresent()) {
            conformsToTraitInfo = this.computeVajramInfoLite(conformsToTrait.get());
        }
        return conformsToTraitInfo;
    }

    private Optional<TypeElement> getConformsToTraitType(TypeElement vajramOrReqClass) {
        for (TypeMirror typeMirror : vajramOrReqClass.getInterfaces()) {
            Element element = this.typeUtils.asElement(typeMirror);
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            if (((Element)Preconditions.checkNotNull((Object)element)).getAnnotation(Trait.class) == null) continue;
            return Optional.of(typeElement);
        }
        return Optional.empty();
    }

    private String getVajramReqClassName(TypeElement vajramClass) {
        if (this.isRawAssignable(vajramClass.asType(), VajramDefRoot.class)) {
            return vajramClass.getQualifiedName().toString() + "_Req";
        }
        if (this.isRawAssignable(vajramClass.asType(), Request.class)) {
            return vajramClass.getQualifiedName().toString();
        }
        throw new AssertionError((Object)("This should not happen! Found:" + vajramClass));
    }

    public Optional<TypeMirror> getTypeFromAnnotationMember(Supplier<Class<?>> supplier) {
        try {
            Class<?> ignored = supplier.get();
            throw new AssertionError((Object)"Expected supplier to throw error");
        }
        catch (MirroredTypeException mte) {
            return Optional.ofNullable(mte.getTypeMirror());
        }
    }

    public List<? extends TypeMirror> getTypesFromAnnotationMember(Supplier<Class<?>[]> supplier) {
        try {
            Class<?>[] ignored = supplier.get();
            return List.of();
        }
        catch (MirroredTypesException mte) {
            return mte.getTypeMirrors();
        }
    }

    private TypeMirror getVajramResponseType(TypeElement vajramOrReqType, Class<?> targetClass) {
        int typeParamIndex = 0;
        ImmutableList<TypeMirror> typeParameters = this.getTypeParamTypes(vajramOrReqType, Objects.requireNonNull(this.elementUtils.getTypeElement(Objects.requireNonNull(targetClass.getCanonicalName()))));
        if (typeParameters.size() > typeParamIndex) {
            return (TypeMirror)typeParameters.get(typeParamIndex);
        }
        throw this.errorAndThrow("Incorrect number of parameter types on Vajram interface. Expected 1, Found %s. Unable to infer response type for Vajram %s".formatted(typeParameters, vajramOrReqType.getQualifiedName()), vajramOrReqType);
    }

    public ImmutableList<TypeMirror> getTypeParamTypes(TypeElement childTypeElement, TypeElement targetParentClass) {
        List<TypeMirror> currentTypes = List.of(childTypeElement.asType());
        this.note("VajramDef: %s".formatted(childTypeElement));
        Types typeUtils = this.processingEnv.getTypeUtils();
        DeclaredType targetType = null;
        do {
            ArrayList<TypeMirror> newSuperTypes = new ArrayList<TypeMirror>();
            for (TypeMirror currentType : currentTypes) {
                List<DeclaredType> superTypes = this.processingEnv.getTypeUtils().directSupertypes(currentType).stream().filter(t -> t instanceof DeclaredType).map(t -> (DeclaredType)t).toList();
                newSuperTypes.addAll(superTypes);
                for (DeclaredType superType : superTypes) {
                    this.note("SuperType: %s [%s]".formatted(superType, superType.getClass()));
                    Element element = typeUtils.asElement(superType);
                    if (!(element instanceof TypeElement)) continue;
                    TypeElement typeElement = (TypeElement)element;
                    this.note("Element qualified name: %s".formatted(typeElement.getQualifiedName()));
                    if (!typeElement.getQualifiedName().contentEquals(targetParentClass.getQualifiedName())) continue;
                    targetType = superType;
                    break;
                }
                this.note("CurrentElement: %s".formatted(currentType));
            }
            if (targetType != null) continue;
            currentTypes = newSuperTypes;
        } while (!currentTypes.isEmpty() && targetType == null);
        if (targetType != null) {
            return ImmutableList.copyOf(CodeGenUtility.getTypeMirrors(targetType));
        }
        return ImmutableList.of();
    }

    private static List<? extends TypeMirror> getTypeMirrors(DeclaredType targetType) {
        List<? extends TypeMirror> typeParameters = targetType.getTypeArguments();
        return typeParameters;
    }

    public void note(CharSequence message) {
        if (NOTE_LEVEL) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[%s] %s".formatted(this.getTimestamp(), message));
        }
    }

    public CodeValidationException errorAndThrow(String message, Element ... elements) {
        this.error(message, elements);
        return new CodeValidationException(message);
    }

    public void error(String message, Element ... elements) {
        if (elements.length == 0) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
        } else {
            for (Element element : elements) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
            }
        }
    }

    private String getTimestamp() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.now(ZoneId.of((String)Preconditions.checkNotNull((Object)ZoneId.SHORT_IDS.get("IST")))));
    }

    public static String getRequestInterfaceName(String vajramName) {
        return vajramName + "_Req";
    }

    public static String getImmutRequestInterfaceName(String vajramName) {
        return vajramName + "_ReqImmut";
    }

    public static String getImmutRequestPojoName(String vajramName) {
        return vajramName + "_ReqImmutPojo";
    }

    public static String getVajramImplClassName(String vajramId) {
        return vajramId + "_Wrpr";
    }

    public static String getFacetsInterfaceName(String vajramName) {
        return vajramName + "_Fac";
    }

    public static String getImmutFacetsClassName(String vajramName) {
        return vajramName + "_FacImmutPojo";
    }

    public TypeName toTypeName(CodeGenType dataType) {
        return TypeName.get((TypeMirror)dataType.javaModelType(this.processingEnv));
    }

    public static TypeName toTypeName(Type typeArg) {
        if (typeArg instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeArg;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            return ParameterizedTypeName.get((ClassName)((ClassName)CodeGenUtility.toTypeName(rawType)), (TypeName[])((TypeName[])Arrays.stream(typeArgs).map(CodeGenUtility::toTypeName).toArray(TypeName[]::new)));
        }
        if (typeArg instanceof Class) {
            return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
        }
        return ClassName.bestGuess((String)typeArg.getTypeName());
    }

    public static List<? extends TypeMirror> getTypeParameters(TypeMirror returnType) {
        return returnType.accept(new SimpleTypeVisitor14<List<? extends TypeMirror>, Void>(){

            @Override
            public List<? extends TypeMirror> visitDeclared(DeclaredType t, Void unused) {
                return t.getTypeArguments();
            }
        }, null);
    }

    public boolean isSameRawType(TypeMirror a, Class<?> b) {
        return this.processingEnv.getTypeUtils().isSameType(this.typeUtils.erasure(a), this.typeUtils.erasure(((TypeElement)Preconditions.checkNotNull((Object)this.processingEnv().getElementUtils().getTypeElement((CharSequence)Preconditions.checkNotNull((Object)b.getCanonicalName())), (Object)("TypeElement not found for: " + b.getCanonicalName()))).asType()));
    }

    public boolean isRawAssignable(TypeMirror from, Class<?> to) {
        return CodeGenUtility.isRawAssignable(from, to, this.processingEnv());
    }

    public TypeMirror box(TypeMirror type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType p = (PrimitiveType)type;
            return this.typeUtils.boxedClass(p).asType();
        }
        return type;
    }

    public TypeSpec.Builder classBuilder(String className, String generatedForCanonicalName) {
        TypeSpec.Builder classBuilder = className.isBlank() ? TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]) : TypeSpec.classBuilder((String)className);
        classBuilder.addJavadoc("@see $L", new Object[]{generatedForCanonicalName});
        this.addDefaultAnnotations(classBuilder);
        return classBuilder;
    }

    public TypeSpec.Builder interfaceBuilder(String interfaceName, String generatedForCanonicalName) {
        if (interfaceName.isBlank()) {
            throw new RuntimeException("interface name cannot be blank");
        }
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)interfaceName);
        this.addDefaultAnnotations(interfaceBuilder);
        interfaceBuilder.addJavadoc("@see $L", new Object[]{generatedForCanonicalName});
        return interfaceBuilder;
    }

    private void addDefaultAnnotations(TypeSpec.Builder classBuilder) {
        classBuilder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", (CodeBlock)Stream.of(CodeBlock.of((String)"$S", (Object[])new Object[]{"unchecked"}), CodeBlock.of((String)"$S", (Object[])new Object[]{"ClassReferencesSubclass"})).collect(CodeBlock.joining((String)",", (String)"{", (String)"}"))).build());
        this.addGeneratedAnnotations(classBuilder);
    }

    public void addGeneratedAnnotations(TypeSpec.Builder classBuilder) {
        classBuilder.addAnnotation(AnnotationSpec.builder(com.flipkart.krystal.vajram.annos.Generated.class).addMember("by", "$S", new Object[]{this.generator.getName()}).build()).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{this.generator.getName()}).addMember("date", "$S", new Object[]{this.getTimestamp()}).build());
    }

    public TypeAndName box(TypeAndName javaType) {
        @Nullable TypeMirror typeMirror = javaType.type();
        if (typeMirror == null) {
            return javaType;
        }
        TypeKind typeKind = typeMirror.getKind();
        if (!typeKind.isPrimitive() && typeKind != TypeKind.VOID) {
            return javaType;
        }
        TypeMirror boxed = typeKind == TypeKind.VOID ? Objects.requireNonNull(this.processingEnv.getElementUtils().getTypeElement(Void.class.getCanonicalName())).asType() : this.processingEnv.getTypeUtils().boxedClass((PrimitiveType)typeMirror).asType();
        return new TypeAndName(TypeName.get((TypeMirror)boxed).annotated(javaType.annotationSpecs()), boxed, javaType.annotationSpecs());
    }

    TypeName optional(TypeAndName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{this.box(javaType).typeName()});
    }

    TypeName responseType(DependencyModel dep) {
        return this.responseType(new TypeAndName((TypeName)CodeGenUtility.toClassName(dep.depReqClassQualifiedName())), this.getTypeName(dep.dataType()));
    }

    private TypeName responseType(TypeAndName requestType, TypeAndName facetType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(One2OneDepResponse.class), (TypeName[])new TypeName[]{requestType.typeName(), this.box(facetType).typeName()});
    }

    public TypeName responsesType(DependencyModel dep) {
        return this.responsesType(new TypeAndName((TypeName)CodeGenUtility.toClassName(dep.depReqClassQualifiedName())), this.getTypeName(dep.dataType()));
    }

    private TypeName responsesType(TypeAndName requestType, TypeAndName facetType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(FanoutDepResponses.class), (TypeName[])new TypeName[]{requestType.typeName(), this.box(facetType).typeName()});
    }

    TypeAndName getTypeName(CodeGenType dataType, List<AnnotationSpec> typeAnnotations) {
        TypeMirror javaModelType = dataType.javaModelType(this.processingEnv);
        return new TypeAndName(TypeName.get((TypeMirror)javaModelType).annotated(typeAnnotations), javaModelType, typeAnnotations);
    }

    public TypeAndName getTypeName(CodeGenType dataType) {
        return this.getTypeName(dataType, List.of());
    }

    public CodeGenType getDataType(FacetGenModel abstractInput) {
        if (abstractInput instanceof DefaultFacetModel) {
            DefaultFacetModel facetDef = (DefaultFacetModel)abstractInput;
            return facetDef.dataType();
        }
        if (abstractInput instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)abstractInput;
            return dep.dataType();
        }
        throw new UnsupportedOperationException("Unable to extract datatype from facet : %s".formatted(abstractInput));
    }

    public ExecutableElement getMethod(Class<?> clazz, String methodName, int paramCount) {
        return Objects.requireNonNull(this.processingEnv().getElementUtils().getTypeElement(Objects.requireNonNull(clazz.getCanonicalName()))).getEnclosedElements().stream().filter(element -> element instanceof ExecutableElement).map(element -> (ExecutableElement)element).filter(element -> element.getSimpleName().contentEquals(methodName) && element.getParameters().size() == paramCount).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find method '" + methodName + "' with param count '" + paramCount + "' in class " + clazz));
    }

    public FacetJavaType getFacetFieldType(FacetGenModel facet) {
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            if (dep.canFanout()) {
                return new FacetJavaType.FanoutResponses(this);
            }
            return new FacetJavaType.One2OneResponse(this);
        }
        return new FacetJavaType.Boxed(this);
    }

    public boolean usePlatformDefault(FacetGenModel facet) {
        IfAbsent ifAbsent = facet.facetField().getAnnotation(IfAbsent.class);
        return ifAbsent != null && ifAbsent.value().usePlatformDefault();
    }

    public boolean isMandatoryOnServer(FacetGenModel facet) {
        IfAbsent ifAbsent = facet.facetField().getAnnotation(IfAbsent.class);
        return ifAbsent != null && ifAbsent.value().isMandatoryOnServer();
    }

    public String getJavaTypeCreationCode(CodeGenType javaType, List<TypeName> collectClassNames) {
        TypeMirror typeMirror = javaType.javaModelType(this.processingEnv);
        collectClassNames.add((TypeName)ClassName.get(JavaType.class));
        if (javaType.typeParameters().isEmpty()) {
            collectClassNames.add(TypeName.get((TypeMirror)typeMirror));
            return "$T.create($T.class)";
        }
        collectClassNames.add(TypeName.get((TypeMirror)this.processingEnv.getTypeUtils().erasure(typeMirror)));
        return "$T.create($T.class, " + javaType.typeParameters().stream().map(dataType -> this.getJavaTypeCreationCode((CodeGenType)dataType, collectClassNames)).collect(Collectors.joining(",")) + ")";
    }

    public Path detectSourceOutputPath(@Nullable Element codeGenElement) {
        Path sourcePath;
        try {
            FileObject dummyFile = this.processingEnv().getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", new Random().nextInt() + "_dummy_detect_source_path.txt", new Element[0]);
            sourcePath = Paths.get(dummyFile.toUri());
            dummyFile.delete();
        }
        catch (Exception e) {
            throw this.errorAndThrow("Could not detect source output directory because dummy_detect_source_path.txt could not be created", codeGenElement);
        }
        return Objects.requireNonNull(sourcePath.getParent());
    }

    public <T> T getAnnotationElement(AnnotationMirror parentModelRootAnno, String annoElement, Class<T> type) {
        return type.cast(this.elementUtils.getElementValuesWithDefaults(parentModelRootAnno).entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals(annoElement)).findAny().map(Map.Entry::getValue).orElseThrow(AssertionError::new).getValue());
    }

    @lombok.Generated
    public ProcessingEnvironment processingEnv() {
        return this.processingEnv;
    }

    @lombok.Generated
    public DataTypeRegistry dataTypeRegistry() {
        return this.dataTypeRegistry;
    }

    private /* synthetic */ Optional lambda$computeVajramInfo$21(VajramInfoLite vajramInfoLite, BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VariableElement depField) {
        return Optional.ofNullable(this.toDependencyModel(vajramInfoLite.vajramId(), depField, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId));
    }

    private /* synthetic */ DefaultFacetModel lambda$computeVajramInfo$19(BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite, VariableElement internalField) {
        return this.toGivenFacetModel(internalField, false, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite);
    }

    private /* synthetic */ DefaultFacetModel lambda$computeVajramInfo$18(BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite, VariableElement inputField) {
        return this.toGivenFacetModel(inputField, true, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite);
    }
}

