/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.Constants;
import com.flipkart.krystal.vajram.codegen.common.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.facets.FacetValidation;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class FacetJavaType {
    protected final CodeGenUtility util;

    public FacetJavaType(CodeGenUtility util) {
        this.util = util;
    }

    public abstract TypeName javaTypeName(FacetGenModel var1);

    public CodeBlock fieldGetterCode(FacetGenModel facet, CodeGenParams codeGenParams) {
        boolean facetInCurrentClass;
        if (codeGenParams.isFacetsSubset()) {
            return CodeBlock.of((String)"return this.$L.$L()", (Object[])new Object[]{"_facetValues", facet.name()});
        }
        boolean bl = facetInCurrentClass = codeGenParams.isRequest() || !facet.facetTypes().contains((Object)FacetType.INPUT) || !codeGenParams.wrapsRequest();
        if (facetInCurrentClass) {
            return CodeBlock.of((String)"return this.$L", (Object[])new Object[]{facet.name()});
        }
        if (codeGenParams.wrapsRequest()) {
            return CodeBlock.of((String)"return this._request.$L()", (Object[])new Object[]{facet.name()});
        }
        throw new UnsupportedOperationException("This should not happen. " + this);
    }

    public CodeBlock fieldInitializer(FacetGenModel facet) {
        if (this.util.usePlatformDefault(facet)) {
            try {
                return facet.dataType().defaultValueExpr(this.util.processingEnv());
            }
            catch (Exception e) {
                throw new VajramDefinitionException("The datatype " + facet.dataType() + " does not support a platform default value. To fix this issue, change the ifNotSet strategy of the @IfAbsent annotation to a value which does not allow default value.");
            }
        }
        return Constants.EMPTY_CODE_BLOCK;
    }

    public Class<?>[] typeAnnotations(FacetGenModel facet, CodeGenParams codeGenParams) {
        return new Class[0];
    }

    public static final class FanoutResponses
    extends FacetJavaType {
        public FanoutResponses(CodeGenUtility util) {
            super(util);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.responsesType((DependencyModel)facet);
        }

        @Override
        public CodeBlock fieldInitializer(FacetGenModel facet) {
            return CodeBlock.of((String)"$T.empty()", (Object[])new Object[]{FanoutDepResponses.class});
        }
    }

    public static final class One2OneResponse
    extends FacetJavaType {
        public One2OneResponse(CodeGenUtility util) {
            super(util);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.responseType((DependencyModel)facet);
        }

        @Override
        public CodeBlock fieldInitializer(FacetGenModel facet) {
            return CodeBlock.of((String)"$T.noRequest()", (Object[])new Object[]{One2OneDepResponse.class});
        }
    }

    public static final class OptionalType
    extends FacetJavaType {
        public OptionalType(CodeGenUtility util) {
            super(util);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.optional(this.util.box(this.util.getTypeName(this.util.getDataType(facet))));
        }

        @Override
        public CodeBlock fieldInitializer(FacetGenModel facet) {
            return CodeBlock.of((String)"$T.empty()", (Object[])new Object[]{Optional.class});
        }

        @Override
        public CodeBlock fieldGetterCode(FacetGenModel facet, CodeGenParams codeGenParams) {
            if (codeGenParams.isSubsetBatch()) {
                return CodeBlock.of((String)"return $T.ofNullable(this.$L.$L())", (Object[])new Object[]{Optional.class, "_facetValues", facet.name()});
            }
            return super.fieldGetterCode(facet, codeGenParams);
        }
    }

    public static final class Boxed
    extends FacetJavaType {
        public Boxed(CodeGenUtility util) {
            super(util);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.box(this.util.getTypeName(this.util.getDataType(facet))).typeName();
        }

        @Override
        public Class<?>[] typeAnnotations(FacetGenModel facet, CodeGenParams codeGenParams) {
            return new Class[]{Nullable.class};
        }
    }

    public static final class Actual
    extends FacetJavaType {
        public Actual(CodeGenUtility util) {
            super(util);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.getTypeName(this.util.getDataType(facet)).typeName();
        }

        @Override
        public Class<?>[] typeAnnotations(FacetGenModel facet, CodeGenParams codeGenParams) {
            if (!(facet instanceof DependencyModel || this.javaTypeName(facet).isPrimitive() || codeGenParams.isSubsetBatch())) {
                return new Class[]{Nullable.class};
            }
            return super.typeAnnotations(facet, codeGenParams);
        }

        @Override
        public CodeBlock fieldGetterCode(FacetGenModel facet, CodeGenParams codeGenParams) {
            if (codeGenParams.isSubsetBatch()) {
                IfAbsent ifAbsent = facet.facetField().getAnnotation(IfAbsent.class);
                if (ifAbsent != null && !ifAbsent.value().usePlatformDefault()) {
                    return CodeBlock.of((String)"return $T.validateMandatoryFacet(this.$L.$L(), $S, $S)\n", (Object[])new Object[]{FacetValidation.class, "_facetValues", facet.name(), facet.vajramInfo().vajramId().id(), facet.name()});
                }
                return CodeBlock.of((String)"return this.$L.$L()", (Object[])new Object[]{"_facetValues", facet.name()});
            }
            return super.fieldGetterCode(facet, codeGenParams);
        }
    }
}

