/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.IfNull;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.vajram.Trait;
import com.flipkart.krystal.vajram.TraitDef;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.annos.ConformsToTrait;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.vajram.codegen.common.models.DefaultFacetModel;
import com.flipkart.krystal.vajram.codegen.common.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetJavaType;
import com.flipkart.krystal.vajram.codegen.common.models.TypeAndName;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.facets.Dependency;
import com.flipkart.krystal.vajram.facets.FacetIdNameMapping;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.inject.Inject;
import java.io.PrintWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    @lombok.Generated
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final boolean DEBUG = false;
    private static final ImmutableMap<Class<?>, String> DISALLOWED_FACET_TYPES = ImmutableMap.builder().put(Optional.class, (Object)(Optional.class + " is not an allowed facet type. All facets are optional by default. So this should not be needed.")).put(Request.class, (Object)(Request.class + " is not an allowed facet type as this can cause undesired behaviour.")).put(FacetValues.class, (Object)(FacetValues.class + " is not an allowed facet type as this can cause undesired behaviour.")).build();
    public static final Splitter QUALIFIED_FACET_SPLITTER = Splitter.onPattern((String)":");
    private final ProcessingEnvironment processingEnv;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final Class<?> generator;

    public Utils(ProcessingEnvironment processingEnv, Class<?> generator) {
        this.processingEnv = processingEnv;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.generator = generator;
    }

    public static ClassName toClassName(String depReqClassName) {
        int lastDotIndex = depReqClassName.lastIndexOf(46);
        return ClassName.get((String)depReqClassName.substring(0, lastDotIndex), (String)depReqClassName.substring(lastDotIndex + 1), (String[])new String[0]);
    }

    public static List<AnnotationSpec> recordAnnotations() {
        return List.of(AnnotationSpec.builder(EqualsAndHashCode.class).build(), AnnotationSpec.builder(ToString.class).addMember("doNotUseGetters", "true", new Object[0]).build());
    }

    public static List<AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    public static @NonNull IfNull getIfNoValue(ExecutableElement method) {
        IfNull ifNull = method.getAnnotation(IfNull.class);
        if (ifNull == null) {
            ifNull = IfNull.Creator.createDefault();
        }
        return ifNull;
    }

    public boolean isNullable(TypeMirror typeMirror) {
        return typeMirror.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map(DeclaredType::asElement).filter(type -> type instanceof QualifiedNameable).map(type -> (QualifiedNameable)type).anyMatch(element -> element.getQualifiedName().contentEquals(Nullable.class.getCanonicalName()));
    }

    public boolean isOptional(TypeMirror returnType) {
        return this.isRawAssignable(returnType, Optional.class);
    }

    public TypeMirror getOptionalInnerType(TypeMirror optionalType) {
        DeclaredType declaredType;
        if (!this.isOptional(optionalType)) {
            throw new IllegalArgumentException("Type %s is not Optional".formatted(optionalType));
        }
        if (optionalType instanceof DeclaredType && !(declaredType = (DeclaredType)optionalType).getTypeArguments().isEmpty()) {
            return declaredType.getTypeArguments().get(0);
        }
        return Objects.requireNonNull(this.processingEnv().getElementUtils().getTypeElement(Optional.class.getCanonicalName())).asType();
    }

    @Nullable String getDisallowedMessage(TypeMirror type, ImmutableMap<Class<?>, String> disallowedTypes) {
        return disallowedTypes.entrySet().stream().map(e -> {
            if (Utils.isRawAssignable(type, (Class)e.getKey(), this.processingEnv())) {
                return (String)e.getValue();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean isRawAssignable(TypeMirror from, Class<?> to, ProcessingEnvironment processingEnv) {
        Types typeUtils = processingEnv.getTypeUtils();
        return typeUtils.isAssignable(typeUtils.erasure(from), typeUtils.erasure(Utils.getTypeElement((String)Preconditions.checkNotNull((Object)to.getCanonicalName()), processingEnv).asType()));
    }

    public static TypeElement getTypeElement(String name, ProcessingEnvironment processingEnv) {
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(name);
        if (typeElement == null) {
            throw new IllegalStateException("Could not find type element with name %s".formatted(name));
        }
        return typeElement;
    }

    public FacetJavaType facetJavaType(FacetGenModel facet, CodeGenParams codeGenParams) {
        boolean localDevAccessible;
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            if (dep.canFanout()) {
                return new FacetJavaType.FanoutResponses(this);
            }
            return new FacetJavaType.One2OneResponse(this);
        }
        boolean bl = localDevAccessible = codeGenParams.isDevAccessible() && codeGenParams.isLocal();
        if (localDevAccessible) {
            IfNull ifNull = facet.facetField().getAnnotation(IfNull.class);
            if (ifNull != null && !ifNull.value().equals((Object)IfNull.IfNullThen.MAY_FAIL_CONDITIONALLY)) {
                return new FacetJavaType.Actual(this);
            }
            return new FacetJavaType.OptionalType(this);
        }
        return new FacetJavaType.Boxed(this);
    }

    public String extractFacetName(String vajramId, String qualifiedFacet, ExecutableElement resolverMethod) {
        List parts = QUALIFIED_FACET_SPLITTER.splitToList((CharSequence)qualifiedFacet);
        if (parts.size() != 2) {
            throw this.errorAndThrow("Qualified Facet is not of the form <vajramId>:<facetName> : " + qualifiedFacet, resolverMethod);
        }
        if (!vajramId.equals(parts.get(0))) {
            throw this.errorAndThrow("Expected vajram id '" + vajramId + "' does not match with the given qualified facet: " + qualifiedFacet, resolverMethod);
        }
        return (String)parts.get(1);
    }

    public List<TypeElement> getDefinitionClasses(RoundEnvironment roundEnv) {
        return roundEnv.getElementsAnnotatedWithAny(Set.of(Vajram.class, Trait.class)).stream().filter(element -> element.getKind() == ElementKind.CLASS).map(executableElement -> (TypeElement)executableElement).toList();
    }

    public void generateSourceFile(String className, String code, TypeElement vajramDefinition) {
        try {
            JavaFileObject requestFile = this.processingEnv.getFiler().createSourceFile(className, vajramDefinition);
            this.note("Successfully Create source file %s".formatted(className));
            try (PrintWriter out = new PrintWriter(requestFile.openWriter());){
                out.println(code);
            }
        }
        catch (Exception e) {
            this.error("Error creating java file for className: %s. Error: %s".formatted(className, e), vajramDefinition);
        }
    }

    public VajramInfo computeVajramInfo(TypeElement vajramClass) {
        VajramInfoLite vajramInfoLite = this.getVajramInfoLite(vajramClass);
        Optional<Element> inputsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_Inputs")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        Optional<Element> internalFacetsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_InternalFacets")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        HashBiMap givenIdsByName = HashBiMap.create();
        Set takenFacetIds = givenIdsByName.values();
        List<VariableElement> inputFields = ElementFilter.fieldsIn(inputsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> internalFacetFields = ElementFilter.fieldsIn(internalFacetsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> dependencyFields = internalFacetFields.stream().filter(variableElement -> variableElement.getAnnotation(Dependency.class) != null).toList();
        AtomicInteger nextFacetId = new AtomicInteger(1);
        VajramInfo vajramInfo = new VajramInfo(vajramInfoLite, (ImmutableList<DefaultFacetModel>)((ImmutableList)Streams.concat((Stream[])new Stream[]{inputFields.stream().map(arg_0 -> this.lambda$computeVajramInfo$14((BiMap)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite, arg_0)), internalFacetFields.stream().map(arg_0 -> this.lambda$computeVajramInfo$15((BiMap)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite, arg_0)).filter(facet -> facet.facetTypes().contains((Object)FacetType.INJECTION))}).collect(ImmutableList.toImmutableList())), (ImmutableList<DependencyModel>)((ImmutableList)dependencyFields.stream().map(arg_0 -> this.lambda$computeVajramInfo$17(vajramInfoLite, (BiMap)givenIdsByName, takenFacetIds, nextFacetId, arg_0)).collect(ImmutableList.toImmutableList())));
        this.note("VajramInfo: %s".formatted(vajramInfo));
        return vajramInfo;
    }

    private DefaultFacetModel toGivenFacetModel(VariableElement facetField, boolean isInput, BiMap<String, Integer> givenIdsByName, Set<Integer> takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite) {
        DefaultFacetModel.DefaultFacetModelBuilder facetBuilder = DefaultFacetModel.builder().facetField(facetField);
        DefaultFacetModel.builder().facetField(facetField);
        String facetName = facetField.getSimpleName().toString();
        facetBuilder.id(Objects.requireNonNullElseGet((Integer)givenIdsByName.get((Object)facetName), () -> Utils.getNextAvailableFacetId(takenFacetIds, nextFacetId)));
        facetBuilder.name(facetName);
        facetBuilder.documentation(this.elementUtils.getDocComment(facetField));
        DataType dataType = (DataType)facetField.asType().accept(new DeclaredTypeVisitor(this, facetField, DISALLOWED_FACET_TYPES), null);
        facetBuilder.dataType((DataType<Object>)dataType);
        EnumSet<FacetType> facetTypes = EnumSet.noneOf(FacetType.class);
        if (isInput) {
            facetTypes.add(FacetType.INPUT);
        }
        if (facetField.getAnnotation(Inject.class) != null) {
            facetTypes.add(FacetType.INJECTION);
        }
        DefaultFacetModel facetModel = facetBuilder.facetTypes(facetTypes).vajramInfo(vajramInfoLite).build();
        givenIdsByName.putIfAbsent((Object)facetName, (Object)facetModel.id());
        return facetModel;
    }

    private static int getNextAvailableFacetId(Set<Integer> takenFacetIds, AtomicInteger nextFacetId) {
        while (takenFacetIds.contains(nextFacetId.get())) {
            nextFacetId.getAndIncrement();
        }
        return nextFacetId.getAndIncrement();
    }

    private DependencyModel toDependencyModel(VajramID vajramId, VariableElement depField, BiMap<String, Integer> givenIdsByName, Set<Integer> takenFacetIds, AtomicInteger nextFacetId) {
        String facetName = depField.getSimpleName().toString();
        Dependency dependency = depField.getAnnotation(Dependency.class);
        DependencyModel.DependencyModelBuilder depBuilder = DependencyModel.builder().facetField(depField);
        depBuilder.id(Objects.requireNonNullElseGet((Integer)givenIdsByName.get((Object)facetName), () -> Utils.getNextAvailableFacetId(takenFacetIds, nextFacetId)));
        depBuilder.name(facetName);
        Optional<TypeMirror> vajramReqType = this.getTypeFromAnnotationMember(() -> ((Dependency)dependency).withVajramReq()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(Utils.getTypeElement(Request.class.getName(), this.processingEnv).getQualifiedName()));
        Optional<TypeMirror> vajramType = this.getTypeFromAnnotationMember(() -> ((Dependency)dependency).onVajram()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(Utils.getTypeElement(VajramDef.class.getName(), this.processingEnv).getQualifiedName()));
        TypeMirror vajramOrReqType = vajramReqType.or(() -> vajramType).orElseThrow(() -> {
            this.error("At least one of `onVajram` or `withVajramReq` is needed in dependency declaration '%s' of vajram '%s'".formatted(depField.getSimpleName(), vajramId), depField);
            return new VajramDefinitionException("Invalid Dependency specification");
        });
        depBuilder.documentation(this.elementUtils.getDocComment(depField));
        if (!vajramReqType.isPresent() || !vajramType.isPresent()) {
            DataType declaredDataType = (DataType)new DeclaredTypeVisitor(this, depField, DISALLOWED_FACET_TYPES).visit(depField.asType());
            TypeElement vajramOrReqElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.processingEnv.getTypeUtils().asElement(vajramOrReqType)));
            VajramInfoLite depVajramInfoLite = this.getVajramInfoLite(vajramOrReqElement);
            depBuilder.depVajramInfo(depVajramInfoLite).depReqClassQualifiedName(this.getVajramReqClassName(vajramOrReqElement)).canFanout(dependency.canFanout());
            if (!declaredDataType.equals(depVajramInfoLite.responseType())) {
                this.error("Declared dependency type %s does not match dependency vajram response type %s".formatted(declaredDataType, depVajramInfoLite.responseType()), depField);
            }
            DependencyModel depModel = depBuilder.dataType(declaredDataType).vajramInfo(depVajramInfoLite).build();
            givenIdsByName.putIfAbsent((Object)facetName, (Object)depModel.id());
            return depModel;
        }
        this.error("Both `withVajramReq` and `onVajram` cannot be set. Please set only one of them for dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get()), depField);
        throw this.errorAndThrow("Invalid dependency spec of dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get()), depField);
    }

    private VajramInfoLite getVajramInfoLite(TypeElement vajramOrReqClass) {
        DataType responseType;
        VajramID vajramId;
        String vajramClassSimpleName = vajramOrReqClass.getSimpleName().toString();
        ImmutableBiMap facetIdNameMappings = ImmutableBiMap.of();
        VajramInfoLite conformsToTraitInfo = this.getConformToTraitInfo(vajramOrReqClass);
        String packageName = this.elementUtils.getPackageOf(vajramOrReqClass).getQualifiedName().toString();
        if (this.isRawAssignable(vajramOrReqClass.asType(), Request.class)) {
            facetIdNameMappings = (ImmutableBiMap)ElementFilter.fieldsIn(vajramOrReqClass.getEnclosedElements()).stream().filter(element -> {
                TypeElement t;
                DeclaredType d;
                Element patt21614$temp;
                TypeMirror patt21545$temp = element.asType();
                return patt21545$temp instanceof DeclaredType && (patt21614$temp = (d = (DeclaredType)patt21545$temp).asElement()) instanceof TypeElement && (t = (TypeElement)patt21614$temp).getQualifiedName().contentEquals(InputMirrorSpec.class.getCanonicalName());
            }).map(element -> element.getAnnotation(FacetIdNameMapping.class)).filter(Objects::nonNull).collect(ImmutableBiMap.toImmutableBiMap(FacetIdNameMapping::id, FacetIdNameMapping::name));
            TypeMirror responseTypeMirror = this.getResponseType(vajramOrReqClass, Request.class);
            TypeElement responseTypeElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.typeUtils.asElement(responseTypeMirror)));
            vajramId = VajramID.vajramID((String)vajramClassSimpleName.substring(0, vajramClassSimpleName.length() - "_Req".length()));
            responseType = (DataType)new DeclaredTypeVisitor(this, responseTypeElement, DISALLOWED_FACET_TYPES).visit(responseTypeMirror);
        } else if (this.isRawAssignable(vajramOrReqClass.asType(), VajramDef.class) || this.isRawAssignable(vajramOrReqClass.asType(), TraitDef.class)) {
            Vajram vajram = vajramOrReqClass.getAnnotation(Vajram.class);
            Trait trait = vajramOrReqClass.getAnnotation(Trait.class);
            if (vajram == null && trait == null) {
                throw new VajramValidationException("Vajram class %s does not have either @VajramDef or @VajramTrait annotation. This should not happen".formatted(vajramOrReqClass));
            }
            boolean isTrait = trait != null;
            TypeMirror responseTypeMirror = this.getResponseType(vajramOrReqClass, isTrait ? TraitDef.class : VajramDef.class);
            TypeElement responseTypeElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.typeUtils.asElement(responseTypeMirror)));
            TypeElement requestType = this.elementUtils.getTypeElement(packageName + "." + Utils.getRequestInterfaceName(vajramClassSimpleName));
            if (requestType != null) {
                facetIdNameMappings = (ImmutableBiMap)ElementFilter.fieldsIn(requestType.getEnclosedElements()).stream().filter(element -> {
                    TypeElement t;
                    DeclaredType d;
                    Element patt23842$temp;
                    TypeMirror patt23771$temp = element.asType();
                    return patt23771$temp instanceof DeclaredType && (patt23842$temp = (d = (DeclaredType)patt23771$temp).asElement()) instanceof TypeElement && (t = (TypeElement)patt23842$temp).getQualifiedName().contentEquals(InputMirrorSpec.class.getCanonicalName());
                }).map(element -> element.getAnnotation(FacetIdNameMapping.class)).filter(Objects::nonNull).collect(ImmutableBiMap.toImmutableBiMap(FacetIdNameMapping::id, FacetIdNameMapping::name));
            }
            vajramId = VajramID.vajramID((String)vajramClassSimpleName);
            responseType = (DataType)new DeclaredTypeVisitor(this, responseTypeElement, DISALLOWED_FACET_TYPES).visit(responseTypeMirror);
        } else {
            throw new IllegalArgumentException("Unknown class hierarchy of vajram class %s. Expected %s or %s".formatted(vajramOrReqClass, VajramDef.class, ImmutableRequest.class));
        }
        return new VajramInfoLite(vajramId, responseType, packageName, (ImmutableBiMap<Integer, String>)facetIdNameMappings, conformsToTraitInfo, vajramOrReqClass, this);
    }

    private @Nullable VajramInfoLite getConformToTraitInfo(TypeElement vajramOrReqClass) {
        ConformsToTrait conformsToTrait = vajramOrReqClass.getAnnotation(ConformsToTrait.class);
        VajramInfoLite conformsToTraitInfo = null;
        if (conformsToTrait != null) {
            Optional<TypeMirror> traitType = this.getTypeFromAnnotationMember(() -> ((ConformsToTrait)conformsToTrait).withDef()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(Utils.getTypeElement(TraitDef.class.getName(), this.processingEnv).getQualifiedName()));
            if (traitType.isEmpty()) {
                throw new VajramValidationException("Either trait or traitRequest must be set in @ConformsTo annotation of vajram %s".formatted(vajramOrReqClass));
            }
            conformsToTraitInfo = this.getVajramInfoLite((TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.processingEnv.getTypeUtils().asElement(Objects.requireNonNull(traitType.orElse(null))))));
        }
        return conformsToTraitInfo;
    }

    private String getVajramReqClassName(TypeElement vajramClass) {
        if (this.isRawAssignable(vajramClass.asType(), VajramDef.class) || this.isRawAssignable(vajramClass.asType(), TraitDef.class)) {
            return vajramClass.getQualifiedName().toString() + "_Req";
        }
        if (this.isRawAssignable(vajramClass.asType(), Request.class)) {
            return vajramClass.getQualifiedName().toString();
        }
        throw new AssertionError((Object)("This should not happen! Found:" + vajramClass));
    }

    Optional<TypeMirror> getTypeFromAnnotationMember(Supplier<Class<?>> supplier) {
        try {
            Class<?> ignored = supplier.get();
            throw new AssertionError((Object)"Expected supplier to throw error");
        }
        catch (MirroredTypeException mte) {
            return Optional.ofNullable(mte.getTypeMirror());
        }
    }

    public List<? extends TypeMirror> getTypesFromAnnotationMember(Supplier<Class<?>[]> supplier) {
        try {
            Class<?>[] ignored = supplier.get();
            return List.of();
        }
        catch (MirroredTypesException mte) {
            return mte.getTypeMirrors();
        }
    }

    private TypeMirror getResponseType(TypeElement vajramDef, Class<?> targetClass) {
        int typeParamIndex = 0;
        List<TypeMirror> currentTypes = List.of(vajramDef.asType());
        this.note("VajramDef: %s".formatted(vajramDef));
        Types typeUtils = this.processingEnv.getTypeUtils();
        DeclaredType vajramInterface = null;
        do {
            ArrayList<TypeMirror> newSuperTypes = new ArrayList<TypeMirror>();
            for (TypeMirror currentType : currentTypes) {
                List<DeclaredType> superTypes = this.processingEnv.getTypeUtils().directSupertypes(currentType).stream().filter(t -> t instanceof DeclaredType).map(t -> (DeclaredType)t).toList();
                newSuperTypes.addAll(superTypes);
                for (DeclaredType superType : superTypes) {
                    this.note("SuperType: %s [%s]".formatted(superType, superType.getClass()));
                    Element element = typeUtils.asElement(superType);
                    if (!(element instanceof TypeElement)) continue;
                    TypeElement typeElement = (TypeElement)element;
                    this.note("Element qualified name: %s".formatted(typeElement.getQualifiedName()));
                    if (!typeElement.getQualifiedName().contentEquals(targetClass.getName())) continue;
                    vajramInterface = superType;
                    break;
                }
                this.note("CurrentElement: %s".formatted(currentType));
            }
            if (vajramInterface != null) continue;
            currentTypes = newSuperTypes;
        } while (!currentTypes.isEmpty() && vajramInterface == null);
        if (vajramInterface != null) {
            List<? extends TypeMirror> typeParameters = vajramInterface.getTypeArguments();
            if (typeParameters.size() > typeParamIndex) {
                return typeParameters.get(typeParamIndex);
            }
            this.error("Incorrect number of parameter types on Vajram interface. Expected 1, Found %s".formatted(typeParameters), vajramDef);
        }
        this.error("Unable to infer response type for Vajram %s".formatted(vajramDef.getQualifiedName()), vajramDef);
        throw new RuntimeException();
    }

    public void note(CharSequence message) {
    }

    public VajramValidationException errorAndThrow(String message, @Nullable Element element) {
        this.error(message, element);
        return new VajramValidationException(message);
    }

    public void error(String message, @Nullable Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private String getTimestamp() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.now(ZoneId.of((String)Preconditions.checkNotNull((Object)ZoneId.SHORT_IDS.get("IST")))));
    }

    public static String getRequestInterfaceName(String vajramName) {
        return vajramName + "_Req";
    }

    public static String getImmutRequestInterfaceName(String vajramName) {
        return vajramName + "_ImmutReq";
    }

    public static String getImmutRequestPojoName(String vajramName) {
        return vajramName + "_ImmutReqPojo";
    }

    public static String getVajramImplClassName(String vajramId) {
        return vajramId + "_Wrpr";
    }

    public static String getFacetsInterfaceName(String vajramName) {
        return vajramName + "_Fac";
    }

    public static String getImmutFacetsClassname(String vajramName) {
        return vajramName + "_ImmutFacPojo";
    }

    public TypeName toTypeName(DataType<?> dataType) {
        return TypeName.get((TypeMirror)this.toTypeMirror(dataType));
    }

    public TypeMirror toTypeMirror(DataType<?> dataType) {
        return dataType.javaModelType(this.processingEnv);
    }

    public static TypeName toTypeName(Type typeArg) {
        if (typeArg instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeArg;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            return ParameterizedTypeName.get((ClassName)((ClassName)Utils.toTypeName(rawType)), (TypeName[])((TypeName[])Arrays.stream(typeArgs).map(Utils::toTypeName).toArray(TypeName[]::new)));
        }
        if (typeArg instanceof Class) {
            return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
        }
        return ClassName.bestGuess((String)typeArg.getTypeName());
    }

    public static List<? extends TypeMirror> getTypeParameters(TypeMirror returnType) {
        return returnType.accept(new SimpleTypeVisitor14<List<? extends TypeMirror>, Void>(){

            @Override
            public List<? extends TypeMirror> visitDeclared(DeclaredType t, Void unused) {
                return t.getTypeArguments();
            }
        }, null);
    }

    public boolean isSameRawType(TypeMirror a, Class<?> b) {
        return this.processingEnv.getTypeUtils().isSameType(this.typeUtils.erasure(a), this.typeUtils.erasure(((TypeElement)Preconditions.checkNotNull((Object)this.processingEnv().getElementUtils().getTypeElement((CharSequence)Preconditions.checkNotNull((Object)b.getCanonicalName())), (Object)("TypeElement not found for: " + b.getCanonicalName()))).asType()));
    }

    public boolean isRawAssignable(TypeMirror from, Class<?> to) {
        return Utils.isRawAssignable(from, to, this.processingEnv());
    }

    public TypeMirror box(TypeMirror type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType p = (PrimitiveType)type;
            return this.typeUtils.boxedClass(p).asType();
        }
        return type;
    }

    public TypeSpec.Builder classBuilder(String className) {
        TypeSpec.Builder classBuilder = className.isBlank() ? TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]) : TypeSpec.classBuilder((String)className);
        return this.addDefaultAnnotations(classBuilder);
    }

    private TypeSpec.Builder addDefaultAnnotations(TypeSpec.Builder classBuilder) {
        classBuilder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", (CodeBlock)Stream.of(CodeBlock.of((String)"$S", (Object[])new Object[]{"unchecked"}), CodeBlock.of((String)"$S", (Object[])new Object[]{"ClassReferencesSubclass"})).collect(CodeBlock.joining((String)",", (String)"{", (String)"}"))).build());
        this.addGeneratedAnnotations(classBuilder);
        return classBuilder;
    }

    public void addGeneratedAnnotations(TypeSpec.Builder classBuilder) {
        classBuilder.addAnnotation(AnnotationSpec.builder(com.flipkart.krystal.vajram.annos.Generated.class).addMember("by", "$S", new Object[]{this.generator.getName()}).build()).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{this.generator.getName()}).addMember("date", "$S", new Object[]{this.getTimestamp()}).build());
    }

    public TypeSpec.Builder interfaceBuilder(String interfaceName) {
        if (interfaceName.isBlank()) {
            throw new RuntimeException("interface name connot be blank");
        }
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)interfaceName);
        return this.addDefaultAnnotations(interfaceBuilder);
    }

    public TypeAndName box(TypeAndName javaType, AnnotationSpec ... annotationSpecs) {
        List<AnnotationSpec> annotationSpecList = Streams.concat((Stream[])new Stream[]{javaType.annotationSpecs().stream(), Arrays.stream(annotationSpecs)}).distinct().toList();
        @Nullable TypeMirror typeMirror = javaType.type();
        if (typeMirror == null || !typeMirror.getKind().isPrimitive()) {
            return new TypeAndName(javaType.typeName(), null, annotationSpecList);
        }
        TypeMirror boxed = this.processingEnv.getTypeUtils().boxedClass((PrimitiveType)typeMirror).asType();
        return new TypeAndName(TypeName.get((TypeMirror)boxed).annotated(annotationSpecList), boxed, annotationSpecList);
    }

    TypeName optional(TypeAndName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{this.box(javaType, new AnnotationSpec[0]).typeName()});
    }

    TypeName responseType(DependencyModel dep) {
        return this.responseType(new TypeAndName((TypeName)Utils.toClassName(dep.depReqClassQualifiedName())), this.getTypeName(dep.dataType()));
    }

    private TypeName responseType(TypeAndName requestType, TypeAndName facetType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(One2OneDepResponse.class), (TypeName[])new TypeName[]{this.box(facetType, new AnnotationSpec[0]).typeName(), requestType.typeName()});
    }

    public TypeName responsesType(DependencyModel dep) {
        return this.responsesType(new TypeAndName((TypeName)Utils.toClassName(dep.depReqClassQualifiedName())), this.getTypeName(dep.dataType()));
    }

    private TypeName responsesType(TypeAndName requestType, TypeAndName facetType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(FanoutDepResponses.class), (TypeName[])new TypeName[]{this.box(facetType, new AnnotationSpec[0]).typeName(), requestType.typeName()});
    }

    TypeAndName getTypeName(DataType<?> dataType, List<AnnotationSpec> typeAnnotations) {
        TypeMirror javaModelType = dataType.javaModelType(this.processingEnv);
        return new TypeAndName(TypeName.get((TypeMirror)javaModelType).annotated(typeAnnotations), javaModelType, typeAnnotations);
    }

    public TypeAndName getTypeName(DataType<?> dataType) {
        return this.getTypeName(dataType, List.of());
    }

    public DataType<?> getDataType(FacetGenModel abstractInput) {
        if (abstractInput instanceof DefaultFacetModel) {
            DefaultFacetModel facetDef = (DefaultFacetModel)abstractInput;
            return facetDef.dataType();
        }
        if (abstractInput instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)abstractInput;
            return dep.dataType();
        }
        throw new UnsupportedOperationException("Unable to extract datatype from facet : %s".formatted(abstractInput));
    }

    public ExecutableElement getMethodToOverride(Class<?> clazz, String methodName, int paramCount) {
        return ((TypeElement)Preconditions.checkNotNull((Object)this.processingEnv().getElementUtils().getTypeElement((CharSequence)Preconditions.checkNotNull((Object)clazz.getCanonicalName())))).getEnclosedElements().stream().filter(element -> element instanceof ExecutableElement).map(element -> (ExecutableElement)element).filter(element -> element.getSimpleName().contentEquals(methodName) && element.getParameters().size() == paramCount).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find method '" + methodName + "' with param count '" + paramCount + "' in class " + clazz));
    }

    public FacetJavaType getFacetFieldType(FacetGenModel facet) {
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            if (dep.canFanout()) {
                return new FacetJavaType.FanoutResponses(this);
            }
            return new FacetJavaType.One2OneResponse(this);
        }
        return new FacetJavaType.Boxed(this);
    }

    public String getJavaTypeCreationCode(JavaType<?> javaType, List<TypeName> collectClassNames, VariableElement facetField) {
        TypeMirror typeMirror = javaType.javaModelType(this.processingEnv);
        collectClassNames.add((TypeName)ClassName.get(JavaType.class));
        if (javaType.typeParameters().isEmpty()) {
            collectClassNames.add(TypeName.get((TypeMirror)typeMirror));
            return "$T.create($T.class)";
        }
        collectClassNames.add(TypeName.get((TypeMirror)this.processingEnv.getTypeUtils().erasure(typeMirror)));
        return "$T.create($T.class, " + javaType.typeParameters().stream().map(dataType -> {
            if (!(dataType instanceof JavaType)) {
                this.error("Unrecognised data type %s".formatted(dataType), facetField);
                return "";
            }
            JavaType typeParamType = (JavaType)dataType;
            return this.getJavaTypeCreationCode(typeParamType, collectClassNames, facetField);
        }).collect(Collectors.joining(",")) + ")";
    }

    public Path detectSourceOutputPath(@Nullable Element codeGenElement) {
        Path sourcePath;
        try {
            FileObject dummyFile = this.processingEnv().getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", new Random().nextInt() + "_dummy_detect_source_path.txt", new Element[0]);
            sourcePath = Paths.get(dummyFile.toUri());
            dummyFile.delete();
        }
        catch (Exception e) {
            throw this.errorAndThrow("Could not detect source output directory because dummy_detect_source_path.txt could not be created", codeGenElement);
        }
        return Objects.requireNonNull(sourcePath.getParent());
    }

    @lombok.Generated
    public ProcessingEnvironment processingEnv() {
        return this.processingEnv;
    }

    private /* synthetic */ DependencyModel lambda$computeVajramInfo$17(VajramInfoLite vajramInfoLite, BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VariableElement depField) {
        return this.toDependencyModel(vajramInfoLite.vajramId(), depField, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId);
    }

    private /* synthetic */ DefaultFacetModel lambda$computeVajramInfo$15(BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite, VariableElement internalField) {
        return this.toGivenFacetModel(internalField, false, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite);
    }

    private /* synthetic */ DefaultFacetModel lambda$computeVajramInfo$14(BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite, VariableElement inputField) {
        return this.toGivenFacetModel(inputField, true, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite);
    }
}

