/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.IfNull;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.common.models.Constants;
import com.flipkart.krystal.vajram.codegen.common.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.Utils;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.facets.FacetValidation;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class FacetJavaType {
    protected final Utils util;

    public FacetJavaType(Utils util) {
        this.util = util;
    }

    public abstract TypeName javaTypeName(FacetGenModel var1);

    public CodeBlock fieldGetterCode(FacetGenModel facet, CodeGenParams codeGenParams) {
        boolean facetInCurrentClass;
        if (codeGenParams.isFacetsSubset()) {
            return CodeBlock.of((String)"return this.$L.$L()", (Object[])new Object[]{"_facetValues", facet.name()});
        }
        boolean bl = facetInCurrentClass = codeGenParams.isRequest() || !facet.facetTypes().contains((Object)FacetType.INPUT) || !codeGenParams.wrapsRequest();
        if (facetInCurrentClass) {
            return CodeBlock.of((String)"return this.$L", (Object[])new Object[]{facet.name()});
        }
        if (codeGenParams.wrapsRequest()) {
            return CodeBlock.of((String)"return this._request.$L()", (Object[])new Object[]{facet.name()});
        }
        throw new UnsupportedOperationException("This should not happen. " + this);
    }

    public CodeBlock fieldInitializer(FacetGenModel facet) {
        return CodeBlock.of((String)"$T.$L.getPlatformDefaultValue()", (Object[])new Object[]{ClassName.get((String)facet.vajramInfo().packageName(), (String)Utils.getFacetsInterfaceName(facet.vajramInfo().vajramId().id()), (String[])new String[0]), facet.name() + "_s"});
    }

    public Class<?>[] typeAnnotations(FacetGenModel facet, CodeGenParams codeGenParams) {
        return new Class[0];
    }

    public static final class FanoutResponses
    extends FacetJavaType {
        public FanoutResponses(Utils util) {
            super(util);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.responsesType((DependencyModel)facet);
        }

        @Override
        public CodeBlock fieldInitializer(FacetGenModel facet) {
            return CodeBlock.of((String)"$T.empty()", (Object[])new Object[]{FanoutDepResponses.class});
        }
    }

    public static final class One2OneResponse
    extends FacetJavaType {
        public One2OneResponse(Utils util) {
            super(util);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.responseType((DependencyModel)facet);
        }

        @Override
        public CodeBlock fieldInitializer(FacetGenModel facet) {
            return CodeBlock.of((String)"$T.noRequest()", (Object[])new Object[]{One2OneDepResponse.class});
        }
    }

    public static final class OptionalType
    extends FacetJavaType {
        public OptionalType(Utils utils) {
            super(utils);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.optional(this.util.box(this.util.getTypeName(this.util.getDataType(facet)), new AnnotationSpec[0]));
        }

        @Override
        public CodeBlock fieldInitializer(FacetGenModel facet) {
            return CodeBlock.of((String)"$T.empty()", (Object[])new Object[]{Optional.class});
        }

        @Override
        public CodeBlock fieldGetterCode(FacetGenModel facet, CodeGenParams codeGenParams) {
            if (codeGenParams.isSubsetBatch()) {
                return CodeBlock.of((String)"return $T.ofNullable(this.$L.$L())", (Object[])new Object[]{Optional.class, "_facetValues", facet.name()});
            }
            return super.fieldGetterCode(facet, codeGenParams);
        }
    }

    public static final class Boxed
    extends FacetJavaType {
        public Boxed(Utils utils) {
            super(utils);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.box(this.util.getTypeName(this.util.getDataType(facet)), new AnnotationSpec[0]).typeName();
        }

        @Override
        public Class<?>[] typeAnnotations(FacetGenModel facet, CodeGenParams codeGenParams) {
            return new Class[]{Nullable.class};
        }

        @Override
        public CodeBlock fieldInitializer(FacetGenModel facet) {
            return CodeBlock.of((String)"null", (Object[])new Object[0]);
        }
    }

    public static final class Actual
    extends FacetJavaType {
        public Actual(Utils utils) {
            super(utils);
        }

        @Override
        public TypeName javaTypeName(FacetGenModel facet) {
            return this.util.getTypeName(this.util.getDataType(facet)).typeName();
        }

        @Override
        public CodeBlock fieldInitializer(FacetGenModel facet) {
            IfNull ifNull = facet.facetField().getAnnotation(IfNull.class);
            if (ifNull != null && ifNull.value().usePlatformDefault()) {
                if (facet.dataType().hasPlatformDefaultValue(this.util.processingEnv())) {
                    return CodeBlock.of((String)"$T.$L.getPlatformDefaultValue()", (Object[])new Object[]{ClassName.get((String)facet.vajramInfo().packageName(), (String)Utils.getFacetsInterfaceName(facet.vajramInfo().vajramId().id()), (String[])new String[0]), facet.name() + "_s"});
                }
                throw new VajramDefinitionException("The datatype " + facet.dataType() + " does not support a platform default value. To fix this issue, change the ifNotSet strategy of the @Mandatory annotation to a value which does not allow default value.");
            }
            return Constants.EMPTY_CODE_BLOCK;
        }

        @Override
        public Class<?>[] typeAnnotations(FacetGenModel facet, CodeGenParams codeGenParams) {
            if (!(facet instanceof DependencyModel || this.javaTypeName(facet).isPrimitive() || codeGenParams.isSubsetBatch())) {
                return new Class[]{Nullable.class};
            }
            return super.typeAnnotations(facet, codeGenParams);
        }

        @Override
        public CodeBlock fieldGetterCode(FacetGenModel facet, CodeGenParams codeGenParams) {
            if (codeGenParams.isSubsetBatch()) {
                IfNull ifNull = facet.facetField().getAnnotation(IfNull.class);
                if (ifNull != null && !ifNull.value().usePlatformDefault()) {
                    return CodeBlock.of((String)"return $T.validateMandatoryFacet(this.$L.$L(), $S, $S)\n", (Object[])new Object[]{FacetValidation.class, "_facetValues", facet.name(), facet.vajramInfo().vajramId().id(), facet.name()});
                }
                return CodeBlock.of((String)"return this.$L.$L()", (Object[])new Object[]{"_facetValues", facet.name()});
            }
            return super.fieldGetterCode(facet, codeGenParams);
        }
    }
}

