/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.vajram.codegen.common.models.Utils;
import com.google.common.collect.ImmutableMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor14;

public class DeclaredTypeVisitor<T>
extends AbstractTypeVisitor14<DataType<T>, Void> {
    private final Utils util;
    private final Element element;
    private final ImmutableMap<Class<?>, String> disallowedTypes;

    public DeclaredTypeVisitor(Utils util, Element element) {
        this(util, element, ImmutableMap.of());
    }

    public DeclaredTypeVisitor(Utils util, Element element, ImmutableMap<Class<?>, String> disallowedTypes) {
        this.util = util;
        this.element = element;
        this.disallowedTypes = disallowedTypes;
    }

    @Override
    public DataType<T> visitDeclared(DeclaredType t, Void inputDef) {
        Element elementOfType;
        String disallowedMessage = this.util.getDisallowedMessage(t, this.disallowedTypes);
        if (disallowedMessage != null) {
            this.util.error(disallowedMessage, this.element);
        }
        if ((elementOfType = t.asElement()) instanceof QualifiedNameable) {
            QualifiedNameable qualifiedNameable = (QualifiedNameable)elementOfType;
            return JavaType.create((String)qualifiedNameable.getQualifiedName().toString(), (DataType[])((DataType[])t.getTypeArguments().stream().map(this::visit).toArray(DataType[]::new)));
        }
        throw this.util.errorAndThrow("Could not infer data type for type " + elementOfType, this.element);
    }

    @Override
    public DataType<T> visitPrimitive(PrimitiveType t, Void unused) {
        PrimitiveType withoutAnnotations = this.util.processingEnv().getTypeUtils().getPrimitiveType(t.getKind());
        return JavaType.create((String)withoutAnnotations.toString(), (DataType[])new DataType[0]);
    }

    @Override
    public DataType<T> visitArray(ArrayType t, Void unused) {
        throw DeclaredTypeVisitor.uoe("Array types are not supported by Krystal. Use collections instead.");
    }

    @Override
    public DataType<T> visitTypeVariable(TypeVariable t, Void unused) {
        throw DeclaredTypeVisitor.uoe();
    }

    @Override
    public DataType<T> visitNull(NullType t, Void unused) {
        throw DeclaredTypeVisitor.uoe();
    }

    @Override
    public DataType<T> visitIntersection(IntersectionType t, Void unused) {
        throw DeclaredTypeVisitor.uoe();
    }

    @Override
    public DataType<T> visitError(ErrorType t, Void unused) {
        throw DeclaredTypeVisitor.uoe();
    }

    @Override
    public DataType<T> visitWildcard(WildcardType t, Void unused) {
        throw DeclaredTypeVisitor.uoe();
    }

    @Override
    public DataType<T> visitExecutable(ExecutableType t, Void unused) {
        throw DeclaredTypeVisitor.uoe();
    }

    @Override
    public DataType<T> visitNoType(NoType t, Void unused) {
        throw DeclaredTypeVisitor.uoe();
    }

    @Override
    public DataType<T> visitUnion(UnionType t, Void unused) {
        throw DeclaredTypeVisitor.uoe();
    }

    private static UnsupportedOperationException uoe(String message) {
        return new UnsupportedOperationException(message);
    }

    private static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException();
    }
}

