/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.codegen.common.datatypes.DataTypeRegistry;
import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.codegen.common.models.TypeAndName;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.vajram.Trait;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.common.models.Constants;
import com.flipkart.krystal.vajram.codegen.common.models.DefaultFacetModel;
import com.flipkart.krystal.vajram.codegen.common.models.DeferCodeGenToNextRound;
import com.flipkart.krystal.vajram.codegen.common.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetJavaType;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.facets.Dependency;
import com.flipkart.krystal.vajram.facets.FacetIdNameMapping;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.reflection.qual.ClassValBottom;
import org.checkerframework.common.reflection.qual.MethodValBottom;
import org.checkerframework.common.reflection.qual.UnknownClass;
import org.checkerframework.common.reflection.qual.UnknownMethod;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenUtility {
    @Generated
    private static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(VajramCodeGenUtility.class);
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> DISALLOWED_FACET_TYPES = ImmutableMap.builder().put(Optional.class, (Object)(Optional.class + " is not an allowed facet type. All facets are optional by default. So this should not be needed.")).put(Request.class, (Object)(Request.class + " is not an allowed facet type as this can cause undesired behaviour.")).put(FacetValues.class, (Object)(FacetValues.class + " is not an allowed facet type as this can cause undesired behaviour.")).build();
    public static final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Splitter QUALIFIED_FACET_SPLITTER = Splitter.onPattern((String)":");
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ProcessingEnvironment processingEnv;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Types typeUtils;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Elements elementUtils;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataTypeRegistry dataTypeRegistry;
    private final @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility codegenUtil;

    public VajramCodeGenUtility(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ProcessingEnvironment processingEnv, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> generator, @Nullable @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String phaseString) {
        this.processingEnv = processingEnv;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.dataTypeRegistry = new DataTypeRegistry();
        this.codegenUtil = new CodeGenUtility(processingEnv, generator, phaseString);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetJavaType getFacetReturnType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel facet, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenParams codeGenParams) {
        boolean localDevAccessible;
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            if (dep.canFanout()) {
                return new FacetJavaType.FanoutResponses(this);
            }
            return new FacetJavaType.One2OneResponse(this);
        }
        boolean bl = localDevAccessible = codeGenParams.isDevAccessible() && codeGenParams.isLocal();
        if (localDevAccessible) {
            IfAbsent ifAbsent = this.codegenUtil.getIfAbsent((Element)facet.facetField());
            if (ifAbsent.value().isMandatoryOnServer()) {
                return new FacetJavaType.Actual(this);
            }
            return new FacetJavaType.OptionalType(this);
        }
        return new FacetJavaType.Boxed(this);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String extractFacetName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramId, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String qualifiedFacet, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement resolverMethod) {
        List parts = QUALIFIED_FACET_SPLITTER.splitToList((CharSequence)qualifiedFacet);
        if (parts.size() != 2) {
            throw this.codegenUtil.errorAndThrow("Qualified Facet is not of the form <vajramId>:<facetName> : " + qualifiedFacet, new Element[]{resolverMethod});
        }
        if (!vajramId.equals(parts.get(0))) {
            this.codegenUtil().error("Expected vajram id '" + vajramId + "' does not match with the given qualified facet: " + qualifiedFacet, new Element[]{resolverMethod});
        }
        return (String)parts.get(1);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement> getDefinitionClasses(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RoundEnvironment roundEnv) {
        return Stream.concat(roundEnv.getElementsAnnotatedWith(Vajram.class).stream().filter(element -> element.getKind() == ElementKind.CLASS).map(executableElement -> (TypeElement)executableElement).filter(typeElement -> typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)), roundEnv.getElementsAnnotatedWith(Trait.class).stream().filter(element -> element.getKind() == ElementKind.INTERFACE).map(executableElement -> (TypeElement)executableElement)).toList();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo computeVajramInfo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramClass) {
        VajramInfoLite vajramInfoLite = this.computeVajramInfoLite(vajramClass);
        VajramInfoLite conformsToTraitInfo = this.getConformToTraitInfoFromVajram(vajramClass);
        Optional<Element> inputsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_Inputs")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        Optional<Element> internalFacetsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_InternalFacets")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        HashBiMap givenIdsByName = HashBiMap.create();
        Set takenFacetIds = givenIdsByName.values();
        List<VariableElement> inputFields = ElementFilter.fieldsIn(inputsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> internalFacetFields = ElementFilter.fieldsIn(internalFacetsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> dependencyFields = internalFacetFields.stream().filter(variableElement -> variableElement.getAnnotation(Dependency.class) != null).toList();
        AtomicInteger nextFacetId = new AtomicInteger(1);
        VajramInfo vajramInfo = new VajramInfo(vajramInfoLite, (ImmutableList<DefaultFacetModel>)((ImmutableList)Streams.concat((Stream[])new Stream[]{inputFields.stream(), internalFacetFields.stream()}).map(arg_0 -> this.lambda$computeVajramInfo$12((BiMap)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite, arg_0)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())), (ImmutableList<DependencyModel>)((ImmutableList)dependencyFields.stream().map(arg_0 -> this.lambda$computeVajramInfo$13(vajramInfoLite, (BiMap)givenIdsByName, takenFacetIds, nextFacetId, arg_0)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())), conformsToTraitInfo);
        this.codegenUtil().note((CharSequence)"VajramInfo: %s".formatted(vajramInfo));
        this.validateVajramInfo(vajramInfo);
        return vajramInfo;
    }

    private void validateVajramInfo(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo) {
        vajramInfo.facetStream().forEach(facetGenModel -> {
            if (facetGenModel.name().startsWith("_")) {
                @Nullable Element[] elements = new Element[]{facetGenModel.facetField()};
                this.codegenUtil().error("Facet names cannot start with an underscore (_). These are reserved for platform specific identifiers", elements);
            }
        });
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DefaultFacetModel> toGivenFacetModel(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement facetField, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BiMap<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer> givenIdsByName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer> takenFacetIds, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent AtomicInteger nextFacetId, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfoLite vajramInfoLite) {
        DefaultFacetModel.DefaultFacetModelBuilder facetBuilder = DefaultFacetModel.builder().facetField(facetField);
        String facetName = facetField.getSimpleName().toString();
        facetBuilder.id(Objects.requireNonNullElseGet((Integer)givenIdsByName.get((Object)facetName), () -> VajramCodeGenUtility.getNextAvailableFacetId(takenFacetIds, nextFacetId)));
        facetBuilder.name(facetName);
        facetBuilder.documentation(this.elementUtils.getDocComment(facetField));
        TypeMirror facetFieldType = facetField.asType();
        if (TypeKind.ERROR.equals((Object)facetFieldType.getKind())) {
            throw new DeferCodeGenToNextRound();
        }
        CodeGenType dataType = (CodeGenType)facetFieldType.accept(new DeclaredTypeVisitor(this.codegenUtil, (Element)facetField, DISALLOWED_FACET_TYPES), null);
        facetBuilder.dataType(dataType);
        FacetType facetType = null;
        boolean isInput = "_Inputs".contentEquals(facetField.getEnclosingElement().getSimpleName());
        if (isInput) {
            facetType = FacetType.INPUT;
        }
        if (facetField.getAnnotation(Inject.class) != null) {
            if (isInput) {
                this.codegenUtil().error("Inject facet '%s' cannot be an input facet".formatted(facetName), new Element[]{facetField});
            }
            facetType = FacetType.INJECTION;
        }
        if (facetType == null) {
            return Optional.empty();
        }
        DefaultFacetModel facetModel = facetBuilder.facetType(facetType).vajramInfo(vajramInfoLite).build();
        givenIdsByName.putIfAbsent((Object)facetName, (Object)facetModel.id());
        return Optional.of(facetModel);
    }

    private static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int getNextAvailableFacetId(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer> takenFacetIds, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent AtomicInteger nextFacetId) {
        while (takenFacetIds.contains(nextFacetId.get())) {
            nextFacetId.getAndIncrement();
        }
        return nextFacetId.getAndIncrement();
    }

    private @Nullable @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyModel toDependencyModel(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID vajramId, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VariableElement depField, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BiMap<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer> givenIdsByName, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Integer> takenFacetIds, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent AtomicInteger nextFacetId) {
        String facetName = depField.getSimpleName().toString();
        Dependency dependency = depField.getAnnotation(Dependency.class);
        DependencyModel.DependencyModelBuilder depBuilder = DependencyModel.builder().facetField(depField);
        depBuilder.id(Objects.requireNonNullElseGet((Integer)givenIdsByName.get((Object)facetName), () -> VajramCodeGenUtility.getNextAvailableFacetId(takenFacetIds, nextFacetId)));
        depBuilder.name(facetName);
        Optional<TypeMirror> vajramReqType = this.codegenUtil.getTypeFromAnnotationMember(() -> ((Dependency)dependency).withVajramReq()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(CodeGenUtility.getTypeElement((String)Request.class.getName(), (ProcessingEnvironment)this.processingEnv).getQualifiedName()));
        Optional<TypeMirror> vajramType = this.codegenUtil.getTypeFromAnnotationMember(() -> ((Dependency)dependency).onVajram()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(CodeGenUtility.getTypeElement((String)VajramDef.class.getName(), (ProcessingEnvironment)this.processingEnv).getQualifiedName()));
        TypeMirror vajramOrReqType = vajramReqType.or(() -> vajramType).orElseThrow(() -> {
            String message = "At least one of `onVajram` or `withVajramReq` is needed in dependency declaration '%s' of vajram '%s'".formatted(depField.getSimpleName(), vajramId);
            this.codegenUtil().error(message, new Element[]{depField});
            return new VajramDefinitionException("Invalid Dependency specification");
        });
        depBuilder.documentation(this.elementUtils.getDocComment(depField));
        if (!vajramReqType.isPresent() || !vajramType.isPresent()) {
            CodeGenType declaredDataType = (CodeGenType)new DeclaredTypeVisitor(this.codegenUtil, (Element)depField, DISALLOWED_FACET_TYPES).visit(depField.asType());
            TypeElement vajramOrReqElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.processingEnv.getTypeUtils().asElement(vajramOrReqType)));
            VajramInfoLite depVajramInfoLite = this.computeVajramInfoLite(vajramOrReqElement);
            depBuilder.depVajramInfo(depVajramInfoLite).depReqClassQualifiedName(this.getVajramReqClassName(vajramOrReqElement)).canFanout(dependency.canFanout());
            if (!declaredDataType.equals(depVajramInfoLite.responseType())) {
                this.codegenUtil().error("Declared dependency type %s does not match dependency vajram response type %s".formatted(declaredDataType, depVajramInfoLite.responseType()), new Element[]{depField});
            }
            DependencyModel depModel = depBuilder.dataType(declaredDataType).vajramInfo(depVajramInfoLite).build();
            givenIdsByName.putIfAbsent((Object)facetName, (Object)depModel.id());
            return depModel;
        }
        String message = "Both `withVajramReq` and `onVajram` cannot be set. Please set only one of them for dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get());
        this.codegenUtil().error(message, new Element[]{depField});
        message = "Invalid dependency spec of dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get());
        this.codegenUtil().error(message, new Element[]{depField});
        return null;
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfoLite computeVajramInfoLite(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramOrReqClass) {
        CodeGenType responseType;
        VajramID vajramId;
        String vajramClassSimpleName = vajramOrReqClass.getSimpleName().toString();
        ImmutableBiMap facetIdNameMappings = ImmutableBiMap.of();
        String packageName = this.elementUtils.getPackageOf(vajramOrReqClass).getQualifiedName().toString();
        TypeMirror from1 = vajramOrReqClass.asType();
        if (this.codegenUtil().isRawAssignable(from1, Request.class)) {
            facetIdNameMappings = (ImmutableBiMap)ElementFilter.fieldsIn(vajramOrReqClass.getEnclosedElements()).stream().filter(element -> {
                TypeElement t;
                DeclaredType d;
                Element patt18054$temp;
                TypeMirror patt17985$temp = element.asType();
                return patt17985$temp instanceof DeclaredType && (patt18054$temp = (d = (DeclaredType)patt17985$temp).asElement()) instanceof TypeElement && (t = (TypeElement)patt18054$temp).getQualifiedName().contentEquals(InputMirrorSpec.class.getCanonicalName());
            }).map(element -> element.getAnnotation(FacetIdNameMapping.class)).filter(Objects::nonNull).collect(ImmutableBiMap.toImmutableBiMap(FacetIdNameMapping::id, FacetIdNameMapping::name));
            TypeMirror responseTypeMirror = this.getVajramResponseType(vajramOrReqClass, Request.class);
            TypeElement responseTypeElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.typeUtils.asElement(responseTypeMirror)));
            vajramId = VajramID.vajramID((String)vajramClassSimpleName.substring(0, vajramClassSimpleName.length() - "_Req".length()));
            responseType = (CodeGenType)new DeclaredTypeVisitor(this.codegenUtil, (Element)responseTypeElement, DISALLOWED_FACET_TYPES).visit(responseTypeMirror);
        } else {
            TypeMirror from = vajramOrReqClass.asType();
            if (this.codegenUtil().isRawAssignable(from, VajramDefRoot.class)) {
                Vajram vajram = vajramOrReqClass.getAnnotation(Vajram.class);
                Trait trait = vajramOrReqClass.getAnnotation(Trait.class);
                if (vajram == null && trait == null) {
                    throw this.codegenUtil.errorAndThrow("Vajram class does not have either @VajramDef or @VajramTrait annotation. This should not happen", new Element[]{vajramOrReqClass});
                }
                TypeMirror responseTypeMirror = this.getVajramResponseType(vajramOrReqClass, VajramDefRoot.class);
                TypeElement responseTypeElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.typeUtils.asElement(responseTypeMirror)));
                TypeElement requestType = this.elementUtils.getTypeElement(packageName + "." + VajramCodeGenUtility.getRequestInterfaceName(vajramClassSimpleName));
                if (requestType != null) {
                    facetIdNameMappings = (ImmutableBiMap)ElementFilter.fieldsIn(requestType.getEnclosedElements()).stream().filter(element -> {
                        TypeElement t;
                        DeclaredType d;
                        Element patt20209$temp;
                        TypeMirror patt20136$temp = element.asType();
                        return patt20136$temp instanceof DeclaredType && (patt20209$temp = (d = (DeclaredType)patt20136$temp).asElement()) instanceof TypeElement && (t = (TypeElement)patt20209$temp).getQualifiedName().contentEquals(InputMirrorSpec.class.getCanonicalName());
                    }).map(element -> element.getAnnotation(FacetIdNameMapping.class)).filter(Objects::nonNull).collect(ImmutableBiMap.toImmutableBiMap(FacetIdNameMapping::id, FacetIdNameMapping::name));
                }
                vajramId = this.getVajramIdOfVajramClass(vajramOrReqClass);
                responseType = (CodeGenType)new DeclaredTypeVisitor(this.codegenUtil, (Element)responseTypeElement, DISALLOWED_FACET_TYPES).visit(responseTypeMirror);
            } else {
                throw new IllegalArgumentException("Unknown class hierarchy of vajram class %s. Expected %s or %s".formatted(vajramOrReqClass, VajramDef.class, ImmutableRequest.class));
            }
        }
        return new VajramInfoLite(vajramId, responseType, packageName, (ImmutableBiMap<Integer, String>)facetIdNameMappings, vajramOrReqClass, this.codegenUtil.processingEnv().getElementUtils().getDocComment(vajramOrReqClass), this);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID getVajramIdOfVajramClass(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramOrReqClass) {
        return VajramID.vajramID((String)vajramOrReqClass.getSimpleName().toString());
    }

    private @Nullable @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfoLite getConformToTraitInfoFromVajram(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramClass) {
        Optional<TypeElement> conformsToTrait = this.getConformsToTraitType(vajramClass);
        VajramInfoLite conformsToTraitInfo = null;
        if (conformsToTrait.isPresent()) {
            conformsToTraitInfo = this.computeVajramInfoLite(conformsToTrait.get());
        }
        return conformsToTraitInfo;
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement> getConformsToTraitType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramOrReqClass) {
        for (TypeMirror typeMirror : vajramOrReqClass.getInterfaces()) {
            Element element = this.typeUtils.asElement(typeMirror);
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            if (((Element)Preconditions.checkNotNull((Object)element)).getAnnotation(Trait.class) == null) continue;
            return Optional.of(typeElement);
        }
        return Optional.empty();
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getVajramReqClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramClass) {
        TypeMirror from1 = vajramClass.asType();
        if (this.codegenUtil().isRawAssignable(from1, VajramDefRoot.class)) {
            return vajramClass.getQualifiedName().toString() + "_Req";
        }
        TypeMirror from = vajramClass.asType();
        if (this.codegenUtil().isRawAssignable(from, Request.class)) {
            return vajramClass.getQualifiedName().toString();
        }
        throw new AssertionError((Object)("This should not happen! Found:" + vajramClass));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeMirror getVajramResponseType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramOrReqType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownVal @BottomVal @UnknownClass @ClassValBottom @UnknownMethod @MethodValBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> targetClass) {
        int typeParamIndex = 0;
        TypeElement targetParentClass = Objects.requireNonNull(this.elementUtils.getTypeElement(Objects.requireNonNull(targetClass.getCanonicalName())));
        ImmutableList typeParameters = this.codegenUtil().getTypeParamTypes(vajramOrReqType, targetParentClass);
        if (typeParameters.size() > typeParamIndex) {
            return (TypeMirror)typeParameters.get(typeParamIndex);
        }
        throw this.codegenUtil.errorAndThrow("Incorrect number of parameter types on Vajram interface. Expected 1, Found %s. Unable to infer response type for Vajram %s".formatted(typeParameters, vajramOrReqType.getQualifiedName()), new Element[]{vajramOrReqType});
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getRequestInterfaceName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramName) {
        return vajramName + "_Req";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getImmutRequestInterfaceName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramName) {
        return vajramName + "_ReqImmut";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getImmutRequestPojoName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramName) {
        return vajramName + Constants.IMMUT_REQUEST_POJO_SUFFIX;
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getVajramImplClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramId) {
        return vajramId + "_Wrpr";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getFacetsInterfaceName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramName) {
        return vajramName + "_Fac";
    }

    public static @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getImmutFacetsClassName(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String vajramName) {
        return vajramName + "_FacImmutPojo";
    }

    @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName responseType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyModel dep) {
        return this.responseType(new TypeAndName((TypeName)this.codegenUtil().toClassName(dep.depReqClassQualifiedName())), this.codegenUtil().getTypeName(dep.dataType()));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName responseType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeAndName requestType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeAndName facetType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(One2OneDepResponse.class), (TypeName[])new TypeName[]{requestType.typeName(), this.codegenUtil().box(facetType).typeName()});
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName responsesType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependencyModel dep) {
        return this.responsesType(new TypeAndName((TypeName)this.codegenUtil().toClassName(dep.depReqClassQualifiedName())), this.codegenUtil().getTypeName(dep.dataType()));
    }

    private @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeName responsesType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeAndName requestType, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeAndName facetType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(FanoutDepResponses.class), (TypeName[])new TypeName[]{requestType.typeName(), this.codegenUtil().box(facetType).typeName()});
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenType getDataType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel abstractInput) {
        if (abstractInput instanceof DefaultFacetModel) {
            DefaultFacetModel facetDef = (DefaultFacetModel)abstractInput;
            return facetDef.dataType();
        }
        if (abstractInput instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)abstractInput;
            return dep.dataType();
        }
        throw new UnsupportedOperationException("Unable to extract datatype from facet : %s".formatted(abstractInput));
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetJavaType getFacetFieldType(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel facet) {
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            if (dep.canFanout()) {
                return new FacetJavaType.FanoutResponses(this);
            }
            return new FacetJavaType.One2OneResponse(this);
        }
        return new FacetJavaType.Boxed(this);
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean usePlatformDefault(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel facet) {
        IfAbsent ifAbsent = facet.facetField().getAnnotation(IfAbsent.class);
        return ifAbsent != null && ifAbsent.value().usePlatformDefault();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isMandatoryOnServer(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel facet) {
        IfAbsent ifAbsent = facet.facetField().getAnnotation(IfAbsent.class);
        return ifAbsent != null && ifAbsent.value().isMandatoryOnServer();
    }

    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Path detectSourceOutputPath(@Nullable @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Element codeGenElement) {
        Path sourcePath;
        try {
            FileObject dummyFile = this.processingEnv().getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", new Random().nextInt() + "_dummy_detect_source_path.txt", new Element[0]);
            sourcePath = Paths.get(dummyFile.toUri());
            dummyFile.delete();
        }
        catch (Exception e) {
            throw this.codegenUtil.errorAndThrow("Could not detect source output directory because dummy_detect_source_path.txt could not be created", new Element[]{codeGenElement});
        }
        return Objects.requireNonNull(sourcePath.getParent());
    }

    public <T> T getAnnotationElement(@UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent AnnotationMirror parentModelRootAnno, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String annoElement, @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<T> type) {
        return type.cast(this.elementUtils.getElementValuesWithDefaults(parentModelRootAnno).entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals(annoElement)).findAny().map(Map.Entry::getValue).orElseThrow(AssertionError::new).getValue());
    }

    @Generated
    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ProcessingEnvironment processingEnv() {
        return this.processingEnv;
    }

    @Generated
    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataTypeRegistry dataTypeRegistry() {
        return this.dataTypeRegistry;
    }

    @Generated
    public @UnknownVal @UnknownClass @UnknownMethod @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility codegenUtil() {
        return this.codegenUtil;
    }

    private /* synthetic */ Optional lambda$computeVajramInfo$13(VajramInfoLite vajramInfoLite, BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VariableElement depField) {
        return Optional.ofNullable(this.toDependencyModel(vajramInfoLite.vajramId(), depField, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId));
    }

    private /* synthetic */ Optional lambda$computeVajramInfo$12(BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite, VariableElement inputField) {
        return this.toGivenFacetModel(inputField, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite);
    }
}

