package com.flipkart.krystal.vajram.codegen.common.intellij;

import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import java.util.function.Predicate;

record ScopeInfo(String name, Predicate<VajramInfo> memberShipCondition, StringBuilder xml) {

  public ScopeInfo(String name, Predicate<VajramInfo> memberShipCondition) {
    this(
        name,
        memberShipCondition,
        new StringBuilder(
            """
            <!--
            ---- Auto generated by %s.
            ---- Any changes made to this file will be overwritten
            -->
            <component name="DependencyValidationManager">
            """
                .formatted(VajramScopesGeneratorProvider.class)));
  }

  public void writeOut(VajramCodeGenUtility util) {
    // TODO: We need to write this scope out in such a way that all information across projects is
    //        collated in a single file in the root project - this needs some investigation.
  }
}
