/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.codegen.common.models;

import com.flipkart.krystal.annos.ComputeDelegationMode;
import com.flipkart.krystal.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.codegen.common.datatypes.DataTypeRegistry;
import com.flipkart.krystal.codegen.common.models.CodeGenShortCircuitException;
import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.codegen.common.models.TypeAndName;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FanoutDepResponses;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.One2OneDepResponse;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.vajram.ComputeVajramDef;
import com.flipkart.krystal.vajram.IOVajramDef;
import com.flipkart.krystal.vajram.Trait;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenParams;
import com.flipkart.krystal.vajram.codegen.common.models.Constants;
import com.flipkart.krystal.vajram.codegen.common.models.DefaultFacetModel;
import com.flipkart.krystal.vajram.codegen.common.models.DependencyModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.FacetJavaType;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.facets.Dependency;
import com.flipkart.krystal.vajram.facets.FacetIdNameMapping;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramCodeGenUtility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VajramCodeGenUtility.class);
    private static final ImmutableMap<Class<?>, String> DISALLOWED_FACET_TYPES = ImmutableMap.builder().put(Optional.class, (Object)(String.valueOf(Optional.class) + " is not an allowed facet type. All facets are optional by default. So this should not be needed.")).put(Request.class, (Object)(String.valueOf(Request.class) + " is not an allowed facet type as this can cause undesired behaviour.")).put(FacetValues.class, (Object)(String.valueOf(FacetValues.class) + " is not an allowed facet type as this can cause undesired behaviour.")).build();
    public static final Splitter QUALIFIED_FACET_SPLITTER = Splitter.onPattern((String)":");
    private final ProcessingEnvironment processingEnv;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final DataTypeRegistry dataTypeRegistry;
    private final CodeGenUtility codegenUtil;

    public VajramCodeGenUtility(CodeGenUtility codegenUtil) {
        this.codegenUtil = codegenUtil;
        this.processingEnv = codegenUtil.processingEnv();
        this.typeUtils = this.processingEnv.getTypeUtils();
        this.elementUtils = this.processingEnv.getElementUtils();
        this.dataTypeRegistry = new DataTypeRegistry();
    }

    public FacetJavaType getFacetReturnType(FacetGenModel facet, CodeGenParams codeGenParams) {
        boolean localDevAccessible;
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            if (dep.canFanout()) {
                return new FacetJavaType.FanoutResponses(this);
            }
            return new FacetJavaType.One2OneResponse(this);
        }
        boolean bl = localDevAccessible = codeGenParams.isDevAccessible() && codeGenParams.isLocal();
        if (localDevAccessible) {
            IfAbsent ifAbsent = this.codegenUtil.getIfAbsent((Element)facet.facetField());
            if (ifAbsent.value().isMandatoryOnServer()) {
                return new FacetJavaType.Actual(this);
            }
            return new FacetJavaType.OptionalType(this);
        }
        return new FacetJavaType.Boxed(this);
    }

    public String extractFacetName(String vajramId, String qualifiedFacet, ExecutableElement resolverMethod) {
        List parts = QUALIFIED_FACET_SPLITTER.splitToList((CharSequence)qualifiedFacet);
        if (parts.size() != 2) {
            throw this.codegenUtil.errorAndThrow("Qualified Facet is not of the form <vajramId>:<facetName> : " + qualifiedFacet, new Element[]{resolverMethod});
        }
        if (!vajramId.equals(parts.get(0))) {
            this.codegenUtil().error("Expected vajram id '" + vajramId + "' does not match with the given qualified facet: " + qualifiedFacet, new Element[]{resolverMethod});
        }
        return (String)parts.get(1);
    }

    public List<TypeElement> getDefinitionClasses(RoundEnvironment roundEnv) {
        return Stream.concat(roundEnv.getElementsAnnotatedWith(Vajram.class).stream().filter(element -> element.getKind() == ElementKind.CLASS).map(executableElement -> (TypeElement)executableElement).filter(typeElement -> typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)), roundEnv.getElementsAnnotatedWith(Trait.class).stream().filter(element -> element.getKind() == ElementKind.INTERFACE).map(executableElement -> (TypeElement)executableElement)).toList();
    }

    public VajramInfo computeVajramInfo(TypeElement vajramClass) {
        ComputeDelegationMode outputLogicDelegationMode;
        VajramInfoLite vajramInfoLite = this.computeVajramInfoLite(vajramClass);
        VajramInfoLite conformsToTraitInfo = this.getConformToTraitInfoFromVajram(vajramClass);
        String parentClassName = null;
        if (vajramInfoLite.isVajram()) {
            parentClassName = ((TypeElement)this.codegenUtil.processingEnv().getTypeUtils().asElement(vajramClass.getSuperclass())).getQualifiedName().toString();
        }
        Optional<Element> inputsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_Inputs")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        Optional<Element> internalFacetsClass = vajramClass.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.CLASS).filter(element -> element.getSimpleName().contentEquals("_InternalFacets")).findFirst().map(element -> this.typeUtils.asElement(element.asType()));
        HashBiMap givenIdsByName = HashBiMap.create();
        Set takenFacetIds = givenIdsByName.values();
        List<VariableElement> inputFields = ElementFilter.fieldsIn(inputsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> internalFacetFields = ElementFilter.fieldsIn(internalFacetsClass.map(Element::getEnclosedElements).orElse(List.of()));
        List<VariableElement> dependencyFields = internalFacetFields.stream().filter(variableElement -> variableElement.getAnnotation(Dependency.class) != null).toList();
        AtomicInteger nextFacetId = new AtomicInteger(1);
        if (vajramInfoLite.isTrait()) {
            outputLogicDelegationMode = null;
        } else if (IOVajramDef.class.getCanonicalName().equals(parentClassName)) {
            outputLogicDelegationMode = ComputeDelegationMode.SYNC;
        } else if (ComputeVajramDef.class.getCanonicalName().equals(parentClassName)) {
            outputLogicDelegationMode = ComputeDelegationMode.NONE;
        } else {
            throw this.codegenUtil.errorAndThrow("Unknown vajram parent class " + parentClassName, new Element[]{vajramClass});
        }
        VajramInfo vajramInfo = new VajramInfo(vajramInfoLite, (ImmutableList<DefaultFacetModel>)((ImmutableList)Streams.concat((Stream[])new Stream[]{inputFields.stream(), internalFacetFields.stream()}).map(arg_0 -> this.lambda$computeVajramInfo$12((BiMap)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite, arg_0)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())), (ImmutableList<DependencyModel>)((ImmutableList)dependencyFields.stream().map(arg_0 -> this.lambda$computeVajramInfo$13(vajramInfoLite, (BiMap)givenIdsByName, takenFacetIds, nextFacetId, arg_0)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())), conformsToTraitInfo, outputLogicDelegationMode);
        this.codegenUtil().note((CharSequence)"VajramInfo: %s".formatted(vajramInfo));
        this.validateVajramInfo(vajramInfo);
        return vajramInfo;
    }

    private void validateVajramInfo(VajramInfo vajramInfo) {
        vajramInfo.facetStream().forEach(facetGenModel -> {
            if (facetGenModel.name().startsWith("_")) {
                @Nullable Element[] elements = new Element[]{facetGenModel.facetField()};
                this.codegenUtil().error("Facet names cannot start with an underscore (_). These are reserved for platform specific identifiers", elements);
            }
        });
    }

    private Optional<DefaultFacetModel> toGivenFacetModel(VariableElement facetField, BiMap<String, Integer> givenIdsByName, Set<Integer> takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite) {
        DefaultFacetModel.DefaultFacetModelBuilder facetBuilder = DefaultFacetModel.builder().facetField(facetField);
        String facetName = facetField.getSimpleName().toString();
        facetBuilder.id(Objects.requireNonNullElseGet((Integer)givenIdsByName.get((Object)facetName), () -> VajramCodeGenUtility.getNextAvailableFacetId(takenFacetIds, nextFacetId)));
        facetBuilder.name(facetName);
        facetBuilder.documentation(this.elementUtils.getDocComment(facetField));
        TypeMirror facetFieldType = facetField.asType();
        if (TypeKind.ERROR.equals((Object)facetFieldType.getKind())) {
            throw new CodeGenShortCircuitException("Vajram Id : " + String.valueOf(vajramInfoLite.vajramId()) + " facet : " + facetName + " has an error type: " + String.valueOf(facetFieldType));
        }
        CodeGenType dataType = (CodeGenType)facetFieldType.accept(new DeclaredTypeVisitor(this.codegenUtil, (Element)facetField, DISALLOWED_FACET_TYPES), null);
        facetBuilder.dataType(dataType);
        FacetType facetType = null;
        boolean isInput = "_Inputs".contentEquals(facetField.getEnclosingElement().getSimpleName());
        if (isInput) {
            facetType = FacetType.INPUT;
        }
        if (facetField.getAnnotation(Inject.class) != null) {
            if (isInput) {
                this.codegenUtil().error("Inject facet '%s' cannot be an input facet".formatted(facetName), new Element[]{facetField});
            }
            facetType = FacetType.INJECTION;
        }
        if (facetType == null) {
            return Optional.empty();
        }
        DefaultFacetModel facetModel = facetBuilder.facetType(facetType).vajramInfo(vajramInfoLite).build();
        givenIdsByName.putIfAbsent((Object)facetName, (Object)facetModel.id());
        return Optional.of(facetModel);
    }

    private static int getNextAvailableFacetId(Set<Integer> takenFacetIds, AtomicInteger nextFacetId) {
        while (takenFacetIds.contains(nextFacetId.get())) {
            nextFacetId.getAndIncrement();
        }
        return nextFacetId.getAndIncrement();
    }

    private @Nullable DependencyModel toDependencyModel(VajramInfoLite vajramInfo, VariableElement depField, BiMap<String, Integer> givenIdsByName, Set<Integer> takenFacetIds, AtomicInteger nextFacetId) {
        VajramID vajramId = vajramInfo.vajramId();
        String facetName = depField.getSimpleName().toString();
        Dependency dependency = depField.getAnnotation(Dependency.class);
        DependencyModel.DependencyModelBuilder depBuilder = DependencyModel.builder().facetField(depField);
        depBuilder.id(Objects.requireNonNullElseGet((Integer)givenIdsByName.get((Object)facetName), () -> VajramCodeGenUtility.getNextAvailableFacetId(takenFacetIds, nextFacetId)));
        depBuilder.name(facetName);
        Optional<TypeMirror> vajramReqType = this.codegenUtil.getTypeFromAnnotationMember(() -> ((Dependency)dependency).withVajramReq()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(CodeGenUtility.getTypeElement((String)Request.class.getName(), (ProcessingEnvironment)this.processingEnv).getQualifiedName()));
        Optional<TypeMirror> vajramType = this.codegenUtil.getTypeFromAnnotationMember(() -> ((Dependency)dependency).onVajram()).filter(typeMirror -> !((QualifiedNameable)Preconditions.checkNotNull((Object)((QualifiedNameable)this.typeUtils.asElement((TypeMirror)typeMirror)))).getQualifiedName().equals(CodeGenUtility.getTypeElement((String)VajramDef.class.getName(), (ProcessingEnvironment)this.processingEnv).getQualifiedName()));
        TypeMirror vajramOrReqType = vajramReqType.or(() -> vajramType).orElseThrow(() -> {
            String message = "At least one of `onVajram` or `withVajramReq` is needed in dependency declaration '%s' of vajram '%s'".formatted(depField.getSimpleName(), vajramId);
            this.codegenUtil().error(message, new Element[]{depField});
            return new VajramDefinitionException("Invalid Dependency specification");
        });
        depBuilder.documentation(this.elementUtils.getDocComment(depField));
        if (!vajramReqType.isPresent() || !vajramType.isPresent()) {
            CodeGenType declaredDataType = (CodeGenType)depField.asType().accept(new DeclaredTypeVisitor(this.codegenUtil, (Element)depField, DISALLOWED_FACET_TYPES), null);
            TypeElement vajramOrReqElement = (TypeElement)Preconditions.checkNotNull((Object)((TypeElement)this.processingEnv.getTypeUtils().asElement(vajramOrReqType)));
            VajramInfoLite depVajramInfoLite = this.computeVajramInfoLite(vajramOrReqElement);
            depBuilder.depVajramInfo(depVajramInfoLite).depReqClassName(this.getVajramReqClassName(vajramOrReqElement)).canFanout(dependency.canFanout());
            if (!declaredDataType.equals(depVajramInfoLite.responseType())) {
                this.codegenUtil().error("Declared dependency type %s does not match dependency vajram response type %s".formatted(declaredDataType, depVajramInfoLite.responseType()), new Element[]{depField});
            }
            DependencyModel depModel = depBuilder.dataType(declaredDataType).vajramInfo(vajramInfo).build();
            givenIdsByName.putIfAbsent((Object)facetName, (Object)depModel.id());
            return depModel;
        }
        String message = "Both `withVajramReq` and `onVajram` cannot be set. Please set only one of them for dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get());
        this.codegenUtil().error(message, new Element[]{depField});
        message = "Invalid dependency spec of dependency '%s' of vajram '%s'. Found withVajramReq=%s and onVajram=%s".formatted(depField.getSimpleName(), vajramId, vajramReqType.get(), vajramType.get());
        this.codegenUtil().error(message, new Element[]{depField});
        return null;
    }

    public VajramInfoLite computeVajramInfoLite(TypeMirror vajramType) {
        DeclaredType declaredType;
        Element element;
        if (vajramType instanceof DeclaredType && (element = (declaredType = (DeclaredType)vajramType).asElement()) instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            return this.computeVajramInfoLite(typeElement, declaredType.getTypeArguments());
        }
        throw new AssertionError();
    }

    public VajramInfoLite computeVajramInfoLite(TypeElement vajramOrReqClass) {
        return this.computeVajramInfoLite(vajramOrReqClass, List.of());
    }

    public VajramInfoLite computeVajramInfoLite(TypeElement vajramOrReqClass, List<? extends TypeMirror> typeArguments) {
        CodeGenType responseType;
        VajramID vajramId;
        TypeElement requestType;
        String vajramClassSimpleName = vajramOrReqClass.getSimpleName().toString();
        String packageName = this.elementUtils.getPackageOf(vajramOrReqClass).getQualifiedName().toString();
        if (this.codegenUtil().isRawAssignable(vajramOrReqClass.asType(), Request.class)) {
            requestType = vajramOrReqClass;
            TypeMirror responseTypeMirror = this.getVajramResponseType(vajramOrReqClass, Request.class);
            vajramId = VajramID.vajramID((String)vajramClassSimpleName.substring(0, vajramClassSimpleName.length() - "_Req".length()));
            responseType = (CodeGenType)responseTypeMirror.accept(new DeclaredTypeVisitor(this.codegenUtil, (Element)vajramOrReqClass, DISALLOWED_FACET_TYPES), null);
        } else if (this.codegenUtil().isRawAssignable(vajramOrReqClass.asType(), VajramDefRoot.class)) {
            Vajram vajram = vajramOrReqClass.getAnnotation(Vajram.class);
            Trait trait = vajramOrReqClass.getAnnotation(Trait.class);
            if (vajram == null && trait == null) {
                throw this.codegenUtil.errorAndThrow("Vajram class does not have either @Vajram or @Trait annotation. This should not happen", new Element[]{vajramOrReqClass});
            }
            TypeMirror responseTypeMirror = this.getVajramResponseType(vajramOrReqClass, VajramDefRoot.class);
            requestType = this.elementUtils.getTypeElement(packageName + "." + VajramCodeGenUtility.getRequestInterfaceName(vajramClassSimpleName));
            vajramId = this.getVajramIdOfVajramClass(vajramOrReqClass);
            responseType = (CodeGenType)responseTypeMirror.accept(new DeclaredTypeVisitor(this.codegenUtil, (Element)vajramOrReqClass, DISALLOWED_FACET_TYPES), null);
        } else {
            throw new IllegalArgumentException("Unknown class hierarchy of vajram class %s. Expected %s or %s".formatted(vajramOrReqClass, VajramDef.class, ImmutableRequest.class));
        }
        return new VajramInfoLite(vajramId, responseType, packageName, this.facetDetailsFromRequestType(requestType), vajramOrReqClass, Collections.unmodifiableList(typeArguments), this.codegenUtil.processingEnv().getElementUtils().getDocComment(vajramOrReqClass), this);
    }

    private ImmutableMap<String, VajramInfoLite.FacetDetail> facetDetailsFromRequestType(@Nullable TypeElement requestType) {
        if (requestType == null) {
            return ImmutableMap.of();
        }
        return (ImmutableMap)ElementFilter.fieldsIn(requestType.getEnclosedElements()).stream().filter(element -> {
            TypeElement t;
            DeclaredType d;
            Element patt22569$temp;
            TypeMirror patt22506$temp = element.asType();
            return patt22506$temp instanceof DeclaredType && (patt22569$temp = (d = (DeclaredType)patt22506$temp).asElement()) instanceof TypeElement && (t = (TypeElement)patt22569$temp).getQualifiedName().contentEquals(InputMirrorSpec.class.getCanonicalName());
        }).map(facetSpecField -> {
            FacetIdNameMapping facetIdNameMapping = facetSpecField.getAnnotation(FacetIdNameMapping.class);
            return new VajramInfoLite.FacetDetail(facetIdNameMapping.id(), facetIdNameMapping.name(), (CodeGenType)((CodeGenType)facetSpecField.asType().accept(new DeclaredTypeVisitor(this.codegenUtil, (Element)requestType, ImmutableMap.of()), null)).typeParameters().get(0), FacetType.INPUT, this.elementUtils.getDocComment((Element)facetSpecField));
        }).collect(ImmutableMap.toImmutableMap(VajramInfoLite.FacetDetail::name, Function.identity()));
    }

    public VajramID getVajramIdOfVajramClass(TypeElement vajramOrReqClass) {
        return VajramID.vajramID((String)vajramOrReqClass.getSimpleName().toString());
    }

    private @Nullable VajramInfoLite getConformToTraitInfoFromVajram(TypeElement vajramClass) {
        Optional<TypeMirror> conformsToTrait = this.getConformsToTraitType(vajramClass);
        VajramInfoLite conformsToTraitInfo = null;
        if (conformsToTrait.isPresent()) {
            conformsToTraitInfo = this.computeVajramInfoLite(conformsToTrait.get());
        }
        return conformsToTraitInfo;
    }

    private Optional<TypeMirror> getConformsToTraitType(TypeElement vajramOrReqClass) {
        for (TypeMirror typeMirror : vajramOrReqClass.getInterfaces()) {
            Element element = this.typeUtils.asElement(typeMirror);
            if (!(element instanceof TypeElement) || ((Element)Preconditions.checkNotNull((Object)element)).getAnnotation(Trait.class) == null) continue;
            return Optional.of(typeMirror);
        }
        return Optional.empty();
    }

    private ClassName getVajramReqClassName(TypeElement vajramClass) {
        TypeMirror from1 = vajramClass.asType();
        if (this.codegenUtil().isRawAssignable(from1, VajramDefRoot.class)) {
            return ClassName.get((String)this.elementUtils.getPackageOf(vajramClass).getQualifiedName().toString(), (String)(String.valueOf(vajramClass.getSimpleName()) + "_Req"), (String[])new String[0]);
        }
        TypeMirror from = vajramClass.asType();
        if (this.codegenUtil().isRawAssignable(from, Request.class)) {
            return ClassName.get((TypeElement)vajramClass);
        }
        throw new AssertionError((Object)("This should not happen! Found:" + String.valueOf(vajramClass)));
    }

    private TypeMirror getVajramResponseType(TypeElement vajramOrReqType, Class<?> targetClass) {
        int typeParamIndex = 0;
        TypeElement targetParentClass = Objects.requireNonNull(this.elementUtils.getTypeElement(Objects.requireNonNull(targetClass.getCanonicalName())));
        ImmutableList typeParameters = this.codegenUtil().getTypeParamTypes(vajramOrReqType, targetParentClass);
        if (typeParameters.size() > typeParamIndex) {
            return (TypeMirror)typeParameters.get(typeParamIndex);
        }
        throw this.codegenUtil.errorAndThrow("Incorrect number of parameter types on Vajram interface %s. Expected 1, Found %s. Unable to infer response type for Vajram %s".formatted(targetClass, typeParameters, vajramOrReqType), new Element[]{vajramOrReqType});
    }

    public static String getRequestInterfaceName(String vajramName) {
        return vajramName + "_Req";
    }

    public static String getImmutRequestInterfaceName(String vajramName) {
        return vajramName + "_ReqImmut";
    }

    public static String getImmutRequestPojoName(String vajramName) {
        return vajramName + Constants.IMMUT_REQUEST_POJO_SUFFIX;
    }

    public static String getVajramImplClassName(String vajramId) {
        return vajramId + "_Wrpr";
    }

    public static String getFacetsInterfaceName(String vajramName) {
        return vajramName + "_Fac";
    }

    public static String getImmutFacetsClassName(String vajramName) {
        return vajramName + Constants.FACETS_IMMUT_CLASS_SUFFIX;
    }

    TypeName responseType(DependencyModel dep) {
        return this.responseType(new TypeAndName((TypeName)dep.depReqClassName()), this.codegenUtil().getTypeName(dep.dataType()));
    }

    private TypeName responseType(TypeAndName requestType, TypeAndName facetType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(One2OneDepResponse.class), (TypeName[])new TypeName[]{requestType.typeName(), this.codegenUtil().box(facetType).typeName()});
    }

    public TypeName responsesType(DependencyModel dep) {
        return this.responsesType(new TypeAndName((TypeName)dep.depReqClassName()), this.codegenUtil().getTypeName(dep.dataType()));
    }

    private TypeName responsesType(TypeAndName requestType, TypeAndName facetType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(FanoutDepResponses.class), (TypeName[])new TypeName[]{requestType.typeName(), this.codegenUtil().box(facetType).typeName()});
    }

    public CodeGenType getDataType(FacetGenModel abstractInput) {
        if (abstractInput instanceof DefaultFacetModel) {
            DefaultFacetModel facetDef = (DefaultFacetModel)abstractInput;
            return facetDef.dataType();
        }
        if (abstractInput instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)abstractInput;
            return dep.dataType();
        }
        throw new UnsupportedOperationException("Unable to extract datatype from facet : %s".formatted(abstractInput));
    }

    public FacetJavaType getFacetFieldType(FacetGenModel facet) {
        if (facet instanceof DependencyModel) {
            DependencyModel dep = (DependencyModel)facet;
            if (dep.canFanout()) {
                return new FacetJavaType.FanoutResponses(this);
            }
            return new FacetJavaType.One2OneResponse(this);
        }
        return new FacetJavaType.Boxed(this);
    }

    public boolean usePlatformDefault(FacetGenModel facet) {
        IfAbsent ifAbsent = facet.facetField().getAnnotation(IfAbsent.class);
        return ifAbsent != null && ifAbsent.value().usePlatformDefault();
    }

    public boolean isMandatoryOnServer(FacetGenModel facet) {
        IfAbsent ifAbsent = facet.facetField().getAnnotation(IfAbsent.class);
        return ifAbsent != null && ifAbsent.value().isMandatoryOnServer();
    }

    public Path detectSourceOutputPath(@Nullable Element codeGenElement) {
        Path sourcePath;
        try {
            FileObject dummyFile = this.processingEnv().getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", new Random().nextInt() + "_dummy_detect_source_path.txt", new Element[0]);
            sourcePath = Paths.get(dummyFile.toUri());
            dummyFile.delete();
        }
        catch (Exception e) {
            throw this.codegenUtil.errorAndThrow("Could not detect source output directory because dummy_detect_source_path.txt could not be created", new Element[]{codeGenElement});
        }
        return Objects.requireNonNull(sourcePath.getParent());
    }

    public <T> T getAnnotationElement(AnnotationMirror parentModelRootAnno, String annoElement, Class<T> type) {
        return type.cast(this.elementUtils.getElementValuesWithDefaults(parentModelRootAnno).entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals(annoElement)).findAny().map(Map.Entry::getValue).orElseThrow(AssertionError::new).getValue());
    }

    @Generated
    public ProcessingEnvironment processingEnv() {
        return this.processingEnv;
    }

    @Generated
    public DataTypeRegistry dataTypeRegistry() {
        return this.dataTypeRegistry;
    }

    @Generated
    public CodeGenUtility codegenUtil() {
        return this.codegenUtil;
    }

    private /* synthetic */ Optional lambda$computeVajramInfo$13(VajramInfoLite vajramInfoLite, BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VariableElement depField) {
        return Optional.ofNullable(this.toDependencyModel(vajramInfoLite, depField, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId));
    }

    private /* synthetic */ Optional lambda$computeVajramInfo$12(BiMap givenIdsByName, Set takenFacetIds, AtomicInteger nextFacetId, VajramInfoLite vajramInfoLite, VariableElement inputField) {
        return this.toGivenFacetModel(inputField, (BiMap<String, Integer>)givenIdsByName, takenFacetIds, nextFacetId, vajramInfoLite);
    }
}

