package com.flipkart.krystal.vajram.codegen.common.intellij;

import static com.google.common.base.Throwables.getStackTraceAsString;
import static java.util.Collections.unmodifiableList;

import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramsCodeGeneratorProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class VajramScopesGeneratorProvider implements AllVajramsCodeGeneratorProvider {

  private Map<Path, List<Path>> moduleRootsCache;

  @Override
  public CodeGenerator create(AllVajramCodeGenContext codeGenContext) {
    return () -> {
      for (VajramInfo vajramInfo : codeGenContext.vajramInfos()) {
        TypeElement typeElement = vajramInfo.vajramClassElem();
        VajramCodeGenUtility util = codeGenContext.util();
        ProcessingEnvironment processingEnv = util.processingEnv();
        try {
          FileObject vajramFile =
              processingEnv
                  .getFiler()
                  .getResource(
                      StandardLocation.SOURCE_PATH,
                      processingEnv.getElementUtils().getPackageOf(typeElement).getQualifiedName(),
                      typeElement.getSimpleName());
          List<Path> moduleRoots = findModuleRoots(Path.of(vajramFile.toUri()));


        } catch (IOException e) {
          util.codegenUtil()
              .error(
                  "Could not read vajram file to generate 'Vajram' scope xml for intellij ide platform"
                      + getStackTraceAsString(e),
                  typeElement);
        }
      }
    };
  }

  private List<Path> findModuleRoots(Path path) {
    List<Path> moduleRoots = moduleRootsCache.get(path);
    if (moduleRoots != null) {
      return moduleRoots;
    }
    moduleRoots = new ArrayList<>();
    if (path != null && path.resolve(".idea").toFile().exists()) {
      moduleRoots.add(path);
      moduleRoots.addAll(findModuleRoots(path));
    }
    moduleRootsCache.put(path, unmodifiableList(moduleRoots));
    return moduleRoots;
  }

  record FileModuleInfo(Path modulePath) {}
}
