/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.ext.cdi.injection;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.except.KrystalCompletionException;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.vajram.ext.cdi.injection.DependentRefProvider;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.inputinjection.InputInjectionUtils;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanContainer;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Provider;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class VajramCdiDynamicInjector
implements VajramInjectionProvider {
    private final Map<VajramID, Map<String, Supplier<? extends Provider<?>>>> providerCache = new LinkedHashMap();
    private final BeanContainer beanContainer = CDI.current().getBeanContainer();

    public <T> Provider<T> get(VajramID vajramID, FacetSpec<T, ?> facetDef) {
        if (!FacetType.INJECTION.equals((Object)facetDef.facetType())) {
            return () -> null;
        }
        Supplier providerSupplier = this.providerCache.computeIfAbsent(vajramID, _v -> new LinkedHashMap()).computeIfAbsent(facetDef.name(), _i -> {
            Type type;
            try {
                type = facetDef.type().javaReflectType();
            }
            catch (ClassNotFoundException e) {
                throw new KrystalCompletionException("Unable to load data type of Input", (Throwable)e);
            }
            Bean bean = this.beanContainer.resolve(this.beanContainer.getBeans(type, InputInjectionUtils.getQualifiers((FacetSpec)facetDef)));
            return () -> DependentRefProvider.newProvider(bean, type, this.beanContainer);
        });
        return (Provider)providerSupplier.get();
    }
}

