/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.rest;

import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.Unit;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.lattice.core.di.Bindings;
import com.flipkart.krystal.lattice.core.di.Produces;
import com.flipkart.krystal.lattice.core.doping.Dopant;
import com.flipkart.krystal.lattice.core.doping.DopantType;
import com.flipkart.krystal.lattice.core.headers.Header;
import com.flipkart.krystal.lattice.core.headers.SingleValueHeader;
import com.flipkart.krystal.lattice.ext.rest.RestService;
import com.flipkart.krystal.lattice.ext.rest.StatusCodes;
import com.flipkart.krystal.lattice.ext.rest.api.status.HttpResponseStatusException;
import com.flipkart.krystal.lattice.ext.rest.config.RestServiceDopantConfig;
import com.flipkart.krystal.lattice.krystex.KrystexDopant;
import com.flipkart.krystal.lattice.vajram.VajramRequestExecutionContext;
import com.flipkart.krystal.pooling.LeaseUnavailableException;
import com.flipkart.krystal.serial.SerializableModel;
import com.flipkart.krystal.tags.Names;
import io.smallrye.mutiny.Multi;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DopantType(value="krystal.lattice.restService")
public abstract class RestServiceDopant
implements Dopant<RestService, RestServiceDopantConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestServiceDopant.class);
    public static final String REST_SERVICE_DOPANT_TYPE = "krystal.lattice.restService";
    private final KrystexDopant krystexDopant;

    @Inject
    protected RestServiceDopant(KrystexDopant krystexDopant) {
        this.krystexDopant = krystexDopant;
    }

    public <RespT, T> CompletionStage<T> executeHttpRequest(ImmutableRequest<RespT> vajramRequest, HttpHeaders headers, UriInfo uriInfo) throws HttpResponseStatusException {
        List requestIds = headers.getRequestHeader("X-Request-Id");
        KryonExecutorConfig.KryonExecutorConfigBuilder executorConfigBuilder = KryonExecutorConfig.builder();
        if (requestIds != null && !requestIds.isEmpty()) {
            executorConfigBuilder.executorId((String)requestIds.get(0));
        }
        return this.executeHttpRequest(VajramRequestExecutionContext.builder().vajramRequest(vajramRequest).requestScopeSeeds(RestServiceDopant.getRequestScopeSeeds(headers, uriInfo)).executorConfigBuilder(executorConfigBuilder)).thenApply(response -> {
            Response.ResponseBuilder responseBuilder;
            int contentLength;
            block6: {
                contentLength = 0;
                try {
                    if (response == null || response instanceof Unit) {
                        responseBuilder = Response.ok();
                        break block6;
                    }
                    if (response instanceof SerializableModel) {
                        SerializableModel serializableResponse = (SerializableModel)response;
                        byte[] bytes = serializableResponse._serialize();
                        contentLength = bytes.length;
                        responseBuilder = Response.ok((Object)bytes).header("Content-Type", (Object)serializableResponse._serdeProtocol().defaultContentType());
                        break block6;
                    }
                    if (response instanceof Response.ResponseBuilder) {
                        Response.ResponseBuilder rb = (Response.ResponseBuilder)response;
                        return rb.build();
                    }
                    if (response instanceof Response) {
                        Response r = (Response)response;
                        return r;
                    }
                    return response;
                }
                catch (Throwable e) {
                    responseBuilder = Response.serverError();
                }
            }
            return responseBuilder.header("Content-Length", (Object)contentLength).build();
        });
    }

    public <T> Flow.Publisher<T> toPublisher(CompletionStage<Flow.Publisher<? extends T>> futurePublisher) {
        return Multi.createFrom().completionStage(futurePublisher).flatMap(Function.identity());
    }

    private <RespT> @NonNull CompletionStage<RespT> executeHttpRequest(VajramRequestExecutionContext.VajramRequestExecutionContextBuilder<RespT> contextBuilder) {
        try {
            return this.krystexDopant.executeRequest(contextBuilder.build());
        }
        catch (LeaseUnavailableException e) {
            log.error("Could not lease out single thread executor. Aborting request", (Throwable)e);
            throw new HttpResponseStatusException(StatusCodes.LEASE_UNAVAILABLE);
        }
    }

    @Named(value="Accept")
    @Produces(inScope=RequestScoped.class)
    public Header getAcceptHeader(HttpHeaders httpHeaders) {
        return Header.of((String)"Accept", (List)httpHeaders.getRequestHeader("Accept"));
    }

    private static Bindings getRequestScopeSeeds(HttpHeaders headers, UriInfo uriInfo) {
        Bindings.BindingsBuilder seeds = Bindings.builder();
        seeds.bind(HttpHeaders.class, (Object)headers);
        seeds.bind(UriInfo.class, (Object)uriInfo);
        for (Map.Entry entry : headers.getRequestHeaders().entrySet()) {
            String name = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value == null) continue;
            Header header = Header.of((String)name, (List)value);
            seeds.bind(Header.class, (Annotation)Names.named((String)name), (Object)header);
            if (!(header instanceof SingleValueHeader)) continue;
            SingleValueHeader singleValueHeader = (SingleValueHeader)header;
            seeds.bind(SingleValueHeader.class, (Annotation)Names.named((String)name), (Object)singleValueHeader);
        }
        return seeds.build();
    }

    protected List<? extends @NonNull Object> declaredApplicationResources() {
        return List.of();
    }
}

