package com.flipkart.krystal.lattice.ext.rest.config;

import static com.flipkart.krystal.lattice.ext.rest.RestServiceDopant.REST_SERVICE_DOPANT_TYPE;

import com.flipkart.krystal.lattice.core.doping.DopantConfig;
import com.flipkart.krystal.lattice.core.doping.DopantType;
import org.checkerframework.checker.nullness.qual.Nullable;

/**
 * @param applicationServer config for the "main" application server
 * @param adminServer Config for the admin server
 */
@DopantType(REST_SERVICE_DOPANT_TYPE)
public record RestServiceDopantConfig(
    RestServerConfig applicationServer, @Nullable RestServerConfig adminServer)
    implements DopantConfig {

  public RestServiceDopantConfig {
    applicationServer = applicationServer.withNameIfNotNamed("application");
    if (adminServer != null) {
      adminServer = adminServer.withNameIfNotNamed("admin");
    }
  }

  @Override
  public String _dopantType() {
    return REST_SERVICE_DOPANT_TYPE;
  }
}
