/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.rest;

import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.data.Unit;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.lattice.core.di.Bindings;
import com.flipkart.krystal.lattice.core.doping.DopantType;
import com.flipkart.krystal.lattice.core.doping.DopantWithAnnotation;
import com.flipkart.krystal.lattice.core.headers.Header;
import com.flipkart.krystal.lattice.core.headers.SingleValueHeader;
import com.flipkart.krystal.lattice.rest.RestService;
import com.flipkart.krystal.lattice.rest.RestServiceSpec;
import com.flipkart.krystal.lattice.rest.StatusCodes;
import com.flipkart.krystal.lattice.rest.api.status.HttpResponseStatusException;
import com.flipkart.krystal.lattice.vajram.VajramDopant;
import com.flipkart.krystal.lattice.vajram.VajramRequestExecutionContext;
import com.flipkart.krystal.pooling.LeaseUnavailableException;
import com.flipkart.krystal.serial.SerializableModel;
import com.flipkart.krystal.tags.Names;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jboss.resteasy.core.ResteasyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DopantType(value="krystal.lattice.restService")
public abstract class RestServiceDopant
implements DopantWithAnnotation<RestService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestServiceDopant.class);
    static final String REST_SERVICE_DOPANT_TYPE = "krystal.lattice.restService";
    private final VajramDopant vajramDopant;

    @Inject
    protected RestServiceDopant(RestServiceDopantInitData initData) {
        this.vajramDopant = initData.vajramDopant();
    }

    public <RespT> CompletionStage<Response> executeHttpRequest(ImmutableRequest<RespT> vajramRequest, HttpHeaders headers, UriInfo uriInfo) throws HttpResponseStatusException {
        List requestIds = headers.getRequestHeader("X-Request-Id");
        KryonExecutorConfig.KryonExecutorConfigBuilder executorConfigBuilder = KryonExecutorConfig.builder();
        if (requestIds != null && !requestIds.isEmpty()) {
            executorConfigBuilder.executorId((String)requestIds.get(0));
        }
        return this.executeHttpRequest(vajramRequest, RestServiceDopant.getRequestScopeSeeds(headers, uriInfo), executorConfigBuilder).thenApply(response -> {
            Response.ResponseBuilder responseBuilder;
            int contentLength = 0;
            try {
                if (response == null || response instanceof Unit) {
                    responseBuilder = Response.ok();
                } else if (response instanceof byte[]) {
                    byte[] bytes = (byte[])response;
                    contentLength = bytes.length;
                    responseBuilder = Response.ok((Object)bytes);
                } else if (response instanceof SerializableModel) {
                    SerializableModel serializableResponse = (SerializableModel)response;
                    byte[] bytes = serializableResponse._serialize();
                    contentLength = bytes.length;
                    responseBuilder = Response.ok((Object)bytes).header("Content-Type", (Object)serializableResponse._serdeProtocol().defaultContentType());
                } else {
                    if (response instanceof Response.ResponseBuilder) {
                        Response.ResponseBuilder rb = (Response.ResponseBuilder)response;
                        return rb.build();
                    }
                    if (response instanceof Response) {
                        Response r = (Response)response;
                        return r;
                    }
                    log.error("Executing vajram request of type {} an unsupported response model of type {}. Supported types are: {}", new Object[]{vajramRequest.getClass(), response.getClass(), List.of(byte[].class, SerializableModel.class, Response.ResponseBuilder.class, Response.class)});
                    responseBuilder = Response.serverError();
                }
            }
            catch (Throwable e) {
                responseBuilder = Response.serverError();
            }
            return responseBuilder.header("Content-Length", (Object)contentLength).build();
        });
    }

    public <RespT> CompletionStage<RespT> executeHttpRequest(ImmutableRequest<RespT> vajramRequest, Bindings requestScopeSeeds, KryonExecutorConfig.KryonExecutorConfigBuilder kryonExecutorConfigBuilder) throws HttpResponseStatusException {
        try {
            VajramRequestExecutionContext.VajramRequestExecutionContextBuilder contextBuilder = VajramRequestExecutionContext.builder().vajramRequest(vajramRequest).requestScopeSeeds(requestScopeSeeds).executorConfigBuilder(kryonExecutorConfigBuilder);
            RestServiceDopant.transferResteasyContext(contextBuilder);
            return this.vajramDopant.executeRequest(contextBuilder.build());
        }
        catch (LeaseUnavailableException e) {
            log.error("Could not lease out single thread executor. Aborting request", (Throwable)e);
            throw new HttpResponseStatusException(StatusCodes.LEASE_UNAVAILABLE);
        }
    }

    private static <RespT> void transferResteasyContext(VajramRequestExecutionContext.VajramRequestExecutionContextBuilder<RespT> contextBuilder) {
        Map contextDataMap = ResteasyContext.getContextDataMap((boolean)false);
        if (contextDataMap != null) {
            contextBuilder.requestScopeInitializer(() -> ResteasyContext.addCloseableContextDataLevel((Map)contextDataMap));
        }
    }

    private static Bindings getRequestScopeSeeds(HttpHeaders headers, UriInfo uriInfo) {
        Bindings.BindingsBuilder seeds = Bindings.builder();
        seeds.bind(HttpHeaders.class, (Object)headers);
        seeds.bind(UriInfo.class, (Object)uriInfo);
        for (Map.Entry entry : headers.getRequestHeaders().entrySet()) {
            String name = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value == null) continue;
            Header header = Header.of((String)name, (List)value);
            seeds.bind(Header.class, (Annotation)Names.named((String)name), (Object)header);
            if (!(header instanceof SingleValueHeader)) continue;
            SingleValueHeader singleValueHeader = (SingleValueHeader)header;
            seeds.bind(SingleValueHeader.class, (Annotation)Names.named((String)name), (Object)singleValueHeader);
        }
        return seeds.build();
    }

    public List<? extends @NonNull Object> getResources() {
        return List.of();
    }

    public static RestServiceSpec.RestServiceSpecBuilder restService() {
        return RestServiceSpec.builder();
    }

    protected record RestServiceDopantInitData(VajramDopant vajramDopant) {
    }
}

