/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.rest.quarkus.restServer;

import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.lattice.core.di.Bindings;
import com.flipkart.krystal.lattice.core.doping.SimpleDopant;
import com.flipkart.krystal.lattice.core.headers.Header;
import com.flipkart.krystal.lattice.core.headers.SingleValueHeader;
import com.flipkart.krystal.lattice.ext.quarkus.app.QuarkusApplicationDopant;
import com.flipkart.krystal.lattice.ext.rest.RestService;
import com.flipkart.krystal.lattice.ext.rest.RestServiceDopant;
import com.flipkart.krystal.lattice.ext.rest.api.status.HttpResponseStatusException;
import com.flipkart.krystal.lattice.ext.rest.config.RestServerConfig;
import com.flipkart.krystal.lattice.ext.rest.quarkus.restServer.QuarkusRestServerSpec;
import com.flipkart.krystal.serial.SerializableModel;
import com.flipkart.krystal.tags.Names;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.vertx.utils.NoBoundChecksBuffer;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jboss.resteasy.plugins.server.vertx.VertxRegistry;
import org.jboss.resteasy.plugins.server.vertx.VertxRequestHandler;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuarkusRestServerDopant
implements SimpleDopant {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuarkusRestServerDopant.class);
    static final String QUARKUS_REST_SERVER_DOPANT_TYPE = "krystal.lattice.restServer.quarkus";
    private final RestService restService;
    private final QuarkusApplicationDopant quarkusApplicationDopant;
    private final RestServiceDopant restServiceDopant;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    @Inject
    QuarkusRestServerDopant(RestService restService, RestServiceDopant restServiceDopant, QuarkusApplicationDopant quarkusApplicationDopant) {
        this.restService = restService;
        this.quarkusApplicationDopant = quarkusApplicationDopant;
        this.restServiceDopant = restServiceDopant;
    }

    public static QuarkusRestServerSpec.QuarkusRestServerSpecBuilder quarkusRestServer() {
        return QuarkusRestServerSpec.builder();
    }

    public void start() {
        Vertx vertx = this.quarkusApplicationDopant.vertx();
        this.startServer(this.restServiceDopant.config().applicationServer(), vertx, this.restServiceDopant.allApplicationRestResources());
        RestServerConfig adminServer = this.restServiceDopant.config().adminServer();
        if (adminServer != null) {
            this.startServer(adminServer, vertx, this.restServiceDopant.allAdminRestResources());
        }
    }

    private void startServer(RestServerConfig restServerConfig, Vertx vertx, List<?> restResources) {
        HttpServerOptions httpServerOptions = new HttpServerOptions();
        httpServerOptions.setPort(restServerConfig.port());
        vertx.createHttpServer(httpServerOptions).requestHandler(this.jaxRsRequestHandler(vertx, restResources)).listen(result -> {
            if (result.succeeded()) {
                log.info("Server '{}' started on port {} ", (Object)restServerConfig.name(), (Object)restServerConfig.port());
            } else {
                log.error("Could not start server {}", (Object)restServerConfig.name(), (Object)result.cause());
            }
        });
    }

    private Handler<HttpServerRequest> jaxRsRequestHandler(Vertx vertx, List<?> serverResources) {
        VertxResteasyDeployment deployment = new VertxResteasyDeployment();
        deployment.start();
        this.closeables.add(() -> ((VertxResteasyDeployment)deployment).stop());
        VertxRegistry registry = deployment.getRegistry();
        serverResources.forEach(arg_0 -> ((VertxRegistry)registry).addSingletonResource(arg_0));
        return new VertxRequestHandler(vertx, (ResteasyDeployment)deployment, this.restService.pathPrefix());
    }

    private <RespT> void executeHttpRequest(RoutingContext routingContext, CompletionStage<ImmutableRequest<RespT>> requestFuture) {
        HttpServerResponse httpResponse = routingContext.response();
        String requestId = routingContext.request().getHeader("X-Request-Id");
        Bindings seedMap = this.getRequestScopeSeedBindings(routingContext, requestId);
        requestFuture.thenCompose(request -> {
            KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder = KryonExecutorConfig.builder();
            if (requestId != null) {
                configBuilder.executorId(requestId);
            }
            return this.restServiceDopant.executeHttpRequest(request, seedMap, configBuilder);
        }).thenAccept(response -> {
            try {
                if (response == null) {
                    httpResponse.end();
                } else if (response instanceof byte[]) {
                    byte[] bytes = (byte[])response;
                    httpResponse.end((Buffer)new NoBoundChecksBuffer(Unpooled.wrappedBuffer((byte[])bytes)));
                } else if (response instanceof SerializableModel) {
                    SerializableModel serializableResponse = (SerializableModel)response;
                    httpResponse.putHeader("Content-Type", serializableResponse._serdeProtocol().defaultContentType()).end((Buffer)new NoBoundChecksBuffer(Unpooled.wrappedBuffer((byte[])serializableResponse._serialize())));
                } else {
                    log.error("Executing vajram request of type {} returned a non-serializable response model of type {}", ((ImmutableRequest)requestFuture.toCompletableFuture().join()).getClass(), response.getClass());
                    routingContext.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
                }
            }
            catch (Throwable e) {
                routingContext.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        }).whenComplete((response, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof HttpResponseStatusException) {
                    HttpResponseStatusException statusException = (HttpResponseStatusException)throwable;
                    routingContext.fail(statusException.status().statusCode());
                } else {
                    routingContext.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
                }
            }
        });
    }

    public void tryMainMethodExit() {
        this.closeables.forEach(autoCloseable -> {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                log.error("Could not perform cleanup of closeable", (Throwable)e);
            }
        });
    }

    private Bindings getRequestScopeSeedBindings(RoutingContext routingContext, @Nullable String requestId) {
        Bindings.BindingsBuilder seeds = Bindings.builder();
        seeds.bind(RoutingContext.class, (Object)routingContext);
        if (requestId != null) {
            seeds.bind(Header.class, (Annotation)Names.named((String)"X-Request-Id"), (Object)new SingleValueHeader("X-Request-Id", requestId));
        }
        return seeds.build();
    }
}

