/*
 * Decompiled with CFR 0.152.
 */
package flipkart.krystal.lattice.ext.rest.quarkus.restServer;

import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.lattice.core.di.Bindings;
import com.flipkart.krystal.lattice.core.doping.Dopant;
import com.flipkart.krystal.lattice.core.doping.DopantInitData;
import com.flipkart.krystal.lattice.core.execution.ThreadingStrategyDopant;
import com.flipkart.krystal.lattice.core.headers.Header;
import com.flipkart.krystal.lattice.core.headers.SingleValueHeader;
import com.flipkart.krystal.lattice.rest.RestService;
import com.flipkart.krystal.lattice.rest.RestServiceDopant;
import com.flipkart.krystal.lattice.rest.api.status.HttpResponseStatus;
import com.flipkart.krystal.lattice.rest.api.status.HttpResponseStatusException;
import com.flipkart.krystal.lattice.vajram.VajramDopant;
import com.flipkart.krystal.serial.SerializableModel;
import com.flipkart.krystal.tags.Names;
import flipkart.krystal.lattice.ext.rest.quarkus.app.QuarkusApplicationDopant;
import flipkart.krystal.lattice.ext.rest.quarkus.restServer.QuarkusRestServerConfig;
import flipkart.krystal.lattice.ext.rest.quarkus.restServer.QuarkusRestServerSpec;
import io.netty.buffer.Unpooled;
import io.quarkus.vertx.utils.NoBoundChecksBuffer;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.jboss.resteasy.plugins.server.vertx.VertxRegistry;
import org.jboss.resteasy.plugins.server.vertx.VertxRequestHandler;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuarkusRestServerDopant
implements Dopant<RestService, QuarkusRestServerConfig> {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(QuarkusRestServerDopant.class);
    static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String REST_SERVER_DOPANT_TYPE = "krystal.lattice.restServer.quarkus";
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusRestServerConfig config;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestService restService;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusApplicationDopant quarkusApplicationDopant;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestServiceDopant restServiceDopant;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    @Inject
    protected QuarkusRestServerDopant(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusRestDopantInitData initData) {
        this.config = initData.config();
        this.restService = initData.annotation();
        this.quarkusApplicationDopant = initData.quarkusApplicationDopant();
        this.restServiceDopant = initData.restServiceDopant();
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusRestServerSpec.QuarkusRestServerSpecBuilder quarkusRestServer() {
        return QuarkusRestServerSpec.builder();
    }

    public void start() {
        Vertx vertx = this.quarkusApplicationDopant.vertx();
        HttpServerOptions httpServerOptions = new HttpServerOptions();
        httpServerOptions.setPort(this.config.port());
        vertx.createHttpServer(httpServerOptions).requestHandler((Handler)this.getRouter(vertx)).listen(result -> {
            if (result.succeeded()) {
                log.info("Server started on port {} ", (Object)this.config.port());
            } else {
                log.error("", result.cause());
            }
        });
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Router getRouter(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Vertx vertx) {
        Handler<HttpServerRequest> jaxRsRequestHandler = this.jaxRsRequestHandler(vertx);
        Router router = Router.router((Vertx)vertx).errorHandler(HttpResponseStatus.NOT_FOUND.statusCode(), routingContext -> jaxRsRequestHandler.handle((Object)routingContext.request()));
        this.addRoutes(router);
        return router;
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Handler<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent HttpServerRequest> jaxRsRequestHandler(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Vertx vertx) {
        VertxResteasyDeployment deployment = new VertxResteasyDeployment();
        deployment.start();
        this.closeables.add(() -> ((VertxResteasyDeployment)deployment).stop());
        VertxRegistry registry = deployment.getRegistry();
        this.restServiceDopant.getResources().forEach(arg_0 -> ((VertxRegistry)registry).addSingletonResource(arg_0));
        return new VertxRequestHandler(vertx, (ResteasyDeployment)deployment, this.restService.pathPrefix());
    }

    protected abstract void addRoutes(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Router var1);

    protected final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getPathPrefix() {
        String pathPrefix = this.restService.pathPrefix();
        return pathPrefix.isEmpty() ? "" : "/" + pathPrefix;
    }

    protected <RespT> void executeHttpRequest(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RoutingContext routingContext, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletionStage<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableRequest<RespT>> requestFuture) {
        HttpServerResponse httpResponse = routingContext.response();
        String requestId = routingContext.request().getHeader("X-Request-Id");
        Bindings seedMap = this.getRequestScopeSeedBindings(routingContext, requestId);
        requestFuture.thenCompose(request -> {
            KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder = KryonExecutorConfig.builder();
            if (requestId != null) {
                configBuilder.executorId(requestId);
            }
            return this.restServiceDopant.executeHttpRequest(request, seedMap, configBuilder);
        }).thenAccept(response -> {
            try {
                if (response == null) {
                    httpResponse.end();
                } else if (response instanceof byte[]) {
                    byte[] bytes = (byte[])response;
                    httpResponse.end((Buffer)new NoBoundChecksBuffer(Unpooled.wrappedBuffer((byte[])bytes)));
                } else if (response instanceof SerializableModel) {
                    SerializableModel serializableResponse = (SerializableModel)response;
                    httpResponse.putHeader("Content-type", serializableResponse._serdeProtocol().contentType()).end((Buffer)new NoBoundChecksBuffer(Unpooled.wrappedBuffer((byte[])serializableResponse._serialize())));
                } else {
                    log.error("Executing vajram request of type {} returned a non-serializable response model of type {}", ((ImmutableRequest)requestFuture.toCompletableFuture().join()).getClass(), response.getClass());
                    routingContext.fail(io.netty.handler.codec.http.HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
                }
            }
            catch (Throwable e) {
                routingContext.fail(io.netty.handler.codec.http.HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        }).whenComplete((response, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof HttpResponseStatusException) {
                    HttpResponseStatusException statusException = (HttpResponseStatusException)throwable;
                    routingContext.fail(statusException.status().statusCode());
                } else {
                    routingContext.fail(io.netty.handler.codec.http.HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
                }
                return;
            }
        });
    }

    public void tryMainMethodExit() {
        this.closeables.forEach(autoCloseable -> {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                log.error("Could not perform cleanup of closeable", (Throwable)e);
            }
        });
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Bindings getRequestScopeSeedBindings(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RoutingContext routingContext, @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String requestId) {
        Bindings.BindingsBuilder seeds = Bindings.builder();
        seeds.bind(RoutingContext.class, (Object)routingContext);
        if (requestId != null) {
            seeds.bind(Header.class, (Annotation)Names.named((String)"X-Request-Id"), (Object)new SingleValueHeader("X-Request-Id", requestId));
        }
        return seeds.build();
    }

    protected static final class QuarkusRestDopantInitData
    extends Record
    implements DopantInitData<RestService, QuarkusRestServerConfig, QuarkusRestServerSpec> {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestService annotation;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusRestServerConfig config;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusRestServerSpec spec;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramDopant vajramDopant;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThreadingStrategyDopant threadingStrategyDopant;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestServiceDopant restServiceDopant;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusApplicationDopant quarkusApplicationDopant;

        @Inject
        public QuarkusRestDopantInitData(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestService annotation, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusRestServerConfig config, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusRestServerSpec spec, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramDopant vajramDopant, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThreadingStrategyDopant threadingStrategyDopant, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestServiceDopant restServiceDopant, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent QuarkusApplicationDopant quarkusApplicationDopant) {
            this.annotation = annotation;
            this.config = config;
            this.spec = spec;
            this.vajramDopant = vajramDopant;
            this.threadingStrategyDopant = threadingStrategyDopant;
            this.restServiceDopant = restServiceDopant;
            this.quarkusApplicationDopant = quarkusApplicationDopant;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{QuarkusRestDopantInitData.class, "annotation;config;spec;vajramDopant;threadingStrategyDopant;restServiceDopant;quarkusApplicationDopant", "annotation", "config", "spec", "vajramDopant", "threadingStrategyDopant", "restServiceDopant", "quarkusApplicationDopant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{QuarkusRestDopantInitData.class, "annotation;config;spec;vajramDopant;threadingStrategyDopant;restServiceDopant;quarkusApplicationDopant", "annotation", "config", "spec", "vajramDopant", "threadingStrategyDopant", "restServiceDopant", "quarkusApplicationDopant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{QuarkusRestDopantInitData.class, "annotation;config;spec;vajramDopant;threadingStrategyDopant;restServiceDopant;quarkusApplicationDopant", "annotation", "config", "spec", "vajramDopant", "threadingStrategyDopant", "restServiceDopant", "quarkusApplicationDopant"}, this, o);
        }

        public RestService annotation() {
            return this.annotation;
        }

        public QuarkusRestServerConfig config() {
            return this.config;
        }

        public QuarkusRestServerSpec spec() {
            return this.spec;
        }

        public VajramDopant vajramDopant() {
            return this.vajramDopant;
        }

        public ThreadingStrategyDopant threadingStrategyDopant() {
            return this.threadingStrategyDopant;
        }

        public RestServiceDopant restServiceDopant() {
            return this.restServiceDopant;
        }

        public QuarkusApplicationDopant quarkusApplicationDopant() {
            return this.quarkusApplicationDopant;
        }
    }
}

