/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.rest.quarkus.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.quarkus.runtime.QuarkusApplication;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

@AutoService(value={LatticeCodeGeneratorProvider.class})
public class QuarkusAppGenProvider
implements LatticeCodeGeneratorProvider {
    public CodeGenerator create(LatticeCodegenContext latticeCodegenContext) {
        return () -> {
            CodeGenUtility util = latticeCodegenContext.codeGenUtility().codegenUtil();
            CodegenPhase codegenPhase = latticeCodegenContext.codegenPhase();
            if (!CodegenPhase.FINAL.equals((Object)codegenPhase)) {
                util.note((CharSequence)("Skipping Quarkus App generation because this is not codegen phase: " + String.valueOf(CodegenPhase.FINAL)));
                return;
            }
            TypeElement latticeAppTypeElement = latticeCodegenContext.latticeAppTypeElement();
            String packageName = util.processingEnv().getElementUtils().getPackageOf(latticeAppTypeElement).getQualifiedName().toString();
            Name appClassName = latticeAppTypeElement.getSimpleName();
            String quarkusAppClassName = String.valueOf(appClassName) + "_QuarkusApp";
            util.generateSourceFile(ClassName.get((String)packageName, (String)quarkusAppClassName, (String[])new String[0]).canonicalName(), JavaFile.builder((String)packageName, (TypeSpec)util.classBuilder(quarkusAppClassName, latticeAppTypeElement.getQualifiedName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(QuarkusApplication.class).addMethod(MethodSpec.overriding((ExecutableElement)util.getMethod(QuarkusApplication.class, "run", 1)).addStatement("new $T().init(args)", new Object[]{ClassName.get((String)packageName, (String)(String.valueOf(appClassName) + "_Impl"), (String[])new String[0])}).addStatement("return 0", new Object[0]).build()).build()).build(), latticeAppTypeElement);
        };
    }
}

