/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.rest.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.codegen.common.spi.ModelProtocolConfigProvider;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenUtils;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.flipkart.krystal.lattice.rest.RestService;
import com.flipkart.krystal.lattice.rest.RestServiceDopant;
import com.flipkart.krystal.lattice.rest.api.Body;
import com.flipkart.krystal.lattice.rest.api.Path;
import com.flipkart.krystal.lattice.rest.api.PathParam;
import com.flipkart.krystal.lattice.rest.api.QueryParam;
import com.flipkart.krystal.lattice.rest.api.methods.RestMethod;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.serial.SerdeProtocol;
import com.flipkart.krystal.vajram.codegen.common.models.FacetGenModel;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

@AutoService(value={LatticeCodeGeneratorProvider.class})
public class JakartaRestServiceResourceGenProvider
implements LatticeCodeGeneratorProvider {
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenerator create(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext latticeCodegenContext) {
        return new JakartaRestServiceResourceGen(latticeCodegenContext);
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName> resourceClasses(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext context) {
        TypeElement latticeAppElem = context.latticeAppTypeElement();
        ArrayList<ClassName> resourceClasses = new ArrayList<ClassName>();
        CodeGenUtility util = context.codeGenUtility().codegenUtil();
        for (TypeElement vajramElem : JakartaRestServiceResourceGen.getRestResourceVajramElems(latticeAppElem, util)) {
            Path path = vajramElem.getAnnotation(Path.class);
            if (path != null && (path.value().startsWith("/") || path.value().endsWith("/"))) {
                util.error("Path value in @Path annotation cannot start or end with '/'", new Element[]{vajramElem});
            }
            VajramInfo vajramInfo = context.codeGenUtility().computeVajramInfo(vajramElem);
            ClassName jaxRsResourceName = JakartaRestServiceResourceGenProvider.getJaxRsResourceName(vajramInfo, vajramElem);
            resourceClasses.add(jaxRsResourceName);
        }
        return resourceClasses;
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassName getJaxRsResourceName(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramElem) {
        return ClassName.get((String)vajramInfo.lite().packageName(), (String)(vajramElem.getSimpleName().toString() + "_JakartaRestResource"), (String[])new String[0]);
    }

    private static class JakartaRestServiceResourceGen
    implements CodeGenerator {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext context;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util;

        public JakartaRestServiceResourceGen(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LatticeCodegenContext context) {
            this.context = context;
            this.util = context.codeGenUtility().codegenUtil();
        }

        public void generate() {
            if (!this.isApplicable()) {
                return;
            }
            TypeElement latticeAppElem = this.context.latticeAppTypeElement();
            this.jakartaResources(latticeAppElem);
            this.dopantImpl(latticeAppElem);
        }

        private void jakartaResources(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement latticeAppElem) {
            RestService restService = latticeAppElem.getAnnotation(RestService.class);
            String pathPrefix = restService.pathPrefix().isEmpty() ? "" : "/" + restService.pathPrefix();
            for (TypeElement vajramElem : JakartaRestServiceResourceGen.getRestResourceVajramElems(latticeAppElem, this.util)) {
                VajramInfo vajramInfo;
                List<MethodSpec> resourceMethods = this.resourceMethods(vajramElem, vajramInfo = this.context.codeGenUtility().computeVajramInfo(vajramElem));
                if (resourceMethods.isEmpty()) continue;
                Path path = vajramElem.getAnnotation(Path.class);
                String pathValue = path == null ? vajramInfo.vajramName() : path.value();
                ClassName jaxRsResourceName = JakartaRestServiceResourceGenProvider.getJaxRsResourceName(vajramInfo, vajramElem);
                TypeSpec.Builder resourceClassBuilder = this.util.classBuilder(jaxRsResourceName.simpleName(), latticeAppElem.getQualifiedName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC});
                resourceClassBuilder.addField(RestServiceDopant.class, "_restServiceDopant", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(jakarta.ws.rs.Path.class).addMember("value", "$S", new Object[]{pathPrefix + pathValue}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Inject.class).addParameter(RestServiceDopant.class, "_restServiceDopant", new Modifier[0]).addStatement("this._restServiceDopant = _restServiceDopant", new Object[0]).build()).addMethods(resourceMethods);
                this.util.generateSourceFile(jaxRsResourceName.canonicalName(), JavaFile.builder((String)jaxRsResourceName.packageName(), (TypeSpec)resourceClassBuilder.build()).build(), latticeAppElem);
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement> getRestResourceVajramElems(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement latticeAppElem, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util) {
            List<TypeElement> restResourceVajramElems = util.getTypesFromAnnotationMember(() -> ((RestService)latticeAppElem.getAnnotation(RestService.class)).resourceVajrams()).stream().map(typeMirror -> Objects.requireNonNull((TypeElement)util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror))).toList();
            return restResourceVajramElems;
        }

        private void dopantImpl(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement latticeAppElem) {
            List<ClassName> resourceClassNames = JakartaRestServiceResourceGenProvider.resourceClasses(this.context);
            String packageName = this.util.processingEnv().getElementUtils().getPackageOf(latticeAppElem).getQualifiedName().toString();
            LatticeCodegenUtils latticeCodegenUtils = new LatticeCodegenUtils(this.util);
            ClassName dopantImplName = latticeCodegenUtils.getDopantImplName(latticeAppElem, RestServiceDopant.class);
            TypeSpec.Builder dopantImplBuilder = this.util.classBuilder(dopantImplName.simpleName(), latticeAppElem.getQualifiedName().toString()).addModifiers(new Modifier[]{Modifier.FINAL}).superclass(RestServiceDopant.class).addMethod(latticeCodegenUtils.dopantConstructorOverride(RestServiceDopant.class).build());
            if (!resourceClassNames.isEmpty()) {
                dopantImplBuilder.addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(RestServiceDopant.class, RestServiceDopant.class.getMethod("getResources", new Class[0]).getName(), 0)).addStatement("return $T.of($L)", new Object[]{List.class, resourceClassNames.stream().map(rc -> CodeBlock.of((String)"new $T(this)", (Object[])new Object[]{rc})).collect(CodeBlock.joining((String)",\n"))}).build());
            }
            this.util.generateSourceFile(dopantImplName.canonicalName(), JavaFile.builder((String)packageName, (TypeSpec)dopantImplBuilder.build()).build(), latticeAppElem);
        }

        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec> resourceMethods(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement vajramElem, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo) {
            ArrayList<MethodSpec.Builder> resourceMethods = new ArrayList<MethodSpec.Builder>();
            @Nullable RestMethod restMethod = this.getRestMethod(vajramInfo);
            if (restMethod == null) {
                restMethod = RestMethod.POST;
            }
            boolean explicitPath = vajramElem.getAnnotation(Path.class) != null;
            Map configProviders = ServiceLoader.load(ModelProtocolConfigProvider.class, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).map(ModelProtocolConfigProvider::getConfig).map(ModelProtocolConfigProvider.ModelProtocolConfig::serdeProtocol).collect(Collectors.toMap(c -> Objects.requireNonNull(c.getClass().getCanonicalName()), Function.identity()));
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)CodeGenUtility.lowerCaseFirstChar((String)vajramInfo.vajramName())).addAnnotation(restMethod.jakartaAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(AsyncResponse.class, (String)"_asyncResponse", (Modifier[])new Modifier[0]).addAnnotation(Suspended.class).build()).addParameter(ParameterSpec.builder(HttpHeaders.class, (String)"_httpHeaders", (Modifier[])new Modifier[0]).addAnnotation(Context.class).build()).addParameter(ParameterSpec.builder(UriInfo.class, (String)"_uriInfo", (Modifier[])new Modifier[0]).addAnnotation(Context.class).build());
            LinkedHashMap<FacetGenModel, FacetParamType> params = new LinkedHashMap<FacetGenModel, FacetParamType>();
            Object bodyFacet = null;
            for (Object facet2 : vajramInfo.facetStream().toList()) {
                VariableElement variableElement = facet2.facetField();
                if (variableElement.getAnnotation(PathParam.class) != null) {
                    if (!explicitPath) {
                        this.util.error("Path param cannot be used without @Path annotation", new Element[]{variableElement});
                    } else {
                        this.assignTypeToFacet((FacetGenModel)facet2, FacetParamType.PATH, params);
                    }
                }
                if (variableElement.getAnnotation(QueryParam.class) != null) {
                    if (!explicitPath) {
                        this.util.error("Query param cannot be used without @Path annotation", new Element[]{variableElement});
                    } else {
                        this.assignTypeToFacet((FacetGenModel)facet2, FacetParamType.QUERY, params);
                    }
                }
                if (variableElement.getAnnotation(Body.class) == null) continue;
                if (!explicitPath) {
                    this.util.error("Body param cannot be used without @Path annotation", new Element[]{variableElement});
                    continue;
                }
                this.assignTypeToFacet((FacetGenModel)facet2, FacetParamType.BODY, params);
                bodyFacet = facet2;
            }
            ImmutableList requestSerdeProtocols = ImmutableList.of();
            for (Map.Entry entry : params.entrySet()) {
                FacetGenModel facet3 = (FacetGenModel)entry.getKey();
                FacetParamType facetParamType = (FacetParamType)((Object)entry.getValue());
                TypeMirror facetType = facet3.dataType().javaModelType(this.util.processingEnv());
                if (facetParamType == FacetParamType.PATH) {
                    methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)facetType), (String)facet3.name(), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(jakarta.ws.rs.PathParam.class).addMember("value", "$S", new Object[]{facet3.name()}).build()).build());
                    continue;
                }
                if (facetParamType == FacetParamType.QUERY) {
                    methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)facetType), (String)facet3.name(), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(jakarta.ws.rs.QueryParam.class).addMember("value", "$S", new Object[]{facet3.name()}).build()).build());
                    continue;
                }
                if (facetParamType != FacetParamType.BODY) continue;
                Element bodyTypeElem = Objects.requireNonNull(this.util.processingEnv().getTypeUtils().asElement(facetType));
                SupportedModelProtocols supportedModelProtocols = bodyTypeElem.getAnnotation(SupportedModelProtocols.class);
                if (supportedModelProtocols == null) {
                    this.util.error("Rest request Body facet " + facet3.name() + " doesn't support any ModelProtocol.", new Element[]{facet3.facetField()});
                    continue;
                }
                requestSerdeProtocols = (ImmutableList)this.util.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value()).stream().filter(t -> this.util.isRawAssignable(t, SerdeProtocol.class)).map(typeMirror -> Objects.requireNonNull((TypeElement)this.util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror))).collect(ImmutableList.toImmutableList());
                if (!requestSerdeProtocols.isEmpty()) continue;
                this.util.error("Rest request Body facet " + facet3.name() + " doesn't support any SerdeProtocols. Found: " + Arrays.toString(supportedModelProtocols.value()), new Element[]{facet3.facetField()});
            }
            if (explicitPath) {
                methodBuilder.addStatement("var _vajramRequest = $T._builder()\n  $L\n", new Object[]{vajramInfo.lite().immutReqPojoType(), params.keySet().stream().filter(p -> params.get(p) != FacetParamType.BODY).map(facet -> CodeBlock.builder().add(".$L($L)", new Object[]{facet.name(), facet.name()}).build()).collect(CodeBlock.joining((String)"\n"))});
            }
            if (bodyFacet != null || !explicitPath) {
                SupportedModelProtocols supportedModelProtocols;
                if (bodyFacet != null) {
                    TypeMirror typeMirror2 = bodyFacet.dataType().javaModelType(this.util.processingEnv());
                    Element bodyTypeElem = Objects.requireNonNull(this.util.processingEnv().getTypeUtils().asElement(typeMirror2));
                    supportedModelProtocols = bodyTypeElem.getAnnotation(SupportedModelProtocols.class);
                } else {
                    supportedModelProtocols = vajramElem.getAnnotation(SupportedModelProtocols.class);
                }
                if (supportedModelProtocols == null) {
                    this.util.error("Rest request body doesn't support any ModelProtocol.", new Element[]{bodyFacet == null ? vajramElem : bodyFacet.facetField()});
                } else {
                    requestSerdeProtocols = (ImmutableList)this.util.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value()).stream().filter(t -> this.util.isRawAssignable(t, SerdeProtocol.class)).map(typeMirror -> Objects.requireNonNull((TypeElement)this.util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror))).collect(ImmutableList.toImmutableList());
                    if (requestSerdeProtocols.isEmpty()) {
                        this.util.error("Rest request Body facet doesn't support any SerdeProtocols. Found: " + Arrays.toString(supportedModelProtocols.value()), new Element[]{bodyFacet == null ? vajramElem : bodyFacet.facetField()});
                    }
                }
                if (bodyFacet != null && !restMethod.supportsRequestBody()) {
                    this.util.error("Vajram %s is mapped to the rest method %s which doesn't support request body, but the vajram has a facet with the @Body annotation.".formatted(vajramInfo.vajramName(), restMethod), new Element[]{bodyFacet.facetField()});
                }
                for (TypeElement serdeProtocolType : requestSerdeProtocols) {
                    SerdeProtocol serdeProtocol = (SerdeProtocol)configProviders.get(serdeProtocolType.getQualifiedName().toString());
                    if (serdeProtocol == null) continue;
                    MethodSpec.Builder serdeSpecificMethodBuilder = methodBuilder.build().toBuilder().setName(CodeGenUtility.lowerCaseFirstChar((String)vajramInfo.vajramName()) + "_" + serdeProtocol.modelClassesSuffix());
                    serdeSpecificMethodBuilder.addAnnotation(AnnotationSpec.builder(Consumes.class).addMember("value", "$S", new Object[]{serdeProtocol.contentType()}).build()).addParameter(ParameterSpec.builder(byte[].class, (String)(bodyFacet == null ? "_body" : bodyFacet.name()), (Modifier[])new Modifier[0]).build());
                    if (bodyFacet != null) {
                        TypeElement bodyFacetModelType = Objects.requireNonNull((TypeElement)this.util.processingEnv().getTypeUtils().asElement(bodyFacet.dataType().javaModelType(this.util.processingEnv())));
                        serdeSpecificMethodBuilder.addStatement(CodeBlock.of((String)"_vajramRequest.$L(new $T($L))", (Object[])new Object[]{bodyFacet.name(), this.util.getImmutSerdeClassName(bodyFacetModelType, serdeProtocol), bodyFacet.name()}));
                    } else {
                        serdeSpecificMethodBuilder.addStatement(CodeBlock.of((String)"var _vajramRequest = new $T(_body)", (Object[])new Object[]{this.util.getImmutSerdeClassName(Objects.requireNonNull(this.util.processingEnv().getElementUtils().getTypeElement(vajramInfo.lite().requestInterfaceType().canonicalName())), serdeProtocol)}));
                    }
                    resourceMethods.add(serdeSpecificMethodBuilder);
                }
            } else {
                resourceMethods.add(methodBuilder);
            }
            return resourceMethods.stream().map(r -> r.addStatement("    this._restServiceDopant\n      .executeHttpRequest(_vajramRequest._build(), _httpHeaders, _uriInfo)\n      .whenComplete((_result, _error) -> {\n        if (_error != null) {\n          _asyncResponse.resume(_error);\n        } else {\n          _asyncResponse.resume(_result);\n        }\n      })\n", new Object[0])).map(MethodSpec.Builder::build).toList();
        }

        private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RestMethod getRestMethod(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo) {
            TypeElement typeElement = vajramInfo.vajramClassElem();
            for (RestMethod restMethod : RestMethod.values()) {
                Object annotation = typeElement.getAnnotation(restMethod.latticeAnnotation());
                if (annotation == null) continue;
                return restMethod;
            }
            return null;
        }

        private void assignTypeToFacet(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel facet, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetParamType type, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetGenModel, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent FacetParamType> params) {
            FacetParamType facetParamType = params.get(facet);
            if (facetParamType != null && facetParamType != type) {
                this.util.error("The facet " + facet.name() + " cannot be both " + facetParamType + " and " + type, new Element[]{facet.facetField()});
            } else {
                params.put(facet, type);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isApplicable() {
            if (!CodegenPhase.FINAL.equals((Object)this.context.codegenPhase())) {
                this.util.note((CharSequence)"Skipping Lattice App Impl codegen current phase is not FINAL");
                return false;
            }
            return true;
        }

        static enum FacetParamType {
            PATH,
            QUERY,
            BODY;

        }
    }
}

