/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.guice;

import com.flipkart.krystal.lattice.core.LatticeApplication;
import com.flipkart.krystal.lattice.core.di.Bindings;
import com.flipkart.krystal.lattice.core.di.DependencyInjectionProvider;
import com.flipkart.krystal.lattice.core.execution.ThreadingStrategy;
import com.flipkart.krystal.lattice.ext.guice.GuiceValueProvider;
import com.flipkart.krystal.vajram.guice.injection.VajramGuiceInputInjector;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class GuiceInjectionProvider
implements DependencyInjectionProvider {
    private final List<InstanceBinding<?>> instanceBindings = new ArrayList();
    private final List<TypeBinding<?>> typeBindings = new ArrayList();
    private final List<Class<?>> singletons = new ArrayList();
    private @MonotonicNonNull AbstractModule rootModule;
    private @MonotonicNonNull GuiceValueProvider guiceValueProvider;
    private @MonotonicNonNull VajramGuiceInputInjector vajramGuiceInputInjector;
    private final LatticeApplication latticeApp;
    private final ImmutableList<? extends Module> modules;

    public GuiceInjectionProvider(LatticeApplication latticeApp, Module ... modules) {
        this(latticeApp, (ImmutableList<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    private GuiceInjectionProvider(LatticeApplication latticeApp, ImmutableList<? extends Module> modules) {
        this.latticeApp = latticeApp;
        this.modules = modules;
    }

    protected List<Module> getExtensionModules() {
        return List.of();
    }

    public <T> void bindToInstance(Class<? extends T> type, T instance) {
        this.instanceBindings.add(new InstanceBinding<T>(type, instance));
    }

    public <T> void bindInSingleton(Class<T> type) {
        this.singletons.add(type);
    }

    public <T> void bind(Class<T> type, Class<? extends T> to) {
        this.typeBindings.add(new TypeBinding<T>(type, to));
    }

    public GuiceValueProvider getValueProvider() {
        GuiceValueProvider guiceValueProvider = this.guiceValueProvider;
        if (guiceValueProvider == null) {
            this.guiceValueProvider = guiceValueProvider = new GuiceValueProvider(Guice.createInjector((Module[])new Module[]{this.getRootModule(), new AbstractModule(){

                protected void configure() {
                    this.binder().bind(LatticeApplication.class).toInstance((Object)GuiceInjectionProvider.this.latticeApp);
                    this.binder().bind(DependencyInjectionProvider.class).toInstance((Object)GuiceInjectionProvider.this);
                }
            }}));
        }
        return guiceValueProvider;
    }

    public Module getRootModule() {
        if (this.rootModule == null) {
            this.rootModule = new AbstractModule(){

                protected void configure() {
                    GuiceInjectionProvider.this.getExtensionModules().forEach(x$0 -> this.install((Module)x$0));
                    GuiceInjectionProvider.this.modules.forEach(x$0 -> this.install((Module)x$0));
                    GuiceInjectionProvider.this.instanceBindings.forEach(instanceBinding -> instanceBinding.bind(this.binder()));
                    GuiceInjectionProvider.this.typeBindings.forEach(typeBinding -> typeBinding.bind(this.binder()));
                    GuiceInjectionProvider.this.singletons.forEach(c -> this.bind((Class)c).in(Singleton.class));
                }
            };
        }
        return this.rootModule;
    }

    public VajramInjectionProvider toVajramInjectionProvider() {
        if (this.vajramGuiceInputInjector == null) {
            this.vajramGuiceInputInjector = new VajramGuiceInputInjector(this.getValueProvider().injector());
        }
        return this.vajramGuiceInputInjector;
    }

    public Closeable openRequestScope(Bindings seedMap, ThreadingStrategy threadingStrategy) {
        return () -> {};
    }

    private record InstanceBinding<T>(Class<T> type, T instance) {
        void bind(Binder binder) {
            binder.bind(this.type).toInstance(this.instance);
        }
    }

    private record TypeBinding<T>(Class<T> type, Class<? extends T> to) {
        void bind(Binder binder) {
            binder.bind(this.type).to(this.to);
        }
    }
}

