/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.guice.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.models.Constants;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.datatypes.Trilean;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenUtils;
import com.flipkart.krystal.lattice.codegen.spi.LatticeAppCodeGenAttrsProvider;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.flipkart.krystal.lattice.codegen.spi.di.Binding;
import com.flipkart.krystal.lattice.codegen.spi.di.BindingsContainer;
import com.flipkart.krystal.lattice.codegen.spi.di.ImplTypeBinding;
import com.flipkart.krystal.lattice.codegen.spi.di.NullBinding;
import com.flipkart.krystal.lattice.codegen.spi.di.ProviderMethod;
import com.flipkart.krystal.lattice.ext.guice.codegen.GuiceBinderGen;
import com.google.auto.service.AutoService;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.util.Providers;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Vetoed;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

@AutoService(value={LatticeCodeGeneratorProvider.class})
public class GuiceModuleGenProvider
implements LatticeCodeGeneratorProvider {
    public CodeGenerator create(LatticeCodegenContext latticeCodegenContext) {
        return new GuiceModuleGen(latticeCodegenContext);
    }

    private record GuiceModuleGen(LatticeCodegenContext context) implements CodeGenerator
    {
        public void generate() {
            if (!this.isApplicable()) {
                return;
            }
            CodeGenUtility util = this.context.codeGenUtility().codegenUtil();
            Map bindingContainers = BindingsContainer.getBindingContainers((LatticeCodegenContext)this.context);
            TypeElement latticeAppTypeElement = this.context.latticeAppTypeElement();
            for (Map.Entry entry : bindingContainers.entrySet()) {
                String identifier = (String)entry.getKey();
                ClassName moduleClassName = LatticeCodegenUtils.getDiBindingContainerName((LatticeCodegenContext)this.context, (String)identifier);
                List bindingsContainers = (List)entry.getValue();
                List<Binding> bindings = bindingsContainers.stream().map(BindingsContainer::bindings).flatMap(Collection::stream).toList();
                TypeSpec.Builder classBuilder = util.classBuilder(moduleClassName.simpleName(), latticeAppTypeElement.getQualifiedName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Vetoed.class).superclass(AbstractModule.class).addMethod(MethodSpec.overriding((ExecutableElement)util.getMethod(AbstractModule.class, AbstractModule.class.getDeclaredMethod("configure", new Class[0]).getName(), 0)).addCode(this.configureMethodCode(this.context, bindings)).build()).addMethods(this.getProviderMethods(bindings));
                util.generateSourceFile(moduleClassName.canonicalName(), JavaFile.builder((String)moduleClassName.packageName(), (TypeSpec)classBuilder.build()).build(), latticeAppTypeElement);
            }
        }

        private boolean isApplicable() {
            return CodegenPhase.FINAL.equals((Object)this.context.codegenPhase()) && GuiceBinderGen.isGuiceBinderConfigured(this.context);
        }

        private CodeBlock configureMethodCode(LatticeCodegenContext context, List<Binding> bindings) {
            CodeGenUtility util = context.codeGenUtility().codegenUtil();
            CodeBlock.Builder codeBlock = CodeBlock.builder();
            List providers = StreamSupport.stream(ServiceLoader.load(LatticeAppCodeGenAttrsProvider.class, this.getClass().getClassLoader()).spliterator(), false).toList();
            Set collect = providers.stream().map(p -> p.get(context).needsRequestScopedHeaders()).collect(Collectors.toSet());
            if (collect.contains(Trilean.TRUE) && collect.contains(Trilean.FALSE)) {
                util.error("Conflicting lattice app attribute values found for attribute 'needsRequestScopedHeaders'. Found both TRUE and FALSE from providers: " + String.valueOf(providers), new Element[0]);
            }
            for (Binding binding : bindings) {
                if (binding instanceof ImplTypeBinding) {
                    ImplTypeBinding implTypeBinding = (ImplTypeBinding)binding;
                    codeBlock.addStatement("           bind($T.class)\n               .to($T.class)\n               .in($T.class)\n", new Object[]{implTypeBinding.parentType(), implTypeBinding.childType(), GuiceModuleGen.getScopeAnnotation(implTypeBinding.scope())});
                    continue;
                }
                if (!(binding instanceof NullBinding)) continue;
                NullBinding nullBinding = (NullBinding)binding;
                ClassName scopeAnnotation = GuiceModuleGen.getScopeAnnotation(nullBinding.scope());
                CodeBlock annotatedWith = nullBinding.qualifierExpression();
                codeBlock.addStatement("           // Actual values will be set when the RequestScope is opened\n           bind($T.class)\n                $L.toProvider($T.of($L))\n                $L\n", new Object[]{nullBinding.bindFrom(), annotatedWith != null ? CodeBlock.of((String)"                .annotatedWith($L)\n", (Object[])new Object[]{annotatedWith}) : Constants.EMPTY_CODE_BLOCK, Providers.class, CodeBlock.of((String)"null", (Object[])new Object[0]), scopeAnnotation != null ? CodeBlock.of((String)"                .in($T.class)\n", (Object[])new Object[]{scopeAnnotation}) : Constants.EMPTY_CODE_BLOCK});
            }
            return codeBlock.build();
        }

        private List<MethodSpec> getProviderMethods(List<Binding> bindingGens) {
            ArrayList<MethodSpec> providers = new ArrayList<MethodSpec>();
            for (Binding binding : bindingGens) {
                if (!(binding instanceof ProviderMethod)) continue;
                ProviderMethod providerMethod = (ProviderMethod)binding;
                @Nullable ClassName scopeAnnotation = GuiceModuleGen.getScopeAnnotation(providerMethod.scope());
                MethodSpec.Builder builder = MethodSpec.methodBuilder((String)providerMethod.identifierName()).returns(providerMethod.boundType()).addParameters((Iterable)providerMethod.dependencies()).addAnnotation(Provides.class).addCode(providerMethod.providingLogic());
                if (scopeAnnotation != null) {
                    builder.addAnnotation(scopeAnnotation);
                }
                builder.addAnnotations((Iterable)providerMethod.annotations());
                providers.add(builder.build());
            }
            return providers;
        }

        private static @PolyNull ClassName getScopeAnnotation(@PolyNull AnnotationSpec scope) {
            if (scope == null) {
                return null;
            }
            TypeName type = scope.type;
            if (type.equals((Object)ClassName.get(RequestScoped.class))) {
                return ClassName.get(com.google.inject.servlet.RequestScoped.class);
            }
            if (type.equals((Object)ClassName.get(ApplicationScoped.class))) {
                return ClassName.get(Singleton.class);
            }
            return (ClassName)scope.type;
        }
    }
}

