/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.guice.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenUtils;
import com.flipkart.krystal.lattice.codegen.spi.di.BindingsContainer;
import com.flipkart.krystal.lattice.codegen.spi.di.DepInjectBinderGen;
import com.flipkart.krystal.lattice.core.LatticeApp;
import com.flipkart.krystal.lattice.core.LatticeApplication;
import com.flipkart.krystal.lattice.ext.guice.GuiceInjectionProvider;
import com.flipkart.krystal.lattice.ext.guice.servlet.GuiceServletInjectionProvider;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.CodeBlock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@AutoService(value={DepInjectBinderGen.class})
public final class GuiceBinderGen
implements DepInjectBinderGen {
    public CodeBlock getBinderCreationCode(LatticeCodegenContext context) {
        if (!this.isApplicable(context)) {
            throw new UnsupportedOperationException();
        }
        Map bindingContainers = BindingsContainer.getBindingContainers((LatticeCodegenContext)context);
        return CodeBlock.builder().addNamed("return new $guiceModuleBinder:T(\n    this,\n    $customBinderCreator:L\n    $autoGenModules:L);\n", Map.ofEntries(Map.entry("customBinderCreator", this.userDefinedDepInjectBinderMethod(context).isPresent() ? CodeBlock.of((String)"super.getDependencyInjectionBinder().getRootModule(),", (Object[])new Object[0]) : CodeBlock.builder().build()), Map.entry("guiceModuleBinder", GuiceBinderGen.getDependencyInjectionBinder(context)), Map.entry("autoGenModules", (CodeBlock)bindingContainers.keySet().stream().map(id -> CodeBlock.of((String)"new $T()", (Object[])new Object[]{LatticeCodegenUtils.getDiBindingContainerName((LatticeCodegenContext)context, (String)id)})).collect(CodeBlock.joining((String)","))))).build();
    }

    static TypeElement getDependencyInjectionBinder(LatticeCodegenContext context) {
        CodeGenUtility util = context.codeGenUtility().codegenUtil();
        TypeElement dependencyInjectionBinder = (TypeElement)Objects.requireNonNull(util.processingEnv().getTypeUtils().asElement(util.getTypeFromAnnotationMember(() -> ((LatticeApp)context.latticeApp()).dependencyInjectionBinder())));
        return dependencyInjectionBinder;
    }

    public boolean isApplicable(LatticeCodegenContext context) {
        return GuiceBinderGen.isGuiceBinderConfigured(context);
    }

    static boolean isGuiceBinderConfigured(LatticeCodegenContext context) {
        TypeElement dependencyInjectionBinder = GuiceBinderGen.getDependencyInjectionBinder(context);
        return dependencyInjectionBinder.equals(context.codeGenUtility().processingEnv().getElementUtils().getTypeElement(GuiceInjectionProvider.class.getCanonicalName())) || dependencyInjectionBinder.equals(context.codeGenUtility().processingEnv().getElementUtils().getTypeElement(GuiceServletInjectionProvider.class.getCanonicalName()));
    }

    private Optional<ExecutableElement> userDefinedDepInjectBinderMethod(LatticeCodegenContext context) {
        TypeElement typeElement = context.latticeAppTypeElement();
        CodeGenUtility util = context.codeGenUtility().codegenUtil();
        try {
            return util.getMethod(typeElement, LatticeApplication.class.getMethod("getDependencyInjectionBinder", new Class[0]).getName(), 0);
        }
        catch (Exception e) {
            throw util.errorAndThrow("Application class has no 'getDependencyInjectionBinder' method. This should not happen. Possibly there are incompatible versions in the classpath.", new Element[0]);
        }
    }
}

