/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.grpc;

import com.flipkart.krystal.lattice.ext.grpc.GrpcServerSpec;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardHeadersInterceptor
implements ServerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardHeadersInterceptor.class);
    private final Context.Key<String> requestIdContextKey;
    private final Metadata.Key<String> requestIdMetadataKey;
    private final Context.Key<String> acceptHeaderContextKey;
    private final Metadata.Key<String> acceptMetadataKey;

    @Inject
    StandardHeadersInterceptor(GrpcServerSpec grpcServerSpec) {
        this.requestIdContextKey = grpcServerSpec.requestIdContextKey();
        this.requestIdMetadataKey = Metadata.Key.of((String)this.requestIdContextKey.toString(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        this.acceptHeaderContextKey = grpcServerSpec.acceptHeaderContextKey();
        this.acceptMetadataKey = Metadata.Key.of((String)this.acceptHeaderContextKey.toString(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
        String requestId = (String)requestHeaders.get(this.requestIdMetadataKey);
        log.info("requestId received from client: {}", (Object)requestId);
        String acceptHeader = (String)requestHeaders.get(this.acceptMetadataKey);
        log.info("Accept header received from client: {}", (Object)acceptHeader);
        Context contextWithHeader = Context.current().withValue(this.requestIdContextKey, (Object)requestId).withValue(this.acceptHeaderContextKey, (Object)acceptHeader);
        return Contexts.interceptCall((Context)contextWithHeader, call, (Metadata)requestHeaders, next);
    }
}

