/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.grpc.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenUtils;
import com.flipkart.krystal.lattice.codegen.spi.LatticeCodeGeneratorProvider;
import com.flipkart.krystal.lattice.ext.grpc.GrpcServer;
import com.flipkart.krystal.lattice.ext.grpc.GrpcServerDopant;
import com.flipkart.krystal.lattice.ext.grpc.GrpcService;
import com.flipkart.krystal.model.Model;
import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.protobuf3.Protobuf3;
import com.flipkart.krystal.vajram.protobuf3.SerializableProtoModel;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.MessageLite;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

@AutoService(value={LatticeCodeGeneratorProvider.class})
public class GrpcDopantImplGenProvider
implements LatticeCodeGeneratorProvider {
    public CodeGenerator create(LatticeCodegenContext latticeCodegenContext) {
        return new GrpcDopantImplGen(latticeCodegenContext);
    }

    private static final class GrpcDopantImplGen
    implements CodeGenerator {
        private final LatticeCodegenContext context;
        private final VajramCodeGenUtility util;

        public GrpcDopantImplGen(LatticeCodegenContext context) {
            this.context = context;
            this.util = context.codeGenUtility();
        }

        public void generate() {
            TypeElement latticeAppElem = this.context.latticeAppTypeElement();
            String packageName = this.util.processingEnv().getElementUtils().getPackageOf(latticeAppElem).getQualifiedName().toString();
            GrpcServer grpcServer = latticeAppElem.getAnnotation(GrpcServer.class);
            if (!this.isApplicable(grpcServer)) {
                return;
            }
            LatticeCodegenUtils latticeCodegenUtils = new LatticeCodegenUtils(this.util.codegenUtil());
            ClassName dopantImplName = latticeCodegenUtils.getDopantImplName(latticeAppElem, GrpcServerDopant.class);
            TypeSpec.Builder classBuilder = this.util.codegenUtil().classBuilder(dopantImplName.simpleName(), latticeAppElem.getQualifiedName().toString()).addModifiers(new Modifier[]{Modifier.FINAL}).superclass(GrpcServerDopant.class);
            classBuilder.addMethod(latticeCodegenUtils.dopantConstructorOverride(GrpcServerDopant.class).build());
            this.serviceDefinitions(grpcServer, classBuilder);
            this.util.codegenUtil().generateSourceFile(dopantImplName.canonicalName(), JavaFile.builder((String)packageName, (TypeSpec)classBuilder.build()).build(), latticeAppElem);
        }

        private void serviceDefinitions(GrpcServer grpcServer, TypeSpec.Builder classBuilder) {
            TypeElement latticeAppElem = this.context.latticeAppTypeElement();
            String latticePackageName = Objects.requireNonNull(this.util.processingEnv().getElementUtils().getPackageOf(latticeAppElem)).getQualifiedName().toString();
            ArrayList<CodeBlock> servicesCode = new ArrayList<CodeBlock>();
            for (GrpcService service : grpcServer.services()) {
                String serviceName = service.serviceName();
                ClassName grpcImplBaseClass = ClassName.get((String)latticePackageName, (String)(serviceName + "Grpc"), (String[])new String[]{serviceName + "ImplBase"});
                ArrayList<CodeBlock> rpcMethodsCode = new ArrayList<CodeBlock>();
                for (TypeMirror vajram : this.util.codegenUtil().getTypesFromAnnotationMember(() -> ((GrpcService)service).rpcVajrams())) {
                    TypeName protoRespMsgType;
                    VajramInfoLite vajramInfoLite = this.util.computeVajramInfoLite((TypeElement)Objects.requireNonNull(this.util.processingEnv().getTypeUtils().asElement(vajram)));
                    ClassName requestType = vajramInfoLite.requestInterfaceType();
                    ClassName reqProtoModelType = ClassName.get((String)vajramInfoLite.packageName(), (String)(requestType.simpleName() + "Immut" + Protobuf3.PROTOBUF_3.modelClassesSuffix()), (String[])new String[0]);
                    ClassName protoReqMsgType = ClassName.get((String)requestType.packageName(), (String)(requestType.simpleName() + "_Proto"), (String[])new String[0]);
                    TypeMirror responseType = vajramInfoLite.responseType().javaModelType(this.util.processingEnv());
                    boolean isModel = this.isProtoModel(responseType);
                    if (isModel) {
                        TypeElement responseTypeElem = (TypeElement)Objects.requireNonNull(this.util.processingEnv().getTypeUtils().asElement(responseType));
                        protoRespMsgType = ClassName.get((String)Objects.requireNonNull(this.util.processingEnv().getElementUtils().getPackageOf(responseTypeElem)).getQualifiedName().toString(), (String)(String.valueOf(responseTypeElem.getSimpleName()) + "_Proto"), (String[])new String[0]);
                    } else {
                        protoRespMsgType = TypeName.get((TypeMirror)responseType);
                        if (!this.util.codegenUtil().isRawAssignable(responseType, MessageLite.class)) {
                            this.util.codegenUtil().error("Response type of a vajram added to a grpc service must either be a '" + String.valueOf(Model.class) + "' with annotation @SupportedModelProtocols({..., Protobuf3.class, ...}) or it must be a " + String.valueOf(MessageLite.class), new Element[]{vajramInfoLite.vajramOrReqClass()});
                        }
                    }
                    rpcMethodsCode.add(CodeBlock.builder().addNamed("          @$override:T\n          public void $rpcName:L(\n              $protoReqMsgType:T request,\n              $streamObserver:T<$protoRespMsgType:T> responseObserver) {\n            executeRpc(\n                /*request= */ new $reqProtoModelType:T(request),\n                /*responseObserver= */ responseObserver,\n                /*responseMapper= */ response -> $responseMapper:L);\n          }\n", Map.ofEntries(Map.entry("override", Override.class), Map.entry("rpcName", CodeGenUtility.lowerCaseFirstChar((String)vajramInfoLite.vajramId().id())), Map.entry("protoReqMsgType", protoReqMsgType), Map.entry("reqProtoModelType", reqProtoModelType), Map.entry("streamObserver", StreamObserver.class), Map.entry("protoRespMsgType", protoRespMsgType), Map.entry("responseType", responseType), Map.entry("grpcDopant", GrpcServerDopant.class), Map.entry("responseMapper", isModel ? CodeBlock.of((String)"                    response == null\n                        ? null\n                        : (($T<$T>) response)\n                            ._proto()\n", (Object[])new Object[]{SerializableProtoModel.class, protoRespMsgType}) : CodeBlock.of((String)"response", (Object[])new Object[0])))).build());
                }
                servicesCode.add(CodeBlock.of((String)"        new $T(){\n          $L\n        }\n", (Object[])new Object[]{grpcImplBaseClass, rpcMethodsCode.stream().collect(CodeBlock.joining((String)"\n\n"))}));
            }
            classBuilder.addMethod(MethodSpec.overriding((ExecutableElement)this.util.codegenUtil().getMethod(GrpcServerDopant.class, GrpcServerDopant.class.getDeclaredMethod("serviceDefinitions", new Class[0]).getName(), 0)).addCode("    return $T.of(\n        $L\n    );\n", new Object[]{ImmutableList.class, servicesCode.stream().collect(CodeBlock.joining((String)",\n"))}).build());
        }

        private boolean isProtoModel(TypeMirror responseType) {
            return this.util.codegenUtil().isRawAssignable(responseType, Model.class);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        private boolean isApplicable(GrpcServer grpcServer) {
            CodegenPhase codegenPhase = this.context.codegenPhase();
            if (!CodegenPhase.FINAL.equals((Object)codegenPhase)) {
                this.util.codegenUtil().note((CharSequence)("Skipping Grpc Dopant Impl generation because this is not codegen phase: " + String.valueOf(CodegenPhase.FINAL)));
                return false;
            }
            if (grpcServer == null) {
                String message = "Skipping Grpc Dopant Impl gen because @GrpcServer missing on lattice app: " + String.valueOf(this.context.latticeAppTypeElement().getSimpleName());
                this.util.codegenUtil().note((CharSequence)message);
                return false;
            }
            return true;
        }
    }
}

