/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.ext.grpc.codegen;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodeValidationException;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.lattice.codegen.LatticeCodegenContext;
import com.flipkart.krystal.lattice.ext.grpc.GrpcServer;
import com.flipkart.krystal.lattice.ext.grpc.GrpcService;
import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfoLite;
import com.flipkart.krystal.vajram.protobuf3.codegen.ProtoGenUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor14;
import javax.tools.Diagnostic;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Proto3ServiceSchemaGen
implements CodeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Proto3ServiceSchemaGen.class);
    private final LatticeCodegenContext context;
    private final VajramCodeGenUtility util;

    public Proto3ServiceSchemaGen(LatticeCodegenContext context) {
        this.context = context;
        this.util = context.codeGenUtility();
    }

    public void generate() {
        if (!CodegenPhase.MODELS.equals((Object)this.context.codegenPhase())) {
            this.util.codegenUtil().note((CharSequence)"Skipping proto service schema codegen since current phase is not MODELS");
            return;
        }
        this.util.codegenUtil().note((CharSequence)"Starting proto service schema gen");
        GrpcServerAnno grpcServer = this.getGrpcServer();
        if (grpcServer == null) {
            this.util.codegenUtil().note((CharSequence)"Grpc Server is null");
            return;
        }
        this.validate(grpcServer);
        this.generateServerFile(grpcServer.grpcServer());
    }

    private @Nullable GrpcServerAnno getGrpcServer() {
        TypeElement latticeAppType = this.context.latticeAppTypeElement();
        GrpcServer grpcServer = latticeAppType.getAnnotation(GrpcServer.class);
        Optional<AnnotationMirror> mirror = latticeAppType.getAnnotationMirrors().stream().filter(annotationMirror -> {
            QualifiedNameable q;
            Element patt3444$temp = annotationMirror.getAnnotationType().asElement();
            return patt3444$temp instanceof QualifiedNameable && (q = (QualifiedNameable)patt3444$temp).getQualifiedName().contentEquals(GrpcServer.class.getCanonicalName());
        }).findAny();
        if (grpcServer != null && mirror.isPresent()) {
            return new GrpcServerAnno(grpcServer, mirror.get());
        }
        return null;
    }

    void validate(GrpcServerAnno anno) throws CodeValidationException {
        Map<String, AnnotationValue> elementValues = anno.mirror().getElementValues().entrySet().stream().collect(Collectors.toMap(e -> ((ExecutableElement)e.getKey()).getSimpleName().toString(), Map.Entry::getValue));
        if (anno.grpcServer().serverName().isEmpty()) {
            String message = "Grpc serverName cannot be empty";
            this.util.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.context.latticeAppTypeElement(), anno.mirror(), elementValues.get("serverName"));
            throw new CodeValidationException(message);
        }
        GrpcService[] grpcServices = anno.grpcServer().services();
        if (grpcServices.length == 0) {
            String message = "No Services registered with the Grpc server. This is not allowed";
            this.util.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.context.latticeAppTypeElement(), anno.mirror(), elementValues.get("services"));
            throw new CodeValidationException(message);
        }
        SimpleAnnotationValueVisitor14<AnnotationMirror, Void> annoMember = new SimpleAnnotationValueVisitor14<AnnotationMirror, Void>(){

            @Override
            public AnnotationMirror visitAnnotation(AnnotationMirror a, Void unused) {
                return a;
            }
        };
        SimpleAnnotationValueVisitor14<List<AnnotationMirror>, Void> nestedAnnotations = new SimpleAnnotationValueVisitor14<List<AnnotationMirror>, Void>(annoMember){
            final /* synthetic */ 1 val$annoMember;
            {
                this.val$annoMember = var2_2;
            }

            @Override
            public List<AnnotationMirror> visitArray(List<? extends AnnotationValue> vals, Void unused) {
                return vals.stream().map(this.val$annoMember::visit).toList();
            }
        };
        List list = (List)nestedAnnotations.visit(Objects.requireNonNull(elementValues.get("services")));
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        for (int i = 0; i < grpcServices.length; ++i) {
            String message;
            GrpcService grpcService = grpcServices[i];
            String serviceName = grpcService.serviceName();
            AnnotationMirror serviceAnnoMirror = (AnnotationMirror)list.get(i);
            if (serviceName.isEmpty()) {
                message = "Grpc Service name cannot be empty";
                this.util.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.context.latticeAppTypeElement(), serviceAnnoMirror, serviceAnnoMirror.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("serviceName")).map(Map.Entry::getValue).findAny().orElse(null));
                throw new CodeValidationException(message);
            }
            if (!serviceNames.add(serviceName)) {
                message = "Duplicate grpc service name";
                this.util.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, message, this.context.latticeAppTypeElement(), serviceAnnoMirror, serviceAnnoMirror.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("serviceName")).map(Map.Entry::getValue).findAny().orElse(null));
            }
            List vajrams = this.util.codegenUtil().getTypesFromAnnotationMember(() -> ((GrpcService)grpcService).rpcVajrams());
            if (!vajrams.isEmpty()) continue;
            String message2 = "No vajrams registered with service grpcService. This is not allowed";
            this.util.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, message2, this.context.latticeAppTypeElement(), serviceAnnoMirror, serviceAnnoMirror.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("vajrams")).map(Map.Entry::getValue).findAny().orElse(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateServerFile(GrpcServer grpcServer) {
        Object[] services = grpcServer.services();
        String packageName = this.util.processingEnv().getElementUtils().getPackageOf(this.context.latticeAppTypeElement()).getQualifiedName().toString();
        try {
            String serviceProtoFileName = grpcServer.serverName() + ".server.proto";
            Path outputDir = ProtoGenUtils.createOutputDirectory((Path)this.util.detectSourceOutputPath(null), (CodeGenUtility)this.util.codegenUtil());
            StringBuilder protoBuilder = new StringBuilder();
            protoBuilder.append("// AUTOMATICALLY GENERATED - DO NOT EDIT!\n").append("// This schema is auto-generated by Krystal's code generator.\n").append("// It defines the service for Vajrams inside the package ").append(packageName).append("\n").append("// Any manual edits to this file will be overwritten.\n\n");
            protoBuilder.append("syntax = \"proto3\";\n\n");
            protoBuilder.append("option java_package = \"").append(packageName).append("\";\n");
            protoBuilder.append("option java_multiple_files = true;\n\n");
            protoBuilder.append("// Service definition for the services defined by lattice application  %s\n".formatted(this.context.latticeAppTypeElement().getQualifiedName().toString()));
            LinkedHashSet imports = new LinkedHashSet();
            Arrays.stream(services).forEach(serviceAnno -> {
                for (TypeMirror vajramType : this.util.codegenUtil().getTypesFromAnnotationMember(() -> ((GrpcService)serviceAnno).rpcVajrams())) {
                    VajramInfoLite vajramInfo = this.util.computeVajramInfoLite(Objects.requireNonNull((TypeElement)this.util.processingEnv().getTypeUtils().asElement(vajramType)));
                    String responseTypeName = ProtoGenUtils.getSimpleClassName((String)vajramInfo.responseType().canonicalClassName());
                    imports.add(vajramInfo.vajramId().id() + "_Req.models.proto");
                    imports.add(responseTypeName + ".models.proto");
                }
            });
            for (String anImport : imports) {
                protoBuilder.append("import \"").append(anImport).append("\";\n");
            }
            protoBuilder.append("\n");
            protoBuilder.append("package ").append(packageName).append(";\n\n\n");
            Arrays.stream(services).forEach(serviceAnno -> {
                List<VajramInfoLite> vajramInfos = this.util.codegenUtil().getTypesFromAnnotationMember(() -> ((GrpcService)serviceAnno).rpcVajrams()).stream().map(typeMirror -> this.util.computeVajramInfoLite(Objects.requireNonNull((TypeElement)this.util.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror)))).toList();
                String doc = serviceAnno.doc();
                if (!doc.isBlank()) {
                    protoBuilder.append("// ").append(doc.replace("\n", "\n  //")).append("\n");
                }
                protoBuilder.append("service ").append(serviceAnno.serviceName()).append(" {\n");
                for (VajramInfoLite vajramInfo : vajramInfos) {
                    String vajramId = vajramInfo.vajramId().id();
                    String responseTypeName = ProtoGenUtils.getSimpleClassName((String)vajramInfo.responseType().canonicalClassName());
                    String vajramDocString = vajramInfo.docString();
                    if (vajramDocString != null && !vajramDocString.isBlank()) {
                        protoBuilder.append("  //").append(vajramDocString.replace("\n", "\n  //")).append("\n");
                    }
                    protoBuilder.append("  rpc ").append(vajramId).append("(").append(vajramId).append("_Req_Proto").append(") \n    returns (").append(responseTypeName).append("_Proto").append(");\n\n");
                }
                protoBuilder.append("}\n\n");
            });
            Path serviceProtoFilePath = outputDir.resolve(serviceProtoFileName);
            log.info("Generated service protobuf schema file: {}", (Object)serviceProtoFilePath);
            try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(serviceProtoFilePath, new OpenOption[0]));){
                out.println(protoBuilder);
            }
            catch (IOException e) {
                this.util.codegenUtil().error("Failed to generate service proto file %s".formatted(serviceProtoFilePath), new Element[0]);
            }
        }
        catch (IOException e) {
            String message = String.format("Error generating protobuf service definition for %s: %s", Arrays.deepToString(services), e.getMessage());
            this.util.codegenUtil().error(message, new Element[0]);
        }
        finally {
            this.util.codegenUtil().note((CharSequence)"Create service proto file");
        }
    }

    record GrpcServerAnno(GrpcServer grpcServer, AnnotationMirror mirror) {
    }
}

