/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.graphql.rest.dispatch;

import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponseFuture;
import com.flipkart.krystal.krystex.commands.ClientSideCommand;
import com.flipkart.krystal.krystex.commands.DirectForwardSend;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecorator;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyDecoratorConfig;
import com.flipkart.krystal.krystex.dependencydecoration.DependencyInvocation;
import com.flipkart.krystal.krystex.kryon.DirectResponse;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfigurator;
import com.flipkart.krystal.lattice.vajram.VajramDopant;
import com.flipkart.krystal.vajram.graphql.api.execution.VajramExecutionStrategy;
import com.flipkart.krystal.vajram.graphql.api.model.GraphQlOperationError;
import com.flipkart.krystal.vajram.graphql.api.traits.GraphQlOperationAggregate;
import com.flipkart.krystal.vajram.graphql.api.traits.GraphQlOperationAggregate_Req;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphQlOperationExecutor
implements DependencyDecorator,
KryonExecutorConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQlOperationExecutor.class);
    public static final String DECORATOR_TYPE = GraphQlOperationExecutor.class.getName();
    private final GraphQL graphQL;
    private final VajramKryonGraph graph;

    @Inject
    public GraphQlOperationExecutor(GraphQL graphQL, VajramDopant vajramDopant) {
        this(graphQL, vajramDopant.graph());
    }

    public GraphQlOperationExecutor(GraphQL graphQL, VajramKryonGraph graph) {
        this.graphQL = graphQL;
        this.graph = graph;
    }

    public <R extends KryonCommandResponse> DependencyInvocation<R> decorateDependency(DependencyInvocation<R> invocationToDecorate) {
        return kryonCommand -> {
            if (!(kryonCommand instanceof DirectForwardSend)) {
                log.error("Only DirectForwardSend supported by {}. Forwarding the command as is", (Object)this.decoratorType());
                return invocationToDecorate.invokeDependency(kryonCommand);
            }
            DirectForwardSend directForwardSend = (DirectForwardSend)kryonCommand;
            List requestResponseFutures = directForwardSend.executableRequests();
            if (requestResponseFutures.size() > 1) {
                String msg = "As per GraphQl spec, only one operation is allowed to execute at a time";
                log.error(msg);
                return CompletableFuture.failedFuture(new IllegalArgumentException(msg));
            }
            if (requestResponseFutures.isEmpty()) {
                log.error("No requests found. Forwarding message as is");
                return invocationToDecorate.invokeDependency(kryonCommand);
            }
            RequestResponseFuture requestResponseFuture = (RequestResponseFuture)requestResponseFutures.get(0);
            Request request = requestResponseFuture.request();
            if (!(request instanceof GraphQlOperationAggregate_Req)) {
                log.error("{} only supports requests of type {}. This decorator should only we used on dependencies on vajram. {} This seems to be a configuration error. Forwarding command as-is.", new Object[]{this.decoratorType(), GraphQlOperationAggregate_Req.class, GraphQlOperationAggregate.class});
                return invocationToDecorate.invokeDependency(kryonCommand);
            }
            GraphQlOperationAggregate_Req graphQlOperationAggregateReq = (GraphQlOperationAggregate_Req)request;
            ExecutionInput executionInput = graphQlOperationAggregateReq.executionInput();
            if (executionInput == null) {
                log.error("Could not delegate GraphQlOperationAggregate_Req because executionInput was null. Forwarding command as is");
                return invocationToDecorate.invokeDependency(kryonCommand);
            }
            this.graphQL.executeAsync(executionInput.transform(execInputBuilder -> execInputBuilder.graphQLContext(Map.of(VajramExecutionStrategy.VAJRAM_INVOCATION_CTX_KEY, computedRequestResponseFuture -> {
                Request computedRequest = computedRequestResponseFuture.request();
                DirectForwardSend newCommand = new DirectForwardSend(computedRequest._vajramID(), List.of(new RequestResponseFuture(computedRequest, requestResponseFuture.response())), kryonCommand.dependentChain());
                invocationToDecorate.invokeDependency((ClientSideCommand)newCommand);
            })))).whenComplete((executionResult, throwable) -> {
                if (throwable != null) {
                    requestResponseFuture.response().completeExceptionally((Throwable)throwable);
                } else if (!requestResponseFuture.response().isDone()) {
                    requestResponseFuture.response().complete(GraphQlOperationError.from((ExecutionResult)executionResult));
                }
            });
            return CompletableFuture.completedFuture(DirectResponse.instance());
        };
    }

    public void addToConfig(KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder) {
        configBuilder.dependencyDecoratorConfig(DECORATOR_TYPE, new DependencyDecoratorConfig(DECORATOR_TYPE, dependencyExecutionContext -> {
            Optional depVajramReq = this.graph.getVajramReqByVajramId(dependencyExecutionContext.depVajramId());
            return depVajramReq.isPresent() && GraphQlOperationAggregate_Req.class.isAssignableFrom((Class)depVajramReq.get());
        }, _c -> DECORATOR_TYPE, _c -> this));
    }
}

