package com.flipkart.krystal.lattice.graphql.rest.restapi;

import com.flipkart.krystal.annos.Generated;
import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.core.GraphExecutionData;
import com.flipkart.krystal.core.OutputLogicExecutionInput;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.ExecutionItem;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.RequestResponse;
import com.flipkart.krystal.data.RequestResponseFuture;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.vajram.VajramInitData;
import com.flipkart.krystal.vajram.exception.VajramDefinitionException;
import com.flipkart.krystal.vajram.facets.resolution.FanoutInputResolver;
import com.flipkart.krystal.vajram.facets.resolution.InputResolver;
import com.flipkart.krystal.vajram.facets.resolution.One2OneInputResolver;
import com.flipkart.krystal.vajram.graphql.api.model.GraphQlOperationObject;
import com.flipkart.krystal.vajram.graphql.api.traits.GraphQlOperationAggregate_ReqImmut;
import com.flipkart.krystal.vajram.graphql.api.traits.GraphQlOperationAggregate_ReqImmutPojo;
import com.google.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import lombok.experimental.Accessors;

/**
 * @see com.flipkart.krystal.lattice.graphql.rest.restapi.HttpGetGraphQl
 */
@SuppressWarnings({"unchecked", "ClassReferencesSubclass"})
@Accessors(fluent = true)
@Generated(by = "com.flipkart.krystal.vajram.codegen.processor.VajramWrapperGenProcessor")
@javax.annotation.processing.Generated(
    value = "com.flipkart.krystal.vajram.codegen.processor.VajramWrapperGenProcessor",
    date = "2025-11-27T12:34:45.608787+05:30")
public final class HttpGetGraphQl_Wrpr extends HttpGetGraphQl {
  private ImmutableCollection<InputResolver> _inputResolvers;

  final Supplier<GraphQlOperationAggregate_ReqImmut.Builder<GraphQlOperationObject>>
      _queryResponse_reqBuilderSupplier;

  final List<One2OneInputResolver> _queryResponse_one2oneInputResolvers;

  public HttpGetGraphQl_Wrpr(VajramInitData _vajramInitData) {
    this._queryResponse_reqBuilderSupplier =
        (Supplier<GraphQlOperationAggregate_ReqImmut.Builder<GraphQlOperationObject>>)
            _vajramInitData
                .vajramRequestBuilderSuppliers()
                .getOrDefault(
                    HttpGetGraphQl_Fac.queryResponse_s.onVajramID(),
                    () -> GraphQlOperationAggregate_ReqImmutPojo._builder());
    List<One2OneInputResolver> _queryResponse_one2oneInputResolvers = new ArrayList();
    for (InputResolver _resolver : getInputResolvers()) {
      switch (_resolver.definition().target().dependency().name()) {
        case "queryResponse" -> {
          if (_resolver instanceof FanoutInputResolver _fanoutResolver) {
            throw new VajramDefinitionException(
                """
                            "HttpGetGraphQl" vajram's dependency 'queryResponse' is not marked as canFanout=true,
                            but still has a simple fanout resolver defined.
                            Either mark the @Dependency as canFanout = true or remove the fanout resolver.
                            """);

          } else if (_resolver instanceof One2OneInputResolver _oneToOneResolver) {
            _queryResponse_one2oneInputResolvers.add(_oneToOneResolver);
          }
        }
      }
    }
    this._queryResponse_one2oneInputResolvers = _queryResponse_one2oneInputResolvers;
  }

  public HttpGetGraphQl_FacImmutPojo.Builder facetsFromRequest(Request<?> request) {
    return new HttpGetGraphQl_FacImmutPojo.Builder((HttpGetGraphQl_Req) request);
  }

  @Override
  public void executeGraph(GraphExecutionData _graphExecData) {
    Map<Facet, CompletableFuture<Void>> _futuresByFacet = new HashMap<>();
    var _queryResponse_ready = new CompletableFuture<Void>();
    _futuresByFacet.put(HttpGetGraphQl_Fac.queryResponse_s, _queryResponse_ready);
    {
      CompletableFuture.allOf()
          .whenComplete(
              (_unused, _throwable) -> {
                List<
                        RequestResponseFuture<
                            GraphQlOperationAggregate_ReqImmut.Builder<GraphQlOperationObject>,
                            GraphQlOperationObject>>
                    _queryResponse_reqs = new ArrayList<>();
                List<ExecutionItem> _executionItems = _graphExecData.executionItems();
                var _queryResponse_futures = new CompletableFuture[_executionItems.size()];
                for (int i = 0; i < _executionItems.size(); i++) {
                  var _executionItem = _executionItems.get(i);
                  HttpGetGraphQl_FacImmutPojo.Builder _facetValues =
                      (HttpGetGraphQl_FacImmutPojo.Builder)
                          _executionItem.facetValues()._asBuilder();
                  var _queryResponse_requestBuilder = _queryResponse_reqBuilderSupplier.get();
                  List<GraphQlOperationAggregate_ReqImmut.Builder<GraphQlOperationObject>>
                      _queryResponse_reqBuilders = List.of(_queryResponse_requestBuilder);

                  for (One2OneInputResolver _queryResponse_inputResolver :
                      _queryResponse_one2oneInputResolvers) {
                    _queryResponse_reqBuilders =
                        (List<GraphQlOperationAggregate_ReqImmut.Builder<GraphQlOperationObject>>)
                            _queryResponse_inputResolver
                                .resolve(_queryResponse_reqBuilders, _facetValues)
                                .getRequests();
                  }

                  if (_queryResponse_reqBuilders.isEmpty()) {
                    _queryResponse_futures[i] = CompletableFuture.completedFuture(null);
                  } else {
                    var _queryResponse_future = new CompletableFuture<GraphQlOperationObject>();
                    _queryResponse_futures[i] =
                        _queryResponse_future.whenComplete(
                            (_unused2, _throwable2) -> {
                              var _errable = Errable.errableFrom(_unused2, _throwable2);
                              _facetValues.queryResponse(
                                  new RequestResponse<>(_queryResponse_requestBuilder, _errable));
                            });
                    _queryResponse_reqs.add(
                        new RequestResponseFuture<>(
                            _queryResponse_requestBuilder, _queryResponse_future));
                  }
                }
                CompletableFuture.allOf(_queryResponse_futures)
                    .whenComplete((_unused2, _throwable2) -> _queryResponse_ready.complete(null));
                _graphExecData
                    .communicationFacade()
                    .triggerDependency(HttpGetGraphQl_Fac.queryResponse_s, _queryResponse_reqs);
              });
    }
    _queryResponse_ready.whenComplete(
        (_unused, _throwable) -> {
          _graphExecData.communicationFacade().executeOutputLogic();
        });
  }

  @Override
  public void execute(OutputLogicExecutionInput _logicInput) {
    for (ExecutionItem _executionItem : _logicInput.facetValueResponses()) {
      HttpGetGraphQl_Fac _facetValues = (HttpGetGraphQl_Fac) _executionItem.facetValues();
      var queryResponse = _facetValues.queryResponse().response();

      Futures.linkFutures(
          Errable.errableFrom(() -> output(queryResponse)).toFuture(), _executionItem.response());
    }
  }

  @Override
  public HttpGetGraphQl_ReqImmutPojo.Builder newRequestBuilder() {
    return HttpGetGraphQl_ReqImmutPojo._builder();
  }

  @Override
  public Class<HttpGetGraphQl_Req> requestRootType() {
    return HttpGetGraphQl_Req.class;
  }
}
