/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.krystex;

import com.flipkart.krystal.concurrent.SingleThreadExecutor;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.lattice.core.di.Bindings;
import com.flipkart.krystal.lattice.core.di.DependencyInjectionProvider;
import com.flipkart.krystal.lattice.core.doping.DopantType;
import com.flipkart.krystal.lattice.core.doping.SimpleDopant;
import com.flipkart.krystal.lattice.core.execution.ThreadingStrategyDopant;
import com.flipkart.krystal.lattice.krystex.KrystexDopantSpec;
import com.flipkart.krystal.lattice.vajram.RequestInitializer;
import com.flipkart.krystal.lattice.vajram.VajramDopant;
import com.flipkart.krystal.lattice.vajram.VajramRequestExecutionContext;
import com.flipkart.krystal.pooling.Lease;
import com.flipkart.krystal.pooling.LeaseUnavailableException;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexGraph;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.checkerframework.checker.builder.qual.CalledMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DopantType(value="krystal.lattice.krystex")
@Singleton
public final class KrystexDopant
implements SimpleDopant {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KrystexDopant.class);
    public static final String DOPANT_TYPE = "krystal.lattice.krystex";
    private final KrystexGraph executableGraph;
    private final KrystexDopantSpec krystexDopantSpec;
    private final ThreadingStrategyDopant threadingStrategyDopant;

    @Inject
    public KrystexDopant(KrystexDopantSpec krystexDopantSpec, DependencyInjectionProvider dependencyInjectionProvider, VajramDopant vajramDopant, ThreadingStrategyDopant threadingStrategyDopant) {
        this.krystexDopantSpec = krystexDopantSpec;
        this.threadingStrategyDopant = threadingStrategyDopant;
        KrystexGraph.KrystexGraphBuilder krystexGraphBuilder = krystexDopantSpec.krystexGraphBuilder();
        krystexGraphBuilder.injectionProvider(dependencyInjectionProvider.toVajramInjectionProvider());
        this.executableGraph = krystexGraphBuilder.vajramGraph(vajramDopant.vajramGraph()).build();
    }

    public <RespT> CompletionStage<RespT> executeRequest(VajramRequestExecutionContext<RespT> executionContext) throws LeaseUnavailableException {
        ImmutableRequest vajramRequest = executionContext.vajramRequest();
        Bindings requestScopeSeeds = executionContext.requestScopeSeeds();
        KryonExecutorConfig.KryonExecutorConfigBuilder executorConfigBuilder = executionContext.executorConfigBuilder();
        Lease<? extends ExecutorService> lease = this.threadingStrategyDopant.getExecutorService();
        ExecutorService executorService = (ExecutorService)lease.get();
        if (!(executorService instanceof SingleThreadExecutor)) {
            throw new UnsupportedOperationException("Expected 'SingleThreadExecutor'. Found " + String.valueOf(executorService.getClass()));
        }
        SingleThreadExecutor singleThreadExecutor = (SingleThreadExecutor)executorService;
        ExecutorService transformedExecutor = this.threadingStrategyDopant.executorServiceTransformer().apply((ExecutorService)singleThreadExecutor);
        CompletionStage future = CompletableFuture.supplyAsync(() -> {
            CompletionStage completionStage;
            block9: {
                ArrayList<AutoCloseable> requestScopedCloseables = new ArrayList<AutoCloseable>();
                ThreadingStrategyDopant.RequestScope requestScope = this.threadingStrategyDopant.openRequestScope(requestScopeSeeds);
                requestScopedCloseables.add(requestScope);
                requestScopedCloseables.add((AutoCloseable)lease);
                for (RequestInitializer requestInitializer : executionContext.requestScopeInitializers()) {
                    requestScopedCloseables.add(requestInitializer.init());
                }
                KrystexVajramExecutor executor = this.createExecutor(executorConfigBuilder.executorService(singleThreadExecutor).executorServiceTransformer(this.threadingStrategyDopant.executorServiceTransformer()));
                try {
                    completionStage = executor.execute(vajramRequest).whenComplete((response, throwable) -> KrystexDopant.closeAll(requestScopedCloseables));
                    if (executor == null) break block9;
                }
                catch (Throwable throwable2) {
                    try {
                        if (executor != null) {
                            try {
                                executor.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                        }
                        throw throwable2;
                    }
                    catch (Exception e) {
                        KrystexDopant.closeAll(requestScopedCloseables);
                        return CompletableFuture.failedFuture(e);
                    }
                }
                executor.close();
            }
            return completionStage;
        }, transformedExecutor).thenCompose(f -> f);
        return ((CompletableFuture)future).whenComplete((respT, throwable) -> {
            if (throwable == null) {
                if (log.isInfoEnabled()) {
                    log.info("Request sent to executor id '{}' completed successfully", (Object)executorConfigBuilder.build().executorId());
                }
            } else if (log.isErrorEnabled()) {
                log.error("Request sent to executor id '{}' completed with error", (Object)executorConfigBuilder.build().executorId(), throwable);
            }
        });
    }

    private KrystexVajramExecutor createExecutor(// Could not load outer class - annotation placement on inner may be incorrect
     @CalledMethods(value={"executorService"}) KryonExecutorConfig.KryonExecutorConfigBuilder kryonConfigBuilder) {
        this.krystexDopantSpec.configureExecutorWith().forEach(arg_0 -> ((KryonExecutorConfig.KryonExecutorConfigBuilder)kryonConfigBuilder).configureWith(arg_0));
        return this.executableGraph.createExecutor(KrystexVajramExecutorConfig.builder().kryonExecutorConfigBuilder(kryonConfigBuilder).build());
    }

    private static void closeAll(List<AutoCloseable> closeables) {
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                log.error("Unable to execute initializer closeable", e);
            }
        }
    }

    @Generated
    public KrystexGraph executableGraph() {
        return this.executableGraph;
    }
}

