/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.core.di;

import com.flipkart.krystal.lattice.core.di.BindingKey;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Bindings {
    private final ImmutableMap<BindingKey<?>, Object> bindings;

    private Bindings(Map<BindingKey<?>, Object> bindings) {
        this.bindings = ImmutableMap.copyOf(bindings);
    }

    public ImmutableMap<BindingKey<?>, Object> asMap() {
        return ImmutableMap.copyOf(this.bindings);
    }

    @Generated
    public static @NonNull BindingsBuilder builder() {
        return new BindingsBuilder();
    }

    public static class BindingsBuilder {
        private final Map<BindingKey<?>, Object> bindings = new LinkedHashMap();

        public <T> void bind(Class<T> key, T to) {
            this.bindings.put(new BindingKey.SimpleKey(key), to);
        }

        public <T> void bind(Class<T> key, Class<? extends Annotation> annotationType, T to) {
            this.bindings.put(new BindingKey.AnnotationTypeKey(key, annotationType), to);
        }

        public <T> void bind(Class<T> key, Annotation annotation, T to) {
            this.bindings.put(new BindingKey.AnnotationKey(key, annotation), to);
        }

        private BindingsBuilder bindings(Map<BindingKey<?>, Object> bindings) {
            throw new UnsupportedOperationException("Please use the bind methods instead");
        }

        @Generated
        BindingsBuilder() {
        }

        @Generated
        public @NonNull Bindings build() {
            return new Bindings(this.bindings);
        }

        @Generated
        public @NonNull String toString() {
            return "Bindings.BindingsBuilder(bindings=" + String.valueOf(this.bindings) + ")";
        }
    }
}

