/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.flipkart.krystal.lattice.core.LatticeAppBootstrap;
import com.flipkart.krystal.lattice.core.LatticeAppConfig;
import com.flipkart.krystal.lattice.core.LatticeDopantSet;
import com.flipkart.krystal.lattice.core.di.DependencyInjectionProvider;
import com.flipkart.krystal.lattice.core.di.InjectionValueProvider;
import com.flipkart.krystal.lattice.core.doping.Dopant;
import com.flipkart.krystal.lattice.core.doping.DopantConfig;
import com.flipkart.krystal.lattice.core.doping.DopantSpec;
import com.flipkart.krystal.lattice.core.doping.DopantType;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LatticeApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LatticeApplication.class);
    private final ObjectMapper configMapper = ((YAMLMapper)YAMLMapper.builder().build()).registerModule((Module)new GuavaModule()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.FAIL_ON_SELF_REFERENCES);
    private ImmutableList<String> args;

    public abstract DependencyInjectionProvider getDependencyInjectionBinder();

    public final int init(String[] args) throws Exception {
        this.args = ImmutableList.copyOf((Object[])args);
        DependencyInjectionProvider dependencyInjectionProvider = this.getDependencyInjectionBinder();
        System.err.println("Lattice app args in APP: " + Arrays.deepToString(args));
        InjectionValueProvider injector = dependencyInjectionProvider.getValueProvider();
        ImmutableList<Dopant> dopants = ((LatticeDopantSet)injector.getInstance(LatticeDopantSet.class).valueOrThrow()).dopants();
        for (Dopant dopant : dopants) {
            dopant.start(args);
        }
        ListIterator itr = dopants.listIterator(dopants.size());
        int exitCode = 0;
        while (itr.hasPrevious()) {
            int dopantExitCode = ((Dopant)itr.previous()).tryApplicationExit();
            if (exitCode != 0 || dopantExitCode == 0) continue;
            exitCode = dopantExitCode;
        }
        return exitCode;
    }

    public LatticeAppConfig loadConfig(LatticeAppBootstrap latticeAppBootstrap) {
        LatticeAppConfig latticeAppConfig;
        CommandLine commandLine;
        this.configMapper.registerSubtypes((NamedType[])this.getConfigTypesByDopantTypes((Collection<DopantSpec>)latticeAppBootstrap.configuredSpecs().values()).entrySet().stream().map(e -> new NamedType((Class)e.getValue(), (String)e.getKey())).toArray(NamedType[]::new));
        Option latticeConfigFileOption = new Option("l", "lattice_config_file", true, "Lattice app config file");
        try {
            commandLine = new DefaultParser().parse(new Options().addOption(latticeConfigFileOption), (String[])this.args.toArray(String[]::new));
        }
        catch (ParseException e2) {
            throw new RuntimeException(e2);
        }
        String latticeConfigFile = commandLine.getOptionValue(latticeConfigFileOption);
        ClassLoader classLoader = Objects.requireNonNull(this.getClass().getClassLoader());
        if (latticeConfigFile == null) {
            latticeAppConfig = new LatticeAppConfig();
        } else {
            URL configResource = classLoader.getResource(latticeConfigFile);
            if (configResource == null) {
                latticeAppConfig = new LatticeAppConfig();
            } else {
                try {
                    latticeAppConfig = (LatticeAppConfig)this.configMapper.readValue(configResource, LatticeAppConfig.class);
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
        }
        return latticeAppConfig;
    }

    private BiMap<String, Class<? extends DopantConfig>> getConfigTypesByDopantTypes(Collection<DopantSpec> allSpecBuilders) {
        HashBiMap configTypesByName = HashBiMap.create();
        for (DopantSpec specBuilder : allSpecBuilders) {
            Class configurationType = specBuilder._configurationType();
            if (DopantConfig.NoConfiguration.class.isAssignableFrom(configurationType)) continue;
            DopantType dopantTypeAnno = configurationType.getAnnotation(DopantType.class);
            if (dopantTypeAnno == null) {
                log.error("Configuration type '{}' of SpecBuilder Type '{}' doesn't have the annotation '{}'. Ignoring this configuration.", new Object[]{configurationType, specBuilder.getClass(), DopantType.class});
                continue;
            }
            String dopantType = dopantTypeAnno.value();
            if (configTypesByName.containsKey((Object)dopantType)) {
                log.error("Dopant type '{}' of config class '{}' clashes with dopant type of config class '{}'. Ignoring this config type", new Object[]{dopantType, configurationType, configTypesByName.get((Object)dopantType)});
                continue;
            }
            configTypesByName.put((Object)dopantType, configurationType);
        }
        return configTypesByName;
    }
}

