/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.flipkart.krystal.lattice.core.doping.DopantConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class LatticeAppConfig {
    private final ImmutableList<DopantConfig> dopants;
    @JsonIgnore
    private @MonotonicNonNull ImmutableMap<String, DopantConfig> dopantConfigsAsMap;

    public LatticeAppConfig() {
        this((ImmutableList<DopantConfig>)ImmutableList.of());
    }

    @JsonCreator
    public LatticeAppConfig(@JsonProperty(value="dopants") ImmutableList<DopantConfig> dopants) {
        this.dopants = dopants;
    }

    public Map<String, DopantConfig> configsByDopantType() {
        if (this.dopantConfigsAsMap == null) {
            this.dopantConfigsAsMap = (ImmutableMap)this.dopants.stream().collect(ImmutableMap.toImmutableMap(DopantConfig::_dopantType, Function.identity()));
        }
        return this.dopantConfigsAsMap;
    }
}

