/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.lattice.vajram;

import com.flipkart.krystal.concurrent.SingleThreadExecutor;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.lattice.core.di.Bindings;
import com.flipkart.krystal.lattice.core.di.DependencyInjectionBinder;
import com.flipkart.krystal.lattice.core.doping.DopantType;
import com.flipkart.krystal.lattice.core.doping.SimpleDopant;
import com.flipkart.krystal.lattice.core.execution.ThreadingStrategyDopant;
import com.flipkart.krystal.lattice.vajram.RequestInitializer;
import com.flipkart.krystal.lattice.vajram.VajramDopantSpec;
import com.flipkart.krystal.lattice.vajram.VajramRequestExecutionContext;
import com.flipkart.krystal.pooling.Lease;
import com.flipkart.krystal.pooling.LeaseUnavailableException;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.checkerframework.checker.builder.qual.CalledMethods;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@DopantType(value="krystal.lattice.vajram")
public final class VajramDopant
implements SimpleDopant {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VajramDopant.class);
    static final String DOPANT_TYPE = "krystal.lattice.vajram";
    private final VajramDopantSpec vajramDopantSpec;
    private final VajramKryonGraph graph;
    private final ThreadingStrategyDopant threadingStrategyDopant;

    @Inject
    VajramDopant(VajramDopantSpec vajramDopantSpec, DependencyInjectionBinder injectionBinder, ThreadingStrategyDopant threadingStrategyDopant) {
        this.vajramDopantSpec = vajramDopantSpec;
        this.graph = vajramDopantSpec.vajramGraph();
        this.threadingStrategyDopant = threadingStrategyDopant;
        VajramInjectionProvider vajramInjectionProvider = injectionBinder.toVajramInjectionProvider();
        if (vajramInjectionProvider != null) {
            this.graph.registerInputInjector(vajramInjectionProvider);
        }
    }

    public static VajramDopantSpec.VajramDopantSpecBuilder vajramGraph() {
        return new VajramDopantSpec.VajramDopantSpecBuilder();
    }

    public KrystexVajramExecutor createExecutor(// Could not load outer class - annotation placement on inner may be incorrect
     @CalledMethods(value={"executorService"}) KryonExecutorConfig.KryonExecutorConfigBuilder kryonConfigBuilder) {
        this.vajramDopantSpec.kryonExecutorConfigurators().forEach(m -> m.addToConfig(kryonConfigBuilder));
        return this.graph.createExecutor(KrystexVajramExecutorConfig.builder().kryonExecutorConfigBuilder(kryonConfigBuilder).build());
    }

    public <RespT> CompletionStage<RespT> executeRequest(VajramRequestExecutionContext<RespT> executionContext) throws LeaseUnavailableException {
        ImmutableRequest vajramRequest = executionContext.vajramRequest();
        Bindings requestScopeSeeds = executionContext.requestScopeSeeds();
        KryonExecutorConfig.KryonExecutorConfigBuilder executorConfigBuilder = executionContext.executorConfigBuilder();
        Lease<? extends ExecutorService> lease = this.threadingStrategyDopant.getExecutorService();
        ExecutorService executorService = (ExecutorService)lease.get();
        if (!(executorService instanceof SingleThreadExecutor)) {
            throw new UnsupportedOperationException("Expected 'SingleThreadExecutor'. Found " + String.valueOf(executorService.getClass()));
        }
        SingleThreadExecutor singleThreadExecutor = (SingleThreadExecutor)executorService;
        CompletionStage future = CompletableFuture.supplyAsync(() -> {
            CompletionStage completionStage;
            block9: {
                ArrayList<AutoCloseable> requestScopedCloseables = new ArrayList<AutoCloseable>();
                ThreadingStrategyDopant.RequestScope requestScope = this.threadingStrategyDopant.openRequestScope(requestScopeSeeds);
                requestScopedCloseables.add(requestScope);
                requestScopedCloseables.add((AutoCloseable)lease);
                for (RequestInitializer requestInitializer : executionContext.requestScopeInitializers()) {
                    requestScopedCloseables.add(requestInitializer.init());
                }
                KrystexVajramExecutor executor = this.createExecutor(executorConfigBuilder.executorService(singleThreadExecutor));
                try {
                    @Nullable CompletableFuture result = executor.execute(vajramRequest);
                    completionStage = result.whenComplete((response, throwable) -> VajramDopant.closeAll(requestScopedCloseables));
                    if (executor == null) break block9;
                }
                catch (Throwable throwable2) {
                    try {
                        if (executor != null) {
                            try {
                                executor.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                        }
                        throw throwable2;
                    }
                    catch (Exception e) {
                        VajramDopant.closeAll(requestScopedCloseables);
                        return CompletableFuture.failedFuture(e);
                    }
                }
                executor.close();
            }
            return completionStage;
        }, (Executor)singleThreadExecutor).thenCompose(f -> f);
        return future;
    }

    private static void closeAll(List<AutoCloseable> closeables) {
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                log.error("Unable to execute initializer closeable", e);
            }
        }
    }

    @Generated
    public VajramKryonGraph graph() {
        return this.graph;
    }
}

